/*
	Duik - Duduf IK Tools

	Copyright (c) 2008 - 2017 Nicolas Dufresne, Rainbox Productions

	https://rainboxprod.coop

	__Contributors:__

		Nicolas Dufresne - Lead developer
		Kevin Masson - Developer

	__Translations:__

		eZioPan – Simplified Chinese
		Ana Arce – Spanish
		Adam Szczepański – Polish

	__Thanks to:__

		Dan Ebberts - Writing the first IK Expressions
		Eric Epstein - making the IK's work with 3D Layers
		Kevin Schires – Including images in the script
		Matias Poggini – Bezier IK feature
		Eric Epstein - Making the IK's work with 3D Layers
		Assia Chioukh and Quentin Saint-Georges – User Guides composition
		Motion Cafe – Ideas and feedback
		Fous d’anim – Ideas and feedback
		All 258 Duik 15 indiegogo backers for making this libDuik possible!

	__Duik makes use of:__

		• x2js
		Copyright (c) 2011-2013 Abdulla Abdurakhmanov
		Original sources are available at https://code.google.com/p/x2js/
		Licensed under the Apache License, Version 2.0

		• json2
		See http://www.JSON.org/js.html
		Public Domain

		• seedRandom
		Copyright (c) David Bau
		Licensed under the MIT license

		• FFMpeg
		See http://ffmpeg.org

		• DuFFMpeg
		Copyright (c) 2017 Nicolas Dufresne and Rainbox Productions
		Sources available at https://github.com/Rainbox-dev/DuFFMpeg
		Licensed under the GNU General Public License v3

	This file is part of Duik.

		Duik is free software: you can redistribute it and/or modify
		it under the terms of the GNU General Public License as published by
		the Free Software Foundation, either version 3 of the License, or
		(at your option) any later version.

		Duik is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with Duik. If not, see <http://www.gnu.org/licenses/>.

*/

(function(obj)
{
	//=========================
	var version = '16.0.5';
	//=========================

/**
 * To use the Duduf After Effects scripting framework, just include one of those three files in your script:<br />
 * - <code>build/DuAEF_full.jsxinc</code> is the best option if you do not know what to choose. It will include the whole framework with all dependencies.<br />
 * - <code>DuAEF.jsxinc</code> will include all files independently, you'll have to keep all files inside lib/ and bin/ for it to work. This is a good option if you plan to make some changes to DuAEF.<br />
 * - <code>build/DuAEF_no_bin.jsxinc</code> will include everything but the binaries, this file is way lighter than the "full" version.<br />
 * - You can also rename one of these file to *.jsx and put it in the Scripts/Startup/ folder of After Effects to make the DuAEF object available for all your scripts without inclusion.<br />
 * @overview Duduf After Effects ExtendScript Framework.
 * @author Nicolas Dufresne and contributors
 * @copyright 2017,2018 Nicolas Dufresne, Rainbox Productions
 * @version 0.1.0-Beta
 * @name DuAEF
 * @license GPL-3.0 <br />
 * DuAEF is free software: you can redistribute it and/or modify<br />
 * it under the terms of the GNU General Public License as published by<br />
 * the Free Software Foundation, either version 3 of the License, or<br />
 * (at your option) any later version.<br />
 *<br />
 * DuAEF is distributed in the hope that it will be useful,<br />
 * but WITHOUT ANY WARRANTY; without even the implied warranty of<br />
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<br />
 * GNU General Public License for more details.<br />
 *<br />
 * You should have received a copy of the GNU General Public License<br />
 * along with DuAEF. If not, see {@link http://www.gnu.org/licenses/}.
 */

/**
* The general Duduf After Effects ExtendScript Framework namespace.<br />
* Provides some general tools and information.
* @namespace
* @example
* //The framework version is
* DuAEF.version;
* //If you need to get the OS the script is running on
* DuAEF.mac; //true on mac
* DuAEF.win; //true on windows
*/
var DuAEF = {};
/**
* The Current DuAEF Version
* @readonly
* @memberof DuAEF
* @type {string}
*/
DuAEF.version = "0.1.0-Beta";
/**
* Set to true and enable debug mode if you're a developper
* @memberof DuAEF
* @type {boolean}
*/
DuAEF.debug = false;

/**
* Includes binaries needed by some libraries, like pngquant for DuQuantLib or FFmpeg for DuFFmpegLib.<br />
* The binaries are available only if you include DuAEF.jsxinc or DuAEF_full.jsxinc.<br />
* If you use the DuAEF_no_bin.jsxinc version of DuAEF, this is an empty object.<br />
* @namespace
* @memberof DuAEF
*/
DuAEF.bin = {};

//Initializes DuAEF
(function ()
{
	//detect OS Version
	var mac = $.os.toLowerCase().indexOf("mac") >= 0;
	/**
	* The current OS, true if we're on Mac OS
	* @memberof DuAEF
	* @readonly
	* @type {boolean}
	*/
	DuAEF.mac = mac;
	/**
	* The current OS, true if we're on Windows
	* @memberof DuAEF
	* @readonly
	* @type {boolean}
	*/
	DuAEF.win = !mac;

	//the binaries
	DuAEF.bin.pngquant = null;
	DuAEF.bin.pngquantbatch = null

})();

//comment out this line to build DuAEF without binaries and make the file lighter
//#include "bin/DuAEF_include_binaries.jsxinc"

/**
 * JSON parser.
 * @name JSON
 * @see {@link http://www.JSON.org/js.html|Json2}
 * @license Public-Domain
 */

if(typeof JSON!=="object"){JSON={};}
(function(){"use strict";var rx_one=/^[\],:{}\s]*$/;var rx_two=/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g;var rx_three=/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g;var rx_four=/(?:^|:|,)(?:\s*\[)+/g;var rx_escapable=/[\\"\u0000-\u001f\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;var rx_dangerous=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;function f(n){return n<10?"0"+n:n;}
function this_value(){return this.valueOf();}
if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+
f(this.getUTCMonth()+1)+"-"+
f(this.getUTCDate())+"T"+
f(this.getUTCHours())+":"+
f(this.getUTCMinutes())+":"+
f(this.getUTCSeconds())+"Z":null;};Boolean.prototype.toJSON=this_value;Number.prototype.toJSON=this_value;String.prototype.toJSON=this_value;}
var gap;var indent;var meta;var rep;function quote(string){rx_escapable.lastIndex=0;return rx_escapable.test(string)?"\""+string.replace(rx_escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4);})+"\"":"\""+string+"\"";}
function str(key,holder){var i;var k;var v;var length;var mind=gap;var partial;var value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key);}
if(typeof rep==="function"){value=rep.call(holder,key,value);}
switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null";}
gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null";}
v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v;}
if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v);}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v);}}}}
v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v;}}
if(typeof JSON.stringify!=="function"){meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r","\"":"\\\"","\\":"\\\\"};JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" ";}}else if(typeof space==="string"){indent=space;}
rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify");}
return str("",{"":value});};}
if(typeof JSON.parse!=="function"){JSON.parse=function(text,reviver){var j;function walk(holder,key){var k;var v;var value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v;}else{delete value[k];}}}}
return reviver.call(holder,key,value);}
text=String(text);rx_dangerous.lastIndex=0;if(rx_dangerous.test(text)){text=text.replace(rx_dangerous,function(a){return"\\u"+
("0000"+a.charCodeAt(0).toString(16)).slice(-4);});}
if(rx_one.test(text.replace(rx_two,"@").replace(rx_three,"]").replace(rx_four,""))){j=eval("("+text+")");return(typeof reviver==="function")?walk({"":j},""):j;}
throw new SyntaxError("JSON.parse");};}}());
/**
 * Adds a new Math.seedRandom() method, used as a workaround for a bug in Math.random() with After Effects on Mac OS
 * @name seedRandom
 * @author David Bau
 * @copyright David Bau
 * @license MIT
 */

!function(a,b){function c(c,j,k){var n=[];j=1==j?{entropy:!0}:j||{};var s=g(f(j.entropy?[c,i(a)]:null==c?h():c,3),n),t=new d(n),u=function(){for(var a=t.g(m),b=p,c=0;q>a;)a=(a+c)*l,b*=l,c=t.g(1);for(;a>=r;)a/=2,b/=2,c>>>=1;return(a+c)/b};return u.int32=function(){return 0|t.g(4)},u.quick=function(){return t.g(4)/4294967296},u["double"]=u,g(i(t.S),a),(j.pass||k||function(a,c,d,f){return f&&(f.S&&e(f,t),a.state=function(){return e(t,{})}),d?(b[o]=a,c):a})(u,s,"global"in j?j.global:this==b,j.state)}function d(a){var b,c=a.length,d=this,e=0,f=d.i=d.j=0,g=d.S=[];for(c||(a=[c++]);l>e;)g[e]=e++;for(e=0;l>e;e++)g[e]=g[f=s&f+a[e%c]+(b=g[e])],g[f]=b;(d.g=function(a){for(var b,c=0,e=d.i,f=d.j,g=d.S;a--;)b=g[e=s&e+1],c=c*l+g[s&(g[e]=g[f=s&f+b])+(g[f]=b)];return d.i=e,d.j=f,c})(l)}function e(a,b){return b.i=a.i,b.j=a.j,b.S=a.S.slice(),b}function f(a,b){var c,d=[],e=typeof a;if(b&&"object"==e)for(c in a)try{d.push(f(a[c],b-1))}catch(g){}return d.length?d:"string"==e?a:a+"\0"}function g(a,b){for(var c,d=a+"",e=0;e<d.length;)b[s&e]=s&(c^=19*b[s&e])+d.charCodeAt(e++);return i(b)}function h(){try{if(j)return i(j.randomBytes(l));var b=new Uint8Array(l);return(k.crypto||k.msCrypto).getRandomValues(b),i(b)}catch(c){var d=k.navigator,e=d&&d.plugins;return[+new Date,k,e,k.screen,i(a)]}}function i(a){return String.fromCharCode.apply(0,a)}var j,k=this,l=256,m=6,n=52,o="random",p=b.pow(l,m),q=b.pow(2,n),r=2*q,s=l-1;if(b["seed"+o]=c,g(b.random(),a),"object"==typeof module&&module.exports){module.exports=c;try{j=require("crypto")}catch(t){}}else"function"==typeof define&&define.amd&&define(function(){return c})}([],Math);
/*
DuTranslatorLib
Translator Framework Library
Copyright (c) 2017,2018 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Creates a new string translation.
 * @class
 * @classdesc An translation for a string.
 * @param {string} source - The source string
 * @param {string} [translation=''] - The translated string
 * @param {string} [comment=''] - A comment to explain what needs to be explained
 * @param {string} [context=''] - The context where the string is used
 * @param {int} [contextId=0] - A unique id for the couple source/context
 * @property {string} source - The source string
 * @property {string} translation - The translated string
 * @property {string} comment - A comment to explain what needs to be explained
 * @property {string} context - The context where the string is used
 * @property {int} contextId - A unique id for the couple source/context
 */
function Translation(source,translation,comment,context,contextId)
{
	if (typeof translation === 'undefined') translation = '';
	if (typeof comment === 'undefined') comment = '';
	if (typeof context === 'undefined') context = '';
	if (typeof contextId === 'undefined') contextId = 0;
	this.source = source;
	this.translation = translation;
	this.comment = comment;
	this.context = context;
	this.contextId = contextId;
}

/**
 * The Javascript translator part of the Dutranslator Framework<br />
 * see {@link https://github.com/Rainbox-dev/Dutranslator}
 * @namespace
 * @memberof DuAEF
 */
DuAEF.Dutranslator = {};

/**
 * The current language id (fr, en, ..)
 * @memberof DuAEF.Dutranslator
 */
DuAEF.Dutranslator.current = '';

/**
 * The current language name
 * @memberof DuAEF.Dutranslator
 */
DuAEF.Dutranslator.currentName = '';

/**
 * A map containing available languages.
 * There is a language name and a file name for each language id.
 * languages["fr_FR"] ["name"] is "Francais" for example.
 *
 * Will be filled when executing Dutranslator.getAvailable().
 *
 * @memberof DuAEF.Dutranslator
 */
DuAEF.Dutranslator.languages = {};

/**
 * The translated strings  of the current language
 *
 * An array of compounds containing the source, the translation and the context
 *
 * @memberof DuAEF.Dutranslator
 */
DuAEF.Dutranslator.localizedStrings = [];

/**
 * Some Settings for the translator
 * @namespace
 * @memberof DuAEF.Dutranslator
 */
DuAEF.Dutranslator.Settings = {}

/**
 * The folder containing the translation files
 * @memberof DuAEF.Dutranslator.Settings
 * @type {string}
 * @default "thisScriptFile/file/path/"
 *
 */
DuAEF.Dutranslator.Settings.folder = File($.fileName).path + "/";

/**
 * The prefix in the translation filenames
 * @memberof DuAEF.Dutranslator.Settings
 * @type {string}
 * @default "thisScriptFileName_"
 */
DuAEF.Dutranslator.Settings.prefix = File($.fileName).name.substring(0,File($.fileName).name.lastIndexOf('.')) + "_";

/**
 * The suffix (including file extension) in the translation filenames
 * @memberof DuAEF.Dutranslator.Settings
 * @type {string}
 * @default ".json"
 */
DuAEF.Dutranslator.Settings.suffix = ".json";

/**
 * The application name (root of the json translations)
 * @memberof DuAEF.Dutranslator.Settings
 * @type {string}
 * @default "duaef"
 */
DuAEF.Dutranslator.Settings.name = "duaef";

/**
 * The original languageId
 * @memberof DuAEF.Dutranslator.Settings
 */
DuAEF.Dutranslator.Settings.originalLanguageId = "en";

/**
 * The original language name
 * @memberof DuAEF.Dutranslator.Settings
 */
DuAEF.Dutranslator.Settings.originalLanguageName = "English";

/**
 * Load the list of available languages
 *
 * If the language id and or the language name can't be found in the file, the file name will be used
 * to determine the language id and the name will be set as the id.
 *
 * @return A success code
 * 0	Success
 * 1	One of the file haven't been correctly opened
 */
DuAEF.Dutranslator.getAvailable = function ()
{
	DuAEF.Dutranslator.languages = {};
	//Add original language
	DuAEF.Dutranslator.languages[DuAEF.Dutranslator.Settings.originalLanguageId] = {
		"name": DuAEF.Dutranslator.Settings.originalLanguageName,
		"file": undefined
	};


	var folder = new Folder(DuAEF.Dutranslator.Settings.folder);

	// Get the list of translations
	languageFiles = folder.getFiles(DuAEF.Dutranslator.Settings.prefix + '*' + DuAEF.Dutranslator.Settings.suffix);

	for (var i = 0 ; i < languageFiles.length ; i++)
	{
		  var fileName = languageFiles[i].name;
		  var langId = langName = "";

		  // Determine the language name and the language id by reading the file
		  // Values are stored at the top so it should be fase
		  var file = new File(folder.absoluteURI + "/" + fileName);
		  if(!file.open("r")) return 1; // Unable to open the file

		  // Line by line reading
		  while(langName == "" || langId == "" && !file.eof )
		  {
			  var line = file.readln();
			  var indexName = line.lastIndexOf("languageName");
			  var indexId = line.lastIndexOf("languageId");

			  var index;
			  if(indexName != -1 && langName == "") index = indexName;
			  else if(indexId != -1 && langId == "") index = indexId;
			  else continue;
			  // ..... "lang" : "value"
			  line = line.substring(index, line.length);
			  // .lang" : "value"
			  line = line.substring(line.indexOf("\"") + 1, line.length);
			  // : "value"
			  line = line.substring(line.indexOf("\"") + 1, line.length);
			  // value"
			  line = line.substring(0, line.indexOf("\""));
			  // value
			   if(indexName != -1 && langName == "") langName = line ;
			  else if(indexId != -1 && langId == "") langId = line ;
			  else continue;
		  }

		  file.close();


		  if(langId == "") langId = fileName.replace(DuAEF.Dutranslator.Settings.prefix, "").replace(DuAEF.Dutranslator.Settings.suffix, "");
		  if(langName == "") langName = langId;

		  DuAEF.Dutranslator.languages[langId] = {
			  "name": langName,
			  "file":  DuAEF.Dutranslator.Settings.folder + "/" + fileName
		  };

	}

}

/**
  * Returns the pretty name of a given language
  * @param {string} langId - The id of the request language
 */
DuAEF.Dutranslator.getPrettyName = function(langId)
{
	if(!DuAEF.Dutranslator.languages[langId]) return 1;
	return DuAEF.Dutranslator.languages[langId]["name"];
}

/**
  * Returns the language id of a given language name
  * @param {string} prettyName - The pretty name of the request language
 */
DuAEF.Dutranslator.getLanguageId = function(prettyName)
{
	for(var langId in DuAEF.Dutranslator.languages)
	{
		if(DuAEF.Dutranslator.languages[langId]["name"] == prettyName) return langId;
	}
	return 1;
}

/**
  * Returns a list containing pretty names of all languages
  * @param {string} langId - The id of the request language
 */
DuAEF.Dutranslator.getPrettyNames = function()
{
	var res = [];
	for(var langId in DuAEF.Dutranslator.languages)
	{
		res[res.length] = DuAEF.Dutranslator.languages[langId]["name"];
	}

	// Order the list by name
	res.sort ();
	return res;
}

/**
 * Set the current language
 * @param {string} languageId - The id of the language to set
 * @return success code
 * 0	Everything went ok
 * 1	The file linked to the given id can't be opened
 * 2	The json content doesn't match a translation file
 */
DuAEF.Dutranslator.setLanguage = function (languageId)
{

	for (var langId in DuAEF.Dutranslator.languages)
	{
		if (langId == languageId)
		{
			DuAEF.Dutranslator.current = languageId;
			DuAEF.Dutranslator.currentName = DuAEF.Dutranslator.getPrettyName(languageId);

			if(languageId == DuAEF.Dutranslator.Settings.originalLanguageId) return 0;  // Default language, no translation

			// Parse process

			var fPath = DuAEF.Dutranslator.languages[langId]["file"];
			var file = new File(fPath);

			if(!file.open("r")) return 1; // Unable to open the file

			var data = file.read();
			file.close();
			var jsonData = JSON.parse(data);

			if(!jsonData[DuAEF.Dutranslator.Settings.name] ||
				jsonData[DuAEF.Dutranslator.Settings.name].length != 2 ||
				!jsonData[DuAEF.Dutranslator.Settings.name][1]["translations"]) return 2; // Wrong json format

			var translations = jsonData[DuAEF.Dutranslator.Settings.name][1]["translations"];
			DuAEF.Dutranslator.localizedStrings = translations;

			return 0;

		}
	}
}

/**
 * Set the current language with a given pretty name
 * @param {string} languageName - The pretty name of the language to set
 * @return success code
 * 0	Everything went ok
 * -1   Can't find any language with the given pretty name
 * >0  Call to setLanguage(languageId) failed
 */
DuAEF.Dutranslator.setPrettyLanguage = function (languageName)
{

	var langId = DuAEF.Dutranslator.getLanguageId(languageName);
	if(langId == 1) return -1;

	return DuAEF.Dutranslator.setLanguage(langId);
}

/**
 * Creates a file for translation with the given base strings.
 * @memberof DuAEF.Dutranslator
 * @param {Translation[]|strings} [translations=DuAEF.Dutranslator.localizedStrings] - The translations or source strings to be included in the translation file.
 * @param {File|string} file - The file or URI
 * @param {string} [appName="dutranslator"] - A name for the app using this translation file.
 * @param {string} [version="0.0"] - A version (as a string) for this translation file or app.
 * @param {string} [languageId=DuAEF.Dutranslator.current] - A version (as a string) for this translation file or app.
 * @param {string} [languageName=DuAEF.Dutranslator.currentName] - A version (as a string) for this translation file or app.
 */
DuAEF.Dutranslator.generateTranslationFile = function (file,translations,appName,version,languageId,languageName)
{
	if (!(file instanceof File)) file = new File(file);
	if (typeof translations === 'undefined') translations = DuAEF.Dutranslator.localizedStrings;
	if (typeof appName === 'undefined') appName = 'dutranslator';
	else appName = appName.toLowerCase();
	if (typeof version === 'undefined') version = '0.0';
	if (typeof languageId === 'undefined') languageId = DuAEF.Dutranslator.current;
	if (typeof languageName === 'undefined') languageName = DuAEF.Dutranslator.currentName;
	if (!translations.length) return;

	//if translations is an array of strings, convert to translations
	if (typeof translations[0] === 'string') translations = DuAEF.Dutranslator.generateTranslations(translations);

	var data = {};
	data[appName] = [];
	var metaData = {};
	metaData.languageId = languageId;
	metaData.languageName = languageName;
	metaData.version = version;
	data[appName].push(metaData);
	var translationsObject = {};
	translationsObject.translations = translations;
	data[appName].push(translationsObject);

	DuAEF.DuJS.Fs.saveJSON(data,file);
}

/**
 * Converts an Array of strings to an Array of empty translations
 * @memberof DuAEF.Dutranslator
 * @param {string[]} strings - The base strings to convert.
 * @return {Translation[]} The empty translations
 */
DuAEF.Dutranslator.generateTranslations = function (strings)
{
	DuAEF.DuJS.Array.removeDuplicates(strings);
	var translations = [];
	for (var i = 0, num = strings.length; i < num ; i++)
	{
		translations.push(new Translation(strings[i]));
	}
	return translations;
}

/**
 * Translate a given string based on the current seted language<br />
 * see {@link DuAEF.Dutranslator} for more details about the translation framework.
 * @function
 * @param {string} s - 		The text to be translated
 * @param {int} or {string} context - 	Can be an integer or a string which is related to contextId or context in a translation file
 * @param {string[]} args -	Args to format into the translated string, default is []<br />
 * For example, when calling tr("Welcome {#}", -1, "Paul"), the output will be "Welcome Paul"<br />
 * If too many args are given, there are ignored<br />
 * If not enough args are given, the {#} are replaced with ?
 * @return {string} The translated text or s if nothing is set or available
 */
function tr(s, context, args)
{
	// Default args
	var useContextId = true;
	if (typeof context === 'string' || context instanceof String) useContextId = false;
	if (typeof context === 'undefined') context = -1;
	else if (context < 0) context = -1;
	if (typeof args === 'undefined') args = [];
	if (typeof args === 'string' || args instanceof String) args = [args];

	var languageNumber = -1;

	var res = s;
	// If a language is set, search for the translation
	if (DuAEF.Dutranslator.current != DuAEF.Dutranslator.Settings.originalLanguageId)
	{
		var stringNumber = -1;

		// Get the translation
		for (var i = 0 ; i < DuAEF.Dutranslator.localizedStrings.length ; i++)
		{
			var tr = DuAEF.Dutranslator.localizedStrings[i];
			if(tr["source"] == s)
			{
				// Check context
				if (useContextId && context > -1)
				{
					if (tr["contextId"] == context)
					{
						stringNumber =i;
						break;
					}
				}
				else if(!useContextId)
				{
					if (tr["context"] == context)
					{
						stringNumber =i;
						break;
					}
				}
				else {
					stringNumber =i;
					break;
				}
			}
		}

		// If a translation is found, set it to res
		if (stringNumber > -1) res = DuAEF.Dutranslator.localizedStrings[stringNumber]["translation"];
		if (res == "") res = s;
	}

	// Args process
	while(res.indexOf("{#}") !== -1)
	{
		// While there is stuff to format
		if(args.length < 1)
		{ // If no more args, replace with ?
			res = res.replace("{#}", "?"); // Will replace the first occurence
		}
		else
		{
			var arg = args.shift(); // Take the first arg and remove it
			res = res.replace("{#}", arg);
		}
	}

	return res;
}
/*
	DuDebugLib
  Library to with tools for debugging
	Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
	https://rainboxprod.coop

	_Contributors:_
		Nicolas Dufresne - Lead developer

	This file is part of DuAEF.

	DuAEF is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	DuAEF is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/


/**
* Tools for debugging
* @namespace
* @memberof DuAEF
*/
DuAEF.Debug = {};

/**
 * The log levels
 * @enum {int}
 * @readonly
 */
DuAEF.Debug.LogLevel =
{
	VERBOSE: 0,
	DEBUG: 1,
	WARNING: 2,
	CRITICAL: 3,
	FATAL: 4,
	NO_DEBUG: 5
}

/**
 * Constructs a new debug logger
 * @class DebugLog
 * @classdesc A logger for debugging purposes: writes debug messages to a file, with date and type
 * @param	{string|File} pathOrFile - The log file.
 * @param	{boolean} [clear=true] - Whether to clear the previous log file before starting
 * @param	{DuAEF.Debug.LogLevel}	[logLevel=DuAEF.Debug.LogLevel.DEBUG] -  The log level.
 * @param	{boolean}	[enabled=DuAEF.debug] -  true to enable the log and start recording
 * @property {DuAEF.Debug.LogLevel} level - The log level.
 * @property {File}	file - The log file.
 * @property {boolean}	running - true if the timer is running, false if it is stopped.
 */
function DebugLog(pathOrFile,clear,logLevel,enabled)
{
	if (!(pathOrFile instanceof File)) this.file = new File(pathOrFile);
	else this.file = pathOrFile;
	this.file.encoding = 'UTF-8';

	if (logLevel == undefined) logLevel = DuAEF.Debug.LogLevel.DEBUG;
	this.level = logLevel;

	if (enabled == undefined) enabled = DuAEF.debug;
	this.enabled = enabled;

	if (clear == undefined) clear = true;
	var openOption = 'a';
	if (clear || !this.file.exists) openOption = 'w';
	if (this.level <= DuAEF.Debug.LogLevel.DEBUG && DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		if (this.file.open(openOption))
		{
			var currentDate = new Date();
			this.file.writeln('[' + currentDate.toString() + '] == Debugger started. ==');
			this.file.close();
		}
	}

	this.elapsed = 0;
	this.running = false;
}

/**
* Logs a message
* @param {string} message - The message to log
* @param {DuAEF.Debug.LogLevel} [level=DuAEF.Debug.LogLevel.DEBUG] - The level of the message
*/
DebugLog.prototype.log = function (message,level)
{
	if (typeof level === 'undefined') level = DuAEF.Debug.LogLevel.DEBUG;

	if (!this.enabled) return;
	if (level < this.level) return;
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess) return;

	if (!this.file.open('a')) return;

	if (level == undefined) level = DuAEF.Debug.DEBUG;

	var currentDate = new Date();
	var levelString = " || Debug info || ";
	if (level == DuAEF.Debug.LogLevel.WARNING) levelString = " || Warning || ";
	else if (level == DuAEF.Debug.LogLevel.CRITICAL) levelString = " || Critical || ";
	else if (level == DuAEF.Debug.LogLevel.FATAL) levelString = " || Fatal || ";
	this.file.writeln('[' + currentDate.toString() + ']' + levelString + message );
	this.file.close();
}

/**
* Starts the debugger timer.
* @param {string} [message] - A message to display in the log
* @param {DuAEF.Debug.LogLevel} [level=DuAEF.Debug.LogLevel.VERBOSE] - The level of the message
*/
DebugLog.prototype.startTimer = function(message, level)
{
	if (typeof level === 'undefined') level = DuAEF.Debug.LogLevel.VERBOSE;

	if (!this.enabled) return;

	if (message == undefined) message = '';

	if (level >= this.level && DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		if (this.file.open('a'))
		{
			var currentDate = new Date();
			this.file.writeln('[' + currentDate.toString() + '] == Timer started. == ' + message);
			this.file.close();
		}
	}

	if (!this.running) this.elapsed = 0;
	this.running = true;
	$.hiresTimer;
}

/**
* Stops the debugger timer.
* @param {string} [message] - A message to display in the log
* @param {DuAEF.Debug.LogLevel} [level=DuAEF.Debug.LogLevel.DEBUG] - The level of the message
*/
DebugLog.prototype.stopTimer = function(message, level)
{
	if (typeof level === 'undefined') level = DuAEF.Debug.LogLevel.DEBUG;
	if (!this.enabled) return;
	if (!this.running) return;

	this.elapsed += Math.round($.hiresTimer/1000);

	if (typeof message === 'undefined') message = '';

	if (level >= this.level && DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		if (this.file.open('a'))
		{
			var currentDate = new Date();
			this.file.writeln('[' + currentDate.toString() + '] == Timer stopped == Time elapsed | ' + this.elapsed + 'ms | == ' + message);
			this.file.close();
		}
	}

	this.elapsed = 0;
	this.running = false;
	$.hiresTimer;
}

/**
* Checks the time elapsed since the timer has started<br />
* If the timer is not running, it will be started.
* @param {string} message - A message to display in the log
* @param {DuAEF.Debug.LogLevel} [level=DuAEF.Debug.LogLevel.DEBUG] - The level of the message
* @return {int} The time elapsed in milliseconds
*/
DebugLog.prototype.checkTimer = function(message, level)
{
	if (typeof level === 'undefined') level = DuAEF.Debug.LogLevel.DEBUG;
	if (!this.running) this.startTimer();
	this.elapsed += Math.round($.hiresTimer/1000);

	if (!this.enabled) return -1;

	if (level >= this.level && DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		if (this.file.open('a'))
		{
			if (message == undefined) message = '';

			var currentDate = new Date();
			this.file.writeln('[' + currentDate.toString() + '] == Time elapsed | ' + this.elapsed + 'ms | == ' + message);
			this.file.close();
		}
	}

	return this.elapsed;
}
var duaef_magic = {"binAsString":"RIFX\x00\x00\u00BA\fFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00Q\x00\x00\x00\b\x01\x00\x00\x00LIST\x00\x00\u00B9\u00E8bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x04\x00\x01\x00\x01\x01\u00F4\x01\u00F4?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Root Vectors Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\tContents\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\u00B8\u00B2tdgptdsb\x00\x00\x00\x04\x00\x00\x04\x01tdsn\x00\x00\x00\tContents\x00\x00tdmn\x00\x00\x00(ADBE Vector Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00j\u00BAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bGroup 1\x00tdmn\x00\x00\x00(ADBE Vector Blend Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vectors Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00(\u00E6tdgptdsb\x00\x00\x00\x04\x00\x00\x04\x01tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u00F4tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 1\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02fom-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x01\u00A8omksLIST\x00\x00\x01\u009Cshapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C2pN\u00F8\u00C1:\u00DC@\u00C2\x11H\u00F0AA<\x00\x01\x00\x00\x00LIST\x00\x00\x01hlistlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00$\x00\x00\x00\t\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00$\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x01 \u00C2\x12X\u00F0\u00C0\u00E5;\u00C0\u00C2\x12X\u00F0\u00C0\u00E5;\u00C0\u00C2^>\u00E0A<\u00FC \u00C2^>\u00E0A<\u00FC \u00C2^\u00F4\u00F0A?\u00D1\u00E0\u00C2_\u00E5\u00F0AA<\x00\u00C2`\u00E6\u00F0AA<\x00\u00C2a\u00E7\u00F0AA<\x00\u00C2b\u00D8\u00F0A?\u00D1\u00E0\u00C2c\u008F\x00A<\u00FC \u00C2c\u008F\x00A<\u00FC \u00C2o>\u00E8A\x0E>\x00\u00C2o>\u00E8A\x0E>\x00\u00C2o\u00F3\u00F0A\x0Bg\u00C0\u00C2pN\u00F8A\x07\u00A2\x00\u00C2pN\u00F8A\x03\u009D\u00E0\u00C2pN\u00F8@\u00FF4@\u00C2o\u00F3\u00F0@\u00F7\u00A7\u00C0\u00C2o>\u00E8@\u00F1\u00FC@\u00C2o>\u00E8@\u00F1\u00FC@\u00C2#X\x00\u00C16\u009B\u00E0\u00C2#X\x00\u00C16\u009B\u00E0\u00C2\"\u00A2\u00F0\u00C19r \u00C2!\u00B1\x00\u00C1:\u00DC@\u00C2 \u00AF\u00F0\u00C1:\u00DC@\u00C2\x1F\u00AE\u00F0\u00C1:\u00DC@\u00C2\x1E\u00BC\u00F0\u00C19r \u00C2\x1E\x07\u00F0\u00C16\u009B\u00E0\u00C2\x1E\x07\u00F0\u00C16\u009B\u00E0\u00C2\x12X\u00F0\u00C1\x07\u00DD\u00E0\u00C2\x12X\u00F0\u00C1\x07\u00DD\u00E0\u00C2\x11\u00A2\u00F0\u00C1\x05\b\x00\u00C2\x11H\u00F0\u00C1\x01B \u00C2\x11H\u00F0\u00C0\u00FA|@\u00C2\x11H\u00F0\u00C0\u00F2t\x00\u00C2\x11\u00A2\u00F0\u00C0\u00EA\u00E8@omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u0094tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 2\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02\x06om-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x01HomksLIST\x00\x00\x01<shapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C2jX\u00F0\u00C1A<\x00\u00C2[<\u00F0\u00C1\x04\u00CB\u00C0\x01\x00\x00\x00LIST\x00\x00\x01\blistlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x06\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x00\u00C0\u00C2[<\u00F0\u00C1#\x03\u00E0\u00C2[<\u00F0\u00C1#\x03\u00E0\u00C2a\x04\u00F0\u00C1\x1B\u00ED\u00C0\u00C2a\x04\u00F0\u00C1\x1B\u00ED\u00C0\u00C2a\x04\u00F0\u00C1\x1B\u00ED\u00C0\u00C2b\u00CB\x00\u00C1\x04\u00CB\u00C0\u00C2b\u00CB\x00\u00C1\x04\u00CB\u00C0\u00C2b\u00CB\x00\u00C1\x04\u00CB\u00C0\u00C2d\u008F\u00E0\u00C1\x1B\u00ED\u00C0\u00C2d\u008F\u00E0\u00C1\x1B\u00ED\u00C0\u00C2d\u008F\u00E0\u00C1\x1B\u00ED\u00C0\u00C2jX\u00F0\u00C1#\x03\u00E0\u00C2jX\u00F0\u00C1#\x03\u00E0\u00C2jX\u00F0\u00C1#\x03\u00E0\u00C2d\u008F\u00E0\u00C1*\x1A\x00\u00C2d\u008F\u00E0\u00C1*\x1A\x00\u00C2d\u008F\u00E0\u00C1*\x1A\x00\u00C2b\u00CB\x00\u00C1A<\x00\u00C2b\u00CB\x00\u00C1A<\x00\u00C2b\u00CB\x00\u00C1A<\x00\u00C2a\x04\u00F0\u00C1*\x1A\x00\u00C2a\x04\u00F0\u00C1*\x1A\x00\u00C2a\x04\u00F0\u00C1*\x1A\x00\u00C2[<\u00F0\u00C1#\x03\u00E0omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u0094tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 3\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02\x06om-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x01HomksLIST\x00\x00\x01<shapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C2_\x02\u00E0\u00C12  \u00C2@\u00CB\x00\u00C0e\x00\u0080\x01\x00\x00\x00LIST\x00\x00\x01\blistlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x06\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x00\u00C0\u00C2@\u00CB\x00\u00C0\u00EB`\x00\u00C2@\u00CB\x00\u00C0\u00EB`\x00\u00C2L\\\u00E0\u00C0\u00CF\f@\u00C2L\\\u00E0\u00C0\u00CF\f@\u00C2L\\\u00E0\u00C0\u00CF\f@\u00C2O\u00E6\u00F0\u00C0e\x00\u0080\u00C2O\u00E6\u00F0\u00C0e\x00\u0080\u00C2O\u00E6\u00F0\u00C0e\x00\u0080\u00C2Sq\u00E0\u00C0\u00CF\f@\u00C2Sq\u00E0\u00C0\u00CF\f@\u00C2Sq\u00E0\u00C0\u00CF\f@\u00C2_\x02\u00E0\u00C0\u00EB`\x00\u00C2_\x02\u00E0\u00C0\u00EB`\x00\u00C2_\x02\u00E0\u00C0\u00EB`\x00\u00C2Sq\u00E0\u00C1\x03\u00DA \u00C2Sq\u00E0\u00C1\x03\u00DA \u00C2Sq\u00E0\u00C1\x03\u00DA \u00C2O\u00E6\u00F0\u00C12  \u00C2O\u00E6\u00F0\u00C12  \u00C2O\u00E6\u00F0\u00C12  \u00C2L\\\u00E0\u00C1\x03\u00DA \u00C2L\\\u00E0\u00C1\x03\u00DA \u00C2L\\\u00E0\u00C1\x03\u00DA \u00C2@\u00CB\x00\u00C0\u00EB`\x00omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u0094tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 4\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02\x06om-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x01HomksLIST\x00\x00\x01<shapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C2D\u0093\x00\u00C1A<\x00\u00C25v\u00F0\u00C1\x04\u00CB\u00C0\x01\x00\x00\x00LIST\x00\x00\x01\blistlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x06\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x00\u00C0\u00C25v\u00F0\u00C1#\x03\u00E0\u00C25v\u00F0\u00C1#\x03\u00E0\u00C2;>\u00E0\u00C1\x1B\u00ED\u00C0\u00C2;>\u00E0\u00C1\x1B\u00ED\u00C0\u00C2;>\u00E0\u00C1\x1B\u00ED\u00C0\u00C2=\x04\u00F0\u00C1\x04\u00CB\u00C0\u00C2=\x04\u00F0\u00C1\x04\u00CB\u00C0\u00C2=\x04\u00F0\u00C1\x04\u00CB\u00C0\u00C2>\u00C9\u00F0\u00C1\x1B\u00ED\u00C0\u00C2>\u00C9\u00F0\u00C1\x1B\u00ED\u00C0\u00C2>\u00C9\u00F0\u00C1\x1B\u00ED\u00C0\u00C2D\u0093\x00\u00C1#\x03\u00E0\u00C2D\u0093\x00\u00C1#\x03\u00E0\u00C2D\u0093\x00\u00C1#\x03\u00E0\u00C2>\u00C9\u00F0\u00C1*\x1A\x00\u00C2>\u00C9\u00F0\u00C1*\x1A\x00\u00C2>\u00C9\u00F0\u00C1*\x1A\x00\u00C2=\x04\u00F0\u00C1A<\x00\u00C2=\x04\u00F0\u00C1A<\x00\u00C2=\x04\u00F0\u00C1A<\x00\u00C2;>\u00E0\u00C1*\x1A\x00\u00C2;>\u00E0\u00C1*\x1A\x00\u00C2;>\u00E0\u00C1*\x1A\x00\u00C25v\u00F0\u00C1#\x03\u00E0omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x034tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 5\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\u00A6om-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x00\u00E8omksLIST\x00\x00\x00\u00DCshapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C21\u00FA\u00E0\u00C1\x16\u0080\x00\u00C2\x1A^\u00F0\u00C0`G\u0080\x01\x00\x00\x00LIST\x00\x00\x00\u00A8listlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00\f\x00\x00\x00\x03\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x00`\u00C2\x1A^\u00F0\u00C0\u00FA|@\u00C2\x1A^\u00F0\u00C0\u00FA|@\u00C2 \u00AF\u00F0\u00C1\x16\u0080\x00\u00C2 \u00AF\u00F0\u00C1\x16\u0080\x00\u00C2 \u00AF\u00F0\u00C1\x16\u0080\x00\u00C21\u00FA\u00E0\u00C0\u00A2\u00A8\u0080\u00C21\u00FA\u00E0\u00C0\u00A2\u00A8\u0080\u00C21\u00FA\u00E0\u00C0\u00A2\u00A8\u0080\u00C2+\u00AA\u00F0\u00C0`G\u0080\u00C2+\u00AA\u00F0\u00C0`G\u0080\u00C2+\u00AA\u00F0\u00C0`G\u0080\u00C2\x1A^\u00F0\u00C0\u00FA|@omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u0094tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Path 6\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02\x06om-sLIST\x00\x00\x00\u00AAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x07\x00\x01\x00\x02\x00\x07\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x01\x00\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00\x04\x00\x00\x00\x00LIST\x00\x00\x01HomksLIST\x00\x00\x01<shapshph\x00\x00\x00\x18\u00B3\u00DE\x02\x00\u00C2\x1E\u00CC\u00F0\u00C0(\u008F\u0080\u00C2\x0F\u00B1\x00?\u0092`\x00\x01\x00\x00\x00LIST\x00\x00\x01\blistlhd3\x00\x00\x004\x00\u00D0\x0B\u00EE\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x06\x00\x00\x00\b\x00\x00\x00\x04\x00\x00\x00\x01\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00ldat\x00\x00\x00\u00C0\u00C2\x0F\u00B1\x00\u00BF>\u00C2\x00\u00C2\x0F\u00B1\x00\u00BF>\u00C2\x00\u00C2\x15x\u00F0\u00BE\u009A\u00C0\x00\u00C2\x15x\u00F0\u00BE\u009A\u00C0\x00\u00C2\x15x\u00F0\u00BE\u009A\u00C0\x00\u00C2\x17>\u00E0?\u0092`\x00\u00C2\x17>\u00E0?\u0092`\x00\u00C2\x17>\u00E0?\u0092`\x00\u00C2\x19\x03\u00F0\u00BE\u009A\u00C0\x00\u00C2\x19\x03\u00F0\u00BE\u009A\u00C0\x00\u00C2\x19\x03\u00F0\u00BE\u009A\u00C0\x00\u00C2\x1E\u00CC\u00F0\u00BF>\u00C2\x00\u00C2\x1E\u00CC\u00F0\u00BF>\u00C2\x00\u00C2\x1E\u00CC\u00F0\u00BF>\u00C2\x00\u00C2\x19\x03\u00F0\u00BF\u0098\x0F\x00\u00C2\x19\x03\u00F0\u00BF\u0098\x0F\x00\u00C2\x19\x03\u00F0\u00BF\u0098\x0F\x00\u00C2\x17>\u00E0\u00C0(\u008F\u0080\u00C2\x17>\u00E0\u00C0(\u008F\u0080\u00C2\x17>\u00E0\u00C0(\u008F\u0080\u00C2\x15x\u00F0\u00BF\u0098\x0F\x00\u00C2\x15x\u00F0\u00BF\u0098\x0F\x00\u00C2\x15x\u00F0\u00BF\u0098\x0F\x00\u00C2\x0F\u00B1\x00\u00BF>\u00C2\x00omtn\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Ellipse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u00BAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0FEllipse Path 1\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Size\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D2@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000@(\x00\x00\x00\x00\x00\x02@!fffffe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Ellipse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u00BAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0FEllipse Path 2\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Size\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D2@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000@4\x19\u0099\u0099\u0099\u0099\u009B@!fffffe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Ellipse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u00BAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0FEllipse Path 3\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Size\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D2@\x18\u00CC\u00CC\u00CC\u00CC\u00CC\u00D1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Ellipse Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000@<\x19\u0099\u0099\u0099\u0099\u009B@!fffffe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Graphic - Fill\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x05\u00C6tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Fill 1\x00\x00tdmn\x00\x00\x00(ADBE Vector Blend Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Composite Order\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Rule\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Color\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Opacity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Transform Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\b\ftdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vector Anchor\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\u00C0H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Scale\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@\x7F\u00E0\x00\x00\x00\x00\x00@\x7F\u00E0\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Skew\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0U@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@U@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Skew Axis\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Rotation\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Group Opacity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Materials Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x007\u00CAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00M6tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bGroup 2\x00tdmn\x00\x00\x00(ADBE Vector Blend Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vectors Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x0Bbtdgptdsb\x00\x00\x00\x04\x00\x00\x04\x01tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape - Rect\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00E2tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x11Rectangle Path 1\x00\x00tdmn\x00\x00\x00(ADBE Vector Shape Direction\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Rect Size\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00 \x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@o \x00\x00\x00\x00\x00@d \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Rect Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Rect Roundness\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Graphic - Fill\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x05\u00C6tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Fill 1\x00\x00tdmn\x00\x00\x00(ADBE Vector Blend Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Composite Order\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Rule\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\x00\x00\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Color\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Fill Opacity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Transform Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\b\ftdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vector Anchor\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Position\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Scale\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x16tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00P@Y\x00\x00\x00\x00\x00\x00@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u00DF@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00DF@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Skew\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0U@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@U@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Skew Axis\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Rotation\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Group Opacity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vector Materials Group\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x007\u00CAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Front IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Bevel IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Side IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back RGB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x06tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x04\x00\x07\x00\x00\x00\x02\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Ambient\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Diffuse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Specular\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Shininess\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Metal\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Reflection\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Gloss\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Fresnel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back Xparency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back XparRoll\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Vec3D Back IOR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00EEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x02\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<?xpacket begin=\"\u00EF\u00BB\u00BF\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 5.3-c011 66.146227, 2012/04/10-09:44:09        \">\n   <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n      <rdf:Description rdf:about=\"\"\n            xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n         <dc:format>application/vnd.adobe.aftereffects.preset-animation</dc:format>\n      </rdf:Description>\n      <rdf:Description rdf:about=\"\"\n            xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n         <xmp:CreatorTool>Adobe After Effects CS6 (Windows)</xmp:CreatorTool>\n         <xmp:CreateDate>2018-04-04T19:04:33+02:00</xmp:CreateDate>\n         <xmp:MetadataDate>2018-04-04T19:04:33+02:00</xmp:MetadataDate>\n         <xmp:ModifyDate>2018-04-04T19:04:33+02:00</xmp:ModifyDate>\n      </rdf:Description>\n      <rdf:Description rdf:about=\"\"\n            xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\"\n            xmlns:stEvt=\"http://ns.adobe.com/xap/1.0/sType/ResourceEvent#\">\n         <xmpMM:InstanceID>xmp.iid:0EF8588D2938E811ADF7A3DA43F57928</xmpMM:InstanceID>\n         <xmpMM:DocumentID>xmp.did:0EF8588D2938E811ADF7A3DA43F57928</xmpMM:DocumentID>\n         <xmpMM:OriginalDocumentID>xmp.did:0EF8588D2938E811ADF7A3DA43F57928</xmpMM:OriginalDocumentID>\n         <xmpMM:History>\n            <rdf:Seq>\n               <rdf:li rdf:parseType=\"Resource\">\n                  <stEvt:action>created</stEvt:action>\n                  <stEvt:instanceID>xmp.iid:0EF8588D2938E811ADF7A3DA43F57928</stEvt:instanceID>\n                  <stEvt:when>2018-04-04T19:04:33+02:00</stEvt:when>\n                  <stEvt:softwareAgent>Adobe After Effects CS6 (Windows)</stEvt:softwareAgent>\n               </rdf:li>\n            </rdf:Seq>\n         </xmpMM:History>\n      </rdf:Description>\n   </rdf:RDF>\n</x:xmpmeta>\n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                           \n<?xpacket end=\"w\"?>","fileName":"duaef_magic.ffx","category":"pseudoEffects"};
duaef_magic;

/**
* Constructs a Pseudo Effect
* @class Structure
* @classdesc Describes a pseudo effect
* @param  {File} file - The ffx file
* @param  {string} [matchName=""] - The matchName
* @param  {string} [name=""] - The default name
* @property  {File} file - The ffx file
* @property  {string} matchName - The matchName
* @property  {string} name - The default name
*/
function PseudoEffect(file,matchName,name)
{
	if(typeof name == 'undefined') name = '';
	if(typeof matchName == 'undefined') matchName = '';
	this.file = file;
	this.matchName = matchName;
	if (name != '') DuAEF.DuScriptUI.uiStrings.push(name);
	this.name = tr(name);
}

/**
* This method adds the pseudo effect to a layer
* @param {Layer} layer - The layer
* @param {string} [name=this.name] - A name for the effect
* @return {PropertyGroup|null} The effect or null if there's no matchName
*/
PseudoEffect.prototype.apply = function(layer,name)
{
	if (this.matchName == '')
	{
		DuAEF.DuAE.Layer.applyPreset(layer,this.file);
		return null;
	}

	if (typeof name === 'undefined') name = this.name;

	return DuAEF.DuAE.Layer.addPseudoEffect(layer,this.file,this.matchName,name);
}

/**
* Constructs a new KeySpatialProperty
* @class KeySpatialProperties
* @classdesc Spatial properties of a {@linkcode KeyFrame}.
* @property {float[]|null}	  [inTangent=null]     - The incoming spatial tangent
* @property {float[]|null}    [outTangent=null]            -  The outgoing spatial tangent
* @property {boolean}      [_continuous=true]         - true if the specified keyframe has spatial continuity
* @property {boolean}	[_autoBezier=false]			- true if the specified keyframe has temporal auto-Bezier interpolation
* @property {boolean}	[_roving=false]	- true if the specified keyframe is roving
*/
function KeySpatialProperties (){
	this.inTangent = null;
	this.outTangent = null;
	this._continuous = true;
	this._autoBezier = false;
	this._roving = false;
}

/**
* Constructs a new KeyFrame
* @class KeyFrame
* @classdesc Properties of an After Effects Keyframe, as returned by {@linkcode DuAEF.DuAE.Property.getKeyFrames} or {@linkcode DuAEF.DuAE.Property.getKeyFrameAtIndex} or {@linkcode DuAEF.DuAE.Property.getKeyFrameAtTime}.
* @property {float}	  _time     - The keyframe time
* @property {null|folat[]|float|MarkerValue|int|Shape|TextDocument}    value  -  The keyframe value
* @property {KeyframeInterpolationType}   _inInterpolationType  - The incoming temporal interpolation type
* @property {KeyframeInterpolationType}	_outInterpolationType		- The outgoing temporal interpolation type
* @property {boolean}	_spatial	- true if this keyframe has a spatial value
* @property {KeySpatialProperties}	spatialProperties	- the spatial properties {@linkcode KeySpatialProperties} of this keyframe
* @property {KeyframeEase[]}	inEase	- The incoming temporal ease. The number of objects in the Array depends on the value type
* @property {KeyframeEase[]}	outEase	- The outgoing temporal ease. The number of objects in the Array depends on the value type
* @property {boolean}	_continuous	- true if the keyframe has temporal continuity
* @property {boolean}	_autoBezier	- true if the keyframe has temporal auto-Bezier interpolation
* @property {int}		_index	- The index of the keyFrame. Warning: not updated when another key frame is added on the property some time before this key._time!
*/
function KeyFrame(){
	this._time = 0;
	this.value = null;
	this._inInterpolationType = KeyframeInterpolationType.LINEAR;
	this._outInterpolationType = KeyframeInterpolationType.LINEAR;
	this._spatial = false;
	this.spatialProperties = new KeySpatialProperties();
	this.inEase = null;
	this.outEase = null;
	this._continuous = false;
	this._autoBezier = false;
	this._index = 0;
}

/**
* Constructs a new animation
* @class PropertyAnim
* @classdesc Describes the animation of an After Effects property
* @property {string}	  [_name=""]     - The property name
* @property {string}    [_matchName=""]  - The property matchName
* @property {KeyFrame[]}   [keys=[]]  - The keyframes of the animation
* @property {null|float[]|float|MarkerValue|int|Shape|TextDocument}	[startValue=null]		- The value at the beginning of the animation
* @property {string}	[expression=""]		- The expression on the property, if any.
* @property {string}   [type="anim"]  - Read Only.
* @property {float}   startTime  - Read Only. The starting time of the animation.
* @property {float}   endTime  - Read Only. The ending time of the animation.
*/
function PropertyAnim()
{
	this._name = "";
	this._matchName = "";
	this.keys = [];
	this.startValue = null;
	this.type = "anim";
	this.expression = "";
	this.dimensions = 0;
	this.startTime = null;
	this.endTime = null;
}

/**
* Constructs a new group animation
* @class PropertyGroupAnim
* @classdesc Contains all PropertyAnim from an After Effects PropertyGroup
* @property {string}	  [_name=""]     - The property name
* @property {string}    [_matchName=""]  - The property matchName
* @property {PropertyAnim[]|PropertyGroupAnim[]}   [anims=[]]  - The animations in the group
* @property {string}   [type="group"]  - Read Only.
* @property {float}   startTime  - Read Only. The starting time of the animation.
* @property {float}   endTime  - Read Only. The ending time of the animation.
*/
function PropertyGroupAnim()
{
	this._name = "";
	this._matchName = "";
	this.anims = [];
	this.type = "group";
	this.startTime = null;
	this.endTile = null;
}

/**
* Constructs a new layer animation
* @class LayerAnim
* @classdesc Contains all PropertyGroupAnim from an After Effects Layer
* @property {string}	  [_name=""]     - The property name
* @property {int}    [_index=""]  - The index of the layer
* @property {PropertyGroupAnim[]} [anims=[]] - All the animations of the layer
* @property {float} [firstKeyFrameTime=0] - The time of the first keyframe
* @property {string}   [type="layer"]  - Read Only.
* @property {float}   startTime  - Read Only. The starting time of the animation.
* @property {float}   endTime  - Read Only. The ending time of the animation.
*/
function LayerAnim()
{
	this._name = "";
	this._index = 0;
	this.anims = [];
	this.type = 'layer';
	this.startTime = null;
	this.endTile = null;
}

/**
* Constructs a new PropertyInfo
* @example
* var propInfo = new PropertyInfo(property);
* layer("ADBE effect parade").addProperty("ADBE layer control"); //now the property object is broken
* property = propInfo.getProperty(); // You can retrieve the property like this, fixed if it's an effect
* @class PropertyInfo
* @classdesc Get some handy informations about a property<br />
* This class is able to "fix" effects properties which have been broken by
* the addition of another effect on the same layer, as long as the class has been
* instanciated before the effect has been broken.
* @param {PropertyBase} property - The property
* @property {int} index - The propertyIndex
* @property {boolean} isEffect - true if this is an effect (sub)property
* @property {boolean} riggable  - true if this prop can be rigged (it's a value which can set expressions)
* @property {Layer} layer - The layer containing the property
* @property {int} dimensions - The number of dimensions, 0 if this is not a dimensionnal value (ie color, text, shape...)
*/
function PropertyInfo(property)
{
	this.property = property;
	this.index = property.propertyIndex;
	this.parentIndices  = [this.index];
	this.isEffect = property.isEffect;
	var parentProp = property;
	while (parentProp.parentProperty)
	{
		// Traverse up the property tree
		parentProp = parentProp.parentProperty;
		this.isEffect = parentProp.isEffect;
		this.parentIndices.unshift(parentProp.propertyIndex);
		if (this.isEffect) break;
	}

	this.riggable = DuAEF.DuAE.Property.isRiggable(property);
	this.editable = DuAEF.DuAE.Property.isEditable(property);
	this.numerical = DuAEF.DuAE.Property.isNumerical(property);
	this.layer = DuAEF.DuAE.Property.getLayer(property);
	this.comp = this.layer.containingComp;
	this.dimensions = DuAEF.DuAE.Property.getDimensions(property);
}

/**
* Gets the original Property<br />
* Always works even if this PropertyInfo represents an effect which has been broken<br />
* ---AE Hack---
* @memberof PropertyInfo
* @return {PropertyBase} The property
* @todo When returning an effect, check if the matchName corresponds too.
*/
PropertyInfo.prototype.getProperty = function()
{
	if (this.isEffect)
	{
		var parentProp = this.layer("ADBE Effect Parade");
		for (var i = 0 ; i < this.parentIndices.length ; i++)
		{
			parentProp = parentProp(this.parentIndices[i]);
		}
		this.property = parentProp;
	}
	return this.property;
}

/**
 * After Effects Tools
 * @author Nicolas Dufresne, Kevin Masson and contributors
 * @copyright 2017,2018 Nicolas Dufresne, Rainbox Productions<br />
 * {@link https://rainboxprod.coop}
 * @namespace
 * @memberof DuAEF
 * @license GPL-3.0 <br />
 * DuAEF is free software: you can redistribute it and/or modify<br />
 * it under the terms of the GNU General Public License as published by<br />
 * the Free Software Foundation, either version 3 of the License, or<br />
 * (at your option) any later version.<br />
 *<br />
 * DuAEF is distributed in the hope that it will be useful,<br />
 * but WITHOUT ANY WARRANTY; without even the implied warranty of<br />
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<br />
 * GNU General Public License for more details.<br />
 *<br />
 * You should have received a copy of the GNU General Public License<br />
 * along with DuAEF. If not, see {@link http://www.gnu.org/licenses/}.
 */
DuAEF.DuAE = {};

/**
 * The axis or channels
 * @enum {int}
 * @readonly
 */
DuAEF.DuAE.Axis =
{
	X: 1,
	Y: 2,
	Z: 3,
	RED: 4,
	GREEN: 5,
	BLUE: 6,
	ALPHA: 7,
	HUE: 8,
	SATURATION: 9,
	VALUE: 10
}

/**
 * Types of values
 * @enum {int}
 * @readonly
 */
DuAEF.DuAE.Types =
{
	VALUE: 1,
	VELOCITY: 2
}

/**
* Associative array that converts property match names to their compact English expression statements.
* @example
* DuAEF.DuAE.compactExpressions["ADBE Transform Group"]
* //returns "'transform'"
* @type {Object}
*/
DuAEF.DuAE.compactExpressions =
{
	"ADBE Transform Group":"'transform'",
	// Handle camera/light vs. AV layers
	"ADBE Anchor Point":"((prop.propertyGroup(prop.propertyDepth).property('intensity')!=null) || (prop.propertyGroup(prop.propertyDepth).property('zoom')!=null)) ? '.pointOfInterest' : '.anchorPoint'",
	"ADBE Position":"'.position'",
	"ADBE Scale":"'.scale'",
	"ADBE Orientation":"'.orientation'",
	"ADBE Rotate X":"'.xRotation'",
	"ADBE Rotate Y":"'.yRotation'",
	// Handle 3D vs. 2D layers
	"ADBE Rotate Z":"(prop.propertyGroup(prop.propertyDepth).threeDLayer || (prop.propertyGroup(prop.propertyDepth).property('intensity')!=null) || (prop.propertyGroup(prop.propertyDepth).property('zoom')!=null)) ? '.zRotation' : '.rotation'",
	"ADBE Opacity":"'.opacity'",
	"ADBE Material Options Group":"'materialOption'",
	"ADBE Casts Shadows":"'.castsShadows'",
	"ADBE Light Transmission":"'.lightTransmission'",
	"ADBE Accepts Shadows":"'.acceptsShadows'",
	"ADBE Accepts Lights":"'.acceptsLights'",
	"ADBE Ambient Coefficient":"'.ambient'",
	"ADBE Diffuse Coefficient":"'.diffuse'",
	"ADBE Specular Coefficient":"'.specular'",
	"ADBE Shininess Coefficient":"'.shininess'",
	"ADBE Metal Coefficient":"'.metal'",
	"ADBE Light Options Group":"'lightOption'",
	"ADBE Light Intensity":"'.intensity'",
	"ADBE Light Color":"'.color'",
	"ADBE Light Cone Angle":"'.coneAngle'",
	"ADBE Light Cone Feather 2":"'.coneFeather'",
	"ADBE Light Shadow Darkness":"'.shadowDarkness'",
	"ADBE Light Shadow Diffusion":"'.shadowDiffusion'",
	"ADBE Camera Options Group":"'cameraOption'",
	"ADBE Camera Zoom":"'.zoom'",
	"ADBE Camera Depth of Field":"'.depthOfField'",
	"ADBE Camera Focus Distance":"'.focusDistance'",
	"ADBE Camera Aperture":"'.aperture'",
	"ADBE Camera Blur Level":"'.blurLevel'",
	"ADBE Text Properties":"'text'",
	"ADBE Text Document":"'.sourceText'",
	"ADBE Text Path Options":"'.pathOption'",
	"ADBE Text Path":"'.path'",
	"ADBE Text Reverse Path":"'.reversePath'",
	"ADBE Text Perpendicular To Path":"'.perpendicularToPath'",
	"ADBE Text Force Align Path":"'.forceAlignment'",
	"ADBE Text First Margin":"'.firstMargin'",
	"ADBE Text Last Margin":"'.lastMargin'",
	"ADBE Text More Options":"'.moreOption'",
	"ADBE Text Anchor Point Option":"'.anchorPointGrouping'",
	"ADBE Text Anchor Point Align":"'.groupingAlignment'",
	"ADBE Text Render Order":"'.fillANdStroke'",
	"ADBE Text Character Blend Mode":"'.interCharacterBlending'",
	"ADBE Text Animators":"'.animator'",
	"ADBE Text Selectors":"'.selector'",
	"ADBE Text Percent Start":"'.start'",
	"ADBE Text Percent End":"'.end'",
	"ADBE Text Percent Offset":"'.offset'",
	"ADBE Text Index Start":"'.start'",
	"ADBE Text Index End":"'.end'",
	"ADBE Text Index Offset":"'.offset'",
	"ADBE Text Range Advanced":"'.advanced'",
	"ADBE Text Range Units":"'.units'",
	"ADBE Text Range Type2":"'.basedOn'",
	"ADBE Text Selector Mode":"'.mode'",
	"ADBE Text Selector Max Amount":"'.amount'",
	"ADBE Text Range Shape":"'.shape'",
	"ADBE Text Selector Smoothness":"'.smoothness'",
	"ADBE Text Levels Max Ease":"'.easeHigh'",
	"ADBE Text Levels Min Ease":"'.easeLow'",
	"ADBE Text Randomize Order":"'.randomizeOrder'",
	"ADBE Text Random Seed":"'.randomSeed'",
	"ADBE Text Selector Mode":"'.mode'",
	"ADBE Text Wiggly Max Amount":"'.maxAmount'",
	"ADBE Text Wiggly Min Amount":"'.minAmount'",
	"ADBE Text Range Type2":"'.basedOn'",
	"ADBE Text Temporal Freq":"'.wigglesSecond'",
	"ADBE Text Character Correlation":"'.correlation'",
	"ADBE Text Temporal Phase":"'.temporalPhase'",
	"ADBE Text Spatial Phase":"'.spatialPhase'",
	"ADBE Text Wiggly Lock Dim":"'.lockDimensions'",
	"ADBE Text Wiggly Random Seed":"'.randomSeed'",
	"ADBE Text Range Type2":"'.basedOn'",
	"ADBE Text Expressible Amount":"'.amount'",
	"ADBE Text Animator Properties":"'.property'",
	"ADBE Text Anchor Point 3D":"'.anchorPoint'",
	"ADBE Text Position 3D":"'.position'",
	"ADBE Text Scale 3D":"'.scale'",
	"ADBE Text Skew":"'.skew'",
	"ADBE Text Skew Axis":"'.skewAxis'",
	"ADBE Text Rotation X":"'.xRotation'",
	"ADBE Text Rotation Y":"'.yRotation'",
	"ADBE Text Rotation":"'.zRotation'",
	"ADBE Text Opacity":"'.opacity'",
	"ADBE Text Fill Opacity":"'.fillOpacity'",
	"ADBE Text Fill Color":"'.fillColor'",
	"ADBE Text Fill Hue":"'.fillHue'",
	"ADBE Text Fill Saturation":"'.fillSaturation'",
	"ADBE Text Fill Brightness":"'.fillBrightness'",
	"ADBE Text Stroke Opacity":"'.strokeOpacity'",
	"ADBE Text Stroke Color":"'.strokeColor'",
	"ADBE Text Stroke Hue":"'.strokeHue'",
	"ADBE Text Stroke Saturation":"'.strokeSaturation'",
	"ADBE Text Stroke Brightness":"'.strokeBrightness'",
	"ADBE Text Stroke Width":"'.strokeWidth'",
	"ADBE Text Line Anchor":"'.lineAnchor'",
	"ADBE Text Line Spacing":"'.lineSpacing'",
	"ADBE Text Track Type":"'.trackingType'",
	"ADBE Text Tracking Amount":"'.trackingAmount'",
	"ADBE Text Character Change Type":"'.characterAlignment'",
	"ADBE Text Character Range":"'.characterRange'",
	"ADBE Text Character Replace":"'.characterValue'",
	"ADBE Text Character Offset":"'.characterOffset'",
	"ADBE Text Blur":"'.blur'",
	"ADBE Mask Parade":"'mask'",
	"ADBE Mask Shape":"'.maskPath'",
	"ADBE Mask Feather":"'.maskFeather'",
	"ADBE Mask Opacity":"'.maskOpacity'",
	"ADBE Mask Offset":"'.maskExpansion'",
	"ADBE Effect Parade":"'effect'",
	"ADBE Paint Group":"'.stroke'",
	"ADBE Paint Shape":"'.path'",
	"ADBE Paint Properties":"'.strokeOption'",
	"ADBE Paint Begin":"'.start'",
	"ADBE Paint End":"'.end'",
	"ADBE Paint Color":"'.color'",
	"ADBE Paint Diameter":"'.diameter'",
	"ADBE Paint Angle":"'.angle'",
	"ADBE Paint Hardness":"'.hardness'",
	"ADBE Paint Roundness":"'.roundness'",
	"ADBE Paint Tip Spacing":"'.spacing'",
	"ADBE Paint Target Channels":"'.channels'",
	"ADBE Paint Opacity":"'.opacity'",
	"ADBE Paint Flow":"'.flow'",
	"ADBE Paint Clone Layer":"'.cloneSource'",
	"ADBE Paint Clone Position":"'.clonePosition'",
	"ADBE Paint Clone Time":"'.cloneTime'",
	"ADBE Paint Clone Time Shift":"'.cloneTimeShift'",
	"ADBE Paint Transform":"'.transform'",
	"ADBE Paint Anchor Point":"'.anchorPoint'",
	"ADBE Paint Position":"'.position'",
	"ADBE Paint Scale":"'.scale'",
	"ADBE Paint Rotation":"'.rotation'",
	"ADBE MTrackers":"'motionTracker'",
	"ADBE MTracker Pt Feature Center":"'.featureCenter'",
	"ADBE MTracker Pt Feature Size":"'.featureSize'",
	"ADBE MTracker Pt Search Ofst":"'.searchOffset'",
	"ADBE MTracker Pt Search Size":"'.searchSize'",
	"ADBE MTracker Pt Confidence":"'.confidence'",
	"ADBE MTracker Pt Attach Pt":"'.attachPoint'",
	"ADBE MTracker Pt Attach Pt Ofst":"'.attachPointOffset'",
	"ADBE Audio Group":"'audio'",
	"ADBE Audio Levels":"'.audioLevels'",
	"ADBE Time Remapping":"'timeRemap'",
	"ADBE Layer Styles":"'layerStyle'",
	"ADBE Blend Options Group":"'.blendingOption'",
		"ADBE Global Angle2":"'.globalLightAngle'",
		"ADBE Global Altitude2":"'.globalLightAltitude'",
		"ADBE Adv Blend Group":"'.advancedBlending'",
		"ADBE Layer Fill Opacity2":"'.fillOpacity'",
		"ADBE R Channel Blend":"'.red'",
		"ADBE G Channel Blend":"'.green'",
		"ADBE B Channel Blend":"'.blue'",
		"ADBE Blend Interior":"'.blendInteriorStylesAsGroup'",
		"ADBE Blend Ranges":"'.useBlendRangesFromSource'",
	"dropShadow/enabled":"'.dropShadow'",
		"dropShadow/mode2":"'.blendMode'",
		"dropShadow/color":"'.color'",
		"dropShadow/opacity":"'.opacity'",
		"dropShadow/useGlobalAngle":"'.useGlobalLight'",
		"dropShadow/localLightingAngle":"'.angle'",
		"dropShadow/distance":"'.distance'",
		"dropShadow/chokeMatte":"'.spread'",
		"dropShadow/blur":"'.size'",
		"dropShadow/noise":"'.noise'",
		"dropShadow/layerConceals":"'.layerKnocksOutDropShadow'",
	"innerShadow/enabled":"'.innerShadow'",
		"innerShadow/mode2":"'.blendMode'",
		"innerShadow/color":"'.color'",
		"innerShadow/opacity":"'.opacity'",
		"innerShadow/useGlobalAngle":"'.useGlobalLight'",
		"innerShadow/localLightingAngle":"'.angle'",
		"innerShadow/distance":"'.distance'",
		"innerShadow/chokeMatte":"'.choke'",
		"innerShadow/blur":"'.size'",
		"innerShadow/noise":"'.noise'",
	"outerGlow/enabled":"'.outerGlow'",
		"outerGlow/mode2":"'.blendMode'",
		"outerGlow/opacity":"'.opacity'",
		"outerGlow/noise":"'.noise'",
		"outerGlow/AEColorChoice":"'.colorType'",
		"outerGlow/color":"'.color'",
		"outerGlow/gradientSmoothness":"'.gradientSmoothness'",
		"outerGlow/glowTechnique":"'.technique'",
		"outerGlow/chokeMatte":"'.spread'",
		"outerGlow/blur":"'.size'",
		"outerGlow/inputRange":"'.range'",
		"outerGlow/shadingNoise":"'.jitter'",
	"innerGlow/enabled":"'.innerGlow'",
		"innerGlow/mode2":"'.blendMode'",
		"innerGlow/opacity":"'.opacity'",
		"innerGlow/noise":"'.noise'",
		"innerGlow/AEColorChoice":"'.colorType'",
		"innerGlow/color":"'.color'",
		"innerGlow/gradientSmoothness":"'.gradientSmoothness'",
		"innerGlow/glowTechnique":"'.technique'",
		"innerGlow/innerGlowSource":"'.source'",
		"innerGlow/chokeMatte":"'.choke'",
		"innerGlow/blur":"'.size'",
		"innerGlow/inputRange":"'.range'",
		"innerGlow/shadingNoise":"'.jitter'",
	"bevelEmboss/enabled":"'.bevelAndEmboss'",
		"bevelEmboss/bevelStyle":"'.style'",
		"bevelEmboss/bevelTechnique":"'.technique'",
		"bevelEmboss/strengthRatio":"'.depth'",
		"bevelEmboss/bevelDirection":"'.direction'",
		"bevelEmboss/blur":"'.size'",
		"bevelEmboss/softness":"'.soften'",
		"bevelEmboss/useGlobalAngle":"'.useGlobalLight'",
		"bevelEmboss/localLightingAngle":"'.angle'",
		"bevelEmboss/localLightingAltitude":"'.altitude'",
		"bevelEmboss/highlightMode":"'.highlightMode'",
		"bevelEmboss/highlightColor":"'.highlightColor'",
		"bevelEmboss/highlightOpacity":"'.highlightOpacity'",
		"bevelEmboss/shadowMode":"'.shadowMode'",
		"bevelEmboss/shadowColor":"'.shadowColor'",
		"bevelEmboss/shadowOpacity":"'.shadowOpacity'",
	"chromeFX/enabled":"'.satin'",
		"chromeFX/mode2":"'.blendMode'",
		"chromeFX/color":"'.color'",
		"chromeFX/opacity":"'.opacity'",
		"chromeFX/localLightingAngle":"'.angle'",
		"chromeFX/distance":"'.distance'",
		"chromeFX/blur":"'.size'",
		"chromeFX/invert":"'.invert'",
	"solidFill/enabled":"'.colorOverlay'",
		"solidFill/mode2":"'.blendMode'",
		"solidFill/color":"'.color'",
		"solidFill/opacity":"'.opacity'",
	"gradientFill/enabled":"'.gradientOverlay'",
		"gradientFill/mode2":"'.blendMode'",
		"gradientFill/opacity":"'.opacity'",
		"gradientFill/gradientSmoothness":"'.gradientSmoothness'",
		"gradientFill/angle":"'.angle'",
		"gradientFill/type":"'.style'",
		"gradientFill/reverse":"'.reverse'",
		"gradientFill/align":"'.alignWithLayer'",
		"gradientFill/scale":"'.scale'",
		"gradientFill/offset":"'.offset'",
	"patternFill/enabled":"'.patternOverlay'",
		"patternFill/mode2":"'.blendMode'",
		"patternFill/opacity":"'.opacity'",
		"patternFill/align":"'.linkWithLayer'",
		"patternFill/scale":"'.scale'",
		"patternFill/phase":"'.offset'",
	"frameFX/enabled":"'.stroke'",
		"frameFX/mode2":"'.blendMode'",
		"frameFX/color":"'.color'",
		"frameFX/size":"'.size'",
		"frameFX/opacity":"'.opacity'",
		"frameFX/style":"'.position'",
};

/**
* Menu Command Ids<br />
* These are the ids which can be found using <code>app.findMenuCommandID("insertMenuNameHere");</code><br />
* Use <code>app.executeCommand(id)</code> to run them.
* @enum {int}
* @readonly
* @example
* app.executeCommand(DuAEF.DuAE.menuCommandID.COPY); //copies the selection
* app.executeCommand(DuAEF.DuAE.menuCommandID.PASTE); //pastes the selection
*/
DuAEF.DuAE.menuCommandID =
{
	//EDIT menu
	CUT: 18,
	COPY: 19,
	COPY_WITH_PROPERTY_LINKS: 10310,
	PASTE: 20,
	DUPLICATE: 2080
}

/**
* How to place new layers
* @enum {int}
* @readonly
*/
DuAEF.DuAE.LayerPlacements =
{
	BOTTOM: 0,
	UNDER_LAYER: 1,
	ABOVE_LAYER: 2,
	TOP: 3
}

/**
 * Types of layers used by Ae
 * @enum {string}
 * @readonly
 */
DuAEF.DuAE.LayerTypes =
{
	NULL: 'null',
	SOLID: 'solid',
	SHAPE: 'shape',
	TEXT: 'text',
	ADJUSTMENT: 'adjustment',
	LIGHT: 'light',
	CAMERA: 'camera'
}

/**
 * Attributes of layers in Ae
 * @enum {string}
 * @readonly
 */
DuAEF.DuAE.LayerAttributes =
{
	SELECTED: 'selected',
	VISIBLE: 'visible',
	AUDIO: 'audio',
	SOLO: 'solo',
	LOCKED: 'locked',
	SHY: 'shy',
	EFFECTS_ENABLED: 'effects',
	MOTION_BLUR: 'motionblur',
	THREE_D: '3d',
	GUIDE: 'guide'
}

/**
* Checks if the param is an AE collection or an Array
* @param {Array|Collection} collection - The list to check
* @return {boolean} true if collection is a collection, false if it's an array
*/
DuAEF.DuAE.isCollection = function (collection)
{
	return collection instanceof ItemCollection || collection instanceof LayerCollection || collection instanceof OMCollection || collection instanceof RQItemCollection;
}

/**
* Gets the PropertyInfo for the properties
* @param {PropertyBase[]} props - The Properties
* @return {PropertyInfo[]} The info
*/
DuAEF.DuAE.getPropertyInfos = function (props)
{
	//convert to propinfo
	var propInfos = [];
	for (var i = 0 ; i < props.length ; i++)
	{
		var propInfo;
		if (props[i] instanceof PropertyInfo) propInfo = props[i];
		else propInfo = new PropertyInfo(props[i]);
		propInfos.push(propInfo);
	}
	return propInfos;
}

/**
* Converts an AE Collection to an Array<br />
* Should only be used in case you need an copy of the collection as an Array,<br />
* you should use an {@link Iterator} otherwise
* @param {Array|Collection} collection - The collection to convert
* @return {Array} The array
*/
DuAEF.DuAE.convertCollectionToArray = function (collection)
{
	var arr = [];
	if (DuAEF.DuAE.isCollection(collection))
	{
		for (var i = 1;i<=collection.length;i++)
		{
			arr.push(collection[i]);
		}
	}
	else
	{
		arr = collection;
	}
	return arr;
}

/**
* Application related methods
* @namespace
* @memberof DuAEF.DuAE
*/
DuAEF.DuAE.App = {};

//App Properties
(function ()
{
	//detect AE Version
	var reV = /^(\d+\.?\d*)/i;
	var v = app.version.match(reV);

	/**
	* The After Effects version
	* @memberof DuAEF.DuAE.App
	* @readonly
	* @type {float}
	*/
	DuAEF.DuAE.App.version = parseFloat(v[1]);

	/**
	 * Has scripting file and network authorization
	 * @readonly
	 * @type {boolean}
	 */
	DuAEF.DuAE.App.hasFilesAndNetworkAccess = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY") == 1;
})();

/**
* Asks the user to check the file and network security pref if not already set.
* Opens the general prefrences of After Effects.
* @memberof DuAEF.DuAE.App
* @param {boolean}	[showAlert=true]	- Wether to display an alert before opening the preferences
* @param {string}	[message=The Duduf After Effects scripting framework needs to be allowed to write files\nPlease, check the box called 'Allow Scripts to write files...' in the general preferences of After Effects.]	- The message to display in the alert.
* @return {boolean}	Wether the preference has been set
*/
DuAEF.DuAE.App.askFilesAndNetworkAccess = function(showAlert,message)
{
	if (showAlert == undefined) alert = true;
	if (message == undefined ) message = "The Duduf After Effects framework needs to be allowed to write files\nPlease, check the box called 'Allow Scripts to write files...' in the general preferences of After Effects.";
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		if (showAlert) alert(message);
		app.executeCommand(2359);
		DuAEF.DuAE.App.hasFilesAndNetworkAccess = app.preferences.getPrefAsLong("Main Pref Section","Pref_SCRIPTING_FILE_NETWORK_SECURITY") == 1;
	}
	return DuAEF.DuAE.App.hasFilesAndNetworkAccess;
}

/**
* Gets the public name of a version of After Effects (like CC2015.3 for version 13.8)
* @param {float}	[versionAsFloat]	- The version as a float. If not provided, will default to the current version of the running instance of After Effects.
* @return {string}	The version name.
*/
DuAEF.DuAE.App.getAEVersionName = function(versionAsFloat)
{
	if (versionAsFloat == undefined) versionAsFloat = DuAEF.DuAE.App.version;
	if (versionAsFloat < 8) return "" + versionAsFloat;
	if (versionAsFloat >= 8 && versionAsFloat < 9) return "CS3";
	if (versionAsFloat >= 9 && versionAsFloat < 10) return "CS4";
	if (versionAsFloat >= 10 && versionAsFloat < 10.5) return "CS5";
	if (versionAsFloat >= 10.5 && versionAsFloat < 11) return "CS5.5";
	if (versionAsFloat >= 11 && versionAsFloat < 12) return "CS6";
	if (versionAsFloat >= 12 && versionAsFloat < 13) return "CC";
	if (versionAsFloat >= 13 && versionAsFloat < 13.1) return "CC2014";
	if (versionAsFloat >= 13.1 && versionAsFloat < 13.2) return "CC2014.1";
	if (versionAsFloat >= 13.2 && versionAsFloat < 13.5) return "CC2014.2";
	if (versionAsFloat >= 13.5 && versionAsFloat < 13.6) return "CC2015";
	if (versionAsFloat >= 13.6 && versionAsFloat < 13.7) return "CC2015.1";
	if (versionAsFloat >= 13.7 && versionAsFloat < 13.8) return "CC2015.2";
	if (versionAsFloat >= 13.8 && versionAsFloat < 14) return "CC2015.3";
	if (versionAsFloat >= 14 && versionAsFloat < 15) return "CC2017";
	if (versionAsFloat >= 15 && versionAsFloat < 16) return "CC2018";
	else return "Unknown";
}

/**
* Cuts the selection (runs the cut menu command)
*/
DuAEF.DuAE.App.cut = function()
{
	app.executeCommand(DuAEF.DuAE.menuCommandID.CUT);
}

/**
* Copies the selection (runs the copy menu command)
*/
DuAEF.DuAE.App.copy = function()
{
	app.executeCommand(DuAEF.DuAE.menuCommandID.COPY);
}

/**
* Duplcates the selection (runs the duplicate menu command)
*/
DuAEF.DuAE.App.duplicate = function()
{
	app.executeCommand(DuAEF.DuAE.menuCommandID.DUPLICATE);
}

/**
* Copies the selection with property links (runs the copy menu command)<br />
* Only on versions of After Effects greater than 11.0 (CS6)<br />
* On CS6 and below, a standard copy will be done.
*/
DuAEF.DuAE.App.copyWithPropertyLinks = function()
{
	if (DuAEF.DuAE.App.version >= 12.0) app.executeCommand(DuAEF.DuAE.menuCommandID.COPY_WITH_PROPERTY_LINKS);
	else DuAEF.DuAE.App.copy();
}

/**
* Pastes the selection (runs the paste menu command)
*/
DuAEF.DuAE.App.paste = function()
{
	app.executeCommand(DuAEF.DuAE.menuCommandID.PASTE);
}

/**
* After Effects project methods
* @namespace
* @memberof DuAEF.DuAE
*/
DuAEF.DuAE.Project = {};

//undocumented flags
DuAEF.DuAE.Project.progressMode = false;
DuAEF.DuAE.Project.activeComp = null;
DuAEF.DuAE.Project.progressComp = null;
DuAEF.DuAE.Project.viewerMaximized = false;

/**
 * Sets the project in "waiting mode" to speed up things.
 * @param {bool} inProgress - True to set progress mode, false to stop it.
*/
DuAEF.DuAE.Project.setProgressMode = function(inProgress)
{
	if (inProgress && DuAEF.DuAE.Project.progressMode) return;
	if (!inProgress && !DuAEF.DuAE.Project.progressMode) return;

	if (inProgress)
	{
		//store the current comp
		DuAEF.DuAE.Project.activeComp = DuAEF.DuAE.Project.getActiveComp();

		if (app.activeViewer != null) DuAEF.DuAE.Project.viewerMaximized = app.activeViewer.maximized;

		//create a temp comp, open it
		DuAEF.DuAE.Project.progressComp = app.project.items.addComp("MAGIC IS HAPPENING...", 500, 500, 1, 1, 1);

		var tempL = DuAEF.DuAE.Project.progressComp.layers.addShape();
		tempL.applyPreset(DuAEF.DuBinary.toFile(duaef_magic));
		tempL.selected = false;

		DuAEF.DuAE.Project.progressComp.openInViewer();
		if (app.activeViewer != null) app.activeViewer.maximized = true;

		DuAEF.DuAE.Project.progressMode = true;
	}
	else
	{
		//remove temp comp
		if (DuAEF.DuAE.Project.progressComp != null) DuAEF.DuAE.Project.progressComp.remove();
		//re-activate previous comp
		if (DuAEF.DuAE.Project.activeComp != null) DuAEF.DuAE.Project.activeComp.openInViewer();
		if (app.activeViewer != null) app.activeViewer.maximized = DuAEF.DuAE.Project.viewerMaximized;

		DuAEF.DuAE.Project.progressMode = false;
	}

}

/** Gets all compositions in the project
* @return {CompItem[]} The compositions
*/
DuAEF.DuAE.Project.getComps = function()
{
	var comps = [];
	var it = new Iterator(app.project.items);
	it.do(function(comp)
	{
		if (comp instanceof CompItem) comps.push(comp);
	});
	return comps;
}

/**
* Gets the After Effects current composition
* @return {CompItem|null} The current composition or null if there's no current comp
*/
DuAEF.DuAE.Project.getActiveComp = function()
{
	if (DuAEF.DuAE.Project.progressMode) return DuAEF.DuAE.Project.activeComp;
	var comp = app.project.activeItem;
	if (!comp) return null;
	if (!(comp instanceof CompItem)) return null;
	return comp;
}

/**
* Retrieves an item by its Item ID
* @return {Item|null} The item
*/
DuAEF.DuAE.Project.getItemById = function (id)
{

	var it = new Iterator(app.project.items);
	while(item = it.next())
	{
		if (item.id == id) return item;
	}
	return null;
}

/**
* After Effects composition methods
* @namespace
* @memberof DuAEF.DuAE
*/
DuAEF.DuAE.Comp = {};

/**
* Gets the After Effects selected properties in the current comp
* @param {PropertyType|PropertyValueType|string|function}	 [filter]	- A filter to get only a certain type, or value type, or property name or matchName.<br />
* A function which take one PropertyBase as argument can be used to filter the properties: the Property will be returned if the function returns true.
* @param {boolean}	[strict=false]	- If a string filter is provided, wether to search for the exact name/matchName or if it contains the filter.
* @param {boolean}	[caseSensitive=true]	- If a string filter is provided, and not strict is false, does the search have to be case sensitive?
* @return {PropertyInfo[]} The selected properties, an empty Array if nothing active or selected
*/
DuAEF.DuAE.Comp.getSelectedProps = function(filter,strict,caseSensitive)
{
	var props = [];
	var comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return props;

	//if no filter, get all using AE native API
	if (typeof filter === 'undefined')
	{
		var layers = comp.selectedLayers;
		var itLayers = new Iterator(layers);
		itLayers.do(function(layer)
		{
			props = props.concat(layer.selectedProperties);
		});
	}
	else
	{
		var layers = comp.selectedLayers;
		if (layers.length === 0) return props;

		for (var i = 0 ; i < layers.length ; i++)
		{
			props = props.concat(DuAEF.DuAE.Layer.getSelectedProps(layers[i],filter,strict,caseSensitive));
		}
	}

	return DuAEF.DuAE.getPropertyInfos(props);
}

/**
* Gets the selected layers in the current comp
* @return {Layer[]} The selected layers
*/
DuAEF.DuAE.Comp.getSelectedLayers = function()
{
	var comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return [];
	return comp.selectedLayers;
}

/**
* Gets the After Effects animated (with keyframes) properties in the current comp
* @param {PropertyType|PropertyValueType|string|function}	 [filter]	- A filter to get only a certain type, or value type, or property name or matchName.<br />
* A function which take one PropertyBase as argument can be used to filter the properties: the Property will be returned if the function returns true.
* @param {boolean}	[strict=false]	- If a string filter is provided, wether to search for the exact name/matchName or if it contains the filter.
* @param {boolean}	[caseSensitive=true]	- If a string filter is provided, and not strict is false, does the search have to be case sensitive?
* @param {boolean}	[selectedLayersOnly=false]	- True to get the properties on the selected layers only
* @param {CompItem}	[comp=DuAEF.DuAE.Project.getActiveComp]	- The composition
* @return {PropertyInfo[]} The selected properties, an empty Array if nothing active or selected
*/
DuAEF.DuAE.Comp.getAnimatedProps = function(filter, strict, caseSensitive, selectedLayersOnly, comp)
{
	var props = [];
	if (typeof comp === 'undefined') comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return props;

	if (typeof selectedLayersOnly === 'undefined') selectedLayersOnly = false;


	var layers;
	if (selectedLayersOnly) layers = comp.selectedLayers;
	else layers = comp.layers;

	var it = new Iterator(layers);
	it.do(function (layer)
	{
		props = props.concat(DuAEF.DuAE.Property.getAnimatedProps(layer, filter, strict, caseSensitive));
	});

	return props;
}

/**
* Deselects all properties in the current composition
*/
DuAEF.DuAE.Comp.unselectProperties = function()
{
	var comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return props;
	var props = comp.selectedProperties;
	for (var i = 0; i < props.length ; i++)
	{
		props[i].selected = false;
	}
}

/**
* Deselects all layers in a composition
* @param {CompItem} [comp=app.project.activeItem] - The composition
* @return {Layer[]} The previously selected layers.<br />
* A custom attribute, Layer.props is added on each layer object which is an array of all previously selected properties as PropertyInfo objects
*/
DuAEF.DuAE.Comp.unselectLayers = function(comp)
{
	if (typeof comp === 'undefined') comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return [];

	var layers = [];

	if (!comp) return layers;
	if (!(comp instanceof CompItem)) return layers;

	layers = [];

	while (comp.selectedLayers.length > 0)
	{
		var layer = comp.selectedLayers[0];
		layer.props = DuAEF.DuAE.getPropertyInfos(layer.selectedProperties);
		layer.selected = false;
		layers.push(layer);
	}

	return layers;
}

/**
* Selects the layers
* @param {Layer[]} layers - The layers
*/
DuAEF.DuAE.Comp.selectLayers = function (layers)
{
	new Iterator(layers).do(function(layer)
	{
		if (layer == undefined) return;
		if (layer == null) return;
		layer.selected = true;
	});
}

/**
* Generates a new unique name for a layer
* @param {string} newName	- The wanted new name
* @param {CompItem} comp 	- The comp
* @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
* @return {string}	The unique name, with a new number at the end if needed.
*/
DuAEF.DuAE.Comp.newUniqueLayerName = function(newName, comp,increment)
{
	if (increment == undefined) increment = true;
	var layerNames = [];
	for (var i = 1 ; i <= comp.layers.length ; i++)
	{
		layerNames.push(comp.layer(i).name);
	}
	return DuAEF.DuJS.String.generateUnique(newName,layerNames,increment);
}

/**
* Generates a new unique name for a marker for this comp
* @param {string} newName	- The wanted new name
* @param {CompItem} comp 	- The comp
* @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
* @return {string}	The unique name, with a new number at the end if needed.
*/
DuAEF.DuAE.Comp.newUniqueMarkerName = function(newName, comp,increment)
{
	if (increment == undefined) increment = true;
	var markerNames = [];
	for (var i = 1, num = comp.markerProperty.numKeys ; i <= num ; i++)
	{
		markerNames.push(comp.markerProperty.keyValue(i).comment);
	}
	return DuAEF.DuJS.String.generateUnique(newName,markerNames,increment);
}

/**
* Creates a new Adjustment layer
* @param {CompItem} comp 	- The comp
* @return {AVLayer}	The layer.
*/
DuAEF.DuAE.Comp.addAdjustmentLayer = function(comp)
{
	if (comp == undefined) return null;
	var layer = comp.layers.addSolid([1,1,1], DuAEF.DuAE.Comp.newUniqueLayerName("Adjustment Layer",comp) , comp.width, comp.height, comp.pixelAspect, comp.duration);
	layer.adjustmentLayer = true;
	return layer;
}

/**
* Links all orphan layers in the comp to a layer
* @param {Layer} layer - The parent layer
* @param {bool} [includeLockedLayers=false] - True to parent layers even if they are locked
*/
DuAEF.DuAE.Comp.parentAllOrphans = function(layer,includeLockedLayers)
{
	if (typeof includeLockedLayers === "undefined") includeLockedLayers = false;
	var comp = layer.containingComp;
	for (var i = 1,num = comp.numLayers;i<=num;i++)
	{
		if (i == layer.index) continue;
		var l = comp.layer(i);
		if (DuAEF.DuAE.Layer.getRelation(l,layer) < 0) continue;
		var locked = l.locked;
		if (locked && includeLockedLayers) l.locked = false;
		if (!locked && l.parent == null) l.parent = layer;
		if (locked && includeLockedLayers) l.locked = locked;
	}
}

/**
 * Gets all precomps and parent comps of the composition
 * @param {CompItem} [comp=DuAEF.DuAE.Project.getActiveComp()] - The composition
 * @param {bool} [recursive=false] - True to search to more than one level of precomposition
 * @return {CompItem[]} The related compositons
 */
DuAEF.DuAE.Comp.getRelatives = function(comp, recursive)
{
	if (typeof recursive === 'undefined') recursive = false;
	if (typeof comp === 'undefined') comp = DuAEF.DuAE.Project.getActiveComp();
	if (!comp) return [];
	//get precomps
	var precomps = DuAEF.DuAE.Comp.getPrecomps(comp,recursive);
	//get parent
	var parentComps = [];
	if (recursive)
	{
		parentComps = DuAEF.DuAE.Comp.getParentComps(comp);
	}
	else
	{
		parentComps = comp.usedIn;
	}

	return precomps.concat(parentComps);
}

/**
* Gets all the precomposition found in the comp.
* @param {CompItem} comp - The composition
* @param {bool} [recursive=false] - True to get nested compositions
* @return {CompItem[]} The precompositions
*/
DuAEF.DuAE.Comp.getPrecomps = function(comp,recursive)
{
	if (typeof recursive === 'undefined') recursive = true;
	var precomps = [];
	var it = new Iterator(comp.layers);
	it.do(function(layer)
	{
		var precomp = layer.source;
		if (precomp instanceof CompItem)
		{
			precomps.push(precomp);
			if (recursive) precomps = precomps.concat(DuAEF.DuAE.Comp.getPrecomps(precomp));
		}
	});
	//remove duplicates
	DuAEF.DuJS.Array.removeDuplicates(precomps);
	return precomps;
}

/**
* Recursively gets all compositions where this item is used
* @param {AVItem} item - The item
* @return {CompItem[]} The compositions
*/
DuAEF.DuAE.Comp.getParentComps = function(item)
{
	var parentComps = item.usedIn;
	new Iterator(parentComps).do(function(parentComp)
	{
		parentComps = parentComps.concat(DuAEF.DuAE.Comp.getParentComps(parentComp));
	});
	DuAEF.DuJS.Array.removeDuplicates(parentComps);
	return parentComps;
}

/**
* Gets all the layers with audio in the composition
* @param {CompItem}	 comp	The composition where the audio will be searched
* @param {bool}	[audioActiveOnly=false]	 If true, does not get muted layers.
* @return {AVLayer[]} An array of AVLayer containing the audio layers
*/
DuAEF.DuAE.Comp.getAudioLayers = function (comp,audioActiveOnly)
{
	if (typeof audioActiveOnly === 'undefined') audioActiveOnly = false;
	var layers = comp.layers;
	var audioLayers = [];
	var it = new Iterator(layers);
	it.do(function (layer)
	{
		if (layer.hasAudio)
		{
			if (audioActiveOnly && layer.audioEnabled || !audioActiveOnly)
			{
				audioLayers.push(layer);
			}
		}
	});

	return audioLayers;
}

/**
* After Effects layer methods
* @namespace
* @memberof DuAEF.DuAE
*/
DuAEF.DuAE.Layer = {};

/**
* Generates a new unique name for an effect
* @param {string} newName	- The wanted new name
* @param {Layer} layer 	- The layer
* @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
* @return {string}	The unique name, with a new number at the end if needed.
*/
DuAEF.DuAE.Layer.newUniqueEffectName = function(newName, layer, increment)
{
	if (!layer) throw new Error("Needs a layer to generate a new unique effect name","DuAECOreLib",645);
	if (increment == undefined) increment = true;
	if (newName == undefined) return "";
	if (newName == "") return "";
	var effectNames = [];
	for (var i = 1 ; i <= layer.effect.numProperties ; i++)
	{
		effectNames.push(layer.effect(i).name);
	}
	return DuAEF.DuJS.String.generateUnique(newName,effectNames,increment);
}

/**
* Generates a new unique name for a marker for this comp
* @param {string} newName	- The wanted new name
* @param {Layer} layer 	- The comp
* @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
* @return {string}	The unique name, with a new number at the end if needed.
*/
DuAEF.DuAE.Layer.newUniqueMarkerName = function(newName, layer,increment)
{
	if (increment == undefined) increment = true;
	var markerNames = [];
	for (var i = 1, num = layer.property('ADBE Marker').numKeys ; i <= num ; i++)
	{
		markerNames.push(layer.property('ADBE Marker').keyValue(i).comment);
	}
	return DuAEF.DuJS.String.generateUnique(newName,markerNames,increment);
}

/**
* Gets the After Effects selected properties in the layer
* @param {Layer}	layer	- The layer
* @param {PropertyType|PropertyValueType|string|function}	 [filter]	- A filter to get only a certain type, or value type, or property name or matchName.<br />
* A function which take one PropertyBase as argument can be used to filter the properties: the Property will be returned if the function returns true.
* @param {boolean}	[strict=false]	- If a string filter is provided, wether to search for the exact name/matchName or if it contains the filter.
* @param {boolean}	[caseSensitive=true]	- If a string filter is provided, and not strict is false, does the search have to be case sensitive?
* @return {PropertyBase[]} The selected properties, an empty Array if nothing active or selected
*/
DuAEF.DuAE.Layer.getSelectedProps = function(layer,filter,strict,caseSensitive)
{
	if (strict == undefined) strict = false;
	if (caseSensitive == undefined) caseSensitive = true;

	var props = [];

	if (!caseSensitive && typeof filter === "string") filter = filter.toLowerCase();

	var selectedProps = layer.selectedProperties;
	if (filter == undefined)
	{
		props = props.concat(selectedProps);
	}
	else
	{
		for (var j = 0 ; j < selectedProps.length ; j++)
		{
			var prop = selectedProps[j];

			var name = prop.name;
			var matchName = prop.matchName;
			if (!caseSensitive)
			{
				name = name.toLowerCase();
				matchName = matchName.toLowerCase();
			}

			if (strict && name === filter) props.push(prop);
			else if (strict && matchName === filter) props.push(prop);
			else if (typeof filter === "string")
			{
				if (name.indexOf(filter) >= 0) props.push(prop);
				else if (matchName.indexOf(filter) >= 0) props.push(prop);
			}
			else if (prop.propertyType == PropertyType.PROPERTY) if (prop.propertyValueType == filter) props.push(prop);
			else if (prop.propertyType == filter) props.push(prop);
			else if (typeof filter === "function") if (filter(prop)) props.push(prop);
		}
	}

	return DuAEF.DuAE.getPropertyInfos(props);
}

/**
* Gets all animations on the layer in the whole timeline or in the time range<br />
* The first KeyFrame._time will be adjusted relatively to the start of the time range (if provided) instead of the startTime of the composition.
* @param {Layer}	layer	- The layer.
* @param {boolean}	[selected=false]	- true to get only selected keyframes.
* @param {float[]}	[timeRange]	- The time range, an array of two time values, in seconds.
* @return {LayerAnim}	The animation.
*/
DuAEF.DuAE.Layer.getAnim = function (layer,selected,timeRange)
{
	var anim = new LayerAnim();
	anim._name = layer.name;
	anim._index = layer.index;
	anim.anims = [];
	for (var propIndex = 1;propIndex <= layer.numProperties;propIndex++)
	{
		var prop = layer.property(propIndex);
		if (prop.matchName == 'ADBE Marker') continue;

		var subAnim = DuAEF.DuAE.Property.getAnim(prop,selected,timeRange);
		if (subAnim != null)
		{
			if (anim.startTime == null) anim.startTime = subAnim.startTime;
			else if (anim.startTime > subAnim.startTime) anim.startTime = subAnim.startTime;
			if (anim.endTime == null) anim.endTime = subAnim.endTime;
			else if (anim.endTime > subAnim.endTime) anim.endTime = subAnim.endTimeendTime;
			anim.anims.push(subAnim);
		}

	}
	return anim;
}

/**
* Gets all animations on the layers in the whole timeline or in the time range<br />
* The first KeyFrame._time will be adjusted relatively to the start of the time range (if provided) instead of the startTime of the composition.
* @param {Layer[]|LayerCollection}	layers	- The layers.
* @param {boolean}	[selected=false]	- true to get only selected keyframes.
* @param {float[]}	[timeRange]	- The time range, an array of two time values, in seconds.
* @return {LayerAnim[]}	The animations.
*/
DuAEF.DuAE.Layer.getAnims = function (layers,selected,timeRange)
{
	var anims = [];
	new Iterator(layers).do(function(layer)
	{
		anims.push(DuAEF.DuAE.Layer.getAnim(layer,selected,timeRange));
	});
	return anims;
}

/**
* Sets the property animation on the property
* @param {Layer}	layer	- The layer.
* @param {LayerAnim} anims	- The animation
* @param {float}	[time=comp.time]	- The time where to begin the animation
* @param {boolean}	[ignoreName=false]	- true to set the anim even if name of the property do not match the name of the animation.<br />
* This way, only the type of property (i.e. matchName) is checked.
* @param {boolean}	[setExpression=false]	- Set the expression on the property
* @param {boolean}	[onlyKeyframes=true]	- If false, the value of properties without keyframes will be set too.
* @param {boolean}	[replace=false]	- true to remove any existing keyframe on the properties before adding new keyframes
* @param {string[]}	[propertyWhiteList]	- A list of matchNames used as a white list for properties to set anims.<br />
* Can be the matchName of a propertyGroup to set all the subproperties.
* @param {boolean}	[offset=false]	- true to offset the current value, instead of replacing it
* @param {boolean}	[reverse=false]	- true to reverse the keyframes (in time)
* @return {boolean} true if the anim was actually set.
*/
DuAEF.DuAE.Layer.setAnim = function(layer, anim, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, reverse)
{
	if (typeof time === 'undefined') time = layer.containingComp.time;
	if (typeof ignoreName === 'undefined') ignoreName = false;
	if (typeof setExpression === 'undefined') setExpression = false;
	if (typeof onlyKeyframes === 'undefined') onlyKeyframes = false;
	if (typeof replace === 'undefined') replace = false;
	if (typeof offset === 'undefined') offset = false;

	if (reverse) DuAEF.DuAE.Layer.reverseAnims(anim);

	for (var i = 0 ; i < anim.anims.length ; i++)
	{
		var subAnim = anim.anims[i];
		for (var propIndex = 1;propIndex <= layer.numProperties;propIndex++)
		{
			var subProp = layer.property(propIndex);
			if (subProp == null) continue;
			if (subProp.matchName == subAnim._matchName && subProp.matchName != 'ADBE Marker')
			{
				var ok = DuAEF.DuAE.Property.setGroupAnim(subProp, subAnim, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, reverse);
				if (ok) break;
			}
		}
	}
}

/**
* Sets the animations on the layers.<br />
* If you need to set only on the same layers (same index, same name), use {@link DuAEF.DuAE.Layer.setAnims}.
* @param {Layer[]|LayerCollection}	layers	- The layers.<br />
* If there are more layers than animations, the layers array will be truncated.
* @param {LayerAnim[]} anims	- The layer animations.<br />
* If there are more animations than layers, the animations array will be truncated.
* @param {float}	[time=comp.time]	- The time where to begin the animation
* @param {boolean}	[ignoreName=false]	- true to set the anim even if name of the property do not match the name animation.<br />
* This way, only the type of property (i.e. matchName) is checked.
* @param {boolean}	[setExpression=false]	- Set the expression on the property
* @param {boolean}	[onlyKeyframes=true]	- If false, the value of properties without keyframes will be set too.
* @param {boolean}	[replace=false]	- true to remove any existing keyframe on the properties before adding new keyframes
* @param {string[]}	[whiteList]	- A list of matchNames used as a white list for properties to set anims.<br />
* Can be the matchName of a propertyGroup to set all the subproperties.
* @param {boolean}	[offset=false]	- true to offset the current value, instead of replacing it
* @param {boolean}	[reverse=false]	- true to reverse the keyframes (in time)<br />
* Note: the remaining animations which are returned will already be reversed, do not set this to true again if you plan to set them later.
*/
DuAEF.DuAE.Layer.setAllAnims = function(layers, anims, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, reverse)
{
	layers = DuAEF.DuAE.convertCollectionToArray (layers);
	var num = anims.length;
	if (num > layers.length) num = layers.length;

	if (reverse) DuAEF.DuAE.Layer.reverseAnims(anims);

	for (var i = 0; i < num; i++)
	{
		var layer = layers[i];
		if (layer) DuAEF.DuAE.Layer.setAnim(layer, anims[i], time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, false);
	}
}

/**
* Sets the animations on the corresponding layers.<br />
* The animation will be set only on layers with the same name and index.<br />
* To set all animations on all layers, not checking their names or indices, use {@link DuAEF.DuAE.Layer.setAllAnims}.
* @param {Layer[]|LayerCollection}	layers	- The layers.
* @param {LayerAnim[]} anims	- The layer animations
* @param {float}	[time=comp.time]	- The time where to begin the animation
* @param {boolean}	[ignoreName=false]	- true to set the anim even if name of the property do not match the name animation.<br />
* This way, only the type of property (i.e. matchName) is checked.
* @param {boolean}	[setExpression=false]	- Set the expression on the property
* @param {boolean}	[onlyKeyframes=true]	- If false, the value of properties without keyframes will be set too.
* @param {boolean}	[replace=false]	- true to remove any existing keyframe on the properties before adding new keyframes
* @param {string[]}	[whiteList]	- A list of matchNames used as a white list for properties to set anims.<br />
* Can be the matchName of a propertyGroup to set all the subproperties.
* @param {boolean}	[offset=false]	- true to offset the current value, instead of replacing it
* @param {boolean}	[reverse=false]	- true to reverse the keyframes (in time)<br />
* Note: the remaining animations which are returned will already be reversed, do not set this to true again if you plan to set them later.
* @return {LayerAnim[]} The animations which were not set (no corresponding layers)
*/
DuAEF.DuAE.Layer.setAnims = function(layers, anims, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, reverse)
{
	//clone the array
	var remaining = anims.slice();

	if (reverse) DuAEF.DuAE.Layer.reverseAnims(anims);

	//for each layeranim, search for the layer and apply anim
	for (var i = remaining.length-1; i >= 0; i--)
	{
		var anim = remaining[i];
		var it = new Iterator(layers);
		var ok = false;
		while(layer = it.next())
		{
			if (layer.name == anim._name && layer.index == anim._index)
			{
				DuAEF.DuAE.Layer.setAnim(layer, anim, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, false);
				ok = true;
				break;
			}
		}
		if (ok) remaining.pop();
	}

	return remaining;
}

/**
* Reverses the times of the keyframes to reverse the animation
* @param {LayerAnim[]|LayerAnim} anims The animation
*/
DuAEF.DuAE.Layer.reverseAnims = function(anims)
{
	if (anims instanceof LayerAnim) anims = [anims];

	var it = new Iterator(anims);

	//get times
	var startTime = null;
	var endTime = null;
	it.do(function(anim)
	{
		if (startTime == null) startTime = anim.startTime;
		else if (startTime > anim.startTime) startTime = anim.startTime;
		if (endTime == null) endTime = anim.endTime;
		else if (endTime > anim.endTime) endTime = anim.endTime;
	});

	var duration = endTime - startTime;


	//recursive function to reverse keyframes in anim
	function reverse(anim)
	{
		if (anim.type == 'anim')
		{
			//reverse the array
			anim.keys = anim.keys.reverse();
			//set the new times
			for (var i = 0, num = anim.keys.length; i < num; i++)
			{
				var ratio = 1 - ( (anim.keys[i]._time - startTime) / duration);
				anim.keys[i]._time = ratio * duration + startTime;
				var sV = anim.endValue;
				anim.endValue = anim.startValue;
				anim.startValue = sV;
			}
		}
		else if (anim.anims)
		{
			for (var i = 0, num = anim.anims.length; i < num; i++)
			{
				reverse(anim.anims[i]);
			}
		}
	}

	//reverse keyframes and times
	it.do(reverse);
}

/**
* Gets the children of a layer
* @param {Layer}	layer	- The layer.
* @return {Layer[]} All the children of the layer
*/
DuAEF.DuAE.Layer.getChildren = function(layer)
{
	var comp = layer.containingComp;
	var children = [];
	for (var i = 1 ; i <= comp.layers.length ; i++)
	{
		var l = comp.layer(i);
		if (l.index == layer.index) continue;
		if (l.parent == null) continue;
		if (l.parent.index == layer.index) children.push(l);
	}
	return children;
}

/**
 * Checks if a layer is a descendant of another layer
 * @param {Layer} layer1 - The first layer
 * @param {Layer} layer2 - The second layer
 * @return {int|null} the degree of relation. 0 if layer1 is not a relative of layer2,<br />
 * negative if layer2 is a descendant of layer1, positive if layer2 is an ancestor.<br />
 * null if the two layers are not in the same composition or if they are the same layer.
 */
DuAEF.DuAE.Layer.getRelation = function(layer1,layer2)
{
	var comp1 = layer1.containingComp;
	var comp2 = layer2.containingComp;
	if (comp1 !== comp2) return null;
	if (layer1.index == layer2.index) return null;
	if (layer1.parent == null && layer2.parent == null) return 0;
	//check
	var degree = 0;
	var parent = layer1.parent;
	while (parent)
	{
		degree++;
		if (layer2.index == parent.index) return degree;
		parent = parent.parent;
	}
	var parent = layer2.parent;
	degree = 0;
	while(parent)
	{
		degree++;
		if (layer1.index == parent.index) return -degree;
		parent = parent.parent;
	}
	return 0;
}

/**
* Measures the distance between two layers
* @param {Layer} layer1 - The first layer
* @param {Layer} layer2 - The second layer
* @return {int} The distance (in pixels)
*/
DuAEF.DuAE.Layer.getDistance = function (layer1,layer2)
{
	var O = DuAEF.DuAE.Layer.getWorldPos(layer1);
	var A = DuAEF.DuAE.Layer.getWorldPos(layer2);
	var OA = DuAEF.DuJS.Math.getLength(O,A);

	return Math.round(OA);
}

/**
* Gets the world position of the layer
* @param {Layer} layer - The layer
* @return {float[]} The world coordinates of the layer
*/
DuAEF.DuAE.Layer.getWorldPos = function (layer)
{
	var comp = layer.containingComp;
	//add a null
	var n = comp.layers.addNull();
	n.transform.position.expression = 'thisComp.layer(' + layer.index + ').toWorld(thisComp.layer(' + layer.index + ').anchorPoint);';
	var pos = n.transform.position.value;
	n.remove();
	return pos;
}

/**
 * Adds an animation preset on the layer.<br />
 * Be careful as layer selection will be kept but not properties selection,<br />
 * and this can result in an "invalid object" if referencing a property.
 * @param {Layer} layer - The layer
 * @param {File} preset - The preset file
 * @param {string} matchName - The pseudo Effect matchName
 * @return {PropertyGroup|null} The effect corresponding to matchName or null if anything went wrong
 */
DuAEF.DuAE.Layer.applyPreset = function (layer,preset,matchName)
{
	if (typeof layer === 'undefined') return null;
	if (typeof preset === 'undefined') return null;
	if (typeof matchName === 'undefined') matchName = '';
	if (!preset.exists) throw new Error("The pseudo effect file does not exist");

	//remove layer selection
	var comp = layer.containingComp;
	var selection = [];
	for (var i = 1,num = comp.numLayers; i <= num;i++)
	{
		var l = comp.layer(i);
		selection.push(l.selected);
		l.selected = false;
	}

	layer.selected = true;
	layer.applyPreset(preset);

	var effect = null;
	if(matchName != '') effect = layer.property("ADBE Effect Parade")(matchName);

	//restore selection
	for (var i = 1,num = comp.numLayers; i <= num;i++)
	{
		var l = comp.layer(i);
		l.selected = selection[i-1];
	}

	return effect;
}

/**
* This method is a workaround to AE API method layer.applyPreset to work like addProperty when adding pseudoEffects
* @param {Layer} layer - The layer
* @param {File} preset - The preset file
* @param {string} matchName - The pseudo Effect matchName.
* @param {string} [name] - The name to set on the effect
* @return {PropertyGroup|null} The effect or null if anything went wrong
*/
DuAEF.DuAE.Layer.addPseudoEffect = function (layer,preset,matchName,name)
{
	if (!preset.exists) throw new Error("The pseudo effect file does not exist");
	if (layer == undefined) return null;
	if (preset == undefined) return null;
	if (matchName == undefined) return null;

	var effects = layer("ADBE Effect Parade");
	//add the preset to a temp comp if not available as an effect
	if (!effects.canAddProperty(matchName) || DuAEF.debug)
	{
		//create comp
		var comp = app.project.items.addComp("DuAEF Temp", 10, 10, 1, 1, 24);
		//add null
		var n = comp.layers.addNull();
		//apply preset
		n.applyPreset(preset);
		//remove all
		var nullSource = n.source;
		n.remove();
		nullSource.remove();
		comp.remove();
	}

	if (!effects.canAddProperty(matchName))
	{
		throw new Error("Invalid pseudo effect file or match name");
	}

	//add the pseudoEffect as a property
	var newEffectName = "";
	newEffectName = DuAEF.DuAE.Layer.newUniqueEffectName(name,layer);
	var effect = effects.addProperty(matchName);
	if (newEffectName != "") effect.name = newEffectName;
	return effect;
}

/**
* Checks if the layers have some selected keyframes
* @param {Layer[]|LayerCollection} layers - The layers
* @return {boolean} true if the layers have at least one selected keyframe
*/
DuAEF.DuAE.Layer.haveSelectedKeys = function (layers)
{
	var it = new Iterator(layers);
	if (it.length == 0) return;
	while(layer = it.next())
	{
		if (DuAEF.DuAE.Property.hasSelectedKeys(layer)) return true;
	}
	return false;
}

/**
* Gets the time of the first keyFrame
* @param {Layer[]|LayerCollection} layer - The layer
* @param {boolean} selected - true to check selected keyframes only
* @return {float|null} The keyframe time or null if there are no keyframe
*/
DuAEF.DuAE.Layer.firstKeyFrameTime = function (layers,selected)
{
	var it =  new Iterator(layers);
	var time = null;
	for (var i = it.min ; i <= it.max ; i++)
	{
		var test = DuAEF.DuAE.Property.firstKeyFrameTime(layers[i],selected);
		if (time == null) time = test;
		else if (test != null) { if (time > test) time = test; }
	}
	return time;
}

/**
* Sort the layers by their parenting (root at first index 0)
* @param {Layer[]|Collection} layers - The layers to sort
* @return {Layer[]} The sorted array
*/
DuAEF.DuAE.Layer.sortByParent = function (layers)
{
	var sortedLayers = [];
	var layersToSort = DuAEF.DuAE.convertCollectionToArray(layers);

	//add layers with no parents
	for (var i = layersToSort.length - 1 ; i >= 0 ; i--)
	{
		var l = layersToSort[i];
		if (l.parent == null)
		{
			sortedLayers.push(l);
			layersToSort.splice(i,1);
		}
	}

	//add layers with a parent outside
	//those with a parent outside of the selection
	for (var i = layersToSort.length - 1 ; i >= 0 ; i--)
	{
		var l = layersToSort[i];
		var parent = l.parent;
		var isParentOutside = true;
		for (var j = 0 ; j < layersToSort.length ; j++ )
		{
			if (parent.index == layersToSort[j].index)
			{
				isParentOutside = false;
				break;
			}
		}
		if (isParentOutside)
		{
			sortedLayers.push(l);
			layersToSort.splice(i,1);
		}
	}

	//sort the rest
	while (layersToSort.length > 0)
	{
		for (var i = layersToSort.length - 1 ; i >= 0 ; i--)
		{
			var l = layersToSort[i];
			for (var j = 0 ; j < sortedLayers.length ; j++ )
			{
				var sL = sortedLayers[j];
				if (l.parent.index == sL.index)
				{
					sortedLayers.push(l);
					layersToSort.splice(i,1);
					break;
				}
			}
		}
	}
	return sortedLayers;

}

/**
* Sort the layers by their indices. Returns a new Array, the original array or collection is not changed.
* @param {Layer[]|LayerCollection} layers - The layers to sort
* @return {Layer[]} The sorted array
*/
DuAEF.DuAE.Layer.sortByIndex = function (layers)
{
	var sortedLayers = DuAEF.DuAE.convertCollectionToArray(layers);
	function compareLayerIndices(lay1,lay2)
	{
		return lay1.index-lay2.index;
	}
	return sortedLayers.sort(compareLayerIndices);
}

/**
* Parents all the layers together beginning by the end of the array
* @param {Layer[]} layers - The layers to parent
*/
DuAEF.DuAE.Layer.parentChain = function (layers)
{
	//unparent  all but the first
	var layersUnparent = [];
	for (var i = 1 ; i < layers.length ; i++)
	{
		layersUnparent.push(layers[i]);
	}
	DuAEF.DuAE.Layer.unparent(layersUnparent);

	for (var i = layers.length -1 ; i >= 1 ; i--)
	{
		layers[i].parent = layers[i-1];
	}
}

/**
* Un-parents all the layers
* @param {Layer[]} layers - The layers
*/
DuAEF.DuAE.Layer.unparent = function (layers)
{
	for (var i = layers.length -1 ; i >= 0 ; i--)
	{
		layers[i].parent = null;
	}
}

/**
* Creates a sequence with the layers, but using opacities.
* This enables more possibilities to rig them, like with the Connector
* @param {Layer[]|LayerCollection} layers - The layers
* @param {string} [expr] - An expression to add to the opacity of the layers
*/
DuAEF.DuAE.Layer.sequence = function (layers,expr)
{
	if (layers.length == 0) return;
	if (expr == undefined) expr = '';
	var comp = layers[0].containingComp;
	var it = new Iterator(layers);
	it.do(function (layer)
	{
		while (layer.transform.opacity.numKeys > 0)
		{
			layer.transform.opacity.removeKey(layer.transform.opacity.numKeys);
		}
		var i = it.current;
		var t = i*comp.frameDuration;
		var endTime = (layers.length-1)*comp.frameDuration;
		layer.transform.opacity.setValueAtTime(0,0);
		layer.transform.opacity.setValueAtTime(endTime,0);
		layer.transform.opacity.setValueAtTime(t,100);
		if (i < layers.length -1 ) layer.transform.opacity.setValueAtTime(t+comp.frameDuration,0);
		for (var keyIndex = 1;keyIndex <= layer.transform.opacity.numKeys;keyIndex++)
		{
			layer.transform.opacity.setInterpolationTypeAtKey(keyIndex,KeyframeInterpolationType.HOLD,KeyframeInterpolationType.HOLD);
		}
		layer.transform.opacity.expression = expr;
	});
}

/**
* Adds a new Null object just above a layer, at the same position
* @param {Layer} layer - The layer
* @return {Layer} the null
*/
DuAEF.DuAE.Layer.addNull = function (layer)
{
	if (layer == undefined) return null;
	var nullLayer = layer.containingComp.layers.addNull();
	layerParent = layer.parent;
	layer.parent = null;
	nullLayer.transform.position.setValue(layer.transform.position.value);
	layer.parent = layerParent;
	nullLayer.moveBefore(layer);
	nullLayer.name = "N | " + layer.name;
	return nullLayer;
}

/**
* Locks the scale with an expression so its value cannot be changed
* @param {Layer} layer - The layer
* @param {bool} [allAEVersions=false] - true to lock scale even on CS6 and older<br />
* Those older versions will display the scale property when typing the "U" shorcut when it's locked.
*/
DuAEF.DuAE.Layer.lockScale = function (layer,allAEVersions)
{
	if (typeof allAEVersions == "undefined") allAEVersions = false;
	if (allAEVersions || DuAEF.DuAE.App.version > 12) DuAEF.DuAE.Property.lock(layer.transform.scale);
}

/**
* Copies the layers to another comp
* @param {Layer[]} layers - The layers to copy and paste
* @param {CompItem} destinationComp - The composition to copy to
* @param {boolean} [withPropertyLinks=false] - Add expressions on the properties to link them to the orriginal layers<br />
* Works only on 12.0 and above, ignored on 11.0 (CS6) and below
* @return {Layer[]} The new layers
*/
DuAEF.DuAE.Layer.copyToComp = function (layers, destinationComp, withPropertyLinks)
{
	if (DuAEF.DuAE.App.version < 12.0) withPropertyLinks = false;
	if (typeof withPropertyLinks === 'undefined') withPropertyLinks = false;

	if (layers.length == 0) return;

	var it = new Iterator(layers);

	var previousActiveComp = DuAEF.DuAE.Project.getActiveComp();

	//activate the origin comp
	var originComp = it.firstItem().containingComp;
	originComp.openInViewer();

	//select the layers
	var previousSelection = DuAEF.DuAE.Comp.unselectLayers(originComp);
	DuAEF.DuAE.Comp.selectLayers(layers);

	//copy
	if (withPropertyLinks) DuAEF.DuAE.App.copyWithPropertyLinks();
	else DuAEF.DuAE.App.copy();

	//destination
	destinationComp.openInViewer();

	//unselect layers in destination
	var previousSelectionDestination = DuAEF.DuAE.Comp.unselectLayers(destinationComp);

	//paste
	DuAEF.DuAE.App.paste();

	//keep new layers to return them
	var newLayers = destinationComp.selectedLayers;

	//restore previous state
	DuAEF.DuAE.Comp.selectLayers(previousSelection);
	previousActiveComp.openInViewer();
	DuAEF.DuAE.Comp.selectLayers(previousSelectionDestination);

	return newLayers;
}

/**
* Parents all unparented layers
* @param {Layer[]} layers - The layers to parent
* @param {Layer} parent - The parent
*/
DuAEF.DuAE.Layer.parent = function(layers, parent)
{
	var it = new Iterator (layers);
	it.do(function(layer)
	{
		if (layer.parent == null) layer.parent = parent;
	});
}

/**
 * Gets all the (selected) puppet pins found on the layer.<br />
 * Will return all puppet pins if there is no puppet selection.
 * @param {Layer} layer - The layer
 * @return {PropertyInfo[]} The properties
 */
DuAEF.DuAE.Layer.getPuppetPins = function (layer)
{
	var pins = [];
	var selectedProps = layer.selectedProperties;

	function getPins(puppet)
	{
		//get pins
		var mesh = puppet.property("ADBE FreePin3 ARAP Group").property("ADBE FreePin3 Mesh Group").property("ADBE FreePin3 Mesh Atom").property("ADBE FreePin3 PosPins");
		for (var i = 1, num = mesh.numProperties ; i <= num; i++)
		{
			pins.push(new PropertyInfo(mesh.property(i)));
		}
	}

	if (selectedProps == 0)
	{
		//look for puppet effects
		for (var i = 1, num = layer('ADBE Effect Parade').numProperties; i <= num; i++)
		{
			var effect = layer.effect(i);
			if (effect.matchName == 'ADBE FreePin3')
			{
				getPins(effect);
			}
		}
	}
	else
	{
		//get any selected pin
		var itProps = new Iterator(selectedProps);
		itProps.do(function(prop)
		{
			if (prop.matchName == 'ADBE FreePin3 PosPin Atom') pins.push(new PropertyInfo(prop));
		});
		//try to find selected puppets
		if (pins.length == 0)
		{
			itProps.do(function(prop)
			{
				if (prop.matchName == 'ADBE FreePin3') getPins(prop);
			});
		}
	}


	return pins;
}

/**
* After Effects properties methods
* @namespace
* @memberof DuAEF.DuAE
*/
DuAEF.DuAE.Property = {};

/**
* Gets the After Effects properties in the property
* @param {PropertyBase|PropertyInfo}	property	- The layer
* @param {PropertyType|PropertyValueType|string|function}	 [filter]	- A filter to get only a certain type, or value type, or property name or matchName.<br />
* A function which take one PropertyBase as argument can be used to filter the properties: the Property will be returned if the function returns true.
* @param {boolean}	[strict=false]	- If a string filter is provided, wether to search for the exact name/matchName or if it contains the filter.
* @param {boolean}	[caseSensitive=true]	- If a string filter is provided, and not strict is false, does the search have to be case sensitive?
* @return {PropertyInfo[]} The selected properties, an empty Array if nothing found
*/
DuAEF.DuAE.Property.getProps = function(property,filter,strict,caseSensitive)
{
	if (strict == undefined) strict = false;
	if (caseSensitive == undefined) caseSensitive = true;
	var prop;
	if (property instanceof PropertyInfo) prop = property.getProperty();
	else prop = property;

	var props = [];

	if (!caseSensitive && typeof filter === "string") filter = filter.toLowerCase();

	var name = prop.name;
	var matchName = prop.matchName;
	if (!caseSensitive)
	{
		name = name.toLowerCase();
		matchName = matchName.toLowerCase();
	}

	if (strict && name === filter) props.push(prop);
	else if (strict && matchName === filter) props.push(prop);
	else if (!strict && typeof filter === "string")
	{
		if (name.indexOf(filter) >= 0) props.push(prop);
		else if (matchName.indexOf(filter) >= 0) props.push(prop);
	}
	else if (typeof filter === "function") if (filter(prop)) props.push(prop);
	else if (prop.propertyType == PropertyType.PROPERTY) if (prop.propertyValueType == filter) props.push(prop);
	else if (prop.propertyType == filter) props.push(prop);

	if (prop.numProperties > 0)
	{
		for (var k = 1 ; k <= prop.numProperties ; k++)
		{
			props = props.concat(DuAEF.DuAE.Property.getProps(prop.property(k),filter,strict,caseSensitive));
		}
	}

	return DuAEF.DuAE.getPropertyInfos(props);
}

/**
* Gets the layer containing the property
* @param {PropertyBase|PropertyInfo}	prop	- The After Effects Property
* @return {Layer}	The layer
*/
DuAEF.DuAE.Property.getLayer = function (prop)
{
	if (prop == undefined) throw "You must provide a property.";
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	var parentProp = prop;
	while (parentProp.parentProperty)
	{
		// Traverse up the property tree
		parentProp = parentProp.parentProperty;
	}
	return parentProp;
}

/**
* Gets the composition containing the property
* @param {PropertyBase|PropertyInfo}	prop	- The After Effects Property
* @return {CompItem}	The composition
*/
DuAEF.DuAE.Property.getComp = function (prop)
{
	var layer = DuAEF.DuAE.Property.getLayer(prop);
	return layer.containingComp;
}

/**
* Generates a new unique name for a marker for this marker porperty
* @param {string} newName	- The wanted new name
* @param {Property} prop 	- The comp
* @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
* @return {string}	The unique name, with a new number at the end if needed.
*/
DuAEF.DuAE.Property.newUniqueMarkerName = function(newName, prop,increment)
{
	if (increment == undefined) increment = true;
	var markerNames = [];
	for (var i = 1, num = prop.numKeys ; i <= num ; i++)
	{
		markerNames.push(prop.keyValue(i).comment);
	}
	return DuAEF.DuJS.String.generateUnique(newName,markerNames,increment);
}

/**
* Gets the number of dimensions of a property
* @param {Property|PropertyInfo}	prop	- The After Effects Property
* @return {int}	The number of dimensions, 0 if this is not a dimensionnal value (ie color, text, shape...)
*/
DuAEF.DuAE.Property.getDimensions = function (prop)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	var dimensions = 0;
	if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.ThreeD)
	{
		//if this is a position or scale and the layer is not 3D, AFX uses a 3D value in the position (with 0 as Z position), but the expression must return a 2D value.......
		if ((prop.matchName == "ADBE Scale" || prop.matchName == "ADBE Position") && !DuAEF.DuAE.Property.getLayer(prop).threeDLayer)
		{
			dimensions = 2;
		}
		else
		{
			dimensions = 3;
		}
	}
	else if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD)
	{
		dimensions = 2;
	}
	else if (prop.propertyValueType == PropertyValueType.OneD)
	{
		dimensions = 1;
	}
	else if (prop.propertyValueType == PropertyValueType.COLOR)
	{
		dimensions = 4;
	}
	return dimensions;
}

/**
* Checks if this property value can be edited
* @param {Property|PropertyInfo} prop - The After Effects Property
* @return {bool} true if the value of the property can be edited, false otherwise
*/
DuAEF.DuAE.Property.isEditable = function (prop)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();

	if (prop.propertyType != PropertyType.PROPERTY) return false;
	if (prop.elided) return false;
	if (prop.dimensionsSeparated) return false;

	//try to set a value if there's no keyframe
	if (prop.numKeys !== 0)
	{
		try
		{
			prop.setValue(prop.value);
			return true;
		}
		catch (e)
		{
			return false;
		}
	}

	return true;
}

/**
* Checks if this property value can be rigged (with an expression)
* @param {Property|PropertyInfo} prop - The After Effects Property
* @return {bool} true if the value of the property can be rigged, false otherwise
*/
DuAEF.DuAE.Property.isRiggable = function (prop)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();

	if (prop.propertyType != PropertyType.PROPERTY) return false;
	if (!prop.canVaryOverTime) return false;
	if (!prop.canSetExpression) return false;
	if (prop.elided) return false;
	if (prop.dimensionsSeparated) return false;

	//try to set an expression
	try { prop.expression = prop.expression; return true; } catch (e) { return false; }

	return true;
}

/**
* Gets the key at a given index on a property
* @param {Property|PropertyInfo}	prop	- The property.
* @param {int}	keyIndex	- The index of the key to retrieve. If the index is negative, it is counted from the end i.e. to retrieve the keyframe before the last one, use -2 (-1 is the last)
* @return {KeyFrame}	The keyframe, or null if incorrect index
*/
DuAEF.DuAE.Property.getKeyFrameAtIndex = function (prop,keyIndex)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (Math.abs(keyIndex) > prop.numKeys || keyIndex == 0)
	{
		return null;
	}
	if (keyIndex < 0)
	{
		keyIndex = prop.numKeys - keyIndex + 1;
	}

	var key = new KeyFrame();
	key._time = prop.keyTime(keyIndex);
	key.value = prop.keyValue(keyIndex);
	key._inInterpolationType = prop.keyInInterpolationType(keyIndex);
	key._outInterpolationType = prop.keyOutInterpolationType(keyIndex);
	if ( prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD_SPATIAL )
	{
		key._spatial = true;
		key.spatialProperties.inTangent = prop.keyInSpatialTangent(keyIndex);
		key.spatialProperties.outTangent  = prop.keyOutSpatialTangent(keyIndex);
		key.spatialProperties._continuous = prop.keySpatialContinuous(keyIndex);
		key.spatialProperties._autoBezier = prop.keySpatialAutoBezier(keyIndex);
		key.spatialProperties._roving = prop.keyRoving(keyIndex);
	}
	key.inEase = prop.keyInTemporalEase(keyIndex);
	key.outEase = prop.keyOutTemporalEase(keyIndex);
	key._continuous = prop.keyTemporalContinuous(keyIndex);
	key._autoBezier = prop.keyTemporalAutoBezier(keyIndex);
	key._index = keyIndex;

	return key;
}

/**
* Gets the nearest key at a given time on a property
* @param {Property|PropertyInfo}	prop	- The property.
* @param {float}	time	- The time of the key to retrieve.
* @return {KeyFrame}	The keyframe, or null if incorrect time or not found
*/
DuAEF.DuAE.Property.getNearestKeyFrameAtTime = function (prop,time)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	return DuAEF.DuAE.Property.getKeyFrameAtIndex(prop.nearestKeyIndex(time));
}

/**
* Gets the key at an exactly given time on a property
* @param {Property|PropertyInfo}	prop	- The property.
* @param {float}	time	- The time of the key to retrieve.
* @return {KeyFrame}	The keyframe, or null if incorrect time
*/
DuAEF.DuAE.Property.getKeyFrameAtTime = function (prop,time)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (!prop.canVaryOverTime) return null;
	if (prop.numKeys == 0) return null;
	var key = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,prop.nearestKeyIndex(time));
	if (key === null) return key;
	if (key._time == time) return key;
	else return null;
}

/**
* Gets the property keyframes in the whole timeline or in the time range<br />
* The KeyFrame._time will be adjusted relatively to the start of the time range instead of the startTime of the composition.
* @param {Property|PropertyInfo}	prop	- The property.
* @param {boolean}	[selected=false]	- true to get only selected keyframes.
* @param {float[]}	[timeRange]	- The time range, an array of two time values, in seconds. If not provided, will use the comp time range.<br />
* Ignored if selected is true;
* @return {KeyFrame[]}	The keyframes, or null of this property is of type PropertyValueType.NO_VALUE or PropertyValueType.CUSTOM_VALUE
*/
DuAEF.DuAE.Property.getKeyFrames = function(prop,selected,timeRange)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (prop.propertyValueType == PropertyValueType.NO_VALUE) return [];
	if (prop.propertyValueType == PropertyValueType.CUSTOM_VALUE) return [];

	var comp = DuAEF.DuAE.Property.getComp(prop);
	if (timeRange == undefined) timeRange = [0,comp.duration];
	if (selected == undefined) selected = false;

	var keyFrames = [];

	if (prop.elided) return keyFrames;

	if (prop.isTimeVarying)
	{
		if (selected)
		{
			for (var keyIndex = 0; keyIndex < prop.selectedKeys.length ; keyIndex++)
			{
				var key = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,prop.selectedKeys[keyIndex]);
				if (key._time >= timeRange[0] && key._time <= timeRange[1])
				{
					key._time = key._time - timeRange[0];
					keyFrames.push(key);
				}
			}
		}
		else if (prop.numKeys > 0)
		{
			for (var keyIndex = 1; keyIndex <= prop.numKeys ; keyIndex++)
			{
				var key = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,keyIndex);
				if (key._time >= timeRange[0] && key._time <= timeRange[1])
				{
					key._time = key._time - timeRange[0];
					keyFrames.push(key);
				}
			}
		}
	}
	return keyFrames;
}

/**
* Gets all animations in the group in the whole timeline or in the time range<br />
* The first KeyFrame._time will be adjusted relatively to the start of the time range (if provided) instead of the startTime of the composition.
* @param {PropertyGroup|PropertyInfo}	prop	- The property.
* @param {boolean}	[selected=false]	- true to get only selected keyframes.
* @param {float[]}	[timeRange]	- The time range, an array of two time values, in seconds. If not provided, will use the comp time range.
* @return {PropertyGroupAnim|PropertyAnim}	The animations. A PropertyAnim if prop is a Property, a PopertyGroupAnim if it is a PropertyGroup
*/
DuAEF.DuAE.Property.getAnim = function (prop,selected,timeRange)
{
	var comp = DuAEF.DuAE.Property.getComp(prop);
	if (typeof timeRange === 'undefined') timeRange = [0,comp.duration];
	if (typeof selected === 'undefined') selected = false;

	if (prop instanceof PropertyInfo) prop = prop.getProperty();

	if (selected && !DuAEF.DuAE.Property.hasSelectedKeys(prop)) return null;

	if (prop.propertyType === PropertyType.PROPERTY)
	{
		if (prop.propertyValueType == PropertyValueType.NO_VALUE) return null;
		if (prop.elided) return null;
		if (!prop.canVaryOverTime) return null;
		var anim = new PropertyAnim();
		anim._name = prop.name;
		anim._matchName = prop.matchName;
		anim.startValue = prop.valueAtTime(timeRange[0],true);
		anim.endValue = prop.valueAtTime(timeRange[1],true);
		anim.keys = DuAEF.DuAE.Property.getKeyFrames(prop,selected,timeRange);
		if (anim.keys.length > 0)
		{
			anim.startTime = anim.keys[0]._time;
			anim.endTime = anim.keys[anim.keys.length-1]._time;
		}
		else
		{
			anim.startTime = 0;
			anim.endTime = 0;
		}
		anim.dimensions = DuAEF.DuAE.Property.getDimensions(prop);
		if (prop.canSetExpression) anim.expression = prop.expression;
		return anim;
	}
	else if (prop.numProperties > 0)
	{
		var groupAnim = new PropertyGroupAnim();
		groupAnim._name = prop.name;
		groupAnim._matchName = prop.matchName;

		for (var propIndex = 1;propIndex <= prop.numProperties;propIndex++)
		{
			var anim = DuAEF.DuAE.Property.getAnim(prop.property(propIndex),selected,timeRange);
			if (anim != null)
			{
				if (groupAnim.startTime == null) groupAnim.startTime = anim.startTime;
				else if (groupAnim.startTime > anim.startTime) groupAnim.startTime = anim.startTime;
				if (groupAnim.endTime == null) groupAnim.endTime = anim.endTime;
				else if (groupAnim.endTime > anim.endTime) groupAnim.endTime = anim.endTimeendTime;
				groupAnim.anims.push(anim);
			}
		}
		return groupAnim;
	}
	return null;
}

/**
* Gets the time of the first keyFrame
* @param {PropertyBase[]|PropertyInfo[]} props - The properties
* @param {boolean} selected - true to check selected keyframes only
* @return {float|null} The keyframe time or null if there are no keyframe
*/
DuAEF.DuAE.Property.firstKeyFrameTime = function (prop,selected)
{
	var time = null;

	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (prop.propertyType == PropertyType.PROPERTY)
	{
		if (!prop.canVaryOverTime) return null;
		if (selected)
		{
			if (prop.selectedKeys.length == 0) return null;
			for (var keyIndex = 0; keyIndex < prop.selectedKeys.length ; keyIndex++)
			{
				var key = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,prop.selectedKeys[keyIndex]);
				if (time == null) time = key._time;
				else if (time > key._time) time = key._time;
			}
		}
		else
		{
			if (prop.numKeys == 0) return null;
			for (var keyIndex = 1; keyIndex <= prop.numKeys ; keyIndex++)
			{
				var key = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,keyIndex);
				if (time == null) time = key._time;
				else if (time > key._time) time = key._time;
			}
		}
	}
	else if (prop.numProperties > 0)
	{
		for (var propIndex = 1;propIndex <= prop.numProperties;propIndex++)
		{
			var test = DuAEF.DuAE.Property.firstKeyFrameTime(prop.property(propIndex),selected);
			if (time == null) time = test;
			else if (test != null) { if (time > test) time = test; }
		}
	}

	return time;
}

/**
* Sets a {@linkcode KeyFrame} on a property
* @param {Property|PropertyInfo}	prop	- The property.
* @param {KeyFrame}	key	- The KeyFrame.
* @param {float}	[timeOffset=comp.time]	- The time offset (added to KeyFrame._time) where to add the key frame.
*/
DuAEF.DuAE.Property.setKey = function (prop,key,timeOffset)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (prop.elided) return;
	if (!prop.propertyType === PropertyType.PROPERTY) throw "Can not set a key on a group property";
	if (!prop.canVaryOverTime) return;

	if (timeOffset == undefined) timeOffset = DuAEF.DuAE.Property.getPropertyComp(prop).time;
	var time = key._time + timeOffset;
	var propDimensions = DuAEF.DuAE.Property.getDimensions(prop);
	var val = key.value;

	if (propDimensions > 1 && !(val instanceof Array))
	{
		val = [val];
	}

	//adjust dimensions
	if (val instanceof Array)
	{
		while (val.length < propDimensions)
		{
			val.push(0);
		}
		while (val.length > propDimensions)
		{
			val.pop();
		}
	}

	prop.setValueAtTime(time,val);

	//get the index of the created key
	var index = prop.nearestKeyIndex(time);

	//set interpolations
	if (key._spatial && (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD_SPATIAL))
	{
		try{
			prop.setSpatialContinuousAtKey(index,key.spatialProperties._continuous);
			prop.setSpatialAutoBezierAtKey(index,key.spatialProperties._autoBezier);
			prop.setRovingAtKey(index,key.spatialProperties._roving);
			prop.setSpatialTangentsAtKey(index,key.spatialProperties.inTangent,key.spatialProperties.outTangent);
		}
		catch(err)
		{
			if (DuAEF.debug) alert(err.description);
		};
	}

	try
	{
		prop.setTemporalContinuousAtKey(index,key._continuous);
		prop.setTemporalAutoBezierAtKey(index,key._autoBezier);
		prop.setTemporalEaseAtKey(index,key.inEase,key.outEase);
		prop.setInterpolationTypeAtKey(index,key._inInterpolationType,key._outInterpolationType);
	}
	catch(err)
	{
		if (DuAEF.debug) alert(err.description);
	}

}

/**
* Sets the property animation on the property.<br />
* Use this method only to force the animation onto the property without checks.<br />
* Must be used on a Property (not a group) with a PropertyAnim (not a PropertyGroupAnim).<br />
* To easily set an animation on a property with automatic compatibility checks, you should use setGroupAnim().
* @param {Property|PropertyInfo}	prop	- The property.
* @param {PropertyAnim} anims	- The animation
* @param {float}	[time=comp.time]	- The time where to begin the animation
* @param {boolean}	[setExpression=false]	- Sets the expression too
* @param {boolean}	[replace=false]	- true to remove any existing keyframe on the properties before adding new keyframes
* @param {boolean}	[offset=false]	- true to offset the current value, instead of replacing it
* @return {boolean} true if the anim was actually set.
*/
DuAEF.DuAE.Property.setAnim = function(prop,anim,time,setExpression, replace, offset)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (typeof time === 'undefined') time = DuAEF.DuAE.Property.getPropertyComp(prop).time;
	if (typeof setExpression === 'undefined') setExpression = false;
	if (typeof replace === 'undefined') replace = false;
	if (typeof offset === 'undefined') offset = false;

	if (!DuAEF.DuAE.Property.isNumerical(prop)) offset = false;

	var dimensions = anim.dimensions;

	var ok = false;

	if (anim == null) return true;
	if (anim.type == 'group') return false;

	if (prop.propertyType === PropertyType.PROPERTY && !prop.elided && prop.canVaryOverTime)
	{
		var comp = DuAEF.DuAE.Property.getComp(prop);
		//keep current value
		var val = prop.valueAtTime(comp.time, true);

		//remove keyframes
		if (replace && prop.numKeys > 0)
		{
			for (var i = prop.numKeys; i > 0; i--)
			{
				prop.removeKey(i);
			}
			prop.setValue(val);
		}

		//if there are keys, set them
		if (anim.keys.length > 0)
		{
			for (var iclef = 0; iclef < anim.keys.length;iclef++)
			{
				var key = anim.keys[iclef];
				if (offset)
				{
					if (iclef == 0) key.value = val;
					else key.value = val + (key.value - anim.startValue);
				}
				DuAEF.DuAE.Property.setKey(prop,key,time);
				ok = true;
			}
		}
		else //set the start value
		{
			var value = anim.startValue;
			if (value instanceof Array)
			{
				while (value.length < dimensions)
				{
					value.push(0);
				}
				while (value.length > dimensions)
				{
					value.pop();
				}
			}

			if (anim.startValue != null && !offset)
			{
				if (prop.numKeys == 0)
				{
					DuAEF.DuAE.Property.setValue(anim.startValue);
				}
				else
				{
					try { prop.setValueAtTime(time,anim.startValue); } catch (e) {};
				}
			}
			ok = true;
		}

		//set the expression
		if (prop.canSetExpression && setExpression)
		{
			try { prop.expression = anim.expression; } catch(e) { if (DuAEF.debug) alert(e.description); };
		}
	}

	return ok;
}

/**
* Sets all animations on a Property or a PropertyGroup.
* @param {PropertyGroup|PropertyInfo}	prop	- The property group.
* @param {PropertyAnim} anims	- The animation
* @param {float}	[time=comp.time]	- The time where to begin the animation
* @param {boolean}	[ignoreName=false]	- true to set the anim even if name of the property do not match the animation.
* @param {boolean}	[setExpression=false]	- Sets the expression too
* @param {boolean}	[onlyKeyframes=true]	- If false, the value of properties without keyframes will be set too.
* @param {boolean}	[replace=false]	- true to remove any existing keyframe on the properties before adding new keyframes
* @param {string[]}	[whiteList]	- A list of matchNames used as a white list for properties to set anims.<br />
* Can be the matchName of a propertyGroup to set all the subproperties.<br />
* Ignored if the list is empty.
* @param {boolean}	[offset=false]	- true to offset the current value, instead of replacing it
* @return {boolean} true if the anim was actually set.
*/
DuAEF.DuAE.Property.setGroupAnim = function(prop, anim, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, set )
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (typeof time === 'undefined') time = DuAEF.DuAE.Property.getPropertyComp(prop).time;
	if (typeof ignoreName === 'undefined') ignoreName = false;
	if (typeof setExpression === 'undefined') setExpression = false;
	if (typeof onlyKeyframes === 'undefined') onlyKeyframes = false;
	if (typeof replace === 'undefined') replace = false;
	if (typeof whiteList === 'undefined') whiteList = [];
	if (typeof offset === 'undefined') offset = false;
	if (typeof reverse === 'undefined') reverse = false;
	if (typeof set === 'undefined') set = false;

	if (whiteList.length == 0) set = true;
	if (DuAEF.DuJS.Array.indexOf(whiteList, anim._matchName) >= 0) set = true;

	var ok = false;

	if (anim == null) return true;

	if (anim.type == 'anim')
	{
		if (set)
		{
			var okToSet = false;
			if (prop.matchName == anim._matchName)
			{
				if (!ignoreName && prop.name == anim._name) okToSet = true;
				if (ignoreName) okToSet = true;
				if (onlyKeyframes && anim.keys.length == 0) okToSet = false;
			}

			if (okToSet) return DuAEF.DuAE.Property.setAnim(prop, anim, time, setExpression, replace, offset);
		}
	}
	else
	{
		for (var i = 0 ; i < anim.anims.length ; i++)
		{
			var propAnim = anim.anims[i];
			//find the property with the same name and matchname
			for (var j = 1 ; j <= prop.numProperties ; j++)
			{
				var subProp = prop.property(j);
				var okToSet = false;
				if (subProp.matchName == propAnim._matchName)
				{
					if (!ignoreName && subProp.name == propAnim._name) okToSet = true;
					if (ignoreName) okToSet = true;
				}
				if (okToSet)
				{
					ok = DuAEF.DuAE.Property.setGroupAnim(subProp, propAnim, time, ignoreName, setExpression, onlyKeyframes, replace, whiteList, offset, set );
					break;
				}
			}
		}
	}

	return ok;
}

/**
* Removes the animation from the property
* @param {Property|PropertyInfo} prop -The property
* @param {boolean} [removeExpression=false] - Set to true to remove the expression too
*/
DuAEF.DuAE.Property.removeAnim = function(prop,removeExpression)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	while (prop.numKeys > 0)
	{
		prop.removeKey(1);
	}
	if (removeExpression && prop.canSetExpression)
	{
		prop.expression = '';
	}
}

/**
* Selects the keyframes in the propoerty.<br />
* Selects all nested keyframes if the property is a group.
* @param {PropertyBase|PropertyInfo} property - The property
* @param {float} [inTime=0] - The time at which to select the keyframes
* @param {float} [outTime=inTime] - The end time
*/
DuAEF.DuAE.Property.selectKeyFrames = function(property,inTime,outTime)
{
	if (inTime == undefined) inTime = 0;
	if (outTime == undefined) outTime = inTime;
	var prop;
	if (property instanceof PropertyInfo) prop = property.getProperty();
	else prop = property;

	if (prop.propertyType == PropertyType.PROPERTY)
	{
		if (prop.elided) return;
		if (prop.isSeparationLeader) if (prop.dimensionsSeparated) return;
		if (inTime == outTime)
		{
			//get key
			var key = DuAEF.DuAE.Property.getKeyFrameAtTime(prop,inTime);
			if (key) prop.setSelectedAtKey(key._index,true);
		}
		else
		{
			//get keys
			var keys = DuAEF.DuAE.Property.getKeyFrames(prop,false,[inTime,outTime]);
			if (!keys) return;
			for (var i = 0 ; i < keys.length ; i++)
			{
				prop.setSelectedAtKey(keys[i]._index,true);
			}
		}
	}
	else if (prop.numProperties > 0)
	{
		for (var i = 1 ; i <= prop.numProperties ; i++)
		{
			DuAEF.DuAE.Property.selectKeyFrames(prop.property(i),inTime,outTime);
		}
	}
}

/**
 * Gets an expression link to the property
 * @memberof DuAEF.DuAE.Property
 * @param {Property|PropertyInfo}	prop			- The property
 * @param {bool}		[useThisComp]		- Wether to begin the expression by 'thisComp' or 'comp("name")'
 * @param {bool}		[fromLayer=true]		- Wether to begin the expression by comp.layer or directly from the first prop of the layer
 * @return {str}		The expression link to the property
 */
DuAEF.DuAE.Property.getExpressionLink = function (prop,useThisComp,fromLayer)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (useThisComp == undefined) useThisComp = false;
	if (fromLayer == undefined) fromLayer = true;

	//get compact expression from matchName, if available
	function getCompactExpression(matchName, name)
	{
		var translatedName = DuAEF.DuAE.compactExpressions[matchName];

		if (translatedName !== undefined)
			return eval(translatedName);
		else
			return ("(" + name + ")");
	}

	var exprCode = "";
	var name;
	while (prop.parentProperty !== null)
	{
		if (prop.propertyType == PropertyType.PROPERTY ) name = prop.propertyIndex;
		else if (prop.parentProperty.propertyType == PropertyType.INDEXED_GROUP)
		{
			name = "\"" + prop.name + "\"";
		}
		else name =  "\"" + prop.matchName + "\"";
		compactName = getCompactExpression(prop.matchName, name);
		exprCode = compactName + exprCode;

		// Traverse up the property tree
		prop = prop.parentProperty;
	}

	if (exprCode.indexOf("(") != 0) exprCode = '.' + exprCode;

	if (fromLayer)
	{
		var comp = prop.containingComp;
		// Prefix the layer reference
		name = "\"" + prop.name + "\"";
		exprCode = "layer(" + name + ")" + exprCode;
		// Prefix the comp reference
		if (useThisComp) exprCode = "thisComp." + exprCode;
		else exprCode = "comp(\"" + comp.name + "\")." + exprCode;
	}

	return exprCode;
}

/**
* Sets a value on a property, adjusting the dimensions if needed
* @param {Property|PropertyInfo} prop - The property
* @param {any} value - The value to set
*/
DuAEF.DuAE.Property.setValue = function(prop,value)
{
	var dimensions = 0;
	var editable = false;
	if (prop instanceof PropertyInfo)
	{
		dimensions = prop.dimensions;
		editable = prop.editable;
		prop = prop.getProperty();
	}
	else
	{
		editable = DuAEF.DuAE.Property.isEditable(prop);
		dimensions = DuAEF.DuAE.Property.getDimensions(prop);
	}

	if (!editable) return;

	//check dimensions of the property
	if (dimensions == 0 || dimensions == 1)
	{
		if (value instanceof Array) value = value[0];
		try { prop.setValue(value); } catch (e) { if (DuAEF.debug) alert(e.description); }
	}
	else
	{
		if (!(value instanceof Array)) value = [value];
		while (value.length < dimensions)
		{
			value.push(0);
		}
		while (value.length > dimensions)
		{
			value.pop();
		}
		try { prop.setValue(value); } catch (e) { if (DuAEF.debug) alert(e.description); }
	}
}

/**
* Changes the interpolation type on selected keyframes, or sets a new key at current time if there are no keyframes selected.
* @param {Layer[]|LayerCollection} layers - The layers containing the properties
* @param {PropertyBase[]|PropertyInfo[]} props - The properties
* @param {KeyframeInterpolationType|string} typeIn - The in interpolation type (see AE API) or the string "roving" or "continuous"
* @param {KeyframeInterpolationType|string} [typeOut=typeIn] - The out interpolation type (see AE API)
* @param {int[]|int} [easeInValue=33] - The in interpolation ease value (used if typeIn is KeyframeInterpolationType.BEZIER)
* @param {int[]|int} [easeOutValue=easeInValue] - The out interpolation ease value (used if typeOut is KeyframeInterpolationType.BEZIER)
*/
DuAEF.DuAE.Property.setInterpolationType = function(layers,props,typeIn,typeOut,easeInValue,easeOutValue)
{
	if (typeOut == undefined) typeOut = typeIn;
	if (easeInValue == undefined) easeInValue = 33;
	if (isNaN(easeInValue)) easeInValue = 33;
	if (easeOutValue == undefined) easeOutValue = easeInValue;
	if (isNaN(easeOutValue)) easeOutValue = 33;

	if (layers.length == 0) return;

	if (!DuAEF.DuAE.Layer.haveSelectedKeys(layers))
	{
		DuAEF.DuAE.Property.addKey(props,typeIn,typeOut,easeInValue,easeOutValue);
	}
	else
	{
		for (var i=0;i<props.length;i++)
		{
			var propInfo = props[i];
			var prop = props[i];
			if (!(propInfo instanceof PropertyInfo)) propInfo = new PropertyInfo(prop);
			prop = props[i].getProperty();

			if (prop.canVaryOverTime)
			{
				//for keys
				for (var k=0,num = prop.selectedKeys.length; k<num; k++)
				{
					DuAEF.DuAE.Property.setKeyInterpolation(prop,prop.selectedKeys[k],typeIn,typeOut,easeInValue,easeOutValue);
				}
			}
		}
	}
}

/**
 * Sets interpolations on a keyframe.<br />
 * @param {Property} prop - The property
 * @param {int} key - The key index
 * @param {KeyframeInterpolationType|string} typeIn - The in interpolation type (see AE API) or the string "roving" or "continuous"
 * @param {KeyframeInterpolationType|string} [typeOut=typeIn] - The out interpolation type (see AE API)
 * @param {int[]|int} [easeInValue=33] - The in interpolation ease value (used if typeIn is KeyframeInterpolationType.BEZIER)
 * @param {int[]|int} [easeOutValue=easeInValue] - The out interpolation ease value (used if typeOut is KeyframeInterpolationType.BEZIER)
 */
DuAEF.DuAE.Property.setKeyInterpolation = function (prop, key, typeIn, typeOut, easeInValue, easeOutValue)
{
	if (typeOut == undefined) typeOut = typeIn;
	if (easeInValue == undefined) easeInValue = 33;
	if (isNaN(easeInValue)) easeInValue = 33;
	if (easeOutValue == undefined) easeOutValue = easeInValue;
	if (isNaN(easeOutValue)) easeOutValue = 33;

	easeInValue = new KeyframeEase(0,easeInValue);
	easeOutValue = new KeyframeEase(0,easeOutValue);

	if (typeIn == "roving" && prop.isSpatial)
	{
		prop.setRovingAtKey(key,true);
	}
	else if (typeIn == "continuous")
	{
		prop.setInterpolationTypeAtKey(key,KeyframeInterpolationType.BEZIER);
		prop.setTemporalContinuousAtKey(key, true);
		prop.setTemporalAutoBezierAtKey(key, true);
		//not roving
		if (prop.isSpatial) prop.setRovingAtKey(key,false);
	}
	else if (typeIn != "roving")
	{
		//influences
		if (!prop.isSpatial && prop.value.length == 3) { prop.setTemporalEaseAtKey(key,[easeInValue,easeInValue,easeInValue],[easeOutValue,easeOutValue,easeOutValue]); }
		else if (!prop.isSpatial && prop.value.length == 2) { prop.setTemporalEaseAtKey(key,[easeInValue,easeInValue],[easeOutValue,easeOutValue]); }
		else { prop.setTemporalEaseAtKey(key,[easeInValue],[easeOutValue]); }
		//type
		prop.setInterpolationTypeAtKey(key,typeIn,typeOut);
		//not roving
		if (prop.isSpatial)
		{
			if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL || prop.propertyValueType == PropertyValueType.TwoD_SPATIAL) prop.setRovingAtKey(key,false);
		}
		//not continuous
		prop.setTemporalContinuousAtKey(key, false);
	}
}

/**
 * Adds a new keyframe on the properties.<br />
 * To set a value of your choice on one property,<br />
 * you can create a new {@link KeyFrame}, then use {@link DuAEF.DuAE.Property.setKey}.
 * @param {PropertyBase[]|PropertyInfo[]} props - The properties
 * @param {KeyframeInterpolationType|string} typeIn - The in interpolation type (see AE API) or the string "roving" or "continuous"
 * @param {KeyframeInterpolationType|string} [typeOut=typeIn] - The out interpolation type (see AE API)
 * @param {int[]|int} [easeInValue=33] - The in interpolation ease value (used if typeIn is KeyframeInterpolationType.BEZIER)
 * @param {int[]|int} [easeOutValue=easeInValue] - The out interpolation ease value (used if typeOut is KeyframeInterpolationType.BEZIER)
 * @param {float} [time=comp.time] - The time at which to add the key
 */
DuAEF.DuAE.Property.addKey = function(props, typeIn, typeOut, easeInValue, easeOutValue, time)
{
	for (var i=0;i<props.length;i++)
	{
		var propInfo = props[i];
		var prop = props[i];
		if (!(propInfo instanceof PropertyInfo)) propInfo = new PropertyInfo(prop);
		prop = props[i].getProperty();
		var comp = DuAEF.DuAE.Property.getComp(prop);
		if (prop.canVaryOverTime)
		{
			var keyTime;
			if (typeof time === 'undefined') keyTime = comp.time;
			else keyTime = time;
			var key = prop.addKey(keyTime);
			DuAEF.DuAE.Property.setKeyInterpolation(prop, key, typeIn, typeOut, easeInValue, easeOutValue);
		}
	}
}

/**
* Changes the ease influences of the selected keys
* @param {PropertyBase[]|PropertyInfo[]} props - The properties
* @param {int[]|int} [easeInValue] - The in interpolation ease value. Will be ignored if undefined.
* @param {int[]|int} [easeOutValue] - The out interpolation ease value. Will be ignored if undefined.
* @param {int[]|int} [velocityInValue] - The out interpolation ease value. Will be ignored if undefined.
* @param {int[]|int} [velocityOutValue] - The out interpolation ease value. Will be ignored if undefined.
*/
DuAEF.DuAE.Property.setEase = function(props,easeInValue,easeOutValue,velocityInValue,velocityOutValue)
{
	if (isNaN(easeInValue) && easeInValue != undefined) easeInValue = 33;
	if (isNaN(easeOutValue) && easeOutValue != undefined) easeOutValue = 33;
	if (isNaN(velocityInValue) && velocityInValue != undefined) velocityInValue = 0;
	if (isNaN(velocityOutValue) && velocityOutValue != undefined) velocityOutValue = 0;

	for (var i = 0; i < props.length ; i++)
	{
		var propInfo = props[i];
		var prop = props[i];
		if (!(propInfo instanceof PropertyInfo)) propInfo = new PropertyInfo(prop);
		prop = propInfo.getProperty();

		if (prop.canVaryOverTime)
		{
			for (var k=0 ; k < prop.selectedKeys.length ; k++)
			{
				var key = prop.selectedKeys[k];

				if (typeof easeInValue !== 'undefined')
				{
					if (typeof velocityInValue === 'undefined' && prop.keyInInterpolationType(key) == KeyframeInterpolationType.LINEAR)
					{
						velocityInValue = 0;
					}
				}

				if (typeof easeOutValue !== 'undefined')
				{
					if (typeof velocityOutValue === 'undefined' && prop.keyOutInterpolationType(key) == KeyframeInterpolationType.LINEAR)
					{
						velocityOutValue = 0;
					}
				}

				var easeIn =  [ new KeyframeEase(velocityInValue != undefined ? velocityInValue : prop.keyInTemporalEase(key)[0].speed, easeInValue != undefined ? easeInValue : prop.keyInTemporalEase(key)[0].influence) ];
				var easeOut = [ new KeyframeEase(velocityOutValue != undefined ? velocityOutValue : prop.keyOutTemporalEase(key)[0].speed, easeOutValue != undefined ? easeOutValue : prop.keyOutTemporalEase(key)[0].influence) ];
				if (!prop.isSpatial)
				{
					for (var j = 1;j < prop.keyInTemporalEase(prop.selectedKeys[k]).length ; j++)
					{
						easeIn.push( new KeyframeEase(velocityInValue != undefined ? velocityInValue : prop.keyInTemporalEase(key)[j].speed, easeInValue != undefined ? easeInValue : prop.keyInTemporalEase(key)[j].influence) );
						easeOut.push( new KeyframeEase(velocityOutValue != undefined ? velocityOutValue : prop.keyOutTemporalEase(key)[j].speed, easeOutValue != undefined ? easeOutValue : prop.keyOutTemporalEase(key)[j].influence) );
					}
				}

				//adjust interpolation types
				var inType = KeyframeInterpolationType.BEZIER;
				var outType = KeyframeInterpolationType.BEZIER;

				if (easeInValue == undefined && velocityInValue == undefined)
				{
					inType = prop.keyInInterpolationType(key);
				}
				if (easeOutValue == undefined && velocityOutValue == undefined)
				{
					outType = prop.keyOutInterpolationType(key);
				}

				prop.setInterpolationTypeAtKey(key, inType, outType);

				prop.setTemporalEaseAtKey(key,easeIn,easeOut);
			}
		}
	}
}

/**
* Checks if the property has some selected keyframes.<br />
* The property can be either a Property or a PropertyGroup.
* @param {PropertyBase} prop - The property
* @return {boolean} true if the property have at least one selected keyframe
*/
DuAEF.DuAE.Property.hasSelectedKeys = function (prop)
{
	var yes = false;

	if (prop.propertyType == PropertyType.PROPERTY)
	{
		if (prop.selectedKeys.length >0)
		{
			yes = true;
		}
	}
	else if (prop.numProperties > 0)
	{
		for (var propIndex = 1;propIndex <= prop.numProperties;propIndex++)
		{
			yes = DuAEF.DuAE.Property.hasSelectedKeys(prop.property(propIndex));
			if (yes) break;
		}
	}
	return yes;
}

/**
* Sets the spatial interpolation of the selected keyframes on the property
* @param {Property|PropertyInfo} prop - The property
* @param {KeyframeInterpolationType} typeIn - The in interpolation type (see AE API)
* @param {KeyframeInterpolationType} [typeOut=typeIn] - The in interpolation type (see AE API)
*/
DuAEF.DuAE.Property.setSpatialInterpolation = function (prop,typeIn,typeOut)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (typeOut == undefined) typeOut = typeIn;
	if (!prop.isSpatial) return;
		if (prop.selectedKeys.length == 0) return;
	for (var k=0;k<prop.selectedKeys.length;k++)
	{
		if (typeIn == KeyframeInterpolationType.BEZIER && typeOut == KeyframeInterpolationType.BEZIER)
		{
			prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],true);
		}
		else if (typeIn == KeyframeInterpolationType.LINEAR && typeOut == KeyframeInterpolationType.LINEAR)
		{
			prop.setSpatialContinuousAtKey(prop.selectedKeys[k],false);
			prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],false);
			if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL)
			{
				prop.setSpatialTangentsAtKey(prop.selectedKeys[k],[0,0,0],[0,0,0]);
    		}
    		else if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL)
    		{
    		    prop.setSpatialTangentsAtKey(prop.selectedKeys[k],[0,0],[0,0]);
    		}
		}
		else if (typeIn == KeyframeInterpolationType.BEZIER)
		{
			prop.setSpatialContinuousAtKey(prop.selectedKeys[k],false);
            prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],false);
            var keyIndex = prop.selectedKeys[k];
            if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL)
            {
                if (prop.keyInSpatialTangent(keyIndex)[0] == 0 && prop.keyInSpatialTangent(keyIndex)[1] == 0 && prop.keyInSpatialTangent(keyIndex)[2] == 0)
                {
                    prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],true);
                }
                prop.setSpatialTangentsAtKey(keyIndex,prop.keyInSpatialTangent(keyIndex),[0,0,0]);
            }
            else if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL)
            {
                if (prop.keyInSpatialTangent(keyIndex)[0] == 0 && prop.keyInSpatialTangent(keyIndex)[1] == 0)
                {
                    prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],true);
                }
                prop.setSpatialTangentsAtKey(keyIndex,prop.keyInSpatialTangent(keyIndex),[0,0]);
            }
		}
		else if (typeIn == KeyframeInterpolationType.LINEAR)
		{
			prop.setSpatialContinuousAtKey(prop.selectedKeys[k],false);
            prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],false);
            var keyIndex = prop.selectedKeys[k];
            if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL)
            {
                if (prop.keyOutSpatialTangent(keyIndex)[0] == 0 && prop.keyOutSpatialTangent(keyIndex)[1] == 0 && prop.keyOutSpatialTangent(keyIndex)[2] == 0)
                {
                    prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],true);
                }
                prop.setSpatialTangentsAtKey(keyIndex,[0,0,0],prop.keyOutSpatialTangent(keyIndex));
            }
            else if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL)
            {
                if (prop.keyOutSpatialTangent(keyIndex)[0] == 0 && prop.keyOutSpatialTangent(keyIndex)[1] == 0)
                {
                    prop.setSpatialAutoBezierAtKey(prop.selectedKeys[k],true);
                }
                prop.setSpatialTangentsAtKey(keyIndex,[0,0],prop.keyOutSpatialTangent(keyIndex));
            }
		}
	}
}

/**
* Fixes the spatial interpolation of the selected keys.<br />
* Sets the interpolation to linear when the property does not move between keyframes
* @param {Property|PropertyInfo} prop - The property
*/
DuAEF.DuAE.Property.fixSpatialInterpolation = function(prop)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();

	if (!prop.isSpatial) return;
	if (!prop.canVaryOverTime) return;

	var keyIndices = prop.selectedKeys;
	if (keyIndices.length < 2) return;

	for (var k=0;k<keyIndices.length-1;k++)
	{
	    var key = keyIndices[k];
	    var nextKey = keyIndices[k+1]
	    //get this key value
	    var keyValue = prop.valueAtTime(prop.keyTime(key),true);
	    //get next key value
	    var nextKeyValue = prop.valueAtTime(prop.keyTime(key+1),true);

	    //compare and set
	    if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL)
	    {
	        if (keyValue[0] == nextKeyValue[0] && keyValue[1] == nextKeyValue[1] && keyValue[2] == nextKeyValue[2])
	        {
	            prop.setSpatialTangentsAtKey(key,prop.keyInSpatialTangent(key),[0,0,0]);
	            prop.setSpatialTangentsAtKey(nextKey,[0,0,0],prop.keyOutSpatialTangent(nextKey));
	        }
	    }
	    else if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL)
	    {
	        if (keyValue[0] == nextKeyValue[0] && keyValue[1] == nextKeyValue[1])
	        {
	            prop.setSpatialTangentsAtKey(key,prop.keyInSpatialTangent(key),[0,0]);
	            prop.setSpatialTangentsAtKey(nextKey,[0,0],prop.keyOutSpatialTangent(nextKey));
	        }
	    }
	}
}

/**
* Removes all unneeded keyframes from the property.< br/>
* Also checks the interpolation values to reset the correct display as linear/smooth.
* @param {Property|PropertyInfo} property - The property
*/
DuAEF.DuAE.Property.cleanKeyframes = function(property)
{
	var prop = property;
	if (prop instanceof PropertyInfo) prop = property.getProperty();

	var numKeys = prop.numKeys;
	if (numKeys == 0) return;
	if (numKeys == 1)
	{
		prop.removeKey(1);
		return;
	}

	for (var i = numKeys ; i > 0 ; i--)
	{
		var currentKey = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,i);

		if (i > 1) var prevKey = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,i-1);
		if (i < prop.numKeys) var nextKey = DuAEF.DuAE.Property.getKeyFrameAtIndex(prop,i+1);

		//check values
		if (i > 1 && !DuAEF.DuJS.Array.compare(currentKey.value,prevKey.value,3)) continue;
		if (i < prop.numKeys && !DuAEF.DuJS.Array.compare(currentKey.value,nextKey.value,3)) continue;
		//check velocities
		var remove = false;
		for (var j = 0 ; j < currentKey.inEase.length ; j++)
		{
			remove = false
			if (i > 1 && !DuAEF.DuJS.Math.compare(prevKey.outEase[j].speed,0,4)) break;
			if (i > 1 && !DuAEF.DuJS.Math.compare(currentKey.inEase[j].speed,0,4)) break;
			if (i < prop.numKeys && !DuAEF.DuJS.Math.compare(currentKey.outEase[j].speed,0,4)) break;
			if (i < prop.numKeys && !DuAEF.DuJS.Math.compare(nextKey.inEase[j].speed,0,4)) break;
			remove = true;
		}
		//remove key
		if (remove) prop.removeKey(i);
	}
}

/**
* Gets the average speed of the animated propreties
* @param {Property[]|PropertyInfo[]} props - The Properties
* @return {float} The average speed
*/
DuAEF.DuAE.Property.getAverageSpeed = function(props)
{
	var averageSpeed = 0;
	var count = 0;

	for (var i = 0 ; i < props.length ; i++)
	{
		var prop = props[i];
		if (prop instanceof PropertyInfo) prop = prop.getProperty();
		if (prop.propertyType != PropertyType.PROPERTY) continue;
		if (!prop.canVaryOverTime) continue;
		if (prop.numKeys < 1) continue;

		var comp = DuAEF.DuAE.Property.getComp(prop);
		var frames = comp.duration / comp.frameDuration ;
		var lastTime = prop.keyTime(prop.numKeys);
		var firstTime = prop.keyTime(1);
		var lastFrame = lastTime/comp.frameDuration ;
		var firstFrame = firstTime/comp.frameDuration ;
		if (lastFrame > frames) lastFrames = frames;
		if (firstFrame < 1) firstFrame = 1;
		var sum = 0;
		for (var frame = firstFrame ; frame < lastFrame ; frame++)
		{
			var time = frame*comp.frameDuration;
			sum += DuAEF.DuAE.Property.getSpeed(prop,time);
		}
		var speed = sum/(lastFrame-firstFrame);

		if (speed > 0)
		{
			averageSpeed += speed;
			count++;
		}
	}

	averageSpeed = averageSpeed/count;
	return averageSpeed;
}

/**
* Gets the speed of a property at a given time
* @param {Property|PropertyInfo} prop - The property
* @param {float} [time=composition.time] - The time.
* @return {float} The speed
*/
DuAEF.DuAE.Property.getSpeed = function (prop,time)
{
	if (prop instanceof PropertyInfo) prop = prop.getProperty();
	if (prop.propertyType != PropertyType.PROPERTY) return 0;
	if (prop.numKeys == 0) return 0;
	var comp = DuAEF.DuAE.Property.getComp(prop);
	if (time == undefined) time = comp.time;

	var speed = DuAEF.DuJS.Math.getLength(prop.valueAtTime(time+comp.frameDuration,false),prop.valueAtTime(time-comp.frameDuration,false));
	return speed;
}

/**
* Sets an expression to a property.<br />
* With the ability to keep the initial value.
* @param {Property|PropertyInfo} prop - The property
* @param {string} expr - The expression
* @param {bool} [keepValue=true] - When true, the method will try to keep the same resulting value as before applying the expression.
*/
DuAEF.DuAE.Property.setExpression = function (prop,expr,keepValue)
{
	if (typeof keepValue === 'undefined') keepValue = true;
	var editable = false;
	var riggable = false;
	var dimensions = 0;
	if (prop instanceof PropertyInfo)
	{
		editable = prop.editable;
		riggable = prop.riggable;
		dimensions = prop.dimensions;
		prop = prop.getProperty();
	}
	else
	{
		editable = DuAEF.DuAE.Property.isEditable(prop);
		riggable = DuAEF.DuAE.Property.isRiggable(prop);
		dimensions = DuAEF.DuAE.Property.getDimensions(prop);
	}

	if (!riggable) return;

	var originalValue = prop.value;
	//remove current expression
	if (keepValue) DuAEF.DuAE.Property.removeExpression(prop);
	else try { prop.expression = "" } catch (e) { if (DuAEF.debug) alert(e.description); return; }
	//set new expression
	try { prop.expression = expr; } catch (e) { if (DuAEF.debug) alert(e.description); }
	//restore value
	if (editable && keepValue && dimensions > 0) DuAEF.DuAE.Property.setValue(prop, 2*originalValue - prop.value);
}

/**
* Replaces text in Expressions
* @param {PropertyBase|PropertyInfo} prop - The property (can be a group)
* @param {string} oldString - The string to replace
* @param {string} newString - The new string
* @param {boolean} [caseSensitive=true] - Wether the search has to be case sensitive
*/
DuAEF.DuAE.Property.replaceInExpressions = function (prop,oldString,newString,caseSensitive)
{
	if (caseSensitive == undefined) caseSensitive = true;

	if (prop.propertyType == PropertyType.PROPERTY)
	{
		if (prop.canSetExpression)
		{
			try {prop.expression = DuAEF.DuJS.String.replace(prop.expression,oldString,newString,caseSensitive);}
			catch(e){};
		}
	}
	else if (prop.numProperties > 0)
	{
		for (var propertyIndex = 1;propertyIndex <= prop.numProperties;propertyIndex++)
		{
			DuAEF.DuAE.Property.replaceInExpressions(prop.property(propertyIndex),oldString,newString,caseSensitive);
		}
	}
}

/**
 * Adds an expression to the child property, linking it to the parent property
 * @memberof DuAEF.DuAE.Property
 * @param {Property} childProp - The child property (the one which gets an expression).
 * @param {Property} parentProp - The parent property.
 * @param {bool} useThisComp - Wether to begin the expression by 'thisComp' or 'comp("name")', default: will detect if the properties are in the same comp
 */
DuAEF.DuAE.Property.pickWhip = function (childProp,parentProp,useThisComp)
{
	if (!childProp.canSetExpression) return;
	if (useThisComp == undefined)
	{
		var parentComp = DuAEF.DuAE.Property.getComp(parentProp);
		var childComp = DuAEF.DuAE.Property.getComp(childProp);
		if (parentComp.id == childComp.id) useThisComp = true;
		else useThisComp = false;
	}
	try { childProp.expression = DuAEF.DuAE.Property.getExpressionLink(parentProp,useThisComp); } catch (e) { if (DuAEF.debug) alert(e.description); };
}

/**
 * Link all the properties found in childProp to all the same properties of parentProp (this is a recursive method)<br />
 * Note: any Property or PropertyGroup (and its subproperties) named "Data" will be ignored.
 * @memberof DuAEF.DuAE.Property
 * @param {PropertyBase}	childProp			- The child property
 * @param {PropertyBase}	parentProp			- The parent property
 * @param {bool}		[useThisComp]			- Wether to begin the expression by 'thisComp' or 'comp("name")', default: will detect if the properties are in the same comp
 */
DuAEF.DuAE.Property.linkProperties = function (childProp,parentProp,useThisComp)
{
	if (parentProp.name.toLowerCase() == 'data') return;
	if (childProp.propertyType == PropertyType.PROPERTY && !childProp.elided && childProp.propertyValueType != PropertyValueType.NO_VALUE)
	{
		//copy paste the animation / value
		var anim = DuAEF.DuAE.Property.getAnim(parentProp,false);
		if (anim != null) DuAEF.DuAE.Property.setAnim(childProp,anim,0,true,true, false);
		//set the link
		DuAEF.DuAE.Property.pickWhip(childProp,parentProp,useThisComp);
	}
	else
	{
		if (parentProp.isEffect)
		{
			var insideData = 0;
			for (var p = 1, num =  childProp.numProperties; p <= num ; p++)
			{
				var subProp = parentProp(p);
				if (subProp.propertyValueType == PropertyValueType.NO_VALUE)
				{
					if (subProp.name.toLowerCase() == 'data')
					{
						insideData++;
						continue;
					}

					if (insideData > 0)
					{
						if (subProp.name == parentProp.name) insideData--;
						else insideData++;
						continue;
					}
				}
				if (insideData == 0) DuAEF.DuAE.Property.linkProperties(childProp(p),subProp,useThisComp);
			}
		}
		else
		{
			for (var p = 1, num = childProp.numProperties ; p <= num ; p++)
			{
				DuAEF.DuAE.Property.linkProperties(childProp(p),parentProp(p),useThisComp);
			}
		}
	}
}

/**
 * Adds all the (supported) properties found in a property to the essential graphics panel<br />
 * Note: any Property or PropertyGroup (and its subproperties) named "Data" will be ignored.
 * @memberof DuAEF.DuAE.Property
 * @param {PropertyBase}	prop			- The property
 * @return {int} The number of properties added
 */
DuAEF.DuAE.Property.addToEGP = function(prop)
{
	var numProps = 0;
	if (prop.name.toLowerCase() == 'data') return numProps;
	if (prop.propertyType == PropertyType.PROPERTY && prop.propertyValueType != PropertyValueType.NO_VALUE)
	{
		var comp = DuAEF.DuAE.Property.getComp(prop);
		var layer = DuAEF.DuAE.Property.getLayer(prop);
		//set the link
		if (prop.canAddToMotionGraphicsTemplate(comp) && !prop.elided && prop.canSetExpression)
		{
			prop.addToMotionGraphicsTemplate(comp);
			//rename the master property if >=15.1
			if (DuAEF.DuAE.App.version >= 15.1)
			{
				var it = new Iterator(comp.usedIn);
				it.do(function (mainComp)
				{
					//search the layer of the precomp
					for (var i = 1, num = mainComp.numLayers; i <= num; i++)
					{
						var l = mainComp.layer(i);
						if (l.source) if (l.source.id == comp.id)
						{
							 l('ADBE Layer Overrides')(1).name = layer.name + ' / ' + DuAEF.DuAE.Property.getExpressionLink(prop,true,false);
						}
					}
				});
			}
			numProps++;
		}
	}
	else
	{
		if (prop.isEffect)
		{
			var insideData = 0;
			for (var p = 1, num =  prop.numProperties; p <= num ; p++)
			{
				var subProp = prop(p);
				if (subProp.propertyValueType == PropertyValueType.NO_VALUE)
				{
					if (subProp.name.toLowerCase() == 'data')
					{
						insideData++;
						continue;
					}

					if (insideData > 0)
					{
						if (subProp.name == prop.name) insideData--;
						else insideData++;
						continue;
					}
				}
				if (insideData == 0) numProps += DuAEF.DuAE.Property.addToEGP(subProp);
			}
		}
		else
		{
			for (var p = 1 ; p <= prop.numProperties ; p++)
			{
				numProps += DuAEF.DuAE.Property.addToEGP(prop(p));
			}
		}
	}
	return numProps;
}

/**
 * Locks the property with an expression so its value cannot be changed
 * @memberof DuAEF.DuAE.Property
 * @param {PropertyBase|PropertyInfo|PropertyBase[]|PropertyInfo[]} properties - The property or properties
*/
DuAEF.DuAE.Property.lock = function(properties)
{
	var it = new Iterator(properties);
	it.do(function (property)
	{
		var p = property;
		var riggable = false;
		var dimensions = 0;
		if (property instanceof PropertyInfo)
		{
			p = property.getProperty();
			riggable = property.riggable;
			dimensions = property.dimensions;
		}
		else
		{
			riggable = DuAEF.DuAE.Property.isRiggable(p);
			dimensions = DuAEF.DuAE.Property.getDimensions(p);
		}

		if (riggable)
		{
			var exp = "";
			if (dimensions == 0) exp = "value";
			else if (dimensions == 1) exp = p.value.toString();
			else exp = p.value.toSource();
			DuAEF.DuAE.Property.setExpression(property,exp);
		}
	});
}

/**
 * Removes the expression from the property, keeping the post-expression value.
 * @memberof DuAEF.DuAE.Property
 * @param {PropertyBase} prop - The property
*/
DuAEF.DuAE.Property.removeExpression = function(prop)
{
	DuAEF.DuAE.Property.setValue(prop, prop.value);
	prop.expression = '';
}

/**
 * Checks if the property has an animation (keyframes)
 * @param {Property} prop - The property
 * @return {boolean} True if the property is animated
 */
DuAEF.DuAE.Property.isAnimated = function(prop)
{
	if (prop.canVaryOverTime)
	{
		if (prop.numKeys > 0) return true;
	}
	return false;
}

/**
* Gets the After Effects animated (with keyframes) properties in the propertyGroup
* @param {PropertyGroup}	 prop	- The parent propertyGroup where to search for animations
* @param {PropertyType|PropertyValueType|string|function}	 [filter]	- A filter to get only a certain type, or value type, or property name or matchName.<br />
* A function which take one PropertyBase as argument can be used to filter the properties: the Property will be returned if the function returns true.
* @param {boolean}	[strict=false]	- If a string filter is provided, wether to search for the exact name/matchName or if it contains the filter.
* @param {boolean}	[caseSensitive=true]	- If a string filter is provided, and not strict is false, does the search have to be case sensitive?
* @return {PropertyInfo[]} The selected properties, an empty Array if nothing active or selected
*/
DuAEF.DuAE.Property.getAnimatedProps = function(prop, filter, strict, caseSensitive)
{
	if (strict == undefined) strict = false;
	if (caseSensitive == undefined) caseSensitive = true;

	var props = [];

	if (!caseSensitive && typeof filter === "string") filter = filter.toLowerCase();

	if (prop.propertyType == PropertyType.PROPERTY)
	{
		if (DuAEF.DuAE.Property.isAnimated(prop))
		{
			if (typeof filter === 'undefined')
			{
				props.push(prop);
			}
			else
			{
				var name = prop.name;
				var matchName = prop.matchName;
				if (!caseSensitive)
				{
					name = name.toLowerCase();
					matchName = matchName.toLowerCase();
				}

				if (strict && name === filter) props.push(prop);
				else if (strict && matchName === filter) props.push(prop);
				else if (typeof filter === 'string')
				{
					if (name.indexOf(filter) >= 0) props.push(prop);
					else if (matchName.indexOf(filter) >= 0) props.push(prop);
				}
				else if (prop.propertyValueType == filter) props.push(prop);
				else if (typeof filter === 'function')
				{
					if (filter(prop)) props.push(prop);
				}
			}
		}
	}
	else
	{
		for (var i = 0, num = prop.numProperties ; i < num ; i++)
		{
			props = props.concat(DuAEF.DuAE.Property.getAnimatedProps(prop.property(i+1), filter, strict, caseSensitive));
		}
	}


	return DuAEF.DuAE.getPropertyInfos(props);
}

/**
* Checks if the property value is a number or an Array of Number.<br >
* I.e if its value type is one of: one D, two D, three D (spatial or not), Color.
* @param {Property}	 prop	- The property
* @return {bool}
*/
DuAEF.DuAE.Property.isNumerical = function (prop)
{
	if (prop.propertyValueType == PropertyValueType.ThreeD_SPATIAL) return true;
	if (prop.propertyValueType == PropertyValueType.ThreeD) return true;
	if (prop.propertyValueType == PropertyValueType.TwoD_SPATIAL) return true;
	if (prop.propertyValueType == PropertyValueType.TwoD) return true;
	if (prop.propertyValueType == PropertyValueType.OneD) return true;
	if (prop.propertyValueType == PropertyValueType.COLOR) return true;
	return false;
}

/**
* Gets the value range of the animated property.<br >
* The property type must be one of: one D, two D, three D (spatial or not), Color.
* If the property is not one of these types, returns an empty Array.
* @param {Property|PropertyInfo}	 prop	- The property
* @param {int}	 [axis=0]	- The axis (or the color channel) to get the range
* @param {bool}	 [preExpression=true]	- True to get the range from keyframes instead of the result of the exression
* @return {float[]} The minimum and maximum value.<br />
* The first item in the Array is not necesarily the lowest value, it is the first in time.
*/
DuAEF.DuAE.Property.getRange = function(prop,axis,preExpression)
{
	if (typeof axis === 'undefined') axis = 0;
	if (typeof preExpression === 'undefined') preExpression = true;

	var propInfo = prop;
	if (!prop instanceof PropertyInfo)
	{
		propInfo = new PropertyInfo(prop);
	}
	else
	{
		propInfo = prop;
		prop = prop.getProperty();
	}


	if (!propInfo.numerical) return [];

	if (prop.expression == '') preExpression = true;

	var comp = propInfo.comp;
	var frames = comp.duration/comp.frameDuration;
	var min = prop.valueAtTime(0,preExpression);
	var minTime = 0;
	var max = prop.valueAtTime(0,preExpression);
	var maxTime = 0;

	if (propInfo.dimensions > 1)
	{
		max = max[axis];
		min = min[axis];
	}

	for (var i = 1; i < frames; i++)
	{
		var val = prop.valueAtTime(i*comp.frameDuration,preExpression);
		if (propInfo.dimensions > 1) val = val[axis];
		if (val < min)
		{
			min = val;
			minTime = i;
		}
		if (val > max)
		{
			max = val;
			maxTime = i;
		}
	}

	if (minTime < maxTime) return [min,max];
	else return [max,min];
}

/**
* Gets the maximum velocity of the animated property.<br >
* The property type must be one of: one D, two D, three D (spatial or not), Color.
* If the property is not one of these types, returns 0.
* @param {Property|PropertyInfo}	 prop	- The property
* @param {bool}	 [preExpression=true]	- True to get the velocity from keyframes instead of the result of the exression
* @return {float} The velocity.
*/
DuAEF.DuAE.Property.getMaxVelocity = function(prop,preExpression)
{
	if (typeof preExpression === 'undefined') preExpression = true;

	var propInfo = prop;
	if (!prop instanceof PropertyInfo)
	{
		propInfo = new PropertyInfo(prop);
	}
	else
	{
		propInfo = prop;
		prop = prop.getProperty();
	}

	var velocity = 0;
	if (!propInfo.numerical) return velocity;

	if (prop.expression == '') preExpression = true;

	var comp = propInfo.comp;
	var frames = comp.duration/comp.frameDuration;

	var prevVal = prop.valueAtTime(0,preExpression);

	for (var i = 1; i < frames; i++)
	{
		var val = prop.valueAtTime(i*comp.frameDuration, preExpression);
		var vel = DuAEF.DuJS.Math.getLength(val,prevVal);
		if (vel > velocity) velocity = vel;
		prevVal = val;
	}

	return velocity;

}

/**
* Bezier Paths methods
* @namespace
* @memberof DuAEF.DuAE.Property
*/
DuAEF.DuAE.Property.Shape = {};

/**
* Export the given shape property to the given file <br/>
* The file name in the given path will be used to name the shape in the jsx code
* @example
* var props = DuAEF.DuAE.Comp.getSelectedProps(PropertyValueType.SHAPE);
* var prop = props[0].getProperty();
* var out = DuAEF.DuAE.Property.Shape.exportToJsxinc(prop, "D:/shape.test");
* @param {Property}	 [shapeProp]	- The path property to export
* @param {String}	     [file]	- The path to where the jsxinc shape will be written
* @param {boolean}	[offsetToCenter=false]	- If true, offset the path to the center
* @return {int} A status code. [0: success, ...]
*/
DuAEF.DuAE.Property.Shape.exportToJsxinc = function(shapeProp, file, offsetToCenter)
{
    if (shapeProp.propertyType !== PropertyType.PROPERTY) throw "Expected a shape property, got a group.";
    if (shapeProp.propertyValueType !== PropertyValueType.SHAPE) throw "Expected a shape property, got another type of value.";
    if(typeof(offsetToCenter) === 'undefined') offsetToCenter = false;

    var shape = shapeProp.value;
    var vertices = shape.vertices;

    if (offsetToCenter)
    {
        //get center and offset
        var sum = [0,0];
        for (var i = 0 ; i < vertices.length ; i++)
        {
            sum[0] += vertices[i][0];
            sum[1] += vertices[i][1];
        }
        var center = sum/vertices.length;
        //adjust values
        for (var i = 0 ; i < vertices.length ; i++)
        {
            vertices[i][0] -= center[0];
            vertices[i][1] -= center[1];
        }
    }

    var verticesStr = vertices.toSource();
    var inTangentsStr = shape.inTangents.toSource();
    var outTangentsStr = shape.outTangents.toSource();
    var closedStr = shape.closed ? 'true' : 'false';

    var file = new File(file);
    if(!file.open("w")) return 3
    var name = DuAEF.DuJS.Fs.getBasename(file);

    file.writeln('var ' + name + ' = new Shape();');
    file.writeln(name + '.vertices = ' + verticesStr + ';');
    file.writeln(name + '.inTangents = ' + inTangentsStr + ';');
    file.writeln(name + '.outTangents = ' + outTangentsStr + ';');
    file.writeln(name + '.closed = ' + closedStr + ';');
    file.close();
    return 0;
}

/**
* Makes a horizontal symetry transformation on the path.
* @param {Property}	pathProperty	- The After Effects Property containing the path to symetrize
*/
DuAEF.DuAE.Property.Shape.horizontalSymetry = function(pathProperty)
{
	if (pathProperty.propertyType !== PropertyType.PROPERTY) throw "Expected a shape property, got a group.";
	if (pathProperty.propertyValueType !== PropertyValueType.SHAPE) throw "Expected a shape property, got another type of value.";

	var shape = pathProperty.value;
	var vertices = shape.vertices;
	var inTangents = shape.inTangents;
	var outTangents = shape.outTangents;

	//get the horizontal center.
	var center = 0;
	for (var i = 0 ; i < vertices.length; i++)
	{
		center += vertices[i][0];
	}
	center = center / vertices.length;

	//twice the value for computing symetry
	center = center*2;

	//compute
	for (var i = 0 ; i < vertices.length; i++)
	{
		vertices[i][0] = center - vertices[i][0];
		inTangents[i][0] = -inTangents[i][0];
		outTangents[i][0] = -outTangents[i][0];
	}

	//set
	shape.vertices = vertices;
	shape.inTangents = inTangents;
	shape.outTangents = outTangents;
	if (pathProperty.numKeys > 0)
	{
		pathProperty.setValueAtTime(DuAEF.DuAE.Property.getPropertyComp(pathProperty).time,shape);
	}
	else
	{
		pathProperty.setValue(shape);
	}
}

/**
* Makes a horizontal symetry transformation on the paths, using the same axis of symetry for all shapes (shapes must be on the same layer).
* @param {Property[]}	pathProperties	- The After Effects Properties containing the paths to symetrize
*/
DuAEF.DuAE.Property.Shape.horizontalSymetries = function(pathProperties)
{
	var shapes = [];
	//get shapes and center
	var center = 0;
	var verticesCount = 0;
	for (var i = 0 ; i < pathProperties.length ; i++)
	{
		var shape = pathProperties[i].value;
		shapes.push(shape);
		for (var j = 0 ; j < shape.vertices.length; j++)
		{
			verticesCount++;
			center += shape.vertices[j][0];
		}
	}
	center = center / verticesCount;
	center = center *2;

	//compute
	for (var i = 0 ; i < shapes.length; i++)
	{
		var shape = shapes[i];
		var vertices = shape.vertices;
		var inTangents = shape.inTangents;
		var outTangents = shape.outTangents;
		for (var j = 0 ; j < shape.vertices.length ; j++)
		{
			vertices[j][0] = center - vertices[j][0];
			inTangents[j][0] = -inTangents[j][0];
			outTangents[j][0] = -outTangents[j][0];
		}
		shape.vertices = vertices;
		shape.inTangents = inTangents;
		shape.outTangents = outTangents;
		if (pathProperties[i].numKeys > 0)
		{
			pathProperties[i].setValueAtTime(DuAEF.DuAE.Property.getPropertyComp(pathProperties[i]).time,shape);
		}
		else
		{
			pathProperties[i].setValue(shape);
		}
	}
}

/**
* Makes a vertical symetry transformation on the path.
* @param {Property}	pathProperty	- The After Effects Property containing the path to symetrize
*/
DuAEF.DuAE.Property.Shape.verticalSymetry = function(pathProperty)
{
	if (pathProperty.propertyType !== PropertyType.PROPERTY) throw "Expected a shape property, got a group.";
	if (pathProperty.propertyValueType !== PropertyValueType.SHAPE) throw "Expected a shape property, got another type of value.";

	var shape = pathProperty.value;
	var vertices = shape.vertices;
	var inTangents = shape.inTangents;
	var outTangents = shape.outTangents;

	//get the horizontal center.
	var center = 0;
	for (var i = 0 ; i < vertices.length; i++)
	{
		center += vertices[i][1];
	}
	center = center / vertices.length;

	//twice the value for computing symetry
	center = center*2;

	//compute
	for (var i = 0 ; i < vertices.length; i++)
	{
		vertices[i][1] = center - vertices[i][1];
		inTangents[i][1] = -inTangents[i][1];
		outTangents[i][1] = -outTangents[i][1];
	}

	//set
	shape.vertices = vertices;
	shape.inTangents = inTangents;
	shape.outTangents = outTangents;
	if (pathProperty.numKeys > 0)
	{
		pathProperty.setValueAtTime(DuAEF.DuAE.Property.getPropertyComp(pathProperty).time,shape);
	}
	else
	{
		pathProperty.setValue(shape);
	}
}

/**
* Makes a vertical symetry transformation on the paths, using the same axis of symetry for all shapes (shapes must be on the same layer).
* @param {Property[]}	pathProperties	- The After Effects Properties containing the paths to symetrize
*/
DuAEF.DuAE.Property.Shape.verticalSymetries = function(pathProperties)
{
	var shapes = [];
	//get shapes and center
	var center = 0;
	var verticesCount = 0;
	for (var i = 0 ; i < pathProperties.length ; i++)
	{
		var shape = pathProperties[i].value;
		shapes.push(shape);
		for (var j = 0 ; j < shape.vertices.length; j++)
		{
			verticesCount++;
			center += shape.vertices[j][1];
		}
	}
	center = center / verticesCount;
	center = center *2;

	//compute
	for (var i = 0 ; i < shapes.length; i++)
	{
		var shape = shapes[i];
		var vertices = shape.vertices;
		var inTangents = shape.inTangents;
		var outTangents = shape.outTangents;
		for (var j = 0 ; j < shape.vertices.length ; j++)
		{
			vertices[j][1] = center - vertices[j][1];
			inTangents[j][1] = -inTangents[j][1];
			outTangents[j][1] = -outTangents[j][1];
		}
		shape.vertices = vertices;
		shape.inTangents = inTangents;
		shape.outTangents = outTangents;
		if (pathProperties[i].numKeys > 0)
		{
			pathProperties[i].setValueAtTime(DuAEF.DuAE.Property.getPropertyComp(pathProperties[i]).time,shape);
		}
		else
		{
			pathProperties[i].setValue(shape);
		}
	}
}
/*
	DuBinaryLib
  Library to create/extract json representations of binary files
	Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
	https://rainboxprod.coop

	_Contributors:_
		Nicolas Dufresne - Lead developer

	This file is part of DuAEF.

	DuAEF is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	DuAEF is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
* Tools to include and extract binary files directly in your script files, allowing to deploy only one .jsx files containing any needed image, preset or executable.
*
* You can easily convert binaries to text (*.jsxinc) files using the {@link https://github.com/Rainbox-dev/DuAEF/tree/master/tools|tools provided with DuAEF}. You can then include those *.jsxinc files inside your scripts, and use the {@link DuAEF.DuBinary.toFile|toFile()} method to extract and use them at runtime.
* @namespace
* @memberof DuAEF
* @example
* //First, include the text representation of the file (Add a # before the include word)
* include icon.png.jsxinc
* // Now, a variable called `icon` (the original file name without extension) is available, you can pass this object to the `DuBinary.toFile()` method to extract it and get an ExtendScript File object representation of it.
* // Note: This object is an instance of a `DuBinaryFile` class, which contains all information and a string representation of the original binary file
* var iconFile = DuBinary.toFile(icon);
* iconFile.fsName; // C:\users\duduf\appData\Roaming\DuAEF\icon.png (Example on Windows)
* //You can also directly use a PNG string in ScriptUI without extracting the file. (Add a # before the include word)
* var button = somePanel.add('iconbutton',undefined,icon.binAsString);
*/
DuAEF.DuBinary = {};

/**
 * Creates a file from a DuBinaryFile object representation.
 * @memberof DuAEF.DuBinary
 * @param {DuBinaryFile}	duBinaryFile  	- The DuBinaryFile object containing the string representation.<br />
 * This object will be replaced by the File object created.<br />
 * If a file object is provided (the file has already been extracted), does nothing.
 * @param {string}			[outputFileName=DuAEF.DuJS.Fs.duaefData/DuAEF/category/binaryfilename]	- The output filename.
 * @return {File|null} The file created, null if the file could not be written.<br />
 * If the file is not written, check user permissions, and check if the file and network access preference is checked<br />
 * You can check {@link DuAEF.DuAE.App.hasFilesAndNetworkAccess} and call {@link DuAEF.DuAE.App.askFilesAndNetworkAccess}.
 * @example
 * //First, include the text representation of the file (Add a # before the include word)
 * include executable.exe.jsxinc
 * // Now, a variable called `executable` (the original file name without extension) is available, you can pass this object to the `DuBinary.toFile()` method to extract it and get an ExtendScript File object representation of it.
 * // Note: This object is an instance of a `DuBinaryFile` class, which contains all information and a string representation of the original binary file
 * var execFile = DuBinary.toFile(executable);
 * //Now, the file exists in the file system, and execFile is an ExtendScript File object.
 * // The `DuBinary.toFile()` method extracts the file to the Application Data folder by default.
 * execFile.fsName; // C:\users\duduf\appData\Roaming\DuAEF\icon.png (Example on Windows)
 * @example
 * //You can specify the output file name. (Add a # before the include word)
 * include preset.ffx.jsxinc
 * var presetFile = DuBinary.toFile(preset,"C:/test/test_preset.ffx");
 * presetFile.fsName; // C:\test\test_preset.exe");
 */
DuAEF.DuBinary.toFile = function(duBinaryFile,outputFileName)
{
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess) return null;

	if (duBinaryFile instanceof File) return;
	if (outputFileName === undefined) outputFileName = DuAEF.DuJS.Fs.duaefData.absoluteURI + '/' + duBinaryFile.category + '/' + duBinaryFile.fileName;
	var file = new File(outputFileName);

	if (!file.exists)
	{
		var folder = new Folder(file.path);
		if (!folder.exists)
		{
			folder.create();
		}
	}

	file.encoding = 'BINARY';
	if (file.open('w'))
	{
		success = file.write(duBinaryFile.binAsString);
		file.close();
	}

	duBinaryFile = file;

	return file;
}

/**
 * Creates a DuBinaryFile object from a binary file
 * @memberof DuAEF.DuBinary
 * @param {File}    file      - The File to convert
 * @param {string}  [category]  - A Category for the file, will be used as a subfolder to extract files. Can have subcategories like "category/subcategory".
 * @return {DuBinaryFile} The DuBinaryFile object containing the file as a string
 */
DuAEF.DuBinary.toObj = function(binaryFile,category)
{
  var content = '';

  binaryFile.encoding = "BINARY";
  if (binaryFile.open("r"))
  {
    content = binaryFile.read().toSource();
    content = content.substr(content.indexOf("\"")+1, content.length);
    content = content.substr(0, content.lastIndexOf("\""));
    binaryFile.close();
  }

  var obj = new DuBinaryFile(content,binaryFile.name,category);

  return obj;
}

/**
 * Converts a binary file to a jsxinc file
 * @memberof DuAEF.DuBinary
 * @param {File}    binaryFile      - The binary file to convert
 * @param {string}  [category]        - A Category for the file, will be used as a subfolder to extract files. Can have subcategories like "category/subcategory". Default: ""
 * @param {string}  [outputFileName=Same folder, same name with .json extension]  - The file name for the output.
 * @param {string}	[varName=File name without extension]	- The name of the variable used to store the javascript object.
 * @return {File} The json file created
 */
DuAEF.DuBinary.convertToIncludeFile = function(binaryFile,category,outputFileName,varName)
{
	if (typeof  outputFileName === 'undefined') outputFileName = binaryFile.absoluteURI + '.jsxinc';
	if (typeof varName === 'undefined') varName = binaryFile.name.replace(/\..+/,'');
	varName = DuAEF.DuJS.String.replace(varName,'%20','_');
	var duBinary = this.toObj(binaryFile,category);
	var jsString = 'var ' + varName + ' = ';
	jsString += '{"binAsString":"' + duBinary.binAsString + '","fileName":"' + duBinary.fileName + '","category":"' + duBinary.category + '"}'
	jsString += ';\r\n';
	jsString += varName + ';\r\n';
	var outputFile = new File(outputFileName);
	outputFile.encoding = 'UTF8';
	if (outputFile.open("w", "TEXT", "????"))
	{
		outputFile.write(jsString);
		outputFile.close();
	}
}

/**
 * Converts a JS file to a binary file
 * @memberof DuAEF.DuBinary
 * @param {File}    jsFile        - The JS file to convert
 * @param {string}	[outputFileName=DuAEF.DuJS.Fs.duaefData/category/binaryfilename]	- The output filename.
 * @return {File} The binary file created, or null if failed
 * @example
 * //If you don't want to include the file in the script. (Add a # before the include word)
 * var stringFile = new File("C:\test\image.jpg.jsxinc");
 * var jpgFile = DuBinary.convertToBinaryFile(stringFile);
 * // Warning, this method uses `$.eval()` which is a bad security issue.
 * //This will be changed in the future, but for now, do not use this method for anything else than debugging and testing.
 * @todo Do not use $.eval() but parse the file.
 */
DuAEF.DuBinary.convertToBinaryFile = function(jsFile,outputFileName)
{
	//TODO parse instead of eval
	var obj = $.eval(jsFile);
	return this.toFile(obj);
}

/**
 *  Extract paths from a given file. Paths are not checked, be sure to check them before using them. (checking if they exist)
 * Ignore lines starting with "#include".
 * Also returns the surounding elements "path" or 'path'.
 * @memberof DuAEF.DuBinary
 * @param {String}    filePath        - The path to the file
 * @return {string[]} List of paths.
 * @return {int} 1 if the file can't be opened
*/
DuAEF.DuBinary.parseFilePaths = function(filePath)
{
    var paths = [];

    var file = new File(filePath);
    if(!file.open("r")) return 1; // Unable to open the file

    var folder = file.parent.absoluteURI;

    var indexSimple, indexDouble, indexEnd;
    var offset = 0;
    var simple = false;
    var currentString;
    var start;
    // Line by line reading
    while(!file.eof )
    {
          var line = file.readln();

          if (line.indexOf("#include", 0) == 0) continue;

          // Detect strings
          var strings = [];
          offset = 0;
          do{
              // Start string
              indexDouble = line.indexOf('"', offset); // "
              indexSimple = line.indexOf("'", offset); // '
              if(indexDouble == indexSimple) break; // No match
              if((indexDouble < indexSimple || indexSimple == -1) && indexDouble != -1)
              {
                    simple = false;
                    offset = indexDouble + 1;
              }else if(indexSimple != -1)
              {
                    simple = true;
                    offset = indexSimple + 1;
               }else break;
                start = offset - 1;
                // End string
               do{
                    if(simple)
                        indexEnd = line.indexOf("'", offset) + 1; // '
                    else
                        indexEnd = line.indexOf('"', offset) + 1; // "
                    offset = indexEnd + 1;
                } while (indexEnd != -1 && line.charAt(indexEnd - 1) == '\\'); // Escaped end string

                if(indexEnd == -1) break;
                // String
                currentString = line.slice(start, indexEnd);

                // Test if its a file
                // Dumb check
                var indexPoint = currentString.lastIndexOf('.');
                if(indexPoint != -1 && indexPoint != currentString.length - 1)
                {
                    paths.push(currentString);
                }

          }while(indexSimple != indexDouble);

    }

    file.close();

    return paths;
}

/**
 * Constructs a new string representation of a file
 * @class DuBinaryFile
 * @classdesc Represents a binary file as a string and a filename.
 * @param	{string}	binAsString			- The string representation.
 * @param	{string}	fileName			- The name of the original file.
 * @param	{string}	[category]			- A Category for the file, will be used as a subfolder to extract files. Can have subcategories like "category/subcategory".
 * @property {string}	binAsString	   - The string representation.
 * @property {string}	fileName  	   - The name of the original file
 * @property {string}	category       - A Category for the file, will be used as a subfolder to extract files. Can have subcategories like "category/subcategory".
 */
function DuBinaryFile(binAsString,fileName,category)
{
	this.binAsString = binAsString;
	fileName = DuAEF.DuJS.String.replace(fileName,'%20','_');
	this.fileName = fileName;
	if (category === undefined) category = '';
	this.category = category;
}
/*
	DuFFMpeg
	Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
	https://rainboxprod.coop

	_Contributors:_
		Nicolas Dufresne - Lead developer

	_DuFFMpeg makes use of:_

		• FFMpeg
		http://ffmpeg.org

	This file is part of DuFFMpeg.

	DuFFMpeg is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	DuFFMpeg is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with DuFFMpeg. If not, see <http://www.gnu.org/licenses/>.
*/

//TODO Use DuProcessLibs

/**
 * Constructs a new FFMpeg encoder.
 * The constructor will try to find the ffmpeg binary in the same folder as DuFFMpeg, or an (ffmpeg) subfolder, or in the scripts folder of After Effects.
 * If ffmpeg is not in one of those, the property ffmpegPath will be an empty string, and it has to be set by the user.
 * @class DuFFMpeg
 * @classdesc A class used to easily encode medias with ffmpeg
 * @param {string}	   [options=-stats]			- The options of the encoder.
 * @property {string}	  ffmpegPath		- The path to the FFMpeg binary.
 * @property {string}	   options			- The options of the encoder.
 * @property {FFMpegQueueItem[]} queue		- The render queue
 * @example
 * //Very simple transcoding
 * //create a new FFMpeg instance
 * var ffmpeg = new DuFFMpeg();
 * //input file. Note that you can use any path format you want, URI, fsName, or path, using either / or \
 * var input = new DuFFMpegInputModule('C:/RAINBOX/Test video 1.mp4');
 * //output to an audio wav file using PCM 32 bit float little-endian codec
 * var output = new DuFFMpegOutputModule('pcm_f32le','C:/RAINBOX/Test audio 1.wav');
 * //create the render queue item
 * var item = new DuFFMpegQueueItem(input,[output]);
 * //add the item to the render queue
 * ffmpeg.queue.push(item);
 *
 * ffmpeg.launch(); //and launch the process!
 * @example
 * //Transcoding two different files, and a few more options
 * //new FFMpeg instance, encoding will overwrite files, and statistics will be shown
 * var ffmpeg = new DuFFMpeg('-y -stats');
 * //input file
 * var input = new DuFFMpegInputModule('C:/RAINBOX/Test video 1.mp4');
 * //output to an audio wav file using PCM 32 bit float little-endian codec, forcing 48000Hz sampling and disabling video
 * var output = new DuFFMpegOutputModule('pcm_f32le','C:/RAINBOX/Test audio 1.wav','-ar 48000 -vn');
 * //create the render queue item
 * var item = new DuFFMpegQueueItem(input,[output]);
 * //add the item to the render queue
 * ffmpeg.queue.push(item);
 *
 * //another render queue item
 * var input = new DuFFMpegInputModule('C:/RAINBOX/Test video 2.mp4');
 * var output = new DuFFMpegOutputModule('pcm_f32le','C:/RAINBOX/Test audio 2.wav','-ar 48000 -vn');
 * var item = new DuFFMpegQueueItem(input,[output]);
 * ffmpeg.queue.push(item);
 *
 * //and launch the process! Both items will be transcoded.
 * ffmpeg.launch();
 */
function DuFFMpeg(options)
{
	if (typeof options === 'undefined') options = '-stats';

	this.ffmpegPath = '';

	//try to detect the ffmpeg path
	var ffmpegBinName = '';
	if (DuAEF.win) ffmpegBinName = 'ffmpeg.exe';
	else ffmpegBinName = 'ffmpeg';
	//first, in the same dir
	var thisScriptFile = new File($.fileName);
	var ffmpegFile = new File(thisScriptFile.parent.absoluteURI + '/' + ffmpegBinName);
	//in an (ffmpeg) subfolder
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(thisScriptFile.parent.absoluteURI + '/(ffmpeg)/' + ffmpegBinName);
	}
	//in AE Scripts folder
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(Folder.appPackage.absoluteURI + '/Scripts/' + ffmpegBinName);
	}
	//in AE Scripts/(ffmpeg) folder
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(Folder.appPackage.absoluteURI + '/Scripts/(ffmpeg)/' + ffmpegBinName);
	}
	//in AE ScriptUI Panels
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(Folder.appPackage.absoluteURI + '/Scripts/ScriptUI Panels/' + ffmpegBinName);
	}
	//in AE ScriptUI Panels/(ffmpeg)
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(Folder.appPackage.absoluteURI + '/Scripts/ScriptUI Panels/(ffmpeg)/' + ffmpegBinName);
	}
	//in the parent dir
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(thisScriptFile.parent.parent.absoluteURI + '/' + ffmpegBinName);
	}
	//in the parent dir (fmmpeg)
	if (!ffmpegFile.exists)
	{
		ffmpegFile = new File(thisScriptFile.parent.parent.absoluteURI + '/(ffmpeg)' + ffmpegBinName);
	}

	if (ffmpegFile.exists) this.ffmpegPath = ffmpegFile.fsName;

	this.options = options;
	this.queue = [];
}

/**
 * Launches encoding
 * @memberof DuFFMpeg
 */
DuFFMpeg.prototype.launch = function ()
{
	if (!DuAEF.DuJS.Fs.fileExists(this.ffmpegPath) || this.ffmpegPath == '') return;

	var cmd = '';

	var ffmpegCmd = '';

	if (DuAEF.win) ffmpegCmd += '"' + this.ffmpegPath + '"';
	else
	{
	  var ffmpegFile = new File(this.ffmpegPath);
	  ffmpegCmd += '"' + ffmpegFile.parent.fsName + '"/./' + ffmpegFile.name;
	}

	if (DuAEF.win) cmd += 'cmd.exe /c "';

	//add RenderItems
	for (var i = 0 ; i < this.queue.length ; i++)
	{
		if (i > 0) cmd += ' & ';
		cmd += ffmpegCmd + ' ' + this.options;
		var item = this.queue[i];
		cmd += ' ' + item.input.options;
		cmd += ' -i "' + item.input.inputPath + '"';
		//add outputs
		for (var j = 0 ; j < item.outputs.length ; j++)
		{
			var output = item.outputs[j];
			cmd += ' -c ' + output.codec;
			cmd += ' ' + output.options;
			cmd += ' "' + output.outputPath + '"';
		}
	}

	if (DuAEF.win) cmd += '"';

	//launch!

	// mac hack, do not wait for ffmpeg as it freezes AE
	if (DuAEF.mac) cmd = cmd + ' && ';

	system.callSystem(cmd);

	// mac hack, but let's wait anyway
	if (DuAEF.mac)
	{
		//timeout
		var currentDate = new Date();
		var timeout = currentDate.getTime() + 30000;
		var checkTime = new Date();

		var cmd = 'ps -A | grep "[f]fmpeg"';

		//wait
		while(checkTime.getTime() < timeout)
		{
			var test = system.callSystem(cmd);
			if (test == '') break;
			$.sleep(300);
			checkTime = new Date();
		}
	}
}

/**
 * Constructs a new FFMpegInputModule module
 * @class DuFFMpegInputModule
 * @classdesc A class used to easily encode medias with ffmpeg
 * @param {string}	inputPath		- The path to the input file.
 * @param {string}	[options]			- The options for the input file.
 * @property {string}	inputPath		- The path to the input file.
 * @property {string}	options			- The options for the input file. Default: ''
 */
function DuFFMpegInputModule(inputPath,options)
{
	if (!inputPath) throw "No input file set";
	if (inputPath == '') throw "No input file set";
	var inputFile = new File(inputPath);
	if (!inputFile.exists) throw "The input file does not exist";

	this.inputPath = inputFile.fsName;

	if (!options) options = '';
	this.options = options;
}

/**
 * Constructs a new FFMpegOutputModule module
 * @class DuFFMpegOutputModule
 * @classdesc A class used to easily encode medias with ffmpeg
 * @param {string}	codec			- The codec used for transcoding.
 * @param {string}	outputPath		- The path to the output file.
 * @param {string}	[options]			- The options for the output file (other than setting the codec).
 * @property {string}	codec			- The codec used for transcoding.
 * @property {string}	outputPath		- The path to the output file.
 * @property {string}	options			- The options for the output file (other than setting the codec).
 */
function DuFFMpegOutputModule(codec,outputPath,options)
{
	if (!codec) throw "No codec set";
	if (codec == '') throw "No codec set";

	this.codec = codec;

	//f (!outputPath) throw "No output file set";
	//if (outputPath == '') throw "No output file set";

	var outputFile = new File(outputPath);
	this.outputPath = outputFile.fsName;

	if (!options) options = '';
	this.options = options;
}

/**
 * Constructs a new FFMpegQueueItem
 * @class DuFFMpegQueueItem
 * @classdesc A class used to easily encode medias with ffmpeg
 * @param {FFMpegInputModule}		input	  - The input module.
 * @param {FFMpegOutputModule[]}	outputs	   - The output modules
 * @property {FFMpegInputModule}	input	  - The input module.
 * @property {FFMpegOutputModule[]}	outputs	   - The output modules
 */
function DuFFMpegQueueItem(input,outputs)
{
	if (!input) throw "No input set";

	this.input = input;

	if (!outputs) throw "No output set";
	if (outputs.length < 1) throw "Empty outputs";

	this.outputs = outputs;
}
/*
DuJSLib
Library javascript tools
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/


/**
* Constructs an iterator
* @example
* //When iterating through the whole list,
* //using the function do() has the best performance
* //but you can not break the loop.
* //If you need it, instead of using the word 'continue',
* //just make the function return.
* var it = new Iterator(layers);
* it.do(function doSomething(layer) {
* 	layer.name = something;
*	//If we need to continue to the next item, return.
*	if (dontWantThis) return;
*	//else do something here
* });
* @example
* //If you need to break the loop at one time,
* //like if you're searching for something,
* //you can use this method instead, which is a bit less quick than using the function do()
* var it = new Iterator(layers);
* while (layer = it.next())
* {
*	//do something with the layer
	layer.name = something;
	//when found what we're looking for
	if (found) break;
* }
* @class Iterator
* @classdesc An iterator object to use for easier loops
* @property {Array|Collection} list - An array or an After Effects Collection
* @param {Array|Collection} list - An array or an After Effects Collection
* @property {int} min - The minimum value (inclusive)
* @property {int} max - The maximum (inclusive)
* @property {int} length - The number of items
* @property {int} current - The current item number
* @property {boolean} atEnd - true if the iterator has reached the end
* @property {boolean} atStart - true if the iterator is at the start
* @property {boolean} valid - true if the iterator is between min and max. false until next() or previous() has been called at least once
* @property {boolean} isCollection - true if the list is a Collection, false if it's a controller
*/
function Iterator(list)
{
	//check if list is an Array, a collection, or something else.
	//if something else, store it in a one-item array
	this.isCollection = DuAEF.DuAE.isCollection(list);
	if (!(list instanceof Array) && !this.isCollection)
	{
		list = [list];
	}

	this.min = 0;
	this.max = list.length -1;
	this.length = list.length;
	if (list.length == 0) return;
	if (this.isCollection)
	{
		this.min = 1;
		this.max = this.length;
	}
	this.current = -1;
	this.atStart = false;
	this.atEnd = false;
	this.valid = false;
	this.list = list;
}

/**
* Increments the Iterator<br />
* Must be called at least once to validate the iterator
* @return {Object} The next item, or null if there isn't
*/
Iterator.prototype.next = function ()
{
	if (this.length == 0) return null;

	if (!this.valid)
	{
		return this.goToStart();
	}
	if (this.current < this.max)
	{
		return this.goTo(this.current + 1);
	}

	return null;
}

/**
* Decrements the Iterator
* if it's called while valid is false, goes to the end
* @return {Object} The previous item, or null if there isn't
*/
Iterator.prototype.previous = function ()
{
	if (this.length == 0) return null;
	if (!this.valid)
	{
		return this.goToEnd();
	}
	if (this.current > this.min)
	{
		return this.goTo(this.current - 1);
	}

	return null;
}

/**
* Goes to the end of the Iterator
* @return {Object} The item at the end, or null if length is 0
*/
Iterator.prototype.goToEnd = function ()
{
	if (this.length == 0) return null;
	return this.goTo(this.max);
}

/**
* Goes to the start of the Iterator
* @return {Object} The item at the start, or null if length is 0
*/
Iterator.prototype.goToStart = function ()
{
	if (this.length == 0) return null;
	return this.goTo(this.min);
}

/**
* Sets the iterator on the index
* @param {int} index - The index
* @return {Object} The item at index, or null if there isn't
*/
Iterator.prototype.goTo = function(index)
{
	if (this.length == 0) return;
	this.current = index;
	if (this.current < this.min || this.current > this.max) this.valid = false;
	else this.valid = true;
	if (this.current == this.min) this.atStart = true;
	else this.atStart = false;
	if (this.current == this.max) this.atEnd = true;
	else this.atEnd = false;

	if (this.valid) return this.list[this.current];
	else return null;
}

/**
* Executes a function on each item of the List
* @param {function} callBack - The function to execute, which takes one parameter: an item of the list
*/
Iterator.prototype.do = function (callBack)
{
	if (this.length == 0) return;
	var current = this.current;

	for (var i = this.min ; i <= this.max ; i++)
	{
		this.valid = true;
		this.current = i;
		callBack(this.list[i]);
	}

	this.goTo(current);
}

/**
* Gets the item at an index,<br />
* without changing the current iterator index.
* @param {int} index - The index of the item
* @return {Object} The item at index, or null if there isn't one
*/
Iterator.prototype.itemAt = function (index)
{
	if (index < this.min) return null;
	if (index > this.max) return null;
	else return this.list[index];
}

/**
* Gets the first item,<br />
* without changing the current iterator index.
* @return {Object} The first item, or null if there isn't one
*/
Iterator.prototype.firstItem = function ()
{
	if (this.list.length == 0) return null;
	else return this.list[this.min];
}

/**
* Gets the last item,<br />
* without changing the current iterator index.
* @return {Object} The last item, or null if there isn't one
*/
Iterator.prototype.lastItem = function ()
{
	if (this.list.length == 0) return null;
	else return this.list[this.max];
}

/**
* Useful JavaScript tools
* @namespace
* @memberof DuAEF
*/
DuAEF.DuJS = {};

/**
* JavaScript Array related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Array = {};

/**
* Checks if this is an Array or an After Effects collection type
* @memberof DuAEF.DuJS.Array
* @param {Array|Collection} list - The list to check
* @return {boolean} true if this is a Cllection or an Array
*/
DuAEF.DuJS.Array.isList = function (list)
{
	return (list instanceof Array || DuAEF.DuAE.isCollection(list));
}

/**
* A function to compare two elements in an array
* @callback DuAEF.DuJS.Array.indexOf~comparisonFunction
* @memberof DuAEF.DuJS.Array.indexOf
* @param {*} elementInArray The element in the array
* @param {*} value The value to compare
* @return {bool} true if the two values should be considered the same
*/

/**
* Gets the first index of a value in an Array, or -1 if not found
* @memberof DuAEF.DuJS.Array
* @param {Array}	arr	- The array
* @param {*}	value	- The value to find. Must be compatible with the == operand, or provide a comparison function
* @param {function}	[comparisonFunction]	- A function which compares two values which returns true if the values are considered the same.
* @return {int}	The index of the value, -1 if not found
*/
DuAEF.DuJS.Array.indexOf = function (arr,value,comparisonFunction)
{
	if (value == undefined) throw "Value can not be undefined";
	var useFunction = typeof comparisonFunction === 'function';

	for (var i = 0;i<arr.length;i++)
	{
		if (!useFunction && arr[i] == value) return i;
		if (useFunction && comparisonFunction(arr[i],value)) return i;
	}
	return -1;
}

/**
* Checks if the array has duplicate values
* @memberof DuAEF.DuJS.Array
* @param {Array}	arr	- The array
* @return {boolean}	true if the array has duplicate values
*/
DuAEF.DuJS.Array.hasDuplicates = function (arr)
{
	for (var i = 0;i<arr.length-1;i++) {
	for (var j=i+1;j<arr.length;j++) {
	if (arr[i] === arr[j]) return true;
	}
	}
	return false;
}

/**
* Returns all duplicated values found in the array
* @memberof DuAEF.DuJS.Array
* @param {Array}	arr	- The array
* @return {Array}	The duplicated values
*/
DuAEF.DuJS.Array.getDuplicates = function (arr)
{
	var duplicates = [];
	for (var i = 0;i<arr.length-1;i++) {
	for (var j=i+1;j<arr.length;j++) {
	if (arr[i] === arr[j]) duplicates.push(arr[j]);
	}
	}
	DuAEF.DuJS.Array.removeDuplicates(duplicates);
	return duplicates;
}

/**
* Removes all duplicated values from the Array, and returns them
* @memberof DuAEF.DuJS.Array
* @param {Array}	arr	- The array
* @return {Array}	The duplicated (and removed) values
*/
DuAEF.DuJS.Array.removeDuplicates = function (arr)
{
	var removed = [];
	for (var i = 0;i<arr.length-1;i++)
	{
        for (var j=i+1;j<arr.length;j++)
		{
            if (arr[i] === arr[j]) removed = removed.concat(arr.splice(j,1));
        }
	}
	return removed;
}

/**
* Compares two arrays.<br />
* The items in the arrays must be compatible with the == operand
* @memberof DuAEF.DuJS.Array
* @param {Array|Collection} array1 - The array
* @param {Array|Collection} array2 - The array
* @param {int} [floatPrecision=-1] - The precision for (float) number comparison, number of decimals. Set to -1 to not use.
* @return {boolean} true if the two arrays contain the same values
*/
DuAEF.DuJS.Array.compare = function (array1,array2,floatPrecision)
{
	if (!DuAEF.DuJS.Array.isList(array1) && !DuAEF.DuJS.Array.isList(array2))
	{
		if (typeof array1 == 'number' && typeof array2 == 'number')
		{
			return DuAEF.DuJS.Math.compare(array1,array2,floatPrecision)
		}
		else return array1 == array2;
	}
	if (DuAEF.DuJS.Array.isList(array1) && !DuAEF.DuJS.Array.isList(array2)) return false;
	if (!DuAEF.DuJS.Array.isList(array1) && DuAEF.DuJS.Array.isList(array2)) return false;
	if (array1.length != array2.length) return false;

	var it = new Iterator(array1);
	var ok = true;
	it.do(function (item1)
	{
		var item2 = array2[it.current];
		if (!DuAEF.DuJS.Array.compare(item1,item2,floatPrecision))
		{
			ok = false;
			return;
		}
	});

	return ok;
}

/**
* JavaScript File System related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Fs = {};

/**
 * The default user data.<br />
 * Replaces the Folder.userData provided by ESTK which does not work properly with mac network sessions.<br />
 * In windows, the value of %APPDATA% ("C:\Documents and Settings\username\Application Data")<br />
 * In Mac OS, "~/Library/Application Support"
 * @type {Folder}
 */
DuAEF.DuJS.Fs.userData = Folder.userData;

if (DuAEF.mac) DuAEF.DuJS.Fs.userData = new Folder('~/Library/Application Support');

/**
 * The folder where DuAEF stores its data, a "DuAEF" subfolder of DuAEF.DuJS.Fs.userData
 * @type {Folder}
 */
DuAEF.DuJS.Fs.duaefData = new Folder(DuAEF.DuJS.Fs.userData.absoluteURI + '/DuAEF/');

/**
* Recursively gets all files in a folder using a name filter
* Returns an array of File objects.
* @memberof DuAEF.DuJS.Fs
* @param {Folder}	folder	- The Folder
* @param {string|function}	[filter=*]	- A search mask for file names, specified as a string or a function.
* A mask string can contain question mark (?) and asterisk (*) wild cards. Default is "*", which matches all file names.
* Can also be the name of a function that takes a File or Folder object as its argument. It is called for each file or folder found in the search; if it returns true, the object is added to the return array.
* @return {Array}	The files found.
*/
DuAEF.DuJS.Fs.getFilesInFolder = function (folder,filter)
{
	if (folder === undefined) return [];
	if (!(folder instanceof Folder)) return [];

	var files = folder.getFiles(filter);
	if (files === null) files = [];

	var folders = folder.getFiles(DuJS.fs.isFolder);

	for (var i = 0 ; i < folders.length ; i++)
	{
		files = files.concat(DuJS.fs.getFilesInFolder(folders[i],filter));
	}
	return files;
}

/**
* Checks if an object is a Folder
* @memberof DuAEF.DuJS.Fs
* @param {*}	file	- The object to check
* @return {boolean}	true if this object is an instance of Folder
*/
DuAEF.DuJS.Fs.isFolder = function (file)
{
	return file instanceof Folder;
}

/**
* Returns the basename of the given path or file
* @memberof DuAEF.DuJS.Fs
* @example
* DuAEF.DuJS.Fs.getBasename(new File("D:/code/open/Duik/shape.test")) // "shape"
* DuAEF.DuJS.Fs.getBasename("D:/code/open/Duik/shape.test") // "shape"
* @param {String|File}	 [pathOrFile]	- The file or the path
* @return {String} The basename
*/
DuAEF.DuJS.Fs.getBasename = function(pathOrFile)
{
    if (pathOrFile instanceof File) pathOrFile = pathOrFile.absoluteURI;
    var name = pathOrFile.split("/").pop();
    name = name.split("\\").pop();
    if(name.lastIndexOf(".") > 0) return name.slice(0, name.lastIndexOf("."));
    return name;
}

/**
* Switch the extension of the given path. Create a new path from a given path and a given extension.
* @memberof DuAEF.DuJS.Fs
* @param {String|File}	 [pathOrFile]	- The file or the path
* @param {String}	     [newExtension]	- The new extension
* @return {String}  The new path
*/
DuAEF.DuJS.Fs.switchExtension = function(pathOrFile, newExtension)
{
    if (pathOrFile instanceof File) pathOrFile = pathOrFile.absoluteURI;
    var point = pathOrFile.lastIndexOf(".");
    if (point == -1) return pathOrFile + "." + newExtension;
    return pathOrFile.slice(0, point) + "." + newExtension;
}

/**
* Checks if the given path exists
* @memberof DuAEF.DuJS.Fs
* @param {string}	 [path]	- The file path
* @return {boolean} True or false
*/
DuAEF.DuJS.Fs.fileExists = function(path)
{
	var file;
	if (path instanceof File) file = path;
  else file = new File(path);
  return file.exists;
}

/**
* Reads the first line of a file and return its content
* @memberof DuAEF.DuJS.Fs
* @param {File}	 file	- The file
* @return {string} The content
*/
DuAEF.DuJS.Fs.readFirstLine = function(file)
{
	//open and parse file
	if (!file.open('r')) return '';
	var data = file.readln();
	file.close();
	return data;
}

/**
* Reads a whole file and return its content
* @memberof DuAEF.DuJS.Fs
* @param {File}	 file	- The file
* @param {string}	 [encoding='UTF-8']	- The text encoding
* @return {string} The content
*/
DuAEF.DuJS.Fs.readFile = function(file,encoding)
{
	if (typeof encoding === 'undefined') encoding = 'UTF-8';
	//open and parse file
	file.encoding = encoding;
	if (!file.open('r')) return '';
	var data = file.read();
	file.close();
	return data;
}

/**
* Parses a JSON file
* @memberof DuAEF.DuJS.Fs
* @param {File}	 file	- The file
* @return {Object|null} The content or null if the file couldn't be parsed
*/
DuAEF.DuJS.Fs.parseJSON = function(file)
{
	//open and parse file
	var json = DuAEF.DuJS.Fs.readFile(file);
	if (json == '') return null;
	var data = {};
	try { data = JSON.parse(data); } catch (e) { if (DuAEF.debug) alert(e.description + '\n\nJSON DATA:\n\n' + json); }
	return data;
}

/**
* Saves a js object to a JSON file
* @memberof DuAEF.DuJS.Fs
* @param {Object} obj - The object to save
* @param {File|string} file - The file or URI
* @return {boolean} true if the file has been correctly written
*/
DuAEF.DuJS.Fs.saveJSON = function (obj,file)
{
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess) return false;
	if (!(file instanceof File)) file = new File(file);
	var data = JSON.stringify(obj,null,4);
	//save to file
	file.encoding = 'UTF-8';
	if (file.open('w'))
	{
		file.write(data);
		file.close();
		return true;
	}
	return false;
}

/**
* Parses a CSV file
* @memberof DuAEF.DuJS.Fs
* @param {File}	 file	- The file
* @param {string}	 [delimiter=',']	- The delimiter used
* @param {string}	 [textSeparator='"']	- The separator for texts
* @return {string[]|null} The content (a two-dimensionnal Array) or null if the file couldn't be parsed
*/
DuAEF.DuJS.Fs.parseCSV = function(file,delimiter,textSeparator)
{
	if (typeof delimiter === 'undefined') delimiter = ',';
	if (typeof textSeparator === 'undefined') textSeparator = '"';
	var reQuoted = new RegExp("(" + textSeparator + ")((?:\\\\\\1|(?:(?!\\1).))*)\\1");
	//open and parse file
	var data = DuAEF.DuJS.Fs.readFile(file);
	if (data == '') return null;
	data = data.split('\n');
	for (var i = 0, num = data.length; i < num; i++)
	{
		//get quoted values
		var quotedValues = [];
		var line = data[i];
		var quoted = reQuoted.exec(line);
		while (quoted)
		{
			quotedValues.push(quoted[2]);
			line = line.replace(quoted[0],'%%');
			quoted = reQuoted.exec(line);
		}
		data[i] = line.split(delimiter);
		for (var j = 0, numJ = data[i].length; j < numJ; j++)
		{
			data[i][j] = DuAEF.DuJS.String.trim(data[i][j]);
			if (data[i][j] == '%%')
			{
				data[i][j] = quotedValues.shift();
			}
		}
	}
	return data;
}

/**
* Shows the default save file dialog and returns the file selected by the user.<r />
* If the user ommits the extension, the default extension will be appended (Mac OS fix).
* @memberof DuAEF.DuJS.Fs
* @param {string}	 prompt	- The prompt text, displayed if the dialog allows a prompt.
* @param {string}	 [filter='']	- The file type filter (windows only)
* @param {string}	 [defaultExtension='']	- The default extension
* @return {File|null} The file or null if the user cancels
*/
DuAEF.DuJS.Fs.saveFileDialog = function(prompt, filter, defaultExtension)
{
	if (typeof defaultExtension === 'undefined') defaultExtension = '';

	var saveFile = File.saveDialog(prompt, filter);
	if (!saveFile) return null;

	if (saveFile.name.indexOf('.') < 1 && defaultExtension != '')
	{
		if (defaultExtension.indexOf('.') != 0) defaultExtension = '.' + defaultExtension;
		saveFile = new File(saveFile.parent.absoluteURI + '/' + saveFile.name + defaultExtension);
	}

	return saveFile;
}

/**
* JavaScript Math related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Math = {};

/**
* Generates a random integer between minimum and maximum
* @memberof DuAEF.DuJS.Math
* @param {int}	[min=0]	- The minimum value
* @param {int}	[max=1]	- The maximum value
* @return {int}	The randomly generated integer
*/
DuAEF.DuJS.Math.random = function (min, max)
{
	if (min == undefined) min = 0;
	if (max == undefined) max = 1;
	var rng = null;
	$.sleep(1);
	var date = new Date();
	var rng = new Math.seedrandom(date.getTime())();
	//rng = Math.random();

	if (!rng) return 0;
	return rng * (max - min) + min;
}

/**
* Measures the vector length between two points
* @param {int[]} value1 - The first value
* @param {int[]} value2 - The second value
* @return {float} The length
*/
DuAEF.DuJS.Math.getLength = function (value1,value2)
{
	if (typeof value1 !== typeof value2)
	{
		return null;
	}
	if (value1.length > 0)
	{
		var result = 0;
		for (var dim = 0;dim<value1.length;dim++)
		{
			result += (value1[dim]-value2[dim])*(value1[dim]-value2[dim]);
		}
		result = Math.sqrt(result);
		return result;
	}
	else return Math.abs(value1 - value2) ;
}

/**
* Compares two numbers
* @memberof DuAEF.DuJS.Array
* @param {Number} value1 - The first value
* @param {Number} value2 - The second value
* @param {int} [floatPrecision=-1] - The precision for (float) number comparison, number of decimals. Set to -1 to not use.
* @return {boolean} true if the two values are equal
*/
DuAEF.DuJS.Math.compare = function (value1,value2,floatPrecision)
{
	if (typeof value1 != 'number') return false;
	if (typeof value2 != 'number') return false;
	if (floatPrecision >= 0)
	{
		var mul = Math.pow(10,floatPrecision);
		var num1 = Math.round(value1*mul)/mul;
		var num2 = Math.round(value2*mul)/mul;
		return num1 == num2;
	}
	else return value1 == value2;
}

/**
* Calculates the log10 of a number
* @memberof DuAEF.DuJS.Math
* @param {float}	w	- The number
* @return {float}	The result of log10(x)<br />
* i.e. Math.log(x)/Math.LN10
*/
DuAEF.DuJS.Math.log10 = function (x)
{
	return Math.log(x)/Math.LN10;
}

/**
* Calculates the average value in a list
* @memberof DuAEF.DuJS.Math
* @param {Number|Number[]}	values	- values
* @return {float}	The average value
*/
DuAEF.DuJS.Math.average = function (values)
{
	if (!(values instanceof Array)) return values;
	var sum = 0;
	var total = values.length;
	if (total == 0) return 0;
	for (var i = 0; i < total; i++)
	{
		sum += values[i];
	}
	return sum/total;
}

/**
* JavaScript Regular Expression related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.RegExp = {};

/**
* Escape reg exp reserved characters from a string to build a regular expression compatible string
* @memberof DuAEF.DuJS.RegExp
* @param {string}	string		- The string to escape
* @return	{string}	The escaped string
*/
DuAEF.DuJS.RegExp.escapeRegExp = function (string)
{
	return string.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
}

/**
* JavaScript String related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.String = {};

/**
* Parses the string as a boolean.<br />
* The following strings are falsy:<br />
* 'false', '0', '', 'null', 'undefined', 'NaN'.<br />
* Note that any string consisiting only in any number of 0 will be falsy.
* @memberof DuAEF.DuJS.String
* @param {string} string - The string to parse
* @param {boolean} [caseSensitive=true] - When false, 'FALSE', 'nan', 'UNdefined'... for example will be falsy too.
* @return {boolean} The resulting boolean
*/
DuAEF.DuJS.String.parseBool = function (string, caseSensitive)
{
	if (typeof caseSensitive === 'undefined') caseSensitive = true;

	if (!caseSensitive) string = string.toLowerCase();
	var nan = 'NaN';
	if (!caseSensitive) nan = 'nan';

	// test if string is only zeroes
	var reZeroes = /^0+$/g;
	if (reZeroes.test(string)) return false;

	return string === 'false' || string === 'null' || string === '' || string === 'undefined' || string === nan;
}

/**
* Replaces all occurences of a substring by another and returns the new string.
* @memberof DuAEF.DuJS.String
* @param {string}	string			- The original string
* @param {string}	find			- The substring to replace
* @param {string}	replace			- The new substring to insert
* @param {boolean}	[caseSensitive=true]	- Optionnal. Do a case sensitive search of substring.
* @return	{string}	The new string
*/
DuAEF.DuJS.String.replace = function (string, find, replace, caseSensitive)
{
	if (caseSensitive == undefined) caseSensitive = true;
	var re = new RegExp(DuAEF.DuJS.RegExp.escapeRegExp(find),caseSensitive ? 'g' : 'gi');
	return string.replace(re, replace);
}

/**
 * Checks if a string ends with a given suffix
 * @memberof DuAEF.DuJS.String
 * @param {string}	str 	The string to check
 * @param {string}	suffix	The suffix
 * @return {bool}	Wether the string ends with the given suffix or not
 */
DuAEF.DuJS.String.endsWith = function (str, suffix)
{
	return str.indexOf(suffix, str.length - suffix.length) !== -1;
}

/**
 * Generates a new unique string (numbered)
 * @param {string} newString	- The wanted new string
 * @param {string[]} stringList 	- The list of strings where the new one must be generateUnique
 * @param {boolean} [increment=true] - true to automatically increment the new name if it already ends with a digit
 * @return {string}	The unique string, with a new number at the end if needed.
 */
DuAEF.DuJS.String.generateUnique = function ( newString , stringList , increment )
{
	if (increment == undefined) increment = true;
	if (!increment) newString += ' ';

    //detect digits
    var reg = "( *)(\\d+)([.,]?\\d*)$";
    //clean input
    var regexClean = new RegExp(reg);
    newString = newString.replace(regexClean,"");
    //go!
    var regex = new RegExp( DuAEF.DuJS.RegExp.escapeRegExp(newString) + reg);
    //The greatest number found
    var greatestNumber = 0;
    //The number of digits for the number as string
    var numDigits = 0;
    var spaceString = "";
    for ( var i =0 ; i < stringList.length ; i ++)
    {
        var currentNumberMatch = stringList[i].match(regex);
        if (stringList[i] === newString && greatestNumber == 0) greatestNumber++;
        else if (currentNumberMatch !== null)
        {
            //if its a decimal number, keep only the integer part
            var numberAsString = currentNumberMatch[2];
            //convert to int
            var numberAsInt = parseInt(currentNumberMatch[2],10);
			if (isNaN(numberAsInt)) continue;
            if(numberAsInt >= greatestNumber ){
                greatestNumber = numberAsInt  + 1;
                spaceString = currentNumberMatch[1];
            }
            //check if there are zeroes before the number, count the digits
            if(numberAsInt.toString().length < numberAsString.length && numDigits < numberAsString.length) numDigits = numberAsString.length;
        }
    }

    //add leading 0 if needed
    if (greatestNumber > 0)
    {
            //convert to string with leading zeroes
            if (greatestNumber == 1) {
                greatestNumber++;
                spaceString = " ";
            }
            newString += spaceString;
            greatestNumber = DuAEF.DuJS.Number.convertToString(greatestNumber,numDigits);
            newString += greatestNumber;
    }

	if (!increment) newString = newString.substr(0,newString.length-1);

    return newString;
}

/**
* Join multiple paths togetther.
* @param {string[]}	 [parts]	- The parts to join togehter
* @param {String}	[sep=/]	- The separator to use. If not defined, will look for the first sep in the path.
* @return {String} The final path
*/
DuAEF.DuJS.String.pathJoin = function(parts, sep)
{
   var separator = sep || false;
   if(!separator)
   {
       // Find first /
       if(parts[0].indexOf('/') != -1) separator = '/';
       if(parts[0].indexOf('\\') != -1) separator = '\\';
   }
   if(!separator) separator = '/';
   var replace   = new RegExp(separator+'{1,}', 'g');  // Replace ///// with /
   return parts.join(separator).replace(replace, separator);
}

/**
* Returns a copy of the string without leading and trailing white spaces.
* @param {string}	 str	- The string to trim
* @return {String} The trimmed string
*/
DuAEF.DuJS.String.trim = function(str)
{
	return str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
}

/**
* Returns a copy of the string without leading white spaces.
* @param {string}	 str	- The string to trim
* @return {String} The trimmed string
*/
DuAEF.DuJS.String.leftTrim = function(str)
{
	return str.replace(/^[\s\uFEFF\xA0]+/, '');
}

/**
* Returns a copy of the string without trailing white spaces.
* @param {string}	 str	- The string to trim
* @return {String} The trimmed string
*/
DuAEF.DuJS.String.rightTrim = function(str)
{
	return str.replace(/[\s\uFEFF\xA0]+$/, '');
}

/**
* Returns a copy of the string without leading and trailing white spaces, and without any new line, leaving only standard spaces.
* @param {string}	 str	- The string to trim
* @return {String} The trimmed string
*/
DuAEF.DuJS.String.fullTrim = function(str)
{
	var newStr = str.replace(/[\s\uFEFF\xA0]+/g,' ');
	return DuAEF.DuJS.String.trim(newStr);
}

/**
* Number related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Number = {};

/**
 * Converts a number to a string, adding optionnal leading zeroes
 * @param {Number} num	- The number
 * @param {int} numDigits 	- The number of digits in the string. Adds leading zeroes
 * @param {int} [base=10]	- The conversion base
 * @return {string}	The number as a string
 */
DuAEF.DuJS.Number.convertToString = function (num, numDigits, base)
{
	if (base == undefined) base = 10;
	var result = num.toString(base);
	while(numDigits > result.length)
	{
		result  = "0" + result ;
	}
	return result;
}

/**
* Color related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Color = {};

/**
 * Enum for predefined colors.
 * @readonly
 * @enum {float[]}
 */
DuAEF.DuJS.Color.Colors =
{
	BLACK: [0,0,0,1],
	VERY_DARK_GREY: [0.12,0.12,0.12,1],
	DARK_GREY: [.262,.262,.262,1],
	LIGHT_GREY: [.65,.65,.65,1],
	VERY_LIGHT_GREY: [.85,.85,.85,1],
	RAINBOX_RED: [.925,.094,.094,1],
	ORANGE: [.925,.471,.094,1],
	YELLOW: [.925,.839,.094,1],
	GREEN: [.094,.925,.094],
	LIGHT_BLUE: [.471,.839,.925,1],
	LIGHT_PURPLE: [.471,.471,.925,1],
	AFTER_EFFECTS_BLUE: [.439,.722,1,1],
	RAINBOX_PURPLE: [.443,.004,.196,1],
	RANDOM: [-1,-1,-1,-1]
};

/**
* Generates a random color
* @memberof DuAEF.DuJS.Color
* @return {float[]}	The color as an [R,G,B,A] Array with float values between 0.0 and 1.0
*/
DuAEF.DuJS.Color.random = function ()
{
	var color = [0,0,0,1];
	for (var i = 0 ; i < 3 ; i++)
	{
		color[i] = DuAEF.DuJS.Math.random();
		$.sleep(10);
	}
	return color;
}

/**
* Converts an hexadecimal color to an RVB Array
* @memberof DuAEF.DuJS.Color
* @param {string|int[]} hexColor	- The hexadecimal color
* @param {boolean}	[isString=true] 	- Whether hexColor is a string or an Array of int of base 16
* @return {float[]}	The color as an [R,G,B,A] Array with float values between 0.0 and 1.0
*/
DuAEF.DuJS.Color.hexToRGB = function (hexColor,isString)
{
		if (isString == undefined) isString = true;
		if (isString)
		{
			if (hexColor.indexOf("#") == 0) hexColor = hexColor.replace("#","");
			var red = parseInt(hexColor.substr(0,2),16)/255.0;
			var green = parseInt(hexColor.substr(2,2),16)/255.0;
			var blue = parseInt(hexColor.substr(4,2),16)/255.0;
			return [red,green,blue];
		}
		else
		{
			var r = hexColor >> 16;
			var g = (hexColor & 0x00ff00) >> 8;
			var b = hexColor & 0xff;
			return [r/255,g/255,b/255,1];
		}
	}

/**
* Converts an RGB color to a hex string
* @memberof DuAEF.DuJS.Color
* @param {float[]} rgbColor	- The rgb color
* @return {string}	The color as an hex string
*/
DuAEF.DuJS.Color.rgbToHex = function (rgbColor)
{
	var red = rgbColor[0]*255;
	var green = rgbColor[1]*255;
	var blue = rgbColor[2]*255;
	var hexR = red.toString(16)
	var hexG = green.toString(16)
	var hexB = blue.toString(16);
	if (hexR.length == 1) hexR = "0" + hexR;
	if (hexG.length == 1) hexG = "0" + hexG;
	if (hexB.length == 1) hexB = "0" + hexB;
	var hex = hexR+hexG+hexB;
	return hex;
}

/**
* Date related methods
* @namespace
* @memberof DuAEF.DuJS
*/
DuAEF.DuJS.Date = {};

/**
* Gets the month number from a literal name
* @memberof DuAEF.DuJS.Date
* @param {string} string - The month name
* @return {int} The month number
*/
DuAEF.DuJS.Date.getMonth = function (string)
{
	var month = 0;
	if (string.toLowerCase().indexOf('feb') == 0) month = 1;
	if (string.toLowerCase().indexOf('mar') == 0) month = 2;
	if (string.toLowerCase().indexOf('apr') == 0) month = 3;
	if (string.toLowerCase().indexOf('may') == 0) month = 4;
	if (string.toLowerCase().indexOf('jun') == 0) month = 5;
	if (string.toLowerCase().indexOf('jul') == 0) month = 6;
	if (string.toLowerCase().indexOf('aug') == 0) month = 7;
	if (string.toLowerCase().indexOf('sep') == 0) month = 8;
	if (string.toLowerCase().indexOf('oct') == 0) month = 9;
	if (string.toLowerCase().indexOf('nov') == 0) month = 10;
	if (string.toLowerCase().indexOf('dec') == 0) month = 11;

	return month;
}
/*
DuProcessLib
Library of tools to run command line tools and processes from After Effects scripts
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
* Constructs a new DuProcess instance
* @class DuProcess
* @classdesc A class to launch and manage processes, using the system command line.
* @param {string}	  processPath     - The path to the process executable binary
* @param {array}    [args]            - The common arguments used to run the process. You can append arguments each time you run the process with start(args)
* @param {int}      [timeout=0]         - Waiting timeout after process start, in ms, 0 to avoid waiting, -1 for infinite.
* If the process times out, process will not be killed, the script will just stop waiting.
* @property {string}	  processPath     - The path to the process executable binary
* @property {array}    args            - The common arguments used to run the process. You can append arguments each time you run the process with start(args)
* @property {int}      timeout         - Waiting timeout after process start, in ms, 0 to avoid waiting, -1 for infinite.
* If the process times out, process will not be killed, the script will just stop waiting. Default: 0
* @property {string[]}	queue			- An Array of arguments array.
Arrays of arguments in the queue will be processed one after each other.
Update the Array and launch the queue with startQueue()
* @property {string}	latestCommand	- The latest command which has been run.
*/
function DuProcess(processPath,args,timeout)
{
	if (processPath === undefined) processPath = "";
	this.processPath = processPath;
	if (args === undefined) args = [];
	this.args = args;
	if (timeout === undefined) timeout = 0;
	this.timeout = timeout;

	this.queue = [];

	this.latestCommand = '';
}

/**
* Starts the process
* @memberof DuProcess
* @param {Array}  args  - Args to append to DuProcess.args before starting
* @param {int}		[timeout] 	- Overrides the default timeout.
*/
DuProcess.prototype.start = function (args,timeout)
{
	if (timeout === undefined) timeout = this.timeout;

	var cmd = this.buildCmd(args);

	this.startCmd(cmd);
	this.latestCommand = cmd;
	this.waitForFinished(timeout);
}

/**
* Starts the queue
* @memberof DuProcess
* @param {int}		[timeout] 	- Overrides the default timeout.
*/
DuProcess.prototype.startQueue = function (timeout)
{
	if (timeout === undefined) timeout = this.timeout;

	var cmd = this.buildQueueCmd();

	this.startCmd(cmd);
	this.latestCommand = cmd;
	this.queue = [];

	this.waitForFinished(timeout);
}

/**
* Waits for the process to finish
* @memberof DuProcess
* @param {int}		[timeout] 	- Overrides the default timeout.
*/
DuProcess.prototype.waitForFinished = function (timeout)
{
	if (timeout === undefined) timeout = this.timeout;
	//wait
	var wait = true;
	var currentDate = new Date();
	var timeout = currentDate.getTime() + timeout;
	var checkTime = new Date();

	var checkCmd = '';
	var processName = new File(this.processPath).name;
	if (DuAEF.mac) checkCmd = 'ps -A | grep "' + processName + '"';
	if (DuAEF.win) checkCmd = 'tasklist /FO TABLE /NH /FI "Imagename eq ' + processName + '"';

	//wait
	while(wait)
	{
		var test = system.callSystem(checkCmd);
		if (test.indexOf(processName) < 0) break;
		$.sleep(100);
		checkTime = new Date();

		if (this.timeout >= 0)
		{
			wait = checkTime.getTime() < timeout;
		}
	}
}

/**
* Buidls and returns the command line
* @memberof DuProcess
* @param {string[]}  [args]  - Args to append to DuProcess.args before starting
* @return {string}	The command
*/
DuProcess.prototype.buildCmd = function (args)
{
	if (args === undefined) args = [];
	//build command
	//make sure to use fsName
	if(this.processPath.indexOf('/') >= 0 || this.processPath.indexOf('\\') >= 0)
	{
		var processFile = new File(this.processPath);
		this.processPath = processFile.fsName;
		if (this.processPath.indexOf(' ') > 0)
		{
			this.processPath = '"' + this.processPath + '"';
		}
	}
	var cmd = this.processPath;

	//args
	for (var a = 0 ; a < this.args.length ; a++)
	{
		var arg = this.args[a];
		if (arg.indexOf(' ') > 0)
		{
			arg = '"' + arg + '"';
		}
		cmd += ' ' + arg;
	}
	for (var b = 0 ; b < args.length ; b++)
	{
		var arg = args[b];
		if (arg.indexOf(' ') > 0)
		{
			arg = '"' + arg + '"';
		}
		cmd += ' ' + arg;
	}

	return cmd;
}

/**
* Builds and returns the command line to launch the current queue
* @memberof DuProcess
* @return {string}	The command
*/
DuProcess.prototype.buildQueueCmd = function ()
{
	var cmd = '';

	if (this.queue.length == 0)
	{
		return this.buildCmd();
	}

	for (var i = 0 ; i < this.queue.length ; i++)
	{
		if (i > 0)
		{
			if (DuAEF.mac) cmd += ' && ';
			if (DuAEF.win) cmd += '\r\n';
		}
		cmd += this.buildCmd(this.queue[i]);
	}
	return cmd;
}

/**
* Starts a command (in another thread).
* @memberof DuProcess
* @param {string}  cmd  - The command to start
*/
DuProcess.prototype.startCmd = function (cmd)
{
	//Start
	if (DuAEF.mac)
	{
		//add ' &' at the end to start detached
		cmd += ' &';
		system.callSystem(cmd);
	}
	if (DuAEF.win)
	{
		//create batch file
		var bat = new File(DuAEF.DuJS.Fs.duaefData.absoluteURI + '/DuProcess.bat');
		bat.open('w');
		bat.write(cmd);
		bat.close();
		bat.execute();
	}
}

/**
* Constructs a queue of different processes
* @class DuProcessQueue
* @classdesc A class to launch several processes
* @param {DuProcess[]}	  [processes]     - The DuProcess Array
* @property {DuProcess[]}	  processes     - The DuProcess Array
*/
function DuProcessQueue(processes)
{
	if (processes === undefined) processes = [];
	this.processes = processes;
}

/**
* Starts the processes
* @memberof DuProcessQueue
*/
DuProcessQueue.prototype.start = function ()
{
	if(!this.processes.length) return;
	var cmd = '';
	for (var i = 0 ; i < this.processes.length ; i++)
	{
		var p = this.processes[i];
		if (i > 0)
		{
			if (DuAEF.mac) cmd += ' && ';
			if (DuAEF.win) cmd += '\r\n';
		}
		cmd += p.buildQueueCmd();
		p.queue = [];
	}
	this.processes[0].startCmd(cmd);
}
/*
DuQuantLib
Library to easily use a pngquant binary executable in After Effects
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

_DuQuant makes use of:_

• pngquant
https://pngquant.org/ licensed under BSD by Kornel Lesiński and contributors.

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
* Constructs a new PNGQuant instance
* The constructor will try to find the pngquant binary in the same folder as DuQuant, or a (pngquant) subfolder, or in the scripts folder of After Effects.
* If pngquant is not in one of those, the property pngquantPath will be an empty string, and it has to be set by the user.
* @class DuQuant
* @classdesc A class used to easily compress png files using pngquant
* @param {string}   [suffix=_DuQuant]          - The suffix added to compressed files. Using an empty string will overwrite input files.
* @param {int}		[quality=85]			- range 0 (worst) to 100 (perfect), similar to JPEG. pngquant will use the least amount of colors required to meet or exceed the quality.
* @param {string}	  [pngquantPath]		- The path to the pngquant binary. Will try to extract or auto find it if not set
* @property {string}	  pngquantPath		- The path to the pngquant binary. Will try to extract or auto find it if not set
* @property {string}   suffix          - The suffix added to compressed files. Using an empty string will overwrite input files.
* @property {int}			quality					- range 0 (worst) to 100 (perfect), similar to JPEG. pngquant will use the least amount of colors required to meet or exceed the quality.
* @property {File[]|Folder[]}		queue			- An Array of File or Folder objects to compress.
*/
function DuQuant(suffix,quality,pngquantPath)
{
	if (quality === undefined) this.quality = 85;
	else this.quality = quality;

	if (suffix === undefined) this.suffix = "_DuQuant";
	else this.suffix = suffix;

	this.pngquantPath = '';
	this.process = null;

	this.queue = [];
	this.folders = [];

	//find pngquant
	this.setPngquantPath(pngquantPath);
}

/**
* Launches compression on all files in a given folder
* @memberof DuQuant
* @param {string}  path  - The path to the folder containing files
*/
DuQuant.prototype.compressFolder = function (path)
{
	if (this.process === null) throw 'pngquant not found, cannot compress folder. You should set pngquant path with DuQuant.setPngquantPath()'
	var folder = new Folder(path);
	//get PNG files in folder
	var pngs = DuJS.fs.getFilesInFolder(folder,"*.png");
	if (pngs.length == 0) return;

	this.compress(pngs);
}

/**
* Launches compression on queue
* @memberof DuQuant
* @param {File[]|Folder[]}  [files=DuQuant.queue]  - The File or Folder objects to compress.
*/
DuQuant.prototype.compress = function (files)
{
	if (files === undefined) files = this.queue;
	else if (!files.length) files = this.queue;
	if (!files.length) return;

	var args = [];

	if (this.suffix != '')
	{
		args.push('--ext');
		args.push(this.suffix + '.png');
	}
	else
	{
		args.push('--ext=.png');
	}
	args.push('--quality');
	args.push('0-' + this.quality);

	for (var i = 0 ; i < files.length ; i++)
	{
		var file = files[i];
		//if folder, get qll files inside
		if (DuJS.fs.isFolder(file))
		{
			var filesInFolder = DuJS.fs.getFilesInFolder(file,"*.png");
			for (var j = 0 ; j < filesInFolder.length  ; j++)
			{
				this.process.queue.push(args.concat(filesInFolder[j].fsName));
			}
		}
		//if file, add it
		else
		{
			this.process.queue.push(args.concat(file.fsName));
		}
	}
	this.process.startQueue();
}

/**
* Sets the path to the pngquant binary executable
* @memberof DuQuant
* @param {pngquantPath}  [path]  - The path to the pngquant binary executable. If not provided, DuAEF will extract the binary if it has been included, or try to find it in common folders.
*/
DuQuant.prototype.setPngquantPath = function (pngquantPath)
{
	if (pngquantPath === undefined) pngquantPath = "";
	var pngquantFile = new File(pngquantPath);
	var pngquantBinName = '';
	if (DuAEF.win) pngquantBinName = 'pngquant.exe';
	else pngquantBinName = 'pngquant';
	//extract
	if(!pngquantFile.exists)
	{
		if (DuAEF.bin.pngquant != null)
		{
			pngquantFile = DuBinary.toFile(DuAEF.bin.pngquant);
		}
	}
	//first, in the same dir
	if (!pngquantFile.exists)
	{
		pngquantFile = new File($.fileName.substring(0,$.fileName.lastIndexOf('/')) + '/' + pngquantBinName);
	}
	//in an (ffmpeg) subfolder
	if (!pngquantFile.exists)
	{
		pngquantFile = new File($.fileName.substring(0,$.fileName.lastIndexOf('/')) + '/(pngquant)/' + pngquantBinName);
	}
	//in AE Scripts folder
	if (!pngquantFile.exists)
	{
		pngquantFile = new File(Folder.appPackage.absoluteURI + '/Scripts/' + pngquantBinName);
	}
	//in AE Scripts/(ffmpeg) folder
	if (!pngquantFile.exists)
	{
		pngquantFile = new File(Folder.appPackage.absoluteURI + '/Scripts/(pngquant)/' + pngquantBinName);
	}
	//in AE ScriptUI Panels
	if (!pngquantFile.exists)
	{
		pngquantFile = new File(Folder.appPackage.absoluteURI + '/Scripts/ScriptUI Panels/' + pngquantBinName);
	}
	//in AE ScriptUI Panels/(ffmpeg)
	if (!pngquantFile.exists)
	{
		pngquantFile = new File(Folder.appPackage.absoluteURI + '/Scripts/ScriptUI Panels/(pngquant)/' + pngquantBinName);
	}

	if (pngquantFile.exists)
	{
		this.pngquantPath = pngquantFile.fsName;
		//create process
		var timeout = 0;
		var commonArgs = ['--force','--skip-if-larger'];
		this.process = new DuProcess(this.pngquantPath,commonArgs,timeout);
	}
}
/*
DuRendererLib
Library to manage the After Effects Renderer/RenderQueue
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
* Constructs a new DuRenderer instance
* @class DuRenderer
* @classdesc A class used to easily manage After Effects Renderer/RenderQueue
* @param {string}             [defaultOutputTemplate]       - The default output module template name to use when adding comp to the queue. Empty string to let default AE OM defaultOutputTemplate.
* @param {PostRenderAction}   [defaultPostRenderAction=PostRenderAction.NONE]     - The default PostRenderAction.
* @param {boolean}				[pngquant=false]					- Compress PNG Sequences using pngquant after render.
* @property {string}             defaultOutputTemplate       - The default output module template name to use when adding comp to the queue. Empty string to let default AE OM defaultOutputTemplate.
* @property {PostRenderAction}   defaultPostRenderAction     - The default PostRenderAction.
* @property {boolean}				pngquant				- Compress PNG Sequences using pngquant after render.
* @property {DuRendererItem[]}              items            - The DuRendererItems in the queue
*/
function DuRenderer(defaultOutputTemplate,defaultPostRenderAction,pngquant)
{
	if (defaultOutputTemplate === undefined) defaultOutputTemplate = '';
	this.defaultOutputTemplate = defaultOutputTemplate;
	if (defaultPostRenderAction === undefined) defaultPostRenderAction = PostRenderAction.NONE;;
	this.defaultPostRenderAction = defaultPostRenderAction;
	if (pngquant === undefined) pngquant = false;
	this.pngquant = pngquant;

	//create pngquant process
	var suffix = '';
	this.pngquantProcess = new DuQuant(suffix);
	if (this.pngquantProcess.pngquantPath == '')
	{
		this.pngquant = false;
	}

	this.items = [];

	this.rqItemsEnabled = [];

	// get aerender
	var aerenderBinName = "aerender";
	if (DuAEF.win) aerenderBinName += ".exe";
	this.aerender = new DuProcess(Folder.appPackage.absoluteURI + "/" + aerenderBinName,['-continueOnMissingFootage']);

	//get pngquant-batch

	pngquantbatchFile = DuBinary.toFile(DuAEF.bin.pngquantbatch);
	this.pngquantbatch = new DuProcess(pngquantbatchFile.fsName,['--force','--skip-if-larger','--ext=.png','--quality','0-85','*.png']);
}

/**
* Adds a comp to the render queue
* @memberof DuRenderer
* @param {CompItem}          comp              - The Composition to add
* @param {string}            outputPath        - The output file path
* @param {string}            [outputTemplate]    - Overrides the default output module template
* @param {PostRenderAction}  [postRenderAction]  - Overrides the default PostRenderAction
*/
DuRenderer.prototype.addComp = function(comp,outputPath,outputTemplate,postRenderAction)
{
	if (outputTemplate === undefined) outputTemplate = this.defaultOutputTemplate;
	if (postRenderAction === undefined) postRenderAction = this.defaultPostRenderAction;
	var item = new DuRendererItem(comp,outputPath,outputTemplate,postRenderAction);
	this.items.push(item);
}

/**
* Adds a DuRendererItem to the After Effects renderQueue
* @memberof DuRenderer
* @param {DuRendererItem}          item              - The Item to add.
* @return {RenderQueueItem}		The item created.
*/
DuRenderer.prototype.addItemToAEQueue = function (item)
{
	//add comp to render queue
	var rqItem = app.project.renderQueue.items.add(item.comp);
	var outputModule = rqItem.outputModule(1);
	//set output format
	outputModule.applyTemplate(item.outputTemplate);

	//set output file
	var outputFile = new File(item.outputPath);
	outputModule.file = outputFile;
	//set post render action
	outputModule.postRenderAction = item.postRenderAction;
	return rqItem;
}

/**
* Renders a comp in background using aerender.exe
* Automatically manages the existing After Effects render queue to leave it untouched.
* The project will be saved.
* @memberof DuRenderer
* @param {CompItem}          comp              - The Composition to render
* @param {string}            outputPath        - The output file path
* @param {string}            [outputTemplate]    - Overrides Durenderer.defaultOutputTemplate
* @param {PostRenderAction}  [postRenderAction]  - Overrides DuRenderer.defaultPostRenderAction
* @property {bool}				[pngquant]		- Overrides DuRenderer.pngquant
*/
DuRenderer.prototype.backgroundRenderComp = function(comp,outputPath,outputTemplate,postRenderAction,pngquant)
{
	if (outputTemplate === undefined) outputTemplate = this.defaultOutputTemplate;
	if (postRenderAction === undefined) postRenderAction = this.defaultPostRenderAction;
	if (pngquant === undefined) pngquant = this.pngquant;

	//disable existing items
	this.disableRqItems();
	if (!app.project.file) app.project.save();
	//launch
	var rqItem = this.addItemToAEQueue(new DuRendererItem(comp,outputPath,outputTemplate,postRenderAction));
	app.project.save();
	var newProjectName = app.project.file.fsName.replace(/\.aep$/gi,"") + "_Durenderer.aep";
	//copy the project as a new file
	app.project.file.copy(newProjectName);

	//launch aerender.exe
	this.aerender.queue.push(['-project',newProjectName]);
	//pngquant
	if (pngquant)
	{
		var cdProcess = new DuProcess('cd',[rqItem.outputModule(1).file.parent.fsName]);
		//launch
		var queue = new DuProcessQueue([this.aerender,cdProcess,this.pngquantbatch]);
		queue.start();
	}
	else
	{
		this.aerender.startQueue();
	}

	rqItem.remove();
	this.enableRqItems();
	app.project.save();
}

/**
* Renders a comp in After Effects
* Automatically manages the existing After Effects render queue to leave it untouched.
* @memberof DuRenderer
* @param {CompItem}          comp              - The Composition to render
* @param {string}            outputPath        - The output file path
* @param {string}            [outputTemplate]    - Overrides Durenderer.defaultOutputTemplate
* @param {PostRenderAction}  [postRenderAction]  - Overrides DuRenderer.defaultPostRenderAction
* @property {bool}				[pngquant]		- Overrides DuRenderer.pngquant
*/
DuRenderer.prototype.renderComp = function(comp,outputPath,outputTemplate,postRenderAction,pngquant)
{
	if (outputTemplate === undefined) outputTemplate = this.defaultOutputTemplate;
	if (postRenderAction === undefined) postRenderAction = this.defaultPostRenderAction;
	if (pngquant === undefined) pngquant = this.pngquant;

	//disable existing items
	this.disableRqItems();

	//launch
	var rqItem = this.addItemToAEQueue(new DuRendererItem(comp,outputPath,outputTemplate,postRenderAction));
	app.project.renderQueue.render();

	//pngquant
	if (rqItem.file.name.toLowerCase().lastIndexOf(".png") == rqItem.file.name.length-4 && pngquant)
	{
		//go!
		this.pngquantProcess.compressFolder(rqItem.file.parent.fsName);
	}

	//remove item after render
	rqItem.remove();

	//enable existing items
	this.enableRqItems();

}

/**
* Renders the queue in background using aerender.exe
* Automatically manages the existing After Effects render queue to leave it untouched.
* The project will be saved.
* @memberof DuRenderer
*/
DuRenderer.prototype.backgroundRender = function()
{
	//disable existing items
	this.disableRqItems();
	if (!app.project.file) app.project.save();

	var rqItems = [];
	var postProcesses = [];
	for (var i = 0 ; i < this.items.length ; i++)
	{
		var item = this.items[i];
		//add comp to render queue
		var rqItem = this.addItemToAEQueue(item);
		//pngquant queue
		var outputFile = rqItem.outputModule(1).file;
		if (this.pngquant)
		{
			var cdProcess = new DuProcess('cd',[rqItem.outputModule(1).file.parent.fsName]);
			postProcesses.push(cdProcess);
			postProcesses.push(this.pngquantbatch);
		}
		rqItems.push(rqItem);
	}

	app.project.save();
	var newProjectName = app.project.file.fsName.replace(/\.aep$/gi,"") + "_Durenderer.aep";
	//copy the project as a new file
	app.project.file.copy(newProjectName);
	this.aerender.queue.push(['-project',newProjectName]);

	if (this.pngquant)
	{
		var queueProcesses = [this.aerender];
		var queue = new DuProcessQueue(queueProcesses.concat(postProcesses));
		queue.start();
	}
	else
	{
		this.aerender.startQueue();
	}

	this.items = [];

	//remove items
	for (var i = rqItems.length -1 ; i>=0  ; i--)
	{
		rqItems[i].remove();
	}

	//enable existing items
	this.enableRqItems();
	app.project.save();
}

/**
* Renders the queue in After Effects
* Automatically manages the existing After Effects render queue to leave it untouched.
* @memberof DuRenderer
*/
DuRenderer.prototype.render = function()
{
	//disable existing items
	this.disableRqItems();
	var rqItems = [];
	for (var i = 0 ; i < this.items.length ; i++)
	{
		var item = this.items[i];
		//add comp to render queue
		var rqItem = this.addItemToAEQueue(item);
		//pngquant queue
		var outputFile = rqItem.outputModule(1).file;
		if (outputFile.name.toLowerCase().lastIndexOf(".png") == outputFile.name.length-4 && this.pngquant)
		{
			//go!
			this.pngquantProcess.queue.push(outputFile.parent);
		}
		rqItems.push(rqItem);
	}
	//render
	app.project.renderQueue.render();
	this.pngquantProcess.compress();

	this.items = [];

	//remove items
	for (var i = rqItems.length -1 ; i>=0  ; i--)
	{
		rqItems[i].remove();
	}

	//enable existing items
	this.enableRqItems();
}

/**
* Disables all previously added Items in the AE renderQueue
* You can re-enable them using DuRenderer.enableRqItems()
*/
DuRenderer.prototype.disableRqItems = function()
{
	for (var i = 1 ; i <= app.project.renderQueue.numItems ; i++)
	{
		var item = app.project.renderQueue.items[i];
		if (item.render) this.rqItemsEnabled.push(i);
		if(item.status != RQItemStatus.RENDERING && item.status != RQItemStatus.DONE &&  item.status != RQItemStatus.WILL_CONTINUE) item.render = false;
	}
}

/**
* Enables all previously added Items in the AE renderQueue, if they were previously disabled by DuRenderer.disableRqItems()
*/
DuRenderer.prototype.enableRqItems = function ()
{
	//re-enable render queue
	for (var i = 0 ; i < this.rqItemsEnabled ; i++)
	{
		var item = app.project.renderQueue.items[this.rqItemsEnabled[i]];
		item.render = true;
	}
}

/**
* Constructs a new item to render
* @class DuRendererItem
* @classdesc An item in the Durenderer queue
* @param {CompItem}			comp				- The composition to render
* @param {string}             [outputTemplate]       - The output module template name to use when adding comp to the queue. Empty string to let default AE OM defaultOutputTemplate.
* @param {PostRenderAction}   [postRenderAction]     - The PostRenderAction.
* @param {string}			outputPath			- The output file path.
* @property {CompItem}			comp				- The composition to render
* @property {string}             outputTemplate       - The output module template name to use when adding comp to the queue. Empty string to let default AE OM defaultOutputTemplate.
* @property {PostRenderAction}   postRenderAction     - The PostRenderAction.
* @property {string}			outputPath			- The output file path.
*/
function DuRendererItem(comp,outputPath,outputTemplate,postRenderAction)
{
	this.comp = comp;
	this.outputPath = outputPath;
	this.outputTemplate = outputTemplate;
	this.postRenderAction = postRenderAction;
}

/**
* Renderer tools
* @namespace
* @memberof DuAEF
*/
DuAEF.DuRenderer = {};

/**
 * Loads the outputModules found in the project and recreates them to make them available in the current Ae installation
 * @memberof DuAEF.Renderer
 * @param {file|string} project - An After Effects project file containing one render queue item with the modules to load
 */
DuAEF.DuRenderer.loadOutputModules = function(project)
{
	if (!(project instanceof File)) project = new File(project);
	if (!project.exists) return;
	//import project
	var importedProject = app.project.importFile(new ImportOptions(project));

	//the last rqItem contains the modules
	var rqItem = app.project.renderQueue.item(app.project.renderQueue.numItems);

	//load modules
	for (var i = 1, num =  rqItem.outputModules.length; i <= num; i++)
	{
		var om = rqItem.outputModule(i);
		if (DuAEF.DuJS.Array.indexOf(om.templates,om.name) < 0) om.saveAsTemplate(om.name);
	}

	//remove project
	importedProject.remove();
}
/*
DuScriptUILib
Library with ScriptUI tools.
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

var w14_menu_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00TIDAT(\u0091c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\f\f\f,\f\f\f\fO\u009E<!\u00C5\u00DA{222\u00CA\u00E4\u00D8(\b\u00B7\u0091\u0081\u0081\u00C1\u0084\u0081\u0081\u00C1\u0098H\u008Dg\x19\x18\x18\x18\x18\u00C9\r\u009C!\u00E4Grl|\u008Fl\u00E3\x19\x125\n\u0091m#\u00D9\u00D1AvZ\x05\x00+\u00B3\x19Pff\x1C\u00C1\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_menu_l.png","category":""};
w14_menu_l;
var w14_menu_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00SIDAT(\u0091c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\f\f\f,\f\f\f\f---\u00A4X{\u00AF\u00A6\u00A6F\u0099\x1C\x1B\x05\u00E16200\u0098000\x18\x13\u00A9\u00F1,\x03\x03\x03\x03#\u00B9\u00813\u0084\u00FCH\u008E\u008D\u00EF\u0091m<C\u00A2F!\u00B2m$;:\u00C8N\u00AB\x00\u00BF\u00A4\x19P\u00CFx\u00CB\u00B2\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_menu_m.png","category":""};
w14_menu_m;
var w14_layers_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00D7IDAT(\u0091\u009D\u00D2\u00CDQ\x02A\x10\u00C5\u00F1\x1F&\u00E0f\u00A0!l\x06\u00AE\x11\u0088\x11\u0088\x19\x18@\x1F\u00A0\u00AA\u00EF\x12\x02F\u00A0F\u00C0\u0092\x01f\u0080\x19\u0090\u00C1zp\u00B4\x16X\u00F0\u00E3U\u00CDe\u00FA\u00FD\u00A7_\u00CF\u00CC\u00A8\u00EB:\u00FF\u00D1\u00D9\u00B1BfV\u0099y\u00F9'03k\u00AC\u00B1\u00CE\u00CC\u00E6W`fN\u00D0\u00E2\x02\u00E7Xf\u00E6t\u00DF7\u00EA\u00CF\u0098\u0099\x0B\u00DC\x1DI\u00F7\u008AIDlw:ff{\x02\u0082\u009B\x12\u00FF \u00EA\x04o'\u00C0w\u008C\u0087@x\u00C0\u00D3\x00\u00B4*\x07\x7F\u00AB\x0F.\u00B0,q\u00EE{\u00FB3\u00CC\u00F1R\u00D6.\x18\x11M\u00E9\u00F6\u0088\x06\u00D7\u00B8E\u0085g\u009F7]\x7F\u00F9G\u00FB?\u00A7<\u00C7\x1C\x1Blq\u0085YDL\u00FB\u00BE\x03\u00B0\u00C0u\u0089Ua\x1C\x11\u00ED\u00BEg\x10,p\u0085*\"6C\u00F5\u00A3\u00E0O\u00FA\x00!\u00C4H\u00DE\u00C8\u00F9\u00AFt\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_layers_m.png","category":""};
w14_layers_m;
var w14_layers_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00DAIDAT(\u0091\u009D\u0092\u00D1q\u00C20\x10D\u009F\u00D3@T\u00C0\u00CE\u0084\x12\u00DC\x01\u00A6\x03R\x01\u00A6\u0083\u0094\x00\x15@\tP\x01\u00A1\x02\u009C\x0E\u00A0\x03\u0098\u00D9\x02\u00E8\u00C0\u00F9\u00B0\u009C1\u00C2&!;\u00A3\x0F\u00E9\u00F6\u009D\u00EEN\u00CA\u00EA\u00BA\u00E6?z\x19\n\u00D8\x0E\u00B6GO\u0081\u00B6s\u00E0\b\x1Cm\x17\x7F\x02m\u0097@\x05\u00BC\x01\u00AF\u00C0\u00C1\u00F6\"\u00F5e\u00DD\x1Emo\u0080\u00D9@u{\u00A0\u0094t\u00BD\x01mW\u00C0x\x00ju\u00914JK-\u0081\u00D3#\b\u0098\u00B6\u009B\u00B4\u00C7\x0F`\u00DB\x03}\u00C5\u00C4?\u00EA\u0082\x1B\u00E0@3\u00CDy\u00E7|\t\u00AC\u0081\u00CF\u00B8nAIE\u00BCm\x05\x14\u00C0\x04x\x07\x02\u00B0\u00A3\u0099t\u00DE\u00FA\u00B3\u00F4\u00E7\u00C4\u00E7X\x03g\u00E0J3\u00B0\u00A5\u00A4E\u00D7w\x07F8\u008Fe\x05`*\u00A9J=\u00BD`\u0084\x03\x10$\u009D\u00FB\u00E2\u0083\u00E0o\u00FA\x06\u00E4\u00C0R\u00B0\x14\u00E1\u009C\u00B1\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_layers_l.png","category":""};
w14_layers_l;
var w14_update_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00C3IDAT(\u0091\u009D\u0092\u00C1\r\u0083@\f\x04\x07\u0094\x06\u00F8\u00EF\u008B\u0094\x10ZH\t\u00A4\x04(\x01J\b%\u0084\x16h\u0081\x16h\u0081\u0097\u00FF)\u0081|\u008E\u00C4\u009C\u00E0\x11,\u009D,\u00AFn\u00BD^\u00DF%\u00CB\u00B2p&\u00D2S,\u00E0\x12\x03fv\x03\x1A\u00A0\f\u00D0\b\u00F4!W\u0092:\u0080\u00C4\u008Fjf\x15\u00F0:\x10y\x03\x19p\u00974\u00A6\u008ET:R-)\u0091\u0094\x00u\u00C02\u00DF\u00C5{lBn%\u00F5\x0E\u00AFv\u00947\x1E; _=\u00C4\u00F8ZH\u009Ab\u00C5<\u008C\u00DC\u0098Y\u00E3.\x0E;\u00CD~\u00CB13\u00FF\u00A0\u0093\u00A4b-\u00DC\u00D2fI\u00D7X\u00D1\u00C7\u00E8H%\u00F0\fe{\u00A48{?\u00B1WI_\u00A2Wl\u0081\"\u009C!R\x7Fx\u00D2F\u00F1\u00DF8\u00FDW?\u00FCXH \u00C0\"\u00E5P\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_update_l.png","category":""};
w14_update_l;
var w14_update_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00C4IDAT(\u0091\u009D\u0092\u00C1\r\u00830\fE\x1F\u00A8\x0B\u00B0\x02+\u00B4+t\x04:\x02\u008C\x00\u0087\x7F\u00F4\u00A1\u008CPV`\x05V`\u0085\u00AE\u00D0\x11\u00E8\u00C5T&\u0082C\u00B1\x149\u00F9\u00C9\u00FF\u00DF\u0096\u0093-\u00CB\u00C2\u0099\u00C8O\u00B1\u0080K\n\u0098\u00D9\x15h\u0081\u00CA\u00A1\t\x18<\u00D7\u0092z\u0080,\u0096jf5\u00F0:0\u00F9\x00\x05p\u00974\u00E5\u0081T\x05R#)\u0093\u0094\x01\u008DcET\u0089=\u00B6\u009E;IC\u00C0\u00EB\x1D\u00E7M\u008F=P\u00AE=\u00A4\u00F8z\u00904\u00A7\u008E\u00A5\u0097\u00DC\u009AY\x1B\x1E\u008E;b\x1B\u00C7g\u00D8\u00CF\u00EE\u0084\u008B\u00D5~\u00FF^\u00F1\u00A39N\u0081T\x05\u00D1n\u00C5\x7F\u00E30\u00B3\u00C5\x15K\u00F6\u00A3\u0097\u00F4#F\u00C7\x0E\u00B8\u00F9\x1A\x13\u00F7G$m\x1C\u00FF\u008D\u00D3\x7F\u00F5\x0B\u00A6\u00E6Ee\u00E0\u0089\u00FA\u00DF\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_update_m.png","category":""};
w14_update_m;
var w14_checked_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u009BIDAT(\u0091\u009D\u00D2Q\r\u00C3 \x10\u00C6\u00F1\x7F\x1B\f\u00CC\u00C2,0\t\u00AB\u0085Y\u00C0\u00C4=\u009E\u0089U\u00C2,\u00B4\x16f\x01+\u00DD\u00C3\u008E\u0086\u0090RH\u00BF\u0084\u0084\x1C\u00DF\u00EF\u00E1\x12\u0086m\u00DB\u00B8\x12\x07\u00A0\u00AAw\u00E0\r\u00F8F\u00FF\x0B\x04\x11\u0089\u00CE\x06\u009F\x0E\x04\u00F0\u00B4\u00EEc\u00B4A\x0FJ\u00F1\x00c\u00ABe\tv\u00F6\u00F4\u00C0IDf\u00FE\u00FBUa\x00\u00A6\x02\u00AD\u00AA\u00EA\u0081\u00E5\fF\x11Y\r\u0097\u00E8\u0096\x17]\x01\x17U\u009D\fSCGp\u00C7\u00E9~\u00F0^\u0085\u00A7 %\u00ED\x18[\u00C5,1\u0087\u00AFN\x1C\u00AD\u00CBp\u00F5\u0093\u00FF\x005\u00BC/\u00CD\f\u00D5\u00AF\x04\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_checked_m.png","category":""};
w14_checked_m;
var w14_checked_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u009AIDAT(\u0091\u009D\u00D2\u00B1\r\u00C3 \x10\u0085\u00E1\u00DF\x16\x0B\u00A4\u00BF*+\u0090\x11\u00C2\nY\u0081\u0099\u0092\x11\u00BC\u0082\u00BDBV\u00A0\u00BA=H\u0091\u00C3\u00B2,c\u0090\u009F\u0084\u0084\u008E\u00F7\x15'1\u00E4\u009C\u00B9\x12\x07\u00A0\u00AAw\u00E0\r\u00F8F\u00FF\x0BD\x11I\u00CE\x06S\x07\x02xZ\u00F71\u00DA\u00A0\x07\u0095x\u0080\u00B1\u00D5\u00B2D;kz`\x10\u0091\x0F\u00FF\u00FD\u00AA0\x02a\u0087\x16U\u00F5\u00C0|\x06\u0093\u0088,\u0086\u00F7\u00E8\u00B6-\u00BA\x1D\u009CU5\x18\u00A6\u0086\u008E\u00E0\u008A\u00CB\u00FD\u00E0\u00BD\nOAI\u00D91\u00B5\u008A\u009B\u00A4-|u\u00E2d]\u0086\u00AB\u009F\u00FC\x07+\r/\u00CD\u00BF\u008E\u00F5\x06\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_checked_l.png","category":""};
w14_checked_l;
var w14_unchecked_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00fIDAT(\u0091\u00ED\u00921\x11\u00800\x10\x047\u0099\u00C8\u00F8\"N\u0088\x04$\u00E0\x04$\u0080\x03$E\u00C4\x0B\u0088\u0083\u00A7IJ&\u0081\u008A\u0082\u00AB\u00FEfn\u00E7\u00AF8gf\u00BCQh\u0087\u00AA.@\u00EC\u00E4\x0Bp\u008AH\t\x15\u00DA\u0080u\u00F0\u00D9\f$_M\x1A/\u00C9\x04\u00E0{\u00A9;\u00FD\u00E0'\u00C1\u00FD\x01s\x00\u00B86rU\u008D\flUD2\u00C0\x05\x07\u00A1\x16\u00F4\u00DE\x11\u0080-\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_unchecked_l.png","category":""};
w14_unchecked_l;
var w14_emptysquare_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u008CIDAT(\u0091\u00ED\u0092A\r\u00C2@\x10E_I\x05\u00E0\u0080:\u00A1\x12\u0090\u0080\u0090\u009F\u0094\u00C3\x17P\x1C\u00D4\x02\x0E\u0090P\tH\u00A8\u0083\u00E5\u00C0.\t\u00B4]6\u009C\u00FB\u0092\u00CD\u00CEa^\u00E6'3U\b\u0081\x7F\u00A8Sa\u00FB\f4?\u00FA'`\u00904\u00D5Q\u00BA\x00]\u00E1\u00B0\x13\u00D0\u00A6\u0089m\u00FCo\u00C0\u0098\u0091:\u00E0\u00F8\x115\u00D2K\u00BA\u00AFY\u00B6\u00DF\u00A9v\u0085\u00F1flb\u0086\u00EFu\f\u00B6\x1F+\u00BD\u00FB%\u00B1\u00E7\u00B5\u00D8C|9\u00AE\x00U:r\u00DB\r\x05\u00B7*i\x04x\x02\u009BT D7\u00D6'\u009B\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_emptysquare_m.png","category":""};
w14_emptysquare_m;
var w14_url_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00AEIDAT(\u0091\u0095\u0092\u00C1\r\u00C20\fE\x1F\u00A8\x0Bt\x05V`\x05\x18\x01V\u00E8\b\\|\u00FC\u0087\u00B2\n\u008C@W\u00E8\be\x04\x18\u00A1\u00C8(\u00A9\u00D4\u0094@\u00F8\u0087(v\u00FC\u00F2m\u00C9\u00ABq\x1CqI\u00DAP 3\u00BB{\u00D5\x1B\u00944\x00E \u00D0\u0099\u00D9\u00BE\nN9\u00A8\x07\u009E\u00E1^\x03[`\u00E7A\u00B5(\u009D\u00AB1\u00B3>f$=\u00C2\x07\u00AC\x17\u00A5s]\u00928\u00BA\x7F\x05\u00BD\u00A8\tNu\u00FA\u0098\x03\x1D:\u009AY'\u00A9\x05\x06I\u0087\u00D8fn\u00C6\x14:\u0085\u00FC\u00AC\u00ED\u00D41\x07-\u0094\u0082E\u00D0\u00C7\x19K W:\u00E3\u00ED\x1709\u0086\u00DD\u00BB\u0096\x02\u00C0\u00D9\u008Fi\u00C9\u00FF\x12\u00F0\x02\u00E6\u008B@\u00CB\u00D9<\u00D2r\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_url_m.png","category":""};
w14_url_m;
var w14_url_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00ADIDAT(\x15\u0095\u0092\u00C1\r\u00C20\fE\x1F\u00A8\x0B\u00F4\u00EE\x13+\u00B0\x02\u008C\x00+t\x04V\u00A0\u00AB\u00C0\bt\u0085\u008EPN\u00FF\f#\x14\x19%\u0095\u009A\x12\b\u00FF\x10\u00C5\u008E_\u00BE-y5\u008E#.I\x1B\ndfw\u00AFz\u0083\u0092\x06\u00A0\b\x04:3\u00DBW\u00C1)\x07\u00F5\u00C03\u00DCk`\x0B\u00EC<\u00A8\x16\u00A5s5f\u00D6\u00C7\u008C\u00A4G\u00F8\u0080\u00F5\u00A2t\u00AEK\x12G\u00F7\u00AF\u00A0\x175\u00C1\u00A9N\x1Fs\u00A0CG3\u00EB$\u009D\u0081A\u00D2!\u00B6\u0099\u009B1\u0085N!?k;u\u00CCA\x0B\u00A5`\x11\u00F4q\u00C6\x12\u00C8\u0095\u00CEx\u00FB\x05L\u008Ea\u00F7\u00AE\u00A5\x00\u00D0\u00FA1-\u00F9_\x02^\u0080#D+\u00F8\u00E3\u00E5\u008F\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_url_l.png","category":""};
w14_url_l;
var w14_cancel_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00F3IDAT(\u0091\u008D\u0092\u00C1m\u00C30\fE\u009F\u00BD\u0081WpFHFpFHFhF\u0088\x0F\u00FF\u00F8\x0F\u00CE\b\u00ED\bY\u00A1^\u00C1#4+x\u0084\u00F4P\u00B2P\u0095\x04\u00E8\x07\x04\t\u0094\x1E\u00F9\t\u00AA\u00B9\u00DF\u00EF\u0094\u00B2\u00DD\x03\x03\u00D0\x03+\u00B0H\u009A\u00A9\u00D4\u0094\u00A0\u00EDw\u00E0\u00AD~\x04,\u00C0I\u00D2\u00F2\x00\u00DA\u00FE\u008CJ\u00AF\u00B4\x02\u00FB\u0084\u00DB\u0080\u00A6\x02Zc\u00A5n\u00B1w\u00C05\u0083m\u00EC\u00A5\u00BD\x1D\u00B0\x0Fx\u0094\u00B4\x01\u00B2\u00C7\u00DE\u00F6\x01\u00A0\u00B5=D\u00B6\u00D4!\u00ECl$]lo\u0081mq?d\u00C5\u00BE\u00EAe\u00B2=HJ\u00BB\u00D7*q\u0097\u00E0\u00AD\x02GI\u00B3\u00ED||\u00ACz^\x01\u00DA\u0098Qy1\u0087\u00BD/\u00DB\u00E7\u00B0]&\u009F!\u00C6a\u00FB\fLe\u00C6\u00C2\u00DEZ\u009C\x17I\u00BB\u00B4\u008A\u00A4\x0B\u00F0Q\x00\x0F=E\u00D5c\x06s\x1CH:\x01#\u00CF5\u00F33\u00FC_\u00CB\u00CD\u0093\u00BF\u00DA\u00F1\u00F7\u00AF\u00CE%\u00F0\x12\u00FC\u00AF\u00BE\x01E\u00F7i6V*\x04\x14\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_cancel_m.png","category":""};
w14_cancel_m;
var w14_cancel_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00F2IDAT(\u0091\u008D\u0092\u00C1m\u00C30\fE\u009F\u00BD\u0081\u00EF\u00FF\u00E4\u008C\u0090\u008C\u00E0\u008C\u0090\u008C\u00D0\u008C\x10\u008F\u00E0\u008C\u00D0\u008E\u0090\x15\u00EA\x15<Bs\u00FAw\u008F\u0090\x1EJ\x15\u00AC\u0092\x00\u00FD\u0080 \u0081\u00D2#?A5\u00F7\u00FB\u009D,\u00DB=0\x00=\u00B0\x02\u008B\u00A4\u0099JM\x06m\u00BF\x03o\u00F5#`\x01N\u0092\u0096\x07\u00D0\u00F6gTz\u00A5\x15\u00D8\x17\u00B8\rhJ\u00D0\x1A\u00AB\u00E8\x16{\x07\\K\u00B0\u008D=\u00DB\u00DB\x01\u00FB\u0080GI\x1B\u00A0\u00F4\u00D8\u00DB>\x00\u00B4\u00B6\u0087\u00C8Vt\b;\x1BI\x17\u00DB[`\u009B\u00EE\u0087R\u00B1\u00AFz\u0099l\x0F\u0092\u008A\u00DDk\u0095\u00B8+\u00E0\u00AD\x02GI\u00B3\u00ED\u00F2\u00F8X\u00F5\u00BC\x02\u00B41\u00A3|1\u0087\u00BD/\u00DB\u00E7\u00B0\u009D\u0093\u00CF\x10\u00E3\u00B0}\x06\u00A6\u009C1\u00D9[\u00D3y\u0091\u00B4+V\u0091t\x01>\x12\u00F0\u00D0ST=\u0096`\x19\x07\u0092N\u00C0\u00C8s\u00CD\u00FC\f\u00FF\u00D7r\u00F3\u00E4\u00AFv\u00FC\u00FD\u00ABs\x06^\u0082\u00FF\u00D57b\u00A6f\u00F6G\x12\u009Bk\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_cancel_l.png","category":""};
w14_cancel_l;
var w14_comp_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u0097IDAT(\u0091\u00D5\u0092M\r\u00C2\x00\f\u0085\u00BF.\x13\u0080\u0080z`\x12\u0090\u0080\x04p\u0080\x04\u00EE\\\u00E6\x00\x0E\x130\tH\u00D8\x1C\u0090\u00B4\x02\u0086\u0082r\u00E9\x0E\x1C`?\x07\x12\u00DE\u00A9I\u00FB\u00F2\u00BE\u00A6\u0095\u0088`\u008D\u008AU.\u00A0t\u00F7\rp\x07j\u00A0\u00CDz\u00FB\u00C5\u00D3\x03\u00BB\x128\u00E5\u00E0\x15\u00A8&Ld\u00BF\u0096\u0088\u00C0\u00DDo\u0099\u00B4(\u0091\u00D1\u00A0\u00AA\u0083\u00BB\u009F3\u00F9\u0093:U\x1D\u00C4\u00CC\x0E\u0089\u00D9\x03\x17\u00A0\u0099@\x058\x16@\x07<g\f\u00BFi\u00DC\u00B1\x02\x1E\u0089\u00BA\u009F\u0081\u00DA\u008A\u0099\u00FD\u00C99\u00E4\u00E7\u00BF\u00FA\x02QBH\u00A2\x16\x16\u00F1\u00BB\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_comp_l.png","category":""};
w14_comp_l;
var w14_comp_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u0098IDAT(\x15c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\f\f\f,---\x02\f\f\f\x07\x18\x18\x18&000l\u0080\u00B2\u00F51T\"\u00C0E\x06\x06\x06\x07\x16\x06\x06\u0086\x02\u00A8\u00C2\u00F9\f\f\f\x06\x0441@\u00E5'\u0080\u00FD\u00D8\u00D2\u00D2\u00B2\x00j\x13I62\u00C04\u00D4\u00D4\u00D4|hiii\u0080\u00DA\u008C\x0B\\\x00\u00A9clnnN\u0080:\x13dR7\x03\x03\u00C3\x12\x1C\x1A\u0090A\"(T/000|\u00C4\u0090\"\x00`~\x049\u00ED\x01\u00D4\u00A9\x01D8u\x03\u00C8\u00A9C$:\u00E8\u009CV\x19\x18\x18\x00\u00B7\u00AAD\"\u00B2\u00E0\u0082\x02\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_comp_m.png","category":""};
w14_comp_m;
var w14_eyedropper_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00BEIDAT(\x15\u009D\u0092\u00D1\r\u00C2 \x10\u0086?M\x17\u00E8\n8\u0082+\u00D8\x11t\u0084\u00CE\u00D0\u0087{\u00BC\x07W\u00D0\x11t\x04]\u0081Y:\x02\u00E6\f4\u00A4@\x1F\u00FA'$\u00C0\u00FD\x1Fw\x07\x1CB\b\u00EC\u00D1q\x17\x05t\u00C5NE\u00AAz\x05\u00EE12\u0089\u00C8\u00BBY\u00AA\u00AA\u00F6\u00C0\b\u00CC\u00C0#\x0B\u00D9\u00FAT\u00CD\x18\u00A1\x0Fp.\u0082`1\u00D7\u00EA\u00D1\u00C5Q\u00D3WD|\x0B\u00B4L}\u00B1\x0B\x1E\u00B8Q\u00BBUU\x1DcOf\x1AbO\x0B(\"s\x01V \u00B7\u00CA\u00EC\u00D3\u00A4\u00DB\u0080\u00EC\t\u00D2z\u00B2CD\u00E4Y\u0080\u00D1hZCC*/W\x0E\u00A6\u0092^\u00C0e\x0B2\u00FD?\u0080\u00AA\u009A\u00D1\u00DE-\u00EF\u00A5\t\u00E5\x19\u00CD`\u00F5\u00DBwj\u009A\x17\x01?\x0EABN\u00EAi\u00F9b\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_eyedropper_m.png","category":""};
w14_eyedropper_m;
var w14_eyedropper_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00B4IDAT(\u0091\u009D\u0092\u00C1\r\u00830\fE\x1FU\x17\u00E0\u00EE\x13\x1D\u0081\x15`\x04:\x023\u00B0J\x19\u00A1+\u00B4+d\u0084\u00DE\u00FE=#\u00D0\x03\u00A1\u008A \u0089*\u00BEd)\u0091\u00FD\u00E2\u00EF$\u00D5\u00B2,\u009C\u00D1\u00E5\x14\u00F5/(i\u0090\u00F4\t1\x00T9\u00AB\u0092j`\x04<\u00F0\u0088R\x1E\u00B8]\x0B\u00D0\x0Bh\x13\u00E9\x1AhrV\u009B\x10)\u00BD\u00CD\u00CC\u00E5\u00C06\u009C\u00BC\u0097\x03\u00EE\u0090\u00B8\x1CI#\u00EBL\x0E\u00E8Yg\u00FA\u0081f\u00E6\x0F`\x02jv\u009D\u00DD\u00B6\u00B8\x16\u00A0!\u00DAO@cf\u00F3\x01\f\u0085$\u00A0~\u00B3\x17+\x067KO\u00A0+A\x10>\u0080\u00A4\u008E\u00F5\u00DD\u00E2Y\u00B2P\u00DC\u00D1\x0330\u0095\u008Ac}\x01\u008C*I@\u00A4\x153\u00A2\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_eyedropper_l.png","category":""};
w14_eyedropper_l;
var w14_back_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00C8IDAT(\u0091\u009D\u0092\u00C1\x11\u0082@\fE\x1F\u008Ew) 3\u00D2\x01\u0096\u00A0\x1D`\x07v \x1D\u0088\x1D\u00D0\x01\u0094@\x0Bv\x00\x1D\u00E8L\n\u00C0\n\u00F0@`2+\x1E$\u00B7M\u00F6\u00ED\u00FF\u00C9&\x1A\u0086\u00815\u00B1\r\x13\u00AA\u009A\x009p\u00B0T\x0F4\"R\u00FB{\u0091WT\u00D5\x12\u00B8\u00FE\x10\u00E9\u0080LD\u009E\x00\x1B\x07\x15\x01\u00F4\x06\x1E\u00EE\u009C\x02\u008D\u00AA\u00C63h\u00F6n\x01t\x04\u008A@5\u00B56f\u00C5l\x01\x02h\x16,_<\x18{HDZ\u00C6\u00A1d\u00C0\t8[\r`\x0F\u00DFS\u00DD1N\u00B3\x05\x12\u00A7\x1C[m\u008E\t\u00EC]\u00AER\u00D5\u00C9fi}\u00F9xy\u00ABa/\u0095\u00D9\u00CC\u00C3\x06\u0081z\x06\u00EDo\u00EE\x0Bp\u00F8`g.\u00D6/@\x14\u00EE\u00EA\u00AA\u0095\u00FB'>\u00DE'L\u0097\u009C?\x7F3\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_back_l.png","category":"14w"};
w14_back_l;
var w14_back_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00C8IDAT(\u0091\u009D\u0092\u00C1\x11\u0082@\fE\x1F\u008Ew\u00E9@:\u00C0\x12\u00B4\x03\u00EC\u00C0\x0E\u00A4\u0080\u00CC\u00883)\u0080\x0E\u00A0\x04Z\u00B0\x03\u00E8@;\u00C0\n\u00F0@`2+\x1E$\u00B7M\u00F6\u00ED\u00FF\u00C9&\x1A\u0086\u00815\u00B1\r\x13\u00AA\u009A\x009p\u00B0T\x0F4\"R\u00FB{\u0091WT\u00D5\x12\u00B8\u00FE\x10\u00E9\u0080LD\u009E\x00\x1B\x07\x15\x01\u00F4\x06\x1E\u00EE\u009C\x02\u008D\u00AA\u00C63h\u00F6n\x01t\x04\u008A@5\u00B56f\u00C5l\x01\x02h\x16,_<\x18{HDZ\u00C6\u00A1d\u00C0\t8[\r`\x0F\u00DFS\u00DD1N\u00B3\x05\x12\u00A7\x1C[m\u008E\t\u00EC]\u00AER\u00D5\u00C9fi}\u00F9xy\u00ABa/\u0095\u00D9\u00CC\u00C3\x06\u0081z\x06\u00EDo\u00EE\x0Bp\u00F8`g.\u00D6/@\x14\u00EE\u00EA\u00AA\u0095\u00FB'>\x17\rJWp\u00D7\u00A6{\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_back_m.png","category":"14w"};
w14_back_m;
var w14_next_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00D2IDAT(\x15\u009D\u0092\u008D\t\u00C2@\fF\u009F\u00E2\x00\u00DD@7\u00D0\r\u00EC\x06\u00BA\u0081\u00DD\u00C0\x0E\x10P!\x038\u0082nP'\u00D0\x11t\u0083\u00BAA\u009D\u00A0r\u0092\u0096\u00F4\u00AA \r\x04\u00EEr\u00F7\u00C8\u0097\u009FQ]\u00D7\f\u00B1I\u00CC\u00A8\u00EA\f\u00C8\u0081\u0085\u0085*\u00A0\x10\u0091\u0093\u00FF\u00D7\u00C9\u00A8\u00AAG`\u00FBC\u00C0\x03X\u008BH\x19.c\x07\u00ED\u00BF@Ow\u009E\u0087\u00CC\u00AA\u009A\u00B4\u00A0\u00C9\u00DBE\u00D0\u00D9\u00E4>\"8\u00F7\x19\u00D7=a\u00B0\u00B1x\x1A\u00C1\u0099\x07\x13\u00F7p\x01\x0E\u00E63\x11\u00A9\"x\u00DA\u00A9\u00D1Y(\u00FE\u00E6\x1C\u0083K\u00FF\u00A9\x01+\x17\x0B\r\u00BA\u009Ag\u00D6\u00830\u008A\u0095oX\x03\x16\u00BD\u00BCp\x11\u0091\u00CC\u00A0Poc\u009Fy\u00B6s\u00B4q\u00F8\u00CE\u00BE\u0080;\u00B0t\u00B1Pg\x1A\u00A4\x0F^\u0080\u00DE\u00AE\x0EZ\u00B9\u00BF\rx\x03\x14\u00D6W\u008E\u00A8\u00FC\u00C4\u00AA\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_next_m.png","category":"14w"};
w14_next_m;
var w14_next_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u00D6IDAT(\x15\u009D\u0092\u0081\r\u0082@\fE\u00BF\u00C6\x01\x18\u00A0\u0089l\u00A0\x1B\u00C8\x06\u00B2\u0081l \x1B\u00E8\b\u008E\u00A0\x1B\u00C8\x04:\u0082l\u0080I\x07\u00C0\t05\u00FFH941\u00FC\u00E4\u0092\u00A3\u00DCK\u00DB\u00DF\u00CE\u00BA\u00AE\u00C3\x14-bFUS\x00%\u00805C-\u0080\u00AB\u0088\u009C\u00FD\u00BBAFU=\x01\u00D8\u00FF(\u00A0\x06\u0090\u008BHc\x1Fs\x07\x1D\u00BF@Ow_YfUMz\u0090\u00E5\x1D\"\u00E8\u00C2r\u00EB\b.}\u00C6|T\x18\u00B0c<\u008B\u00E0\x02\u00CE\u009C\u00C4\u00FD\u00A8\x00<xOE\u00A4UU\u0083\u00EF\u00CC\u00B8\x1C\u00F4\u00E8\u00D4\u00F0Q80\u0098\u00F1^\x01l]\u00CC\f\u00BA\u00F1\x14\u00F4\u00C0F\u00B1\u00F5\u0086\x05\u00F0:\u00CA\x0BT\"R\x10\u00B2~\u0083>\u00F3\u00EC\u00E7\u00C8qxg_\u00ECu\u00E3bfRf\u00A5O^\u0080\u00D1\u00AENZ\u00B9\u00BF\x05\u00E0\r\u00A5\u00E4\\hP:\u00AF\u00D3\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_next_l.png","category":"14w"};
w14_next_l;
var w14_news_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u0095IDAT(\x15c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\f\f\f,0\u00C6\u0093'OB\x19\x18\x18\u008C1T`\x07gY\u009E<y\"\u00C8\u00C0\u00C0p\u0086\u0081\u0081A\t\u00AB\x12\u00EC\u00E0,\x0B\u00D4\x16dM\u00AEX\u0095\"\u00C0*\x14\u00A7\"\u0081\x0E\f\x11T \u0088K#\u00B2\u00ED\u0082P\u00FA=\u00BA\"l\x1A\u00F7 \u00B1a\u0081u\x16I,\x14\u0097\u00C6P\f\x11,\x01\u0087Mc'\x12\u00DB\x05\u008B+\u00CAA\x048\u00E5<y\u00F2\u00E4.\u0089\u00D1\u00B1\x1A\u009E\u00E4\u009E<y\x023\u009D \u0090\u0091\u0091\u00D9C\u00E7\u00B4\u00CA\u00C0\u00C0\x00\x00\u00AE1$s4X\u00AE`\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_news_l.png","category":"14w"};
w14_news_l;
var w14_news_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u0093IDAT(\x15c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\f\f\f,0FKKK(\x03\x03\u00831\u0086\n\u00EC\u00E0,KKK\u008B \x03\x03\u00C3\x19\x06\x06\x06%\u00ACJ\u00B0\u0083\u00B3,P[\u00905\u00B9bU\u008A\x00\u00ABP\u009C\u008A\x04:0DP\u0081 .\u008D\u00C8\u00B6\x0BB\u00E9\u00F7\u00E8\u008A\u00B0i\u00DC\u0083\u00C4\u0086\x05\u00D6Y$\u00B1P\\\x1AC1D\u00B0\x04\x1C6\u008D\u009DHl\x17,\u00AE(\x07\x11\u00E0\u0094\u00D3\u00D2\u00D2r\u0097\u00C4\u00E8X\rOr---0\u00D3\t\u0082\u009A\u009A\u009A=tN\u00AB\f\f\f\x00\u00CD(!\x13rv\u00DD\u00FE\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_news_m.png","category":"14w"};
w14_news_m;
var w14_help_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u008BIDAT(\u0091c\u00FC\u00FF\u00FF?\x039\u0080\u0089,]\u0094hdA\x17hii\x11d``\u0098\u00C9\u00C0\u00C0\x10\n\x15z\u00CF\u00C0\u00C0PQSS3\u008B\u0090\u008D\x1DH\u009A@\x00lPKK\u008B\x0B!\u008D \u0093\u00CF200\u0084100\b!\u0089\x1B#+\u00C2\x19\u00AA--- \u0085\u00BB\u00A16\u0082\u009CkRSSs\x0F\u009F\u008D0\x00\u00D3\x04\u00B2]\x19Y\x13!\u008D\u00EFaN\u00AF\u00A9\u00A9y\u008F.\u0089O\u00A3\x12\u0094\x06\u00D9\u008A\x01\u0088\u00B1\x11+\x18*I\u008E\u0081\u0081\x01\x00\u00A0\u00CB#\u0088\u00C0\u00B4'\u00EE\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_help_m.png","category":"14w"};
w14_help_m;
var w14_help_l = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x0E\x00\x00\x00\x0E\b\x06\x00\x00\x00\x1FH-\u00D1\x00\x00\x00\tpHYs\x00\x00\x04\u00D8\x00\x00\x04\u00D8\x01\u00AE\u00AFK>\x00\x00\x00\u0090IDAT(\u0091\u00BD\u0092\u00C1\r\u00830\fE\x1F\x15\x0B\u00A4\u00E7\x7F\u0082\x11\u00E8\b\u00AC\u00D0\u00CE\u00D2\x11X\x01V\u00E9\f\u00AC\u00D0\u0093\u00EF\x19!\\\x12)B@\x10\u0095\u00FA/\u0096\u00BE\u00FD\u00F4-\u00CBU\b\u0081+\u00BA]\u00A2~\x01\u00EB\u00B5af\x0E\x18\u0081g\u00B4<\u00F0\u00964\u0095\x12\u0087\f\x02p\u00C0hf}\t\u009C\u0080\x19x\x01\u00F7\u00CC\u00EF\u00F2\u00A1j\u00EF\u00AAf\u00D6\x01\u009F\u0098\u00E8\u0081\u0087\u00A4\u00EFQbR\u0082f\u00A0\u00CD\u00A1\x12\u00E8\u00D3\u00EA\u0092\u00FC\u00BAy\x046\u00B1\u00BA\u00AD\u00E6\u0099\u00C4M\u00ED\x1E\u00A7\u00A4\u00FF\u00BF\u00DC\x02<\u00AB\"hN6\u00BD:\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w14_help_l.png","category":"14w"};
w14_help_l;
var w25_back_r = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x19\x00\x00\x00\x19\b\x06\x00\x00\x00\u00C4\u00E9\u0085c\x00\x00\x00\tpHYs\x00\x00\b\u00A6\x00\x00\b\u00A6\x01\u00E0\u0081\u00E0\u00E7\x00\x00\x01\u0084IDATH\u0089\u00BD\u0096\u00C1q\u00C20\x10E\x1F\u0099\u00DCa\u00C6\u00A7=\u00E1\x0EB*\u0088K \x15\x00\x1DP\x02\u00A9 \u00E9 N\x07\u00A4\x03\u00E8\u0080T\x10\u00FB\u00A4\u0093fH\x05\u00E4`\u0089\u0091\u00C5Z&\t\u00E4\u009Fly\u00A5'\u00ADV_\x1E\x1C\x0E\x07\u00AE\u00AD\u009B\u00AB\x13\u0080\u00DBs\u0082\u00AC\u00C8\x04\u0098\x02E\u00D0\u00BC\x076\u00C0:3\u00A6J\u00F5\x1F\u00A4\u00D2eE\u00A6\u00C0\x0B0\u00EE\u0099\u00C7\x16Xf\u00C6\u00EC~\x04\u00B1\"%0\u00EB\x19<\u00D6\"3\u00A6\u008C\x1B\u00D5=\u00F9%\x00\u00E0\u00D5\u008A,{!Vd\u0095\x00|\x01\x0B\u00E0=\x01zvi>\u00AA\u0095.+\u0092\x03\u009F\t@\u00E1\u00F3nEv\u00C0]Gl\u009D\x19\u0093\u00FB\u0097x%\u00AB3\x01\u0093\x04\x00`lE\u00E6]\u0090)\u00A7\u00D2\x00\u009B\x04\u00C0\u00EB\x14bE\n`\u00D8\x03\u00C8\x1D \u008E\u00D3\u00F4\u00E0\x1F\u00C2\u00C38R\x02\u008B\u00B0\u00F6\u00DD\u00A1;\u0089\x0BV7\u008C\u00DA\u00F3\u00CC\u0098*L\u00D7$\u00EA[w\x1D\u00AEX.\u00AER>\u00E5\u00D0^I<\u00E0\u00D8\u008A\u0094\u00991\u00F3`f#e2\u00D0\u00EC\u00A5V\bU\f\u00D9+A3+B\b\u00A2\u00B1\u0099Te\x1D\u00E5=\u00ED&h\u00D8\u00D0l\u00B4\x06*]\u00CC\u009E\u00C6$?\u00CE`l\u00FDC\\\u00C2\u00EB\u008E\x0E\x1A\u00A8\u00EE\u0081\u0094]\u0090U\u00A2\u00D3\x11\u00E4\u00A4U\u00A3W\x1D\x1Ae\x0B\u00E2r\u00F8\u00D4\x03\u00DA\u00D1\x14I\u00EA\u00AC\u00B4LR\u00B5\u00FA?\u00B80(v\u00AFZ\u00BD\u00AB\u00A6\u00B7K\x00:!\x01\u00E8\u0091\u00FE\r\u0086\u00A6\u0092\u00EE5\x00\u00F4\\\u00BF^W\u00BD\u00E3/\u00A5\x7F\u00F9%\u00FA\x06\u00E04\u00AC\u00B1\u00C1X\x1B8\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w25_back_r.png","category":""};
w25_back_r;
var w25_back_m = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x19\x00\x00\x00\x19\b\x06\x00\x00\x00\u00C4\u00E9\u0085c\x00\x00\x00\tpHYs\x00\x00\b\u00A6\x00\x00\b\u00A6\x01\u00E0\u0081\u00E0\u00E7\x00\x00\x01}IDATH\u0089\u00BD\u0096\u00EDm\u00C20\x10\u0086\x1FP\u00FF\u0097\r\u00A0\x13\x14&(#\u00A4\x13\x00\x13\u0094\x01N*\u0095\u00EE\x7F\u00D9\u00A0\u00E9\x04\u00A5\x13\x146\u00A0\x1B\u0084\r\u00E8\x04\u00F4G\u009C\u00CA1g\u009B~\u00D0W\u008A\x149\u00E7<\u00CE\u00DD\u00F9u:\u0087\u00C3\u0081s\u00AB{v\x02pqJ\u0090\u00AA\x0E\u0081\x02\x18{\u00C3{`\r\u00ACD\u00A4J\u00CD\u00EF\u00A4\u00D2\u00A5\u00AA\x05\u00B0\x04\u00FA\u0099ul\u0080\u00B9\u0088l\u00BF\x05Q\u00D5\x12\u0098d^\x1Ej&\"e8h\u00D6\u00E4\u0087\x00\u0080'U\u009Dg!\u00AA\u00BAH\x00>\u0080\x19\u00F0\u009A\x00=\u00BA4\u00DB\x10U\x1D\x00\u00F7\t\u00C0XDJ\x11)\u0080\u00F7\x04h\x19\u0085\x00\u008B\f`\u00EB\x163\x04\u00AE\x13\u0090\u00BE\u00AANc\u0090\u0082cY\u0080u\x02\u00D0\u00E8\x18\u00A2\u00AAc\u00E02\x03\x188@\x18g\u00E9\u00A6\u00B9\u00F9jaW\u00AC\u0097 p\x14\u00EB}_\u00DE\u00D7\u0085\u00F0+\x11\u00A9\u00FCt\r\u0083\u0080\u00DD)\x00\x00\x17W\x19\u008F\x06\u00D0\u00B6\u0095\u00F0\u0085}U-Ed\u00EA\u00AD\u00B8g,\x06\u00EAZZ\u008DPA\u00BB\u00F0{#h\u00E26\u00A6\u00AF%\u00F0\x16\\w\u00C6\\\x1AO\u00EBz\x03k\u00EABGA\"\u00B2\u00A76\u00C9\u00D4\x1Ei\u00B4in\u00C2\x16^E&X\u00A0]\x06R\u00C6 \u008B\u00C4\u00A40u\u00BDD\u00EC\u00CE7\u00CA\x16\u00C4\u00E5\u00F0!\x03\u00DAR7Ij\u00AF\u00B4L\u00D2\u00B4\u00FA_\u00B80\x18voZ\u00BDk\u00DB\u00E7\u00BF\x00D!\x1E\u00E8\u0096|\u0081\u00A1\u00EE\u00A4\u0091\x05\u0080\u00CC\u00F1\u00DB\u00E8\u00ACg\u00FC_\u00E9_~\u0089>\x01E\u00F9\u00A9\u00ED\x02\u009A\u00F5\u00AF\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w25_back_m.png","category":""};
w25_back_m;
var w25_check_r = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x19\x00\x00\x00\x19\b\x06\x00\x00\x00\u00C4\u00E9\u0085c\x00\x00\x00\tpHYs\x00\x00\b\u00A6\x00\x00\b\u00A6\x01\u00E0\u0081\u00E0\u00E7\x00\x00\x01\u008BIDATH\u0089\u00BD\u0095\u00C1q\u00C20\x10E\x1F\u00994\u00E0\u00D1IWR\x02)\u00C1\u0094@J0%\u0090\x12\u00D2B\\\x02\u0094\x00%@\t\u00F8\u00AA\u0093\u00C6%\u0090\u0083$\u00CFZ\u0096@\u00C0\u0090\u009Da\x18\u00DBk=\u00ED\u00EE\u00D7\u00F7\u00ECr\u00B9\u00F0\u00EAx{9\u00E1\u00BF \u00EF\u00B7\x12\u00AC\u00D65\u00B0\x02j`\u00EEo\u00F7\u00FE\u00B7\x03ZeLwm\u008DYn&V\u00EB9\u00B0\x05\x16\x05\u009B\u00DD\x01keL\u009Fz\u0098l\u0097\u00D5z\x03\x1C\x0B\x01\u00E0*=[\u00AD\u0093\u00F9\u0093J<\u00E0\u00A7p\u00F18z`\u00A9\u008C9e!\u00BEEG\u00A0z\x10\x02\u00D0\x01\u009F\u00B2uq\u00BB\u00B6O\x02\u00C0\u0089c#o\f\x10\u00AF\u00A2\u00D2\x19\u00C8h\u0081% [\u00D4X\u00AD\u0087\u00CD\u00CAJV\u008F\x00\u00941ke\u00CC\u00C1\u0083\u0082\u0094+\u00A0IA\u00EAh\u0081p\x0E\u0092\u00B2\f\u0080p\u00E1g s\u00C3\u0099\x1AA\u00E4,\u0082J\u00BE\u00FC\x0Ec\u00D0\b\x00`\u00B5\u00FEe\u00DC\u00EEa\u00D39H\x1Bd\u00E8\u00FF%(\x07h\u00C8\u0084\u0084Hk\u00A8\u00E5\u00E0\x04\u00E8\x1E\u00C0\u00F0\u00FEpN\u00AC\u00D6gD\x1FqjY\u00E6\u00AC\u00A2\u00A0\u0082N\x19\u00F3\x11W\u00D2FI\x0B`/+\u00BA\x030ZOB\x0E\u0089\u00C4$\u00A8\x000Zo\u0080\u00F8\u00BE\u00C7\u00D5L@\u0085\u0080V\u00FAW\u00EC]\x15\u00CE\u00BB\u00E6\u0089\x17;\u009C\u00C2n\u00B9\u00C2\u00C4\u00BBR.\u00BC\x00\u00F6<\u00E6aI\x17\u009E|O\u0084\\O\u00F1\u00B3\x1B\x11\u00D48y\u00EF\u00DA\u0097\u00B1\u00C2\u00B9i\u00C3\u00F5\u00AAz\u00DC\f\u00BEs\tYH\x04lps\n&\u00DA\u00F9\u009Dw\u00CA\u0098\u0094X\u00EE\u0087<\x1B\x7F\u00DD\u0083\u00B8\x12\f\u008B7\u00CF\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w25_check_r.png","category":""};
w25_check_r;
var w25_check_g = {"binAsString":"\u0089PNG\r\n\x1A\n\x00\x00\x00\rIHDR\x00\x00\x00\x19\x00\x00\x00\x19\b\x06\x00\x00\x00\u00C4\u00E9\u0085c\x00\x00\x00\tpHYs\x00\x00\b\u00A6\x00\x00\b\u00A6\x01\u00E0\u0081\u00E0\u00E7\x00\x00\x01\u0092IDATH\u0089\u00BD\u0095\u00C1q\u00C20\x10E\x1F\u00994\u00E0\u00B3n\u00A4\x04R\u00829\u00A8\x00R\u00829\u00A8\x00RB\x1A\u00F0!.\x01\n\u00F0\x01J\u0080\x12\u00F0\u00CDg\u0097@\x0E\u0092<kY\x02\x03Cv\u0086al\u00AF\u00F5\u00B4\u00BB_\u00DF\u00B3\u00CB\u00E5\u00C2\u00AB\u00E3\u00ED\u00E5\u0084\u00FF\u0082\u00BC\u00DFJ\u00D0m\u0099\x03+ \x07\u00E6\u00EEv\u00E7~;\u00A0\u00AA\u0095i\u00AE\u00AD1K\u00CDD\u00B7\u00E5\x1C\u00D8\x02\u008B\t\u009B\u00DD\x01\u00EBZ\u0099.\u00F60\u00DA.\u00DD\u0096\x1B\u00E08\x11\x00\u00B6\u00D2\u00B3n\u00CBh\u00FE\u00A8\x12\x07\u00F8\u0099\u00B8x\x18\x1D\u00B0\u00AC\u00959%!\u00AEEG {\x10\x02\u00D0\x00\u009F\u00B2ua\u00BB\u00B6O\x02\u00C0\u008Ac#o\u00F4\x10\u00A7\u00A2\u00A93\u0090Q\x01K@\u00B6\u00A8\u00D0m\u00D9oVV\u00B2z\x04P+\u00B3\u00AE\u009598\u0090\u0097r\x06\x141H\x1E,\u00E0\u00CFAT\u0096\x1E\u00E0/\u00DC\fd\u00AE?S\x03\u0088\u009C\u0085W\u00C9\u0097\u00DBa\b\x1A\x00\x00t[\u00FE2lw\u00BF\u00E9\x14\u00A4\u00F22t\u00FF\x12\u0094\x02\x14$BB\u00A45\u00E4rp\x02t\x0F\u00A0\x7F\u00BF?'\u00BA-\u00CF\u0088>b\u00D5\u00B2LY\u00C5\u0084\n\u009AZ\u0099\u008F\u00B0\u0092*HZ\x00{Y\u00D1\x1D\u0080\u00C1z\x12r\u0088$FA\x13\x00\u0083\u00F5z\u0088\u00EB{X\u00CD\b4\x11PI\u00FF\n\u00BD+\u00C3z\u00D7<\u00F2b\u0083U\u00D8-W\x18yW\u00CC\u0085\x17\u00C0\u009E\u00C7<,\u00EA\u00C2\u00A3\u00EF\u0089\u0090\u00EB)|v#\u00BC\x1AG\u00EF]\u00FB2fX7-\u00B8^U\u0087\u009D\u00C1w*!\t\t\u0080\x05vN\u00DED\x1B\u00B7\u00F3\u00A6V&&\u0096\u00FB!\u00CF\u00C6\x1F\x06d\u00B7nH\u00F3\u00FB+\x00\x00\x00\x00IEND\u00AEB`\u0082","fileName":"w25_check_g.png","category":""};
w25_check_g;

/**
* ScriptUI tools
* @namespace
* @memberof DuAEF
*/
DuAEF.DuScriptUI = {};

/**
* The default alignment of children of containers with "column" orientation
* @memberof DuAEF.DuScriptUI
* @type {String[]}
* @default ["fill","top"]
*/
DuAEF.DuScriptUI.defaultColumnAlignment = ["fill","top"];

/**
* The default alignment of children of containers with "row" orientation
* @memberof DuAEF.DuScriptUI
* @type {String[]}
* @default ["left","center"]
*/
DuAEF.DuScriptUI.defaultRowAlignment = ["left","center"];

/**
* The default alignment of children of containers with "stack" orientation
* @memberof DuAEF.DuScriptUI
* @type {String[]}
* @default ["fill","top"]
*/
DuAEF.DuScriptUI.defaultStackAlignment = ["fill","fill"];

/**
* The default spacing of containers
* @memberof DuAEF.DuScriptUI
* @type {int}
* @default 2
*/
DuAEF.DuScriptUI.defaultSpacing = 2;

/**
* The default margins of containers
* @memberof DuAEF.DuScriptUI
* @type {int}
* @default 2
*/
DuAEF.DuScriptUI.defaultMargins = 2;

/**
* Stores all strings used by the UI.<br />
* This can be very useful to work with a translation framework.
*/
DuAEF.DuScriptUI.uiStrings = [];

//low-level undocumented list: keeps the currently highlighted controls
DuAEF.DuScriptUI.highlightedControls = [];

//low-level undocumented list: keeps all the tabs, used in the buildAllTabs method
DuAEF.DuScriptUI.allTabs = [];

//low-level undocumented function: dims all currently highlighted controls
DuAEF.DuScriptUI.dimControls = function(e)
{
	if (DuAEF.DuScriptUI.highlightedControls.length == 0) return;
	for (var i = DuAEF.DuScriptUI.highlightedControls.length-1; i >= 0; i--)
	{
		try { DuAEF.DuScriptUI.highlightedControls[i].dim(); } catch (e) {};
		DuAEF.DuScriptUI.highlightedControls.pop();
	}
}

/**
 * Resets the layout of the whole ui containing a scriptUI item.
 * @memberof DuAEF.DuScriptUI
 * @param {ScriptUI} item - The ScriptUI element which needs to be resized
 */
DuAEF.DuScriptUI.layout = function(item)
{
	item.layout.layout(true);
	item.layout.resize();
}

/**
 * Adjust the color according to the brightness setting of After Effects
 * @memberof DuAEF.DuScriptUI
 * @param {float[]} color - The color [R,V,B,A] Array
 * @return {float[]} - The new color [R,V,B,A] Array
 */
DuAEF.DuScriptUI.adjustColor = function (color)
{
	//gets the main application color
	var q = app.themeColor(78)[0];
	//the darkest one is 0.15000000596046
	q = q - 0.15000000596046;
	var newColor = color + [q,q,q,0];
	for (var i = 0; i < 3; i++)
	{
		if (newColor[i] < 0) newColor[i] = 0;
		else if (newColor[i] > 1) newColor[i] = 1;
	}
	return newColor;
}

/**
 * Changes the color of the text of a ScriptUI Object
 * @memberof DuAEF.DuScriptUI
 * @param {ScriptUI}		text	- The ScriptUI Object
 * @param {float[]}				color	- The new color [R,V,B,A] Array
 * @param {bool}				[adjusted=true]	- lightens the color if the brightness setting of Ae is not set on the darkest one
 */
DuAEF.DuScriptUI.setTextColor = function (text,color,adjusted)
{
	if (typeof adjusted === 'undefined') adjusted = true;
	if (!text) throw "You must provide a ScriptUI Control to change the color of the text";
	if (color.length == 3) color.push(1);
	if (adjusted) color = DuAEF.DuScriptUI.adjustColor(color);
	var g = text.graphics;
	var textPen = g.newPen(g.PenType.SOLID_COLOR,color,1);
	g.foregroundColor = textPen;
}

/**
 * Changes the color of the background of a ScriptUI Object
 * @memberof DuAEF.DuScriptUI
 * @param {ScriptUI} uiItem - The ScriptUI Object
 * @param {Array} color - The new color [R,V,B,A] Array
 * @param {bool} [adjusted=true] - lightens the color if the brightness setting of Ae is not set on the darkest one
 */
DuAEF.DuScriptUI.setBackgroundColor = function (uiItem,color,adjusted)
{
	if (typeof adjusted === 'undefined') adjusted = true;
	if (!uiItem) throw "You must provide a ScriptUI Control to change the color of the background";
	var c = color;
	if (adjusted) c = DuAEF.DuScriptUI.adjustColor(color);
	var g = uiItem.graphics;
	var brush = g.newBrush(g.BrushType.SOLID_COLOR,c);
	g.backgroundColor = brush;
}

/**
 * Creates the main panel of a script
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|null}		container	- The container ('this' in the root of the calling script), either a Panel (when launched from the 'Window' menu) or null (when launched from 'file/scripts/run...')
 * @param {string}	scriptName	- A name for this UI
 * @param {string[]}	[contentAlignment=DuAEF.DuScriptUI.defaultColumnAlignment]	- The alignment of the contents in the panel
 * @return {Panel|Window}	The panel created, either a ScriptUI Panel or a ScriptUI Window.<br />
 * The resulting object has one custom method: Panel.refreshUI which takes one argument:<br />
 * a File object which must be the script to reload.<br />
 * The method returns true on success, false otherwise.<br />
 * @example
 * var ui = DuAEF.DuScriptUI.createUI(this,"Test Script");
 * var refreshButton = ui.add('button',undefined,"Refresh");
 * refreshButton.onClick = function() { ui.refreshUI( new File($.fileName) ); }; //reloads the current script
 * DuAEF.DuScriptUI.showUI(ui);
 */
DuAEF.DuScriptUI.createUI = function (container, scriptName, contentAlignment)
{
	if (typeof scriptName === 'undefined') scriptName = '';
	if (typeof contentAlignment === 'undefined') contentAlignment = DuAEF.DuScriptUI.defaultColumnAlignment;

	if (scriptName != '') DuAEF.DuScriptUI.uiStrings.push(scriptName);
	scriptName = tr(scriptName);

	var  myPal = null;
	container instanceof Panel ? myPal = container : myPal = new Window('palette',scriptName,undefined, {resizeable:true});

	if (myPal == null) throw "Failed to create User Interface.";

	myPal.margins = 0;
	myPal.spacing = 0;

	//create margins to dim buttons
	var topMargin = myPal.add('group');
	topMargin.minimumSize.height = DuAEF.DuScriptUI.defaultMargins;
	topMargin.alignment = ['fill','top'];
	topMargin.margins = 0;
	topMargin.spacing = 0;

	var mainRow = myPal.add('group');
	mainRow.alignment = contentAlignment;
	mainRow.alignChildren = contentAlignment;
	mainRow.margins = 0;
	mainRow.spacing = 0;

	var leftMargin = mainRow.add('group');
	leftMargin.minimumSize.width = leftMargin.preferredSize.width = DuAEF.DuScriptUI.defaultMargins;
	leftMargin.alignment = ['left','fill'];
	leftMargin.margins = 0;
	leftMargin.spacing = 0;

	myPal.contents = mainRow.add('group');
	myPal.contents.margins = 0;
	myPal.contents.spacing = DuAEF.DuScriptUI.defaultSpacing;
	myPal.contents.alignChildren = DuAEF.DuScriptUI.defaultColumnAlignment;
	myPal.contents.orientation = "column";

	var rightMargin = mainRow.add('group');
	rightMargin.minimumSize.width = rightMargin.preferredSize.width = DuAEF.DuScriptUI.defaultMargins;
	rightMargin.alignment = ['right','fill'];
	rightMargin.margins = 0;
	rightMargin.spacing = 0;

	var bottomMargin = myPal.add('group');
	bottomMargin.minimumSize.height = bottomMargin.preferredSize.height = DuAEF.DuScriptUI.defaultMargins;
	bottomMargin.alignment = ['fill','bottom'];
	bottomMargin.margins = 0;
	bottomMargin.spacing = 0;

	myPal.refreshUI = function (scriptFile)
	{

		function refresh()
		{
			var ok = false;
			DuAEF.DuScriptUI.dimControls();
			// Remove everything
			for ( var i = myPal.children.length - 1; i >= 0; i-- )
			{
				myPal.remove( this.children[ i ] );
			}

			// delete DuAEF
			delete DuAEF;
			delete tr;

			// Run the scriptFile
			try
			{
				ok = true;
				$.evalFile( scriptFile );
			}
			catch ( err )
			{
				ok = false;
				//add debug info
				myPal.add('statictext',undefined,err.fileName,{multiline:true});
				myPal.add('statictext',undefined,err.message,{multiline:true});
				myPal.add('statictext',undefined,"on line" + err.line);
				//add a refresh button
				var button = myPal.add('button',undefined,"Refresh UI");
				button.onClick = function () { myPal.refreshUI(scriptFile) };
			}

			// Recalculate UI
			myPal.layout.layout( true );
			myPal.layout.resize()

			return ok;
		}

		return refresh.call(myPal);
	}

	myPal.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);
	topMargin.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);
	leftMargin.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);
	rightMargin.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);
	bottomMargin.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	return myPal;
}

/**
 * Resizes and shows the main panel of a script
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window}		ui	- The UI created by Duik.ui.createUI
 */
DuAEF.DuScriptUI.showUI = function (ui)
{
	ui.layout.layout(true);
	ui.layout.resize();
	ui.onResizing = ui.onResize = function () {try {ui.layout.resize();} catch (e) {}}

	// If it's a Window, it needs to be shown
	if (ui instanceof Window) {
		//ui.center();
		ui.show();
	}
}

/**
 * Adds a group in a container, using  DuAEF.DuScriptUI default alignments, and DuAEF.DuScriptUI.defaultSpacing. Margins are set to 0.
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window|Group}		container	- Where to create the group
 * @param {string}					[orientation] - The orientation to use. One of "column", "row" or "stack". By default, "column" if added in a row, "row" if added in a column.
 * @return {Group}	The group created
 */
DuAEF.DuScriptUI.addGroup = function (container,orientation)
{
	var group = container.add("group");
	group.spacing = 2;
	group.margins = 0;
	if (orientation !== undefined) group.orientation = orientation;
	if(group.orientation === "row")
	{
		group.alignChildren = DuAEF.DuScriptUI.defaultRowAlignment;
	}
	else if (group.orientation === "column")
	{
		group.alignChildren = DuAEF.DuScriptUI.defaultColumnAlignment;
	}
	else
	{
		group.alignChildren = DuAEF.DuScriptUI.defaultStackAlignment;
	}

	group.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	return group;
}

/**
* @class
* @name Separator
* @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
* A Separator.<br />
* This is not a real class, and cannot be instanciated.<br />
* Use {@link DuAEF.DuScriptUI.addSeparator} to create a Separator.<br />
* The Separator inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {StaticText|CheckBox} label - the label
* @property {boolean} checkable - Read-Only | true if a checkbox is displayed
*/

/**
 * Adds separator with an optionnal name in the group
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window|Group} container - Where to create the separator
 * @param {string} [name] - The name displayed
 * @param {boolean} [checkable=false] - When true, adds a checkbox to the separator
 * @param {boolean} [drawLine=true] - Draws a line when there is no name. When false, the separator is an empty space
 * @return {Separator} The separator
 */
DuAEF.DuScriptUI.addSeparator = function (container,name,checkable,drawLine)
{
	if (name == undefined) name = '';
	if (checkable == undefined) checkable = false;
	if (drawLine == undefined) drawLine = true;

	if (name != '') DuAEF.DuScriptUI.uiStrings.push(name);
	name = tr(name);

	var separator = DuAEF.DuScriptUI.addGroup(container,"row");
	separator.margins = DuAEF.DuScriptUI.defaultMargins;
	separator.margins.bottom = DuAEF.DuScriptUI.defaultMargins*2;
	separator.alignment = ['fill','top'];
	separator.checkable = checkable;

	separator.label = null;
	if (name != '' || checkable)
	{
		DuAEF.DuScriptUI.uiStrings.push(name);
		name = tr(name);
		if (checkable) separator.label = separator.add('checkbox',undefined,name);
		else separator.label = separator.add('statictext',undefined,name);
		separator.label.alignment = ['center','bottom'];
		if (drawLine) DuAEF.DuScriptUI.setBackgroundColor(separator,DuAEF.DuJS.Color.Colors.DARK_GREY);
	}
	else if (drawLine)
	{
		DuAEF.DuScriptUI.setBackgroundColor(separator,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
	}

	separator.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	return separator;
}

/**
 * @class
 * @name DuButton
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * An Image Button.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addButton} to create an Image Button.<br />
 * The Image Button inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {string} standardImage - The path to the image (or a PNG as a string representation)
 * @property {string} imageOver - The path to the image (or a PNG as a string representation) to display when mouseover
 * @property {Image} image - The scriptui object representing the image
 * @property {StaticText} label - The label
 * @property {DuButton~onClick} onClick - The function to execute when the button is clicked
 */

/**
 * The function to execute when the button is clicked.
 * @callback DuButton~onClick
 * @memberof DuButton
 */

/**
 * Creates a button with an optionnal icon. Must have at least an icon or a text, or both.
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window|Group}			container	- The ScriptUI Object which will contain and display the button.
 * @param {string}					[text]		- The label of the button. Default: empty string
 * @param {string}					[image]		- The path to the icon. Default: empty string
 * @param {string}					[helpTip]		- The helptip. Default: empty string
 * @param {string}					[imageOver=image]	- The path to an icon displayed when the mouse is over the button.
 * @return {DuButton}			The image button created.
 */
DuAEF.DuScriptUI.addButton = function (container,text,image,helpTip,imageOver)
{
	if (typeof text === 'undefined') text = '';
	if (!image) image = '';
	if (typeof helpTip === 'undefined') helpTip = '';
	if (!imageOver) imageOver = '';
	if (imageOver != '' && !DuAEF.DuJS.Fs.fileExists(imageOver)) imageOver = '';
	if (image != '' && !DuAEF.DuJS.Fs.fileExists(image)) image = '';

	if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
	if (helpTip != '') DuAEF.DuScriptUI.uiStrings.push(helpTip);
	text = tr(text);
	helpTip = tr(helpTip);

	if (image == '' && text == '') text = 'o';

	var imageButton = container.add('group');
	imageButton.orientation = 'row';
	imageButton.margins = 2;
	if (image == '') imageButton.margins = 5;
	imageButton.spacing = 5;
	imageButton.group = imageButton;

	imageButton.standardImage = image;
	imageButton.imageOver = imageOver;
	imageButton.onClick = function(){};
	imageButton.image = null;
	imageButton.label = null;

	if (image != '')
	{
		var icon = imageButton.add('image',undefined,image);
		icon.alignment = ['center','center'];
		icon.helpTip = helpTip;
		imageButton.image = icon;
		imageButton.icon = icon;
	}

	if (text != '')
	{
		var label = imageButton.add('statictext',undefined,text);
		label.helpTip = helpTip;
		if (image == '') label.alignment = ['center','center'];
		imageButton.label = label;
		DuAEF.DuScriptUI.setBackgroundColor(imageButton,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
		imageButton.alignment = ['fill','top'];
	}

	//events
	imageButton.clicked = function (e)
	{
		DuAEF.DuScriptUI.updateHelpPopup(imageButton.help.title, imageButton.help.text, imageButton.help.link);
		if (e.shiftKey)
		{
			if (imageButton.help.text != '')
			{
				DuAEF.DuScriptUI.showHelp();
			}
			return;
		}
		else
		{
			try { imageButton.onClick(); } catch (e) { if (DuAEF.debug) alert('An error has occured in file at line ' + e.line + '\n\n' + e.description); }
		}
	}

	imageButton.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		if (icon) if (imageButton.imageOver != '') icon.image = imageButton.imageOver;
		if (label)
		{
			DuAEF.DuScriptUI.setTextColor(imageButton.label,DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);
			DuAEF.DuScriptUI.setBackgroundColor(imageButton.group,DuAEF.DuJS.Color.Colors.DARK_GREY);
		}
		DuAEF.DuScriptUI.highlightedControls.push(imageButton);
	}

	imageButton.dim = function ()
	{
		if (icon) if (imageButton.standardImage != '') icon.image = imageButton.standardImage;
		if (label)
		{
			DuAEF.DuScriptUI.setTextColor(imageButton.label,DuAEF.DuJS.Color.Colors.LIGHT_GREY);
			DuAEF.DuScriptUI.setBackgroundColor(imageButton.group,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
		}
	}

	//add events
	imageButton.addEventListener('click',imageButton.clicked,true);
	// Hack - CS6 Bug on mouseover with images
	if (DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12)
	{
		if (label) imageButton.label.addEventListener("mouseover",imageButton.highlight);
	}
	else
	{
		imageButton.addEventListener("mouseover",imageButton.highlight);
	}


	imageButton.help = {};
	imageButton.help.title = '';
	imageButton.help.text = '';
	imageButton.help.link = '';

	//help popup
	imageButton.setHelp = function(title,text,link)
	{
		if (text != '') DuAEF.DuScriptUI.uiStrings.push(title);
		title = tr(title);
		imageButton.help.title = title;
		imageButton.help.text = text;
		imageButton.help.link = link;
	}

	return imageButton;
}

/**
 * @class
 * @name DuCheckBox
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * An Image Checkbox.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addCheckBox} to create an Image Checkbox.<br />
 * The Image Checkbox inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {string} standardImage - The path to the image (or a PNG as a string representation)
* @property {string} imageOver - The path to the image (or a PNG as a string representation) to display when mouseover
* @property {string} imageChecked - The path to the image (or a PNG as a string representation) to display when the button is checked
* @property {Image}	image	- The scriptui object representing the image
* @property {StaticText}	label	- The label
* @property {boolean}	checked 	- The checked state of the button
* @property {DuCheckBox~onClick} onClick - The function to execute when the button is clicked
*/

/**
 * The function to execute when the button is clicked.
 * @callback DuCheckBox~onClick
 * @memberof DuCheckBox
 */

/**
 * Creates a checkbox with an optionnal icon. Must have at least an icon or a text, or both.
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window|Group}			container		- The ScriptUI Object which will contain and display the button.
 * @param {string}					text			- The label of the button. Default: empty string
 * @param {string}					image			- The path to the icon. Default: empty string
 * @param {string}					helpTip			- The helptip. Default: empty string
 * @param {string}					imageChecked	- The path to an icon displayed when the button is checked. Default: empty string
 * @param {string}					imageOver		- The path to an icon displayed when the mouse is over the button. Default: same as imageChecked
 * @param {string}					[textChecked]			- The label of the button displayed when it is checked.
 * @return {DuCheckBox}					The image checkbox created.
 */
DuAEF.DuScriptUI.addCheckBox = function (container,text,image,helpTip,imageChecked,imageOver,textChecked)
{
	if (!container) return null;
	if (!text) text = '';
	if (!image) image = '';
	if (!helpTip) helpTip = '';
	if (!imageChecked) imageChecked = '';
	if (!imageOver) imageOver = imageChecked;
	if (textChecked == undefined) textChecked = '';
	if (imageOver != '' && !DuAEF.DuJS.Fs.fileExists(imageOver)) imageOver = '';
	if (image != '' && !DuAEF.DuJS.Fs.fileExists(image)) image = '';
	if (imageChecked != '' && !DuAEF.DuJS.Fs.fileExists(imageChecked)) imageChecked = '';

	if (image == '' && text == '') text = '#';

	if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
	if (helpTip != '') DuAEF.DuScriptUI.uiStrings.push(helpTip);
	text = tr(text);
	helpTip = tr(helpTip);

	var group = container.add('group');
	group.orientation = 'row';
	group.margins = 2;
	if (image == '') group.margins = 5;
	group.spacing = 5;
	var imageButton = group;
	imageButton.group = group;

	imageButton.standardImage = image;
	imageButton.imageOver = imageOver;
	imageButton.imageChecked = imageChecked;
	imageButton.onClick = function () {};
	imageButton.checked = imageButton.value = false;
	imageButton.textChecked = textChecked;
	imageButton.defaultText = text;

	imageButton.iconChecked = DuAEF.DuBinary.toFile(w14_checked_m);
	imageButton.iconCheckedOver = DuAEF.DuBinary.toFile(w14_checked_l);
	imageButton.iconUnchecked = DuAEF.DuBinary.toFile(w14_emptysquare_m);
	imageButton.iconUncheckedOver = DuAEF.DuBinary.toFile(w14_unchecked_l);

	//add checkbox
	if (text != '' && DuAEF.DuAE.App.hasFilesAndNetworkAccess)
	{
		imageButton.checkbox = group.add('image',undefined,imageButton.iconUnchecked);
		imageButton.checkbox.alignment = ['left','center'];
		imageButton.checkbox.helpTip = helpTip;
		DuAEF.DuScriptUI.setBackgroundColor(group,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
		imageButton.alignment = ['fill','top'];
	}

	if (image != '')
	{
		var icon = group.add('image',undefined,image);
		icon.alignment = ['left','center'];
		icon.helpTip = helpTip;
		imageButton.image = icon;
	}

	if (text != '')
	{
		var label = group.add('statictext',undefined,text);
		label.helpTip = helpTip;
		label.alignment = ['fill','center'];
		imageButton.label = label;

		if (text.length < textChecked.length) imageButton.label.minimumSize.width = textChecked.length*7;
		else imageButton.label.minimumSize.width = text.length*7;
	}

	/**
	* Checks or unchecks the button
	* @memberof DuCheckBox
	* @param {boolean} c	- The checked state
	*/
	imageButton.setChecked = function (c)
	{
		imageButton.checked = imageButton.value = c;

		if (imageButton.label)
		{
			if (imageButton.checked)
			{
				if (imageButton.textChecked != '') imageButton.label.text = imageButton.textChecked;
				if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) imageButton.checkbox.image = imageButton.iconChecked;
			}
			else
			{
				imageButton.label.text = imageButton.defaultText;
				if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) imageButton.checkbox.image = imageButton.iconUnchecked;
			}
		}

		if (imageButton.image)
		{
			if (imageButton.checked)
			{
				if (imageButton.imageChecked != '') icon.image = imageButton.imageChecked;
			}
			else
			{
				if (imageButton.standardImage != '') icon.image = imageButton.standardImage;
			}
		}
	}

	imageButton.clicked = function (e)
	{
		DuAEF.DuScriptUI.updateHelpPopup(imageButton.help.title, imageButton.help.text, imageButton.help.link);
		if (e.shiftKey)
		{
			if (imageButton.help.text != '')
			{
				DuAEF.DuScriptUI.showHelp();
			}
			return;
		}
		imageButton.setChecked(!imageButton.checked);
		try { imageButton.onClick(); } catch (e) { if (DuAEF.debug) alert('An error has occured at line ' + e.line + '\n\n' + e.description); }
	}

	imageButton.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		if (icon) if (imageButton.imageOver != '') icon.image = imageButton.imageOver;
		if (label)
		{
			DuAEF.DuScriptUI.setBackgroundColor(group,DuAEF.DuJS.Color.Colors.DARK_GREY);
			if (DuAEF.DuAE.App.hasFilesAndNetworkAccess)
			{
				if (imageButton.checked) imageButton.checkbox.image = imageButton.iconCheckedOver;
				else imageButton.checkbox.image = imageButton.iconUncheckedOver;
			}

		}
		DuAEF.DuScriptUI.highlightedControls.push(imageButton);
	}

	imageButton.dim = function (e)
	{
		if (label) DuAEF.DuScriptUI.setBackgroundColor(group,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
		if (imageButton.checked)
		{
			if (icon) if (imageButton.imageChecked != '') icon.image = imageButton.imageChecked;
			if (label && DuAEF.DuAE.App.hasFilesAndNetworkAccess) imageButton.checkbox.image = imageButton.iconChecked;
		}
		else
		{
			if (icon) if (imageButton.standardImage != '') icon.image = imageButton.standardImage;
			if (label && DuAEF.DuAE.App.hasFilesAndNetworkAccess) imageButton.checkbox.image = imageButton.iconUnchecked;
		}
	}

	imageButton.group.addEventListener("mousedown",imageButton.clicked,true);
	// Hack - CS6 Bug on mouseover with images
	if (DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12)
	{
		if (label) imageButton.label.addEventListener("mouseover",imageButton.highlight);
	}
	else
	{
		imageButton.group.addEventListener("mouseover",imageButton.highlight);
	}

	imageButton.help = {};
	imageButton.help.title = '';
	imageButton.help.text = '';
	imageButton.help.link = '';

	//help popup
	imageButton.setHelp = function(title,text,link)
	{
		imageButton.help.title = title;
		imageButton.help.text = text;
		imageButton.help.link = link;
	}

	return imageButton;
}

/**
 * @class
 * @name SimpleCheckBox
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A Nice Checkbox.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addSimpleCheckBox} to create an Nice Checkbox.<br />
 * The Nice Checkbox inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {StaticText} label - The statictext used as a label
* @property {CheckBox} checkbox - The box
* @property {float[]} color - The color [R,G,B,A]
* @property {NiceCheckbox~onClick} onClick - Function to execute when clicked
*/

/**
 * The function to execute when the button is clicked.
 * @callback NiceCheckbox~onClick
 * @memberof NiceCheckbox
 */

/**
 * Creates a checkbox which can be colored, and changes color on hover
 * @memberof DuAEF.DuScriptUI
 * @param {Panel|Window|Group}		container		- The ScriptUI Object which will contain and display the button.
 * @param {string}					[text]			- The label of the button.
 * @param {string}					[helpTip]			- The helptip.
 * @param {color}					[color=DuAEF.DuJS.Color.Colors.LIGHT_GREY]			- The color of the text
 * @return {SimpleCheckBox}					The image checkbox created.
 */
DuAEF.DuScriptUI.addSimpleCheckBox = function (container,text,helpTip,color)
{
	if (color == undefined) color = DuAEF.DuJS.Color.Colors.LIGHT_GREY;
	if (helpTip == undefined) helpTip = '';
	if (text == undefined) text = '';

	if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
	if (helpTip != '') DuAEF.DuScriptUI.uiStrings.push(helpTip);
	text = tr(text);
	helpTip = tr(helpTip);

	var niceCheckBox = container.add('group');
	niceCheckBox.orientation = 'row';
	niceCheckBox.alignChildren = ['left','center'];
	niceCheckBox.spacing = DuAEF.DuScriptUI.defaultSpacing;
	niceCheckBox.margins = 0;
	niceCheckBox.checkBox = niceCheckBox.add('checkbox',undefined,'');
	niceCheckBox.label = niceCheckBox.add('statictext',undefined,text);
	niceCheckBox.onClick = function () {};
	niceCheckBox.checked = niceCheckBox.value = false;
	niceCheckBox.color = color;

	niceCheckBox.checkBox.helpTip = helpTip;
	niceCheckBox.label.helpTip = helpTip;

	DuAEF.DuScriptUI.setTextColor(niceCheckBox.label,niceCheckBox.color);

	/**
	* Checks or unchecks the button
	* @memberof SimpleCheckBox
	* @param {boolean} c	- The checked state
	*/
	niceCheckBox.setChecked = function (c)
	{
		niceCheckBox.checked = niceCheckBox.value = c;
		niceCheckBox.checkBox.value = c;
	}

	niceCheckBox.labelClicked = function (e)
	{
		niceCheckBox.setChecked(!niceCheckBox.checked);
		try { niceCheckBox.onClick(); } catch (e) { if (DuAEF.debug) alert('An error has occured at line ' + e.line + '\n\n' + e.description); }
	}

	niceCheckBox.checkBoxClicked = function (e)
	{
		niceCheckBox.checked = niceCheckBox.value = niceCheckBox.checkBox.value;
		try { niceCheckBox.onClick(); } catch (e) { if (DuAEF.debug) alert('An error has occured at line ' + e.line + '\n\n' + e.description); }
	}

	niceCheckBox.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		DuAEF.DuScriptUI.setTextColor(niceCheckBox.label,DuAEF.DuJS.Color.Colors.RAINBOX_RED);
		DuAEF.DuScriptUI.highlightedControls.push(niceCheckBox);
	}

	niceCheckBox.dim = function (e)
	{
		DuAEF.DuScriptUI.setTextColor(niceCheckBox.label,niceCheckBox.color);
	}

	niceCheckBox.label.addEventListener("mousedown",niceCheckBox.labelClicked,false);
	niceCheckBox.checkBox.onClick = niceCheckBox.checkBoxClicked;
	niceCheckBox.addEventListener("mouseover",niceCheckBox.highlight);

	return niceCheckBox;
}

/**
* @class
* @name Form
* @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
* A Form.<br />
* This is not a real class, and cannot be instanciated.<br />
* Use {@link DuAEF.DuScriptUI.addForm} to create a Form.<br />
* The Form inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {Group} labels - The left vertical group
* @property {Group} buttons - The right vertical group
*/

/**
 * Adds a field to the form
 * example: form.addFormField('Composition:','dropdownlist',['Composition1','Composition2'],'Select a composition')
 * @memberof Form
 * @param {string}			label		- The label text.
 * @param {string}			type		- The type of ScriptUI object to add (like 'button','edittext', etc.).
 * @param {object}			[value]		- The default value or content of the field added, depends on the type.
 * @param {string}			[helpTip]		- The helpTip of the form control.
 * @return {ScriptUI[]}		An array with at 0 the StaticText label, and at 1 the ScriptUI object of the type type, added to the form
 */

/**
 * Creates a layout to add forms to a UI, using ScriptUI groups.<br />
 * You can easily add controls/fields to this form using DuAEF.DuScriptUI.addFormField
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group}	container		- The ScriptUI Object which will contain and display the form.
 * @return {Form}		The custom Group containing the form.
 */
DuAEF.DuScriptUI.addForm = function (container)
{
	var mainGroup = container.add('group');
	mainGroup.orientation = 'row';
	mainGroup.margins = 0;
	mainGroup.spacing = DuAEF.DuScriptUI.defaultSpacing;

	var labelsGroup = mainGroup.add('group');
	labelsGroup.alignment = ['left','top'];
	labelsGroup.orientation = 'column';
	labelsGroup.alignChildren = ['left','bottom'];
	labelsGroup.spacing = DuAEF.DuScriptUI.defaultSpacing;

	var buttonsGroup = mainGroup.add('group');
	buttonsGroup.alignment = ['fill','top'];
	buttonsGroup.orientation = 'column';
	buttonsGroup.alignChildren = ['fill','fill'];
	buttonsGroup.spacing = DuAEF.DuScriptUI.defaultSpacing;

	mainGroup.labels = labelsGroup;
	mainGroup.buttons = buttonsGroup;

	mainGroup.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	mainGroup.addFormField = function (label,type,value,helpTip)
	{
		if (helpTip == undefined) helpTip = '';

		if (label != '') DuAEF.DuScriptUI.uiStrings.push(label);
		if (helpTip != '') DuAEF.DuScriptUI.uiStrings.push(helpTip);
		label = tr(label);
		helpTip = tr(helpTip);

		var control = null;
		var height = 20;
		if (type == "DuButton")
		{
			control = DuAEF.DuScriptUI.addButton(mainGroup.buttons,'',value[0],helpTip,value[1]);
			height = control.image.preferredSize[1];
		}
		else
		{
			control = mainGroup.buttons.add(type,undefined,value);
			control.helpTip = helpTip;
			height = control.preferredSize[1];
		}

		var l = mainGroup.labels.add('statictext',undefined,label);
		l.helpTip = helpTip;

		l.minimumSize.height = l.maximumSize.height = height;
		return [l,control];
	}

	return mainGroup;
}

/**
* @class
* @name DuEditText
* @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
* A Nice EditText.<br />
* This is not a real class, and cannot be instanciated.<br />
* Use {@link DuAEF.DuScriptUI.addEditText} to create a Nice EditText.<br />
* The Nice EditText inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {string} text - Read-Only | The text displayed
* @property {DuEditText~onActivate} onActivate - Function to execute when activated
* @property {DuEditText~onDeactivate} onDeactivate - Function to execute when deactivated
* @property {DuEditText~onChange} onChange - Function to execute when text changed
*/

/**
 * The function to execute when the text is changed.
 * @callback DuEditText~onChange
 * @memberof DuEditText
 */

/**
 * The function to execute when the box is activated.
 * @callback DuEditText~onActivate
 * @memberof DuEditText
 */

/**
 * The function to execute when the box is deactivated.
 * @callback DuEditText~onDeactivate
 * @memberof DuEditText
 */

/**
 * Changes the text
 * @method
 * @memberof DuEditText
 * @name setText
 * @param {string} text - The new text
 */

/**
 * Creates a nice edittext where the edit text is shown only on click.
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group}	container		- The ScriptUI Object which will contain and display the nice edit text.
 * @param {string} text - The initial text in the edit.
 * @param {string} [prefix=""] - A text prefix to display.
 * @param {string} [suffix=""] - A text suffix to display.
 * @param {string} [placeHolder=""] - A place holder default text.
 * @param {string} [helpTip=""] The helpTip of this control
 * @param {bool} [translatable=true] Wether to translate the texts of this control
 * @return {DuEditText}	The custom Group containing the edit text.
 */
DuAEF.DuScriptUI.addEditText = function(container,text,prefix,suffix,placeHolder,helpTip,translatable)
{
	if (prefix == undefined) prefix = '';
	if (suffix == undefined) suffix = '';
	if (placeHolder == undefined) placeHolder = '';
	if (helpTip == undefined) helpTip = '';

	if (typeof translatable === 'undefined') translatable = true;
	if (translatable)
	{
		if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
		if (prefix != '') DuAEF.DuScriptUI.uiStrings.push(prefix);
		if (suffix != '') DuAEF.DuScriptUI.uiStrings.push(suffix);
		if (placeHolder != '') DuAEF.DuScriptUI.uiStrings.push(placeHolder);
		text = tr(text);
		prefix = tr(prefix);
		suffix = tr(suffix);
		placeHolder = tr(placeHolder);
	}

	var niceEditText = container.add('group');
	niceEditText.orientation = 'stack';
	niceEditText.margins = 0;
	niceEditText.alignChildren = ['fill','fill'];
	niceEditText.placeHolder = placeHolder;
	var staticText = text;
	if (text == "" && placeHolder != "") staticText = placeHolder;
	niceEditText.static = niceEditText.add('statictext',undefined,prefix + staticText + suffix);
	niceEditText.static.alignment = ['fill','center'];
	if (text == "" && placeHolder != "") DuAEF.DuScriptUI.setTextColor(niceEditText.static,DuAEF.DuJS.Color.Colors.LIGHT_PURPLE);
	else DuAEF.DuScriptUI.setTextColor(niceEditText.static,DuAEF.DuJS.Color.Colors.AFTER_EFFECTS_BLUE);
	niceEditText.edit = niceEditText.add('edittext',undefined,text);
	niceEditText.edit.visible = false;
	niceEditText.prefix = prefix;
	niceEditText.suffix = suffix;

	niceEditText.text = text;
	niceEditText.editing = false;

	niceEditText.onActivate = function(){};
	niceEditText.onDeactivate = function(){};
	niceEditText.onChange = function(){};
	niceEditText.onChanging = function(){};

	niceEditText.clicked = function()
	{
		if (niceEditText.editing) return;
		else
		{
			niceEditText.static.visible = false;
			niceEditText.edit.visible = true;
			niceEditText.editing = true;
			niceEditText.edit.active = true;
		}
	}

	niceEditText.changed = function()
	{
		niceEditText.editing = false;
		var staticText = '';
		if (niceEditText.edit.text == '' && niceEditText.placeHolder != '')
		{
			DuAEF.DuScriptUI.setTextColor(niceEditText.static,DuAEF.DuJS.Color.Colors.LIGHT_PURPLE);
			staticText = niceEditText.placeHolder;
		}
		else
		{
			if (niceEditText.placeHolder != '') DuAEF.DuScriptUI.setTextColor(niceEditText.static,DuAEF.DuJS.Color.Colors.AFTER_EFFECTS_BLUE);
			staticText = niceEditText.edit.text;
		}
		niceEditText.static.text = niceEditText.prefix + staticText + niceEditText.suffix;
		niceEditText.text = niceEditText.edit.text ;
		niceEditText.edit.visible = false;
		niceEditText.static.visible = true;
		niceEditText.edit.active = false;
		niceEditText.onChange();
	}
	niceEditText.changing = function()
	{
		niceEditText.text = niceEditText.edit.text ;
		niceEditText.onChanging();
	}

	niceEditText.setText = function (text)
	{
		niceEditText.edit.text = niceEditText.text = text;
		niceEditText.static.text = niceEditText.prefix + text + niceEditText.suffix;
	}


	niceEditText.edit.onActivate = function()
	{
		niceEditText.onActivate();
	}
	niceEditText.edit.onDeactivate = function ()
	{
		niceEditText.changed();
		niceEditText.onDeactivate();
	}
	niceEditText.edit.onChange = niceEditText.changed;
	niceEditText.edit.onChanging = niceEditText.changing;
	niceEditText.addEventListener("mousedown",niceEditText.clicked,true);

	niceEditText.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	niceEditText.helpTip = helpTip;

	return niceEditText;
}

/**
* @class
* @name DuSlider
* @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
* A Nice Slider.<br />
* This is not a real class, and cannot be instanciated.<br />
* Use {@link DuAEF.DuScriptUI.addSlider} to create a Nice Slider.<br />
* The Nice Slider inherits the Group object from ScriptUI and has all of its properties and methods.
* @property {int} value - Read-Only | The current value
* @property {DuSlider~onChanging} onChanging - Function to execute when changing
* @property {DuSlider~onChange} onChange - Function to execute when changed
*/

/**
 * Function to execute when changing
 * @callback DuSlider~onChanging
 * @memberof DuSlider
 */

/**
 * Function to execute when changed
 * @callback DuSlider~onChange
 * @memberof DuSlider
 */

/**
 * Changes the value
 * @method
 * @memberof DuSlider
 * @name setValue
 * @param {int} value - The new value
 */

/**
* Creates a statictext (with an optionnal color).
* @memberof DuAEF.DuScriptUI
* @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the nice edit text.
* @param {string} text - The initial text in the edit.
* @param {int[]} [color] - The color of the text.
* @param {bool} [translatable=true] - Set this to false to never translate this text.
* @param {bool} [multiline=false] - Set this to true to add a multiline text.
* @return {StaticText} The ScriptUI StaticText created.
*/
DuAEF.DuScriptUI.addStaticText = function(container,text,color,helpTip,translatable,multiline)
{
	if (typeof helpTip === 'undefined') helpTip = '';
	if (typeof multiline === 'undefined') multiline = false;

	if (typeof translatable === 'undefined') translatable = true;
	if (translatable)
	{
		if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
		text = tr(text);
	}

	var t = container.add('statictext',undefined,text,{multiline:multiline});

	if (typeof color !== 'undefined') DuAEF.DuScriptUI.setTextColor(t,color);

	t.helpTip = helpTip;

	return t;
}

/**
 * Creates a nice edittext where the edit text is shown only on click.
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group}	container		- The ScriptUI Object which will contain and display the nice edit text.
 * @param {int}	[defaultValue=0]		- The initial value.
 * @param {int}	[min=0]		- The minimal value.
 * @param {int}	[max=100]		- The maximal value.
 * @param {string}	[orientation='column']		- Either 'row' or 'column'
 * @param {boolean}	[invertedAppearance]		- Revert the slider with max value on the left
 * @param {string}	[prefix]		- A text prefix to display.
 * @param {string}	[suffix]		- A text suffix to display.
 * @return {DuSlider}	The custom Group containing the slider.
 * @todo implement helpTip
 */
DuAEF.DuScriptUI.addSlider = function(container,defaultValue,min,max,orientation,invertedAppearance,prefix,suffix)
{
	if (prefix == undefined) prefix = '';
	if (suffix == undefined) suffix = '';
	if (min == undefined) min = 0;
	if (max == undefined) max = 100;
	if (defaultValue == undefined) defaultValue = 0;
	if (orientation != 'row') orientation = 'column';

	if (prefix != '') DuAEF.DuScriptUI.uiStrings.push(prefix);
	if (suffix != '') DuAEF.DuScriptUI.uiStrings.push(suffix);
	prefix = tr(prefix);
	suffix = tr(suffix);

	var niceSlider = container.add('group');
	niceSlider.orientation = orientation;
	niceSlider.spacing = DuAEF.DuScriptUI.defaultSpacing;
	niceSlider.alignment = ['fill','top'];
	niceSlider.alignChildren = ['fill','center'];

	niceSlider.value = defaultValue;
	niceSlider.invertedAppearance = invertedAppearance;

	var sliderValue = defaultValue;
	if (niceSlider.invertedAppearance) sliderValue = max-defaultValue+min;

	niceSlider.slider = niceSlider.add('slider',undefined,sliderValue,min,max);
	niceSlider.edit = DuAEF.DuScriptUI.addEditText(niceSlider,defaultValue.toString(),prefix,suffix);
	niceSlider.edit.minimumSize.width = max.toString().length*7+7;
	if (orientation == 'row')
	{
		niceSlider.edit.alignment = ['right','center'];
	}
	else
	{
		niceSlider.edit.alignment = ['center','center'];
	}
	niceSlider.onChanging = function () {};
	niceSlider.onChange = function () {};

	niceSlider.setValue = function (val)
	{
		niceSlider.value = val;
		niceSlider.edit.setText(niceSlider.value);
		if (niceSlider.invertedAppearance) niceSlider.slider.value = niceSlider.slider.maxvalue - val + niceSlider.slider.minvalue;
		else niceSlider.slider.value = val;
	}

	//events
	niceSlider.slider.onChanging = function ()
	{
		if (niceSlider.invertedAppearance) niceSlider.value = Math.round(niceSlider.slider.maxvalue - niceSlider.slider.value + niceSlider.slider.minvalue);
		else niceSlider.value = Math.round(niceSlider.slider.value);
		niceSlider.edit.setText(niceSlider.value);
		niceSlider.onChanging();
	}
	niceSlider.slider.onChange = function ()
	{
		niceSlider.onChange();
	}
	niceSlider.edit.onChanging = function ()
	{
		var val = parseInt(niceSlider.edit.text);
		if (isNaN(val)) return;
		niceSlider.value = val;
		if (niceSlider.invertedAppearance) niceSlider.slider.value = niceSlider.slider.maxvalue-val+niceSlider.slider.minvalue;
		else niceSlider.slider.value = val;
		niceSlider.onChanging();
	}
	niceSlider.edit.onChange = function ()
	{
		var val = parseInt(niceSlider.edit.text);
		if (isNaN(val)) return;
		if (val < niceSlider.slider.minvalue) val = niceSlider.slider.minvalue;
		if (val > niceSlider.slider.maxvalue) val = niceSlider.slider.maxvalue;
		niceSlider.value = val;
		if (niceSlider.invertedAppearance) niceSlider.slider.value = niceSlider.slider.maxvalue-val+niceSlider.slider.minvalue;
		else niceSlider.slider.value = val;
		niceSlider.onChange();
	}

	niceSlider.addEventListener("mouseover",DuAEF.DuScriptUI.dimControls);

	return niceSlider;
}

/**
 * @class
 * @name Selector
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A drop down selector.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addSelector} to create a Selector.<br />
 * The Selector inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {string} image - The path to the current image (or a PNG as a string representation)
 * @property {Image} icon - The Image currently displayed
 * @property {StaticText} label - The current text
 * @property {DuButton[]} items  - The buttons
 * @property {int} index  - The current index
 * @property {Selector~onChange} onChange  - The function to execute when the index changes.<br />
 * You can set your own function here, which must take no argument.<br />
 * The method is called after the index has changed.
 */

/**
 * The function to execute when the index changes.<br />
 * The method is called after the index has changed.
 * @callback Selector~onChange
 * @memberof Selector
 */

/**
 * Adds a new button to the selector
 * @method
 * @memberof Selector
 * @name addButton
 * @param {string} text - The text displayed by the button
 * @param {string} image - The icon, either a path to the file or a PNG represented as a string.
 * @param {string} helpTip - The help tip
 * @param {string} imageOver - The roll over icon, either a path to the file or a PNG represented as a string.
 */

/**
* Removes all buttons from the selector
* @method
* @memberof Selector
* @name removeAll
*/

/**
 * Changes the selection and the current index of the selector
 * @method
 * @memberof Selector
 * @name setCurrentIndex
 * @param {int} index - The new index
 */

/**
 * Creates a drop down selector, using image buttons
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the selector.
 * @return {Selector} - The selector
 */
DuAEF.DuScriptUI.addSelector = function(container)
{
	//create main group
	var selector = container.add('group');
	selector.orientation = 'row';
	selector.margins = 2;
	selector.spacing = 5;
	selector.alignment = ['fill','top'];
	selector.alignChildren = ['center','center'];
	DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);

	selector.addButton = function (text,image,helpTip,imageOver)
	{
		if (!text) text = '-';
		if (!image) image = '';
		if (!helpTip) helpTip = '';
		if (!imageOver) imageOver = '';

		if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
		if (helpTip != '') DuAEF.DuScriptUI.uiStrings.push(helpTip);
		text = tr(text);
		helpTip = tr(helpTip);

		var size = text.length*7;
		if (selector.label.minimumSize.width < size) selector.label.minimumSize.width = size;

		var index = selector.items.length;
		selector.items.push([text,image,helpTip,imageOver]);
		//add to popup
		var button = DuAEF.DuScriptUI.addButton(selector.popup.buttons,text,image,helpTip,imageOver);
		button.onClick = function () { selector.setCurrentIndex(index); selector.popup.hide(); };
		if (button.icon) button.icon.alignment = ['left','center'];
	}

	selector.removeAll = function ()
	{
		selector.items = [];
		selector.setCurrentIndex(0);
		for ( var i = selector.popup.buttons.children.length - 1; i >= 0; i-- )
		{
			selector.popup.buttons.remove( selector.popup.buttons.children[ i ] );
		}
	}

	selector.setCurrentIndex = function (index)
	{
		if (index < 0) return;
		if (index >= selector.items.length) return;

		var item = selector.items[index];

		if (!item) return;

		selector.image = item[1];
		if (selector.image != '')
		{
			selector.icon.image = selector.image;
			selector.icon.helpTip = item[2];
		}
		selector.label.helpTip = item[2];
		selector.label.text = item[0];
		selector.imageOver = item[3];

		selector.index = index;

		selector.onChange();
	}

	//the menu button
	selector.menuImage = DuAEF.DuBinary.toFile(w14_menu_m);
	selector.menuImageOver = DuAEF.DuBinary.toFile(w14_menu_l);
	if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.menuButton = selector.add('image',undefined,selector.menuImage);
	else selector.menuButton = selector.add('statictext',undefined,'M');
	selector.menuButton.alignment = ['left','center'];

	//the image
	selector.image = '';
	selector.icon = selector.add('image');
	selector.icon.alignment = ['left','center'];

	//the text
	selector.label = selector.add('statictext',undefined,'');
	selector.label.helpTip = '';
	selector.label.alignment = ['fill','center'];

	//the image over
	selector.imageOver = '';

	//create popup
	selector.popup = new Window('palette','',undefined,{borderless:true});
	selector.popup.margins = 2;
	selector.popup.spacing = 0;
	//DuAEF.DuScriptUI.setBackgroundColor(selector.popup,DuAEF.DuJS.Color.Colors.DARK_GREY);
	selector.popup.closeButton = DuAEF.DuScriptUI.addButton(selector.popup,"Cancel");
	selector.popup.closeButton.onClick = function () { selector.popup.hide(); };
	selector.popup.buttons = selector.popup.add('group');
	selector.popup.buttons.orientation = 'column';
	selector.popup.buttons.margins = 0;
	selector.popup.buttons.spacing = 0;
	//Deactivate bugs on CS6, needs a try/catch
	selector.popup.onDeactivate = function () { try { selector.popup.hide(); } catch (e) {} };

	//add default button
	selector.items = [];
	selector.index = -1;


	selector.clicked = function (e)
	{
		var popup = false;

		if (e.target === selector.menuButton) popup = true;
		if (e.altKey) popup = true;

		if (popup)
		{
			if (DuAEF.DuAE.App.version < 11 || DuAEF.DuAE.App.version >= 12)
			{
				var x = e.screenX-e.clientX;
				var y = e.screenY-e.clientY;
				selector.popup.location = [x,y];
			}
			selector.popup.show();
		}
		else
		{
			var index = selector.index;
			if (index == selector.items.length -1) index = 0;
			else index++;
			selector.setCurrentIndex(index);
		}
	}

	//mouse over
	selector.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		selector.menuButton.image = selector.menuImageOver;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.DARK_GREY);
		if (selector.imageOver != '') selector.icon.image = selector.imageOver;
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.dim = function (e)
	{
		selector.menuButton.image = selector.menuImage;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
		if (selector.image != '') selector.icon.image = selector.image;
	}

	// Hack - CS6 Bugs on mouseover with images
	if (DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12)
	{
		selector.label.addEventListener("mouseover",selector.highlight);
	}
	else
	{
		selector.addEventListener("mouseover",selector.highlight);
	}
	selector.addEventListener("click",selector.clicked,true);

	selector.onChange = function(){};

	return selector;
}

/**
 * @class
 * @name LayerSelector
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A drop down selector.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addLayerSelector} to create a Selector.<br />
 * The Selector inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {int} [index=0]  - The current layer index, 0 if None
 * @property {CompItem|null} [comp=null] - The composition linked to the selector.<br />
 * If set to null, the seletor will use the current active composition.
 * @property {boolean} [selectedOnly=false] - True to list only selected layers in the composition
 * @property {Selector~onChange} onChange  - The function to execute when the index changes.<br />
 * You can set your own function here, which must take no argument.<br />
 * The method is called after the index has changed.
 */

/**
 * The function to execute when the index changes.<br />
 * The method is called after the index has changed.
 * @callback LayerSelector~onChange
 * @memberof LayerSelector
 */

/**
 * Changes the selection and the current layer index of the selector
 * @method
 * @memberof LayerSelector
 * @name setCurrentIndex
 * @param {int} index - The new layer index
 */

/**
* Force the refresh of the layer list
* @method
* @memberof LayerSelector
* @name refresh
*/

/**
 * Creates a drop down selector for layers
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the selector.
 * @return {Selector} - The selector
 */
DuAEF.DuScriptUI.addLayerSelector = function(container)
{
	//create main group
	var selector = container.add('group');
	selector.orientation = 'row';
	selector.margins = 2;
	selector.spacing = 5;
	selector.alignment = ['fill','top'];
	selector.mainGroup =  selector.add('group');
	selector.mainGroup.orientation = 'row';
	selector.mainGroup.margins = 0;
	selector.mainGroup.spacing = 5;
	selector.mainGroup.alignment = ['fill','fill'];
	selector.mainGroup.alignChildren = ['center','center'];
	DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);

	//init
	selector.index = 0;
	selector.comp = null;
	selector.selectedOnly = false;
	selector.pauseRefresh = false;

	var cs6 = DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12;

	//CS6
	if (cs6)
	{
		//the menu button
		selector.menuImage = DuAEF.DuBinary.toFile(w14_layers_m);
		selector.menuButton = selector.mainGroup.add('image',undefined,selector.menuImage);
		selector.menuButton.alignment = ['left','center'];

		//the dropdownlist
		selector.popup = {};
		selector.popup.list = selector.mainGroup.add('dropdownlist');
		selector.popup.list.alignment = ['fill','center'];

		//the refresh button
		selector.refreshImage = DuAEF.DuBinary.toFile(w14_update_m);
		selector.refreshImageOver = DuAEF.DuBinary.toFile(w14_update_l);
		selector.refreshButton = selector.add('image',undefined,selector.refreshImage);
		selector.refreshButton.alignment = ['right','center'];
	}
	else
	{
		//the menu button
		selector.menuImage = DuAEF.DuBinary.toFile(w14_layers_m);
		selector.menuImageOver = DuAEF.DuBinary.toFile(w14_layers_l);
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.menuButton = selector.mainGroup.add('image',undefined,selector.menuImage);
		else selector.menuButton = selector.mainGroup.add('statictext',undefined,'L');
		selector.menuButton.alignment = ['left','center'];

		//the text
		selector.label = selector.mainGroup.add('statictext',undefined,'None');
		selector.label.helpTip = '';
		selector.label.alignment = ['fill','center'];

		//create popup
		selector.popup = new Window('palette','',undefined,{borderless:true});
		selector.popup.margins = 2;
		selector.popup.spacing = 0;
		DuAEF.DuScriptUI.setBackgroundColor(selector.popup,DuAEF.DuJS.Color.Colors.DARK_GREY);
		selector.popup.closeButton = DuAEF.DuScriptUI.addButton(selector.popup,"Cancel");
		selector.popup.closeButton.onClick = function () { selector.popup.hide(); };
		selector.popup.onDeactivate = function () { selector.popup.hide(); };
		selector.popup.list = selector.popup.add('listbox',undefined);

		selector.clicked = function (e)
		{
			selector.refresh();

			selector.popup.list.minimumSize.width = selector.popup.list.maximumSize.width = selector.size.width;
			selector.popup.list.minimumSize.height = selector.popup.list.maximumSize.height = selector.size.height * 10;

			selector.popup.layout.layout();
			selector.popup.layout.resize();

			var x = e.screenX-e.clientX;
			var y = e.screenY-e.clientY;
			selector.popup.location = [x,y];

			selector.popup.show();
		}

		selector.mainGroup.addEventListener("click",selector.clicked,true);
	}

	//the pick button
	selector.pickImage = DuAEF.DuBinary.toFile(w14_eyedropper_m);
	selector.pickImageOver = DuAEF.DuBinary.toFile(w14_eyedropper_l);
	if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.pickButton = selector.add('image',undefined,selector.pickImage);
	else selector.pickButton = selector.add('statictext',undefined,'P');
	selector.pickButton.alignment = ['right','center'];

	selector.popup.list.add('item',"None");
	selector.popup.list.selection = 0;

	selector.refresh = function()
	{
		var comp = selector.comp;
		if (!comp) comp = DuAEF.DuAE.Project.getActiveComp();
		if (!comp) return;

		selector.pauseRefresh = true;

		var layers;
		if (selector.selectedOnly) layers = comp.selectedLayers;
		else layers = comp.layers;

		var prevIndex = selector.index;
		selector.popup.list.removeAll();
		selector.popup.list.add('item',"None");
		var it = new Iterator(layers);
		it.do(function(layer)
		{
			selector.popup.list.add('item',layer.index + ' | ' + layer.name);
		});
		selector.setCurrentIndex(prevIndex);

		selector.pauseRefresh = false;
	};

	selector.setCurrentIndex = function (index)
	{
		if (index < 0) return;

		selector.pauseRefresh = true;

		if (index == 0)
		{
			selector.popup.list.selection = 0;
		}
		else
		{
			for(var i = 0,num = selector.popup.list.items.length ; i < num ; i++)
			{
				var t = selector.popup.list.items[i].text;
				if (index == parseInt(t.split(' | ')[0]))
				{
					selector.popup.list.selection = i;
					break;
				}
			}
		}

		if (!cs6)
		{
			if ( selector.popup.list.selection) selector.label.text = selector.popup.list.selection.text;
			else
			{
				selector.popup.list.selection = 0;
				selector.label.text = "None";
			}
		}

		selector.index = index;

		selector.pauseRefresh = false;

		selector.onChange();
	};

	selector.popup.list.onChange = function()
	{
		if (selector.pauseRefresh) return;
		selector.setCurrentIndex(selector.popup.list.selection.index);
		if (!cs6) selector.popup.hide();
	};

	//mouse over
	selector.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		selector.menuButton.image = selector.menuImageOver;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.DARK_GREY);
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.pickHighlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		selector.pickButton.image = selector.pickImageOver;
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.dim = function (e)
	{
		selector.menuButton.image = selector.menuImage;
		selector.pickButton.image = selector.pickImage;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
	}

	selector.pick = function ()
	{
		var layers = DuAEF.DuAE.Comp.getSelectedLayers();
		if (layers.length > 0) selector.setCurrentIndex(layers[0].index);
	}

	selector.getLayer = function ()
	{
		if (selector.index < 1) return null;
		var comp = selector.comp;
		if (!comp) comp = DuAEF.DuAE.Project.getActiveComp();
		if (!comp) return null;
		try { return comp.layer(selector.index)} catch(e){return null};
	}

	// Hack - CS6 Bugs on mouseover with images
	if (DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12)
	{
		selector.refreshButton.addEventListener("mousedown",selector.refresh,false);
	}
	else
	{
		selector.mainGroup.addEventListener("mouseover",selector.highlight);
		selector.pickButton.addEventListener("mouseover",selector.pickHighlight);
	}

	selector.pickButton.addEventListener("click",selector.pick);

	selector.onChange = function(){};

	selector.refresh();

	return selector;
}

/**
* The panel where the help is displayed
*/
DuAEF.DuScriptUI.helpPanel = new Window('palette',"Help panel",undefined,{resizeable:true});

//Initializes the help panel
(function(){

	DuAEF.DuScriptUI.helpPanel.link = '';
	DuAEF.DuScriptUI.helpPanel.news = {};
	DuAEF.DuScriptUI.helpPanel.news.link = '';
	DuAEF.DuScriptUI.helpPanel.about = {};
	DuAEF.DuScriptUI.helpPanel.about.link = '';
	DuAEF.DuScriptUI.helpPanel.newsItems = [];
	DuAEF.DuScriptUI.helpPanel.currentNewsItem = -1;

	DuAEF.DuScriptUI.helpPanel.margins = 2;
	DuAEF.DuScriptUI.helpPanel.spacing = 0;
	DuAEF.DuScriptUI.helpPanel.maximumSize.height = 500;
	DuAEF.DuScriptUI.helpPanel.alignChildren = ['fill','fill'];
	//DuAEF.DuScriptUI.setBackgroundColor(popup,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);

	//add buttons for help/news/about tabs
	DuAEF.DuScriptUI.uiStrings.push("Help");
	DuAEF.DuScriptUI.uiStrings.push("News");
	DuAEF.DuScriptUI.uiStrings.push("About");
	var tabsGroup = DuAEF.DuScriptUI.addGroup(DuAEF.DuScriptUI.helpPanel,'row');
	tabsGroup.alignment = ['fill','top'];
	DuAEF.DuScriptUI.helpPanel.helpButton = DuAEF.DuScriptUI.addCheckBox(
		tabsGroup,
		tr("Help"),
		DuAEF.DuBinary.toFile(w14_help_m),
		'',
		DuAEF.DuBinary.toFile(w14_help_l)
	);
	DuAEF.DuScriptUI.helpPanel.newsButton = DuAEF.DuScriptUI.addCheckBox(
		tabsGroup,
		tr("News"),
		DuAEF.DuBinary.toFile(w14_news_m),
		'',
		DuAEF.DuBinary.toFile(w14_news_l)
	);
	DuAEF.DuScriptUI.helpPanel.aboutButton = DuAEF.DuScriptUI.addCheckBox(
		tabsGroup,
		tr("About"),
		DuAEF.DuBinary.toFile(w14_help_m),
		'',
		DuAEF.DuBinary.toFile(w14_help_l)
	);

	//add main panel
	var mainGroup = DuAEF.DuScriptUI.addGroup(DuAEF.DuScriptUI.helpPanel,'stack');

	//help panel
	var helpGroup = DuAEF.DuScriptUI.addGroup(mainGroup,'column');
	helpGroup.alignment = ['fill','fill'];

	//add title
	DuAEF.DuScriptUI.helpPanel.title = helpGroup.add('statictext',undefined,'');
	DuAEF.DuScriptUI.helpPanel.title.alignment = ['fill','top'];
	DuAEF.DuScriptUI.setTextColor(DuAEF.DuScriptUI.helpPanel.title, DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);

	//add text
	DuAEF.DuScriptUI.helpPanel.help = helpGroup.add('edittext',undefined,'',{multiline:true});
	DuAEF.DuScriptUI.helpPanel.help.alignment = ['fill','fill'];

	//news panel
	var newsGroup = DuAEF.DuScriptUI.addGroup(mainGroup,'column');
	newsGroup.alignment = ['fill','fill'];

	//add title
	DuAEF.DuScriptUI.helpPanel.news.title = newsGroup.add('statictext',undefined,'');
	DuAEF.DuScriptUI.helpPanel.news.title.alignment = ['fill','top'];
	DuAEF.DuScriptUI.setTextColor(DuAEF.DuScriptUI.helpPanel.news.title, DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);
	//add date
	DuAEF.DuScriptUI.helpPanel.news.date = newsGroup.add('statictext',undefined,'');
	DuAEF.DuScriptUI.helpPanel.news.date.alignment = ['fill','top'];

	//add next and previous buttons
	var newsNavGroup = DuAEF.DuScriptUI.addGroup(newsGroup,'row');
	newsNavGroup.alignment = ['fill','top'];
	DuAEF.DuScriptUI.uiStrings.push("Previous");
	DuAEF.DuScriptUI.uiStrings.push("Next");
	DuAEF.DuScriptUI.helpPanel.news.prevButton = DuAEF.DuScriptUI.addButton(
		newsNavGroup,
		tr("Previous"),
		DuAEF.DuBinary.toFile(w14_back_m),
		'',
		DuAEF.DuBinary.toFile(w14_back_l)
	);
	DuAEF.DuScriptUI.helpPanel.news.nextButton = DuAEF.DuScriptUI.addButton(
		newsNavGroup,
		tr("Next"),
		DuAEF.DuBinary.toFile(w14_next_m),
		'',
		DuAEF.DuBinary.toFile(w14_next_l)
	);


	//add text
	DuAEF.DuScriptUI.helpPanel.news.help = newsGroup.add('edittext',undefined,'',{multiline:true});
	DuAEF.DuScriptUI.helpPanel.news.help.alignment = ['fill','fill'];

	//about panel
	var aboutGroup = DuAEF.DuScriptUI.addGroup(mainGroup,'column');
	aboutGroup.alignment = ['fill','fill'];

	//add title
	DuAEF.DuScriptUI.helpPanel.about.title = aboutGroup.add('statictext',undefined,'');
	DuAEF.DuScriptUI.helpPanel.about.title.alignment = ['fill','top'];
	DuAEF.DuScriptUI.setTextColor(DuAEF.DuScriptUI.helpPanel.about.title, DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);

	//add text
	DuAEF.DuScriptUI.helpPanel.about.help = aboutGroup.add('edittext',undefined,'',{multiline:true});
	DuAEF.DuScriptUI.helpPanel.about.help.alignment = ['fill','fill'];

	//add buttons
	var buttonsGroup = DuAEF.DuScriptUI.addGroup(DuAEF.DuScriptUI.helpPanel,'row');
	buttonsGroup.alignment = ['fill','bottom'];
	DuAEF.DuScriptUI.helpPanel.closeButton = DuAEF.DuScriptUI.addButton(buttonsGroup,"Close",DuAEF.DuBinary.toFile(w14_cancel_m),"Close this window",DuAEF.DuBinary.toFile(w14_cancel_l));
	DuAEF.DuScriptUI.helpPanel.closeButton.onClick = function () { DuAEF.DuScriptUI.helpPanel.hide(); };
	DuAEF.DuScriptUI.helpPanel.moreButton = DuAEF.DuScriptUI.addButton(buttonsGroup,"More...",DuAEF.DuBinary.toFile(w14_url_m),"Read more details online",DuAEF.DuBinary.toFile(w14_url_l));
	DuAEF.DuScriptUI.helpPanel.moreButton.addEventListener('click', function (e) {
		var link = DuAEF.DuScriptUI.helpPanel.link;
		if (e.shiftKey) link = 'https://bat-ultra-bunny.tumblr.com/';
		else if (DuAEF.DuScriptUI.helpPanel.newsButton.checked) link = DuAEF.DuScriptUI.helpPanel.news.link;
		else if (DuAEF.DuScriptUI.helpPanel.aboutButton.checked) link = DuAEF.DuScriptUI.helpPanel.about.link;
		DuAEF.DuSystem.openURL(link);
	}, true);



	DuAEF.DuScriptUI.helpPanel.setPanel = function (panel)
	{
		if (typeof panel === 'undefined') panel = 0;

		if (panel == 0)
		{
			helpGroup.visible = true;
			DuAEF.DuScriptUI.helpPanel.helpButton.setChecked(true);
			newsGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.newsButton.setChecked(false);
			aboutGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.aboutButton.setChecked(false);

			if (DuAEF.DuScriptUI.helpPanel.link != '') DuAEF.DuScriptUI.helpPanel.moreButton.show();
			else DuAEF.DuScriptUI.helpPanel.moreButton.hide();
		}
		else if (panel == 1)
		{
			helpGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.helpButton.setChecked(false);
			newsGroup.visible = true;
			DuAEF.DuScriptUI.helpPanel.newsButton.setChecked(true);
			aboutGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.aboutButton.setChecked(false);

			if (DuAEF.DuScriptUI.helpPanel.news.link != '') DuAEF.DuScriptUI.helpPanel.moreButton.show();
			else DuAEF.DuScriptUI.helpPanel.moreButton.hide();
		}
		else if (panel == 2)
		{
			helpGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.helpButton.setChecked(false);
			newsGroup.visible = false;
			DuAEF.DuScriptUI.helpPanel.newsButton.setChecked(false);
			aboutGroup.visible = true;
			DuAEF.DuScriptUI.helpPanel.aboutButton.setChecked(true);

			if (DuAEF.DuScriptUI.helpPanel.about.link != '') DuAEF.DuScriptUI.helpPanel.moreButton.show();
			else DuAEF.DuScriptUI.helpPanel.moreButton.hide();
		}
	}

	DuAEF.DuScriptUI.helpPanel.displayNewsItem = function (ind)
	{
		if (DuAEF.DuScriptUI.helpPanel.newsItems.length == 0)
		{
			DuAEF.DuScriptUI.helpPanel.news.title.text = '';
			DuAEF.DuScriptUI.helpPanel.news.date.text = '';
			DuAEF.DuScriptUI.helpPanel.news.help.text = '';
			DuAEF.DuScriptUI.helpPanel.news.link = '';
			DuAEF.DuScriptUI.helpPanel.currentNewsItem = -1;
			return;
		}

		if (ind < 0)
		{
			ind = 0;
		}

		if (ind >= DuAEF.DuScriptUI.helpPanel.newsItems.length)
		{
			ind = DuAEF.DuScriptUI.helpPanel.newsItems.length -1;
		}

		DuAEF.DuScriptUI.helpPanel.news.nextButton.enabled = ind != 0;
		DuAEF.DuScriptUI.helpPanel.news.prevButton.enabled = ind != DuAEF.DuScriptUI.helpPanel.newsItems.length -1;

		var text = DuAEF.DuScriptUI.helpPanel.newsItems[ind].description.replace('![CDATA[','').replace(']]','');
		var title = DuAEF.DuScriptUI.helpPanel.newsItems[ind].title;
		var date = DuAEF.DuScriptUI.helpPanel.newsItems[ind].pubDate.toString();
		var link = DuAEF.DuScriptUI.helpPanel.newsItems[ind].link;

		DuAEF.DuScriptUI.helpPanel.news.title.text = title;
		DuAEF.DuScriptUI.helpPanel.news.date.text = date;
		DuAEF.DuScriptUI.helpPanel.news.help.text = text;
		DuAEF.DuScriptUI.helpPanel.news.link = link;

		DuAEF.DuScriptUI.helpPanel.currentNewsItem = ind;
	}

	DuAEF.DuScriptUI.helpPanel.news.prevButton.onClick = function () { DuAEF.DuScriptUI.helpPanel.displayNewsItem(DuAEF.DuScriptUI.helpPanel.currentNewsItem + 1); };
	DuAEF.DuScriptUI.helpPanel.news.nextButton.onClick = function () { DuAEF.DuScriptUI.helpPanel.displayNewsItem(DuAEF.DuScriptUI.helpPanel.currentNewsItem - 1); };

	DuAEF.DuScriptUI.helpPanel.helpButton.onClick = function () {DuAEF.DuScriptUI.helpPanel.setPanel(0);};
	DuAEF.DuScriptUI.helpPanel.newsButton.onClick = function () {DuAEF.DuScriptUI.helpPanel.setPanel(1);};
	DuAEF.DuScriptUI.helpPanel.aboutButton.onClick = function () {DuAEF.DuScriptUI.helpPanel.setPanel(2);};

	DuAEF.DuScriptUI.helpPanel.onResizing = DuAEF.DuScriptUI.helpPanel.onResize = function () { DuAEF.DuScriptUI.helpPanel.layout.resize(); };
})();

/**
* Updates the helpPopup with new information
* @memberof DuAEF.DuScriptUI
* @param {string} title - A title.
* @param {string} text - The help text.
* @param {string} link - The http link to a webpage
*/
DuAEF.DuScriptUI.updateHelpPopup = function (title, text, link)
{
	if (typeof link === 'undefined') link = '';

	if (text == '') return;

	if (text != '') DuAEF.DuScriptUI.uiStrings.push(text);
	if (title != '') DuAEF.DuScriptUI.uiStrings.push(title);
	text = tr(text);
	title = tr(title);

	DuAEF.DuScriptUI.helpPanel.title.text = title;
	DuAEF.DuScriptUI.helpPanel.help.text = text;
	DuAEF.DuScriptUI.helpPanel.link = link;

	DuAEF.DuScriptUI.helpPanel.layout.layout(true);
	DuAEF.DuScriptUI.helpPanel.layout.resize();
}

/**
* Updates the About Popup with new information
* @memberof DuAEF.DuScriptUI
* @param {string} title - A title.
* @param {string} text - The help text.
* @param {string} link - The http link to a webpage
*/
DuAEF.DuScriptUI.updateAboutPopup = function (title,text,link)
{
	if (typeof link === 'undefined') link = '';

	if (text == '') return;

	if (title != '') DuAEF.DuScriptUI.uiStrings.push(title);
	title = tr(title);

	text += '\n\nThis script is built with the Duduf After Effects Framework.\n(c) 2017-2018 Nicolas Dufresne, Rainbox Productions. All Rights Reserved.\nLicense: GNU GPL-3.0 (http://www.gnu.org/licenses/)\n\nSource & Documentation: https://github.com/Rainbox-dev/DuAEF_Duik';

	DuAEF.DuScriptUI.helpPanel.about.title.text = title;
	DuAEF.DuScriptUI.helpPanel.about.help.text = text;
	DuAEF.DuScriptUI.helpPanel.about.link = link;

	DuAEF.DuScriptUI.helpPanel.layout.layout(true);
	DuAEF.DuScriptUI.helpPanel.layout.resize();
}

/**
* Gets the RSS content from a feed url, and set the news in the Help popup
* @memberof DuAEF.DuRSS
* @param {string} url - The url of the server.
* @param {string} [subfolder='feed'] - The subdirectory of the feed (without a leading '/')
* @param {int} [port=80] - The server port.
* @return {RSSItem[]} The news items
*/
DuAEF.DuScriptUI.getNews = function (url, subfolder, port)
{
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess) return;

	if (typeof port === 'undefined') port = 80;
	if (typeof subfolder === 'undefined') subfolder = 'feed';

	var channel = DuAEF.DuRSS.get(url, subfolder, port);

	if (!channel) return [];

	DuAEF.DuScriptUI.setNews(channel.items);

	return channel.items;
}

/**
* Sets the news in the help popup
* @memberof DuAEF.DuRSS
* @param {RSSItem[]} items - The items.
*/
DuAEF.DuScriptUI.setNews = function (items)
{
	DuAEF.DuScriptUI.helpPanel.newsItems = items;

	if (DuAEF.DuScriptUI.helpPanel.newsItems.length == 0) return;

	DuAEF.DuScriptUI.helpPanel.displayNewsItem(0);

	DuAEF.DuScriptUI.helpPanel.layout.layout(true);
	DuAEF.DuScriptUI.helpPanel.layout.resize();
}

/**
* Shows the help popup
* @memberof DuAEF.DuScriptUI
*/
DuAEF.DuScriptUI.showHelp = function ()
{
	DuAEF.DuScriptUI.helpPanel.setPanel(0);
	DuAEF.DuScriptUI.helpPanel.show();
}

/**
* Shows the news popup
* @memberof DuAEF.DuScriptUI
*/
DuAEF.DuScriptUI.showNews = function ()
{
	if (DuAEF.DuScriptUI.helpPanel.newsItems.length == 0) return;
	DuAEF.DuScriptUI.helpPanel.setPanel(1);
	DuAEF.DuScriptUI.helpPanel.show();
}

/**
* Shows the about popup
* @memberof DuAEF.DuScriptUI
*/
DuAEF.DuScriptUI.showAbout = function ()
{
	DuAEF.DuScriptUI.helpPanel.setPanel(2);
	DuAEF.DuScriptUI.helpPanel.show();
}

/**
 * @class
 * @name CompSelector
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A drop down selector.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addCompSelector} to create a Selector.<br />
 * The Selector inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {int} [id=0]  - The current compitem id, 0 if None
 * @property {CompItem[]} [comps] - The compositions listed in the selector.
 * @property {Selector~onChange} onChange  - The function to execute when the index changes.<br />
 * You can set your own function here, which must take no argument.<br />
 * The method is called after the index has changed.
 * @property {Selector~filterComps} filterComps - A function which gets the comps to set in the selector.<br />
 * The default function will get all the comps in the project,<br />
 * You can set your own function here, which must take no argument.<br />
 * The function must return an array of CompItem.
 */

/**
 * The function to execute when the index changes.<br />
 * The method is called after the index has changed.
 * @callback CompSelector~onChange
 * @memberof CompSelector
 */


/**
  * A function which gets the comps to set in the selector.<br />
  * The default function will get all the comps in the project,<br />
  * assign another function to this callback if you need to filter these comps.<br />
  * The function must return an array of CompItem.
  * @callback CompSelector~filterComps
  * @memberof CompSelector
  * @return {CompItem[]} The compositions to set in the selector.
  */

/**
 * Changes the selection and the current comp id of the selector
 * @method
 * @memberof CompSelector
 * @name setCurrentId
 * @param {int} index - The new comp id
 */

/**
* Sets the comp list
* @method
* @memberof CompSelector
* @name setComps
* @param {CompItem[]} [comps] - The list of compositions. By default, will use {@link CompSelector.filterComps()} to get the comps.
*/

/**
* Gets the selected comp
* @method
* @memberof CompSelector
* @name getComp
* @return {CompItem|null} the selected comp
*/

/**
 * Creates a drop down selector for compositions
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the selector.
 * @return {CompSelector} - The selector
 */
DuAEF.DuScriptUI.addCompSelector = function(container)
{
	//create main group
	var selector = container.add('group');
	selector.orientation = 'row';
	selector.margins = 2;
	selector.spacing = 5;
	selector.alignment = ['fill','top'];
	selector.mainGroup =  selector.add('group');
	selector.mainGroup.orientation = 'row';
	selector.mainGroup.margins = 0;
	selector.mainGroup.spacing = 5;
	selector.mainGroup.alignment = ['fill','fill'];
	selector.mainGroup.alignChildren = ['center','center'];
	DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);

	//init
	selector.id = 0;
	selector.comp = null;
	selector.selectedOnly = false;
	selector.pauseRefresh = false;

	var cs6 = DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12;

	//CS6
	if (cs6)
	{
		//the menu button
		selector.menuImage = DuAEF.DuBinary.toFile(w14_comp_m);
		selector.menuButton = selector.mainGroup.add('image',undefined,selector.menuImage);
		selector.menuButton.alignment = ['left','center'];

		//the dropdownlist
		selector.popup = {};
		selector.popup.list = selector.mainGroup.add('dropdownlist');
		selector.popup.list.alignment = ['fill','center'];
	}
	else
	{
		//the menu button
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess)
		{
			selector.menuImage = DuAEF.DuBinary.toFile(w14_comp_m);
			selector.menuImageOver = DuAEF.DuBinary.toFile(w14_comp_l);
			selector.menuButton = selector.mainGroup.add('image',undefined,selector.menuImage);
			selector.menuButton.alignment = ['left','center'];
		}


		//the text
		selector.label = selector.mainGroup.add('statictext',undefined,'None');
		selector.label.helpTip = '';
		selector.label.alignment = ['fill','center'];

		//create popup
		selector.popup = new Window('palette','',undefined,{borderless:true});
		selector.popup.margins = 2;
		selector.popup.spacing = 0;
		DuAEF.DuScriptUI.setBackgroundColor(selector.popup,DuAEF.DuJS.Color.Colors.DARK_GREY);
		selector.popup.closeButton = DuAEF.DuScriptUI.addButton(selector.popup,"Cancel");
		selector.popup.closeButton.onClick = function () { selector.popup.hide(); };
		selector.popup.onDeactivate = function () { selector.popup.hide(); };
		selector.popup.list = selector.popup.add('listbox',undefined);

		selector.clicked = function (e)
		{
			selector.popup.list.minimumSize.width = selector.popup.list.maximumSize.width = selector.size.width;
			selector.popup.list.minimumSize.height = selector.popup.list.maximumSize.height = selector.size.height * 10;

			selector.popup.layout.layout();
			selector.popup.layout.resize();

			var x = e.screenX-e.clientX;
			var y = e.screenY-e.clientY;
			selector.popup.location = [x,y];

			selector.popup.show();
		}
	}

	//the pick & refresh buttons
	selector.pickImage = DuAEF.DuBinary.toFile(w14_eyedropper_m);
	selector.pickImageOver = DuAEF.DuBinary.toFile(w14_eyedropper_l);
	if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.pickButton = selector.add('image',undefined,selector.pickImage);
	else selector.pickButton = selector.add('statictext',undefined,'P');
	selector.pickButton.alignment = ['right','center'];

	//the refresh button
	selector.refreshImage = DuAEF.DuBinary.toFile(w14_update_m);
	selector.refreshImageOver = DuAEF.DuBinary.toFile(w14_update_l);
	if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.refreshButton = selector.add('image',undefined,selector.refreshImage);
	else selector.refreshButton = selector.add('statictext',undefined,'R');
	selector.refreshButton.alignment = ['right','center'];

	var itemNone = selector.popup.list.add('item',"None");
	itemNone.id = 0;
	selector.popup.list.selection = 0;

	selector.setComps = function()
	{
		var comps = selector.filterComps();
		selector.pauseRefresh = true;

		var prevId = selector.id;
		selector.popup.list.removeAll();
		var itemNone = selector.popup.list.add('item',"None");
		itemNone.id = 0;
		var it = new Iterator(comps);
		it.do(function(comp)
		{
			var item = selector.popup.list.add('item', comp.name);
			item.id = comp.id;
		});
		selector.setCurrentId(prevId);

		selector.pauseRefresh = false;
	};

	selector.getComp = function ()
	{
		if (selector.id == 0) return null;
		return DuAEF.DuAE.Project.getItemById(selector.id);
	}

	selector.setCurrentId = function (id)
	{
		if (id < 0) id = 0;

		selector.pauseRefresh = true;

		if (id == 0)
		{
			selector.popup.list.selection = 0;
		}
		else
		{
			for(var i = 0,num = selector.popup.list.items.length ; i < num ; i++)
			{
				var item = selector.popup.list.items[i];
				if (id == item.id)
				{
					selector.popup.list.selection = i;
					break;
				}
			}
		}

		if (!cs6)
		{
			if ( selector.popup.list.selection) selector.label.text = selector.popup.list.selection.text;
			else
			{
				selector.popup.list.selection = 0;
				selector.label.text = "None";
			}
		}

		selector.id = id;

		selector.pauseRefresh = false;

		selector.onChange();
	};

	selector.popup.list.onChange = function()
	{
		if (selector.pauseRefresh) return;
		selector.setCurrentId(selector.popup.list.selection.id);
		if (!cs6) selector.popup.hide();
	};

	selector.onChange = function(){};

	//mouse over
	selector.highlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.menuButton.image = selector.menuImageOver;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.VERY_LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.DARK_GREY);
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.refreshHighlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.refreshButton.image = selector.refreshImageOver;
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.pickHighlight = function (e)
	{
		e.stopPropagation();
		DuAEF.DuScriptUI.dimControls();
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.pickButton.image = selector.pickImageOver;
		DuAEF.DuScriptUI.highlightedControls.push(selector);
	}

	selector.dim = function (e)
	{
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.menuButton.image = selector.menuImage;
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.refreshButton.image = selector.refreshImage;
		if (DuAEF.DuAE.App.hasFilesAndNetworkAccess) selector.pickButton.image = selector.pickImage;
		DuAEF.DuScriptUI.setTextColor(selector.label,DuAEF.DuJS.Color.Colors.LIGHT_GREY);
		DuAEF.DuScriptUI.setBackgroundColor(selector,DuAEF.DuJS.Color.Colors.VERY_DARK_GREY);
	}

	selector.pick = function ()
	{
		var comp = DuAEF.DuAE.Project.getActiveComp();
		if (comp) selector.setCurrentId(comp.id);
	}

	// Hack - CS6 Bugs on mouseover with images
	if (DuAEF.DuAE.App.version >= 11 && DuAEF.DuAE.App.version < 12)
	{
		//selector.label.addEventListener("mouseover",selector.highlight);
	}
	else
	{
		selector.mainGroup.addEventListener("mouseover",selector.highlight);
		selector.refreshButton.addEventListener("mouseover",selector.refreshHighlight);
		selector.pickButton.addEventListener("mouseover",selector.pickHighlight);
	}

	selector.mainGroup.addEventListener("click",selector.clicked,true);
	selector.refreshButton.addEventListener("click",selector.setComps);
	selector.pickButton.addEventListener("click",selector.pick);

	selector.onChange = function(){};
	selector.filterComps = function(){ var comps = DuAEF.DuAE.Project.getComps(); return comps; };

	return selector;
}

/**
 * @class
 * @name LayerPicker
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A picker for layers with labels.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.createLayerPicker} to create a picker.<br />
 * The picker inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {LayerSelector[]} selectors  - The layer selectors
 * @property {string[]} inputs - The labels texts
 */

/**
 * Empties the LayerPicker
 * @method
 * @memberof LayerPicker
 * @name removeAll
 */

/**
* Adds a new line on the LayerPicker
* @method
* @memberof LayerPicker
* @name addSelector
* @return {LayerSelector} The added LayerSelector
*/

/**
 * Creates a two-columns group to allow the user to pick layers
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the selector.
 * @return {LayerPicker} The picker.
 */
DuAEF.DuScriptUI.addLayerPicker = function(container)
{
	var name = "Select layers";
	DuAEF.DuScriptUI.uiStrings.push(name);
	name = tr(name);
	var layerPicker = container.add('group');
	layerPicker.orientation = 'row';
	layerPicker.margins = 0;
	layerPicker.spacing = DuAEF.DuScriptUI.defaultSpacing;
	layerPicker.alignment = ['fill','top'];

	layerPicker.labelsGroup = layerPicker.add('group');
	layerPicker.labelsGroup.orientation = 'column';
	layerPicker.labelsGroup.margins = 0;
	layerPicker.labelsGroup.spacing = DuAEF.DuScriptUI.defaultSpacing;
	layerPicker.labelsGroup.alignment = ['left','fill'];
	layerPicker.labelsGroup.alignChildren = ['left','center'];

	layerPicker.selectorsGroup = layerPicker.add('group');
	layerPicker.selectorsGroup.orientation = 'column';
	layerPicker.selectorsGroup.margins = 0;
	layerPicker.selectorsGroup.spacing = DuAEF.DuScriptUI.defaultSpacing;
	layerPicker.selectorsGroup.alignment = ['fill','fill'];

	layerPicker.selectors = [];
	layerPicker.inputs = [];

	layerPicker.removeAll = function()
	{
		layerPicker.selectors = [];
		layerPicker.inputs = [];
		for ( var i = layerPicker.labelsGroup.children.length - 1; i >= 0; i-- )
		{
			layerPicker.labelsGroup.remove( layerPicker.labelsGroup.children[ i ] );
			layerPicker.selectorsGroup.remove( layerPicker.selectorsGroup.children[ i ] );
		}
	}

	layerPicker.addSelector = function(inputLabel)
	{
		DuAEF.DuScriptUI.uiStrings.push(inputLabel);
		inputLabel = tr(inputLabel);
		var l = layerPicker.labelsGroup.add('statictext',undefined,inputLabel);

		var sel = DuAEF.DuScriptUI.addLayerSelector(layerPicker.selectorsGroup);
		layerPicker.selectors.push(sel);

		l.minimumSize.height = l.maximumSize.height = 18;

		return sel;
	}

	return layerPicker;
}

/**
 * @class
 * @name LayerPickerDialog
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A picker for layers with labels.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.createLayerPicker} to create a picker.<br />
 * The picker inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {LayerPicker} layerPicker The layer picker inside the dialog.
 * @property {bool} accepted This property is true if the user has clicked the OK button, false otherwise.
 */

/**
 * Empties the LayerPicker<br />
 * This is a convenience function equivalent to {@link LayerPickerDialog.layerPicker.removeAll}.
 * @method
 * @memberof LayerPickerDialog
 * @name removeAll
 */

/**
* Adds a new line on the LayerPicker
 * This is a convenience function equivalent to {@link LayerPickerDialog.layerPicker.addSelector}.
* @method
* @memberof LayerPickerDialog
* @name addSelector
* @return {LayerSelector} The added LayerSelector
*/

/**
* Gets the layers picked by the user.
* @method
* @memberof LayerPickerDialog
* @name getLayers
* @return {Layer[]} The layers picked (null if the user has set none in the selector), in the display order.
*/

/**
* Gets the layers picked by the user.
* @method
* @memberof LayerPickerDialog
* @name getLayers
* @return {Layer[]} The layers picked (null if the user has set none in the selector), in the display order.
*/

/**
 * The function called when the dialog is accepted.
 * @callback LayerPickerDialog~onAccept
 * @memberof LayerPickerDialog
 */

/**
 * Creates a dialog with a LayerPicker<br />
 * Use {@link DuAEF.DuScriptUI.showUI} to show it after creation.
 * @memberof DuAEF.DuScriptUI
 * @param {string} title - The title of the dialog.
 * @return {LayerPickerDialog} The dialog window.
 */
DuAEF.DuScriptUI.createLayerPickerDialog = function (title)
{
	var dialog = new Window('palette', title, undefined, {resizeable:true});
	dialog.minimumSize.width = 300;

	dialog.margins = DuAEF.DuScriptUI.defaultMargins;
	dialog.orientation = 'column';

	dialog.layerPicker = DuAEF.DuScriptUI.addLayerPicker(dialog);

	dialog.onAccept = function() {};
	dialog.removeAll = dialog.layerPicker.removeAll;
	dialog.addSelector = dialog.layerPicker.addSelector;
	dialog.getLayers = function ()
	{
		var layers = [];
		for (var i = 0, num = dialog.layerPicker.selectors.length; i < num; i++)
		{
			var sel = dialog.layerPicker.selectors[i];
			layers.push(sel.getLayer());
		}
		return layers;
	}

	dialog.accepted = false;

	//add buttons
	var validGroup = dialog.add('group');
	validGroup.alignment = ['fill', 'bottom'];
	var validGroupCancelButton = DuAEF.DuScriptUI.addButton(validGroup,"Cancel",DuAEF.DuBinary.toFile(w25_back_m),"Cancel",DuAEF.DuBinary.toFile(w25_back_r));
	var validGroupValidButton = DuAEF.DuScriptUI.addButton(validGroup,"OK",DuAEF.DuBinary.toFile(w25_check_g),"OK",DuAEF.DuBinary.toFile(w25_check_r));

	validGroupValidButton.onClick = function() {dialog.accepted = true; dialog.hide(); dialog.onAccept(); };
	validGroupCancelButton.onClick = function() {dialog.hide();};

	return dialog;
}

/**
 * @class
 * @name TabPanel
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A Panel with tabs.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link DuAEF.DuScriptUI.addTabPanel} to create a picker.<br />
 * The TabPanel inherits the Group object from ScriptUI and has all of its properties and methods.
 * @property {DuButton[]} buttons - The buttons for the tabs. Not that an "index" property is added to the button, containing the Tab index.
 * @property {Tab[]} tabs - The tabs.
 * @property {int} index - The currently visible tab.
 * @property {Group} buttonsGroup - The ScriptUI Group containing the buttons
 * @property {Group} mainGroup - The ScriptUI Group containing the tabs
 * @property {TabPanel~onChange} onChange - Called when the index changes.
 */

/**
* Adds a new empty Tab in the TabPanel.
* @method
* @memberof TabPanel
* @name addTab
* @param {string} [tabTitle=''] - The title of the tab.
* @param {string} [text=tabTitle] - The label of the button.
* @param {string} [image=''] - The path to the icon.
* @param {string} [helpTip=''] - The helptip.
* @param {string} [imageOver=image] - The path to an icon displayed when the mouse is over the button.
* @return {Tab} The new Tab.
*/

/**
* Sets the current visible tab.
* @method
* @memberof TabPanel
* @name setCurrentIndex
* @param {int} [index=0] - The index of the tab to show.
*/

 /**
 * Called when the index changes.
 * @callback TabPanel~onChange
 * @memberof TabPanel
*/

/**
 * @class
 * @name Tab
 * @classdesc For use with {@link DuAEF.DuScriptUI}.<br />
 * A Tab inside a {@link TabPanel}.<br />
 * This is not a real class, and cannot be instanciated.<br />
 * Use {@link TabPanel.add} to create a new Tab.
 * @property {int} index - The index of this tab.
 * @property {DuButton} button - The button associated with this tab.
 * @property {Tab~tabActivated} onActivate - The function to execute when the tab is displayed.
 * @property {Tab~tabDeActivated} onActivate - The function to execute when the tab is hidden.
 * @property {Tab~build} build - You can use this callbacl to add a function which builds the UI of the tab, it will be called on first display.
 */

 /**
 * The function to execute when the tab is about to be displayed.
 * @callback Tab~tabActivated
 * @memberof Tab
*/

 /**
 * The function to execute when the tab is hidden.
 * @callback Tab~tabDeActivated
 * @memberof Tab
*/

 /**
 * You can use this callback to add a function which builds the UI of the tab, it will be called on first display.<br />
 * This allows a faster startup of your script by delaying the creation of the tabs which are hidden at startup.<br />
 * The function must take one argument, a ScriptUI Group which is the tab iteself. You can add controls in this group.
 * @callback Tab~build
 * @param {Group} tab - The tab where the ui has to be built
 * @memberof Tab
*/

/**
 * Creates a panel with tabs<br />
 * @memberof DuAEF.DuScriptUI
 * @param {Window|Panel|Group} container - The ScriptUI Object which will contain and display the panel.
 * @param {boolean} [showTitle=true] - Wether to show the titles of the tabs or not.
 * @return {TabPanel} The panel.
 */
DuAEF.DuScriptUI.addTabPanel = function (container)
{
	if (typeof buttonsAlignment === 'undefined') buttonsAlignment = 'center';

	var panel = DuAEF.DuScriptUI.addGroup(container,'column');

	panel.alignment = ['fill','fill'];

	panel.buttons = [];
	panel.tabs = [];
	panel.tabGroups = [];
	panel.showTitle = true;
	panel.onChange = function () {};

	//adds a group for the buttons
	panel.buttonsGroup = DuAEF.DuScriptUI.addGroup(panel,'row');
	//adds a group for the tabs
	panel.mainGroup = DuAEF.DuScriptUI.addGroup(panel,'stack');
	panel.mainGroup.alignment = ['fill','fill'];

	panel.addTab = function(text, image, helpTip, imageOver)
	{
		//adds the new button
		var button = DuAEF.DuScriptUI.addCheckBox(panel.buttonsGroup, text, image, helpTip, imageOver);
		button.index = panel.tabs.length;
		panel.buttons.push(button);

		//adds the new tab
		var tab = DuAEF.DuScriptUI.addGroup(panel.mainGroup,'column');
		tab.alignment = ['fill','fill'];
		tab.visible = false;

		//the onActivate callBack
		tab.tabActivated = function() {};
		tab.tabDeActivated = function() {};
		//the build callBack
		tab.build = function (theTab) { };
		tab.built = false;

		tab.button = button;

		//add to the list
		tab.index = panel.tabs.length;
		panel.tabs.push(tab);

		DuAEF.DuScriptUI.allTabs.push(tab);

		button.onClick = function ()
		{
			panel.setCurrentIndex(button.index);
		}

		return tab;
	}

	panel.setCurrentIndex = function (index)
	{
		var numTabs = panel.tabs.length;

		if (numTabs == 0) return;

		//hide all tabs
		for (var i = 0; i < numTabs; i++)
		{
			var visible = i == index;
			var tab = panel.tabs[i];
			if (visible)
			{
				if (!tab.built)
				{
					tab.build(tab);
					//resize everything
					DuAEF.DuScriptUI.layout(tab);
					tab.built = true;
				}
				tab.visible = true;
				tab.tabActivated();
			}
			else
			{
				tab.visible = false;
				tab.tabDeActivated();
			}

			panel.buttons[i].setChecked(visible);
		}

		if (index >= 0 && index < numTabs) panel.index = index;
		else panel.index = -1;

		panel.onChange();
	}

	return panel;
}

/**
 * Builds all the tabs from all the tab panels<br />
 * @memberof DuAEF.DuScriptUI
 */
DuAEF.DuScriptUI.buildAllTabs = function()
{
	for (var i = 0, num = DuAEF.DuScriptUI.allTabs.length; i < num; i++)
	{
		var tab = DuAEF.DuScriptUI.allTabs[i];
		if (!tab.built)
		{
			tab.build(tab);
			//resize everything
			DuAEF.DuScriptUI.layout(tab);
			tab.built = true;
		}
	}
	//check if there's still unbuilt tabs which may have been added
	var redo = false;
	for (var i = DuAEF.DuScriptUI.allTabs.length-1; i >=0; i--)
	{
		var tab = DuAEF.DuScriptUI.allTabs[i];
		if (!tab.built)
		{
			redo = true;
			break;
		}
	}
	if (redo) DuAEF.DuScriptUI.buildAllTabs();
}
/*
DuSettingsLib
Library to manager settings in a JSON file.
Copyright (c) 2017 Nicolas Dufresne, Rainbox Productions
https://rainboxprod.coop

_Contributors:_
Nicolas Dufresne - Lead developer

This file is part of DuAEF.

DuAEF is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DuAEF is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DuAEF. If not, see <http://www.gnu.org/licenses/>.
*/

/**
* Constructs a new DuSettings instance
* @class DuSettings
* @classdesc A class to manage settings.
* @param {string}	  namespace     - A namespace to group your settings.
* @param {File|string}    [file=Folder.myDocuments/namespace_settings.json]    - The file to store the settings
* @property {string}	  namespace	- A namespace to group your settings.
* @property {File}		file	- The file to store the settings
* @property {Object}	data	- The settings as a js object
*/
function DuSettings(namespace,file)
{
	if (file == undefined) file = new File(Folder.myDocuments.absoluteURI + "/" + namespace + "_settings.json");
	this.namespace = namespace;
	if (file instanceof File) this.file = file;
	else this.file = new File(file);
	this.file.encoding = 'UTF-8';

	this.data = {};
	this.load();
}

/**
 * loads data from the settings file
 * @memberof DuAEF.DuSettings
 */
DuSettings.prototype.load = function()
{
	//load file
	if (this.file.exists)
	{
		//open file
		if (this.file.open("r"))
		{
			var data = this.file.read();
			this.file.close();
			if (data != "") this.data = JSON.parse(data);
		}
	}
}

/**
 * Saves data to the file
 * @memberof DuAEF.DuSettings
 * @param {string}		name	- The name of the setting
 * @return {boolean} true if the file has been correctly written
 */
DuSettings.prototype.save = function()
{
	if (!DuAEF.DuAE.App.hasFilesAndNetworkAccess) return false;
	return DuAEF.DuJS.Fs.saveJSON(this.data, this.file);
}
/**
 * Duduf ik Tools
 * @author Nicolas Dufresne, Kevin Masson and contributors
 * @copyright 2017,2018 Nicolas Dufresne, Rainbox Productions<br />
 * {@link https://rainboxprod.coop}
 * @namespace
 * @memberof DuAEF
 * @license GPL-3.0 <br />
 * DuAEF is free software: you can redistribute it and/or modify<br />
 * it under the terms of the GNU General Public License as published by<br />
 * the Free Software Foundation, either version 3 of the License, or<br />
 * (at your option) any later version.<br />
 *<br />
 * DuAEF is distributed in the hope that it will be useful,<br />
 * but WITHOUT ANY WARRANTY; without even the implied warranty of<br />
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the<br />
 * GNU General Public License for more details.<br />
 *<br />
 * You should have received a copy of the GNU General Public License<br />
 * along with DuAEF. If not, see {@link http://www.gnu.org/licenses/}.
 */
DuAEF.Duik = {};

//Loads pseudo effects and presets
(function ()
{
	//Load pseudo effect files
	{
		//structures
var duik_structure = {"binAsString":"RIFX\x00\x00\r\u00DCFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00B8bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\nStructure\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f:sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK structure-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDisplay options\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nSize\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2\u00C8\x00\x00Dz\x00\x00\x00\x00\x00\x00Dz\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Target\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Color\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00EC\x18\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07\x16tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nStructure\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK structure-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DCtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x10Display options\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Size\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Target\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK structure-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ntdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Color\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@m\u0080\x00\x00\x00\x00\x00@8\x00\x00\x00\x00\x00\x00@8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK structure-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nStructure\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Structure\">[{\"name\":\"Display options\",\"type\":\"group\",\"id\":\"Group1\"},{\"name\":\"Size\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":false,\"hold\":false,\"value\":100,\"sMin\":0,\"sMax\":1000,\"vMin\":-100,\"vMax\":1000,\"pre\":2,\"per\":true,\"pix\":false},{\"name\":\"Target\",\"type\":\"layer\",\"id\":\"Layer3\",\"keys\":false,\"hold\":true,\"value\":true},{\"name\":\"Color\",\"type\":\"color\",\"id\":\"Color3\",\"keys\":false,\"hold\":false,\"red\":236,\"green\":24,\"blue\":24},{\"type\":\"endgroup\"}]</control>","fileName":"duik_structure.ffx","category":"pseudoEffects"};
duik_structure;
		duik_structure = DuAEF.DuBinary.toFile(duik_structure);
		//list
var duik_1d_list = {"binAsString":"RIFX\x00\x00*PFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00*,bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x05List\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00(\u00B2sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x10\u00CCparTparn\x00\x00\x00\x04\x00\x00\x00\x15tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C4z\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C4z\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00D\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C4z\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C4z\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C4z\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x17\u009Atdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x021\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x022\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x023\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x024\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x025\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"List\">[{\"name\":\"1\",\"type\":\"group\",\"id\":\"Group0\"},{\"name\":\"Value\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"2\",\"type\":\"group\",\"id\":\"Group1\"},{\"name\":\"Value\",\"type\":\"slider\",\"id\":\"Slider8\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider9\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":2000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"3\",\"type\":\"group\",\"id\":\"Group2\"},{\"name\":\"Value\",\"type\":\"slider\",\"id\":\"Slider11\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider12\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"4\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Value\",\"type\":\"slider\",\"id\":\"Slider14\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider15\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"5\",\"type\":\"group\",\"id\":\"Group4\"},{\"name\":\"Value\",\"type\":\"slider\",\"id\":\"Slider16\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider17\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_1d_list.ffx","category":"pseudoEffects"};
duik_1d_list;
		duik_1d_list = new PseudoEffect(DuAEF.DuBinary.toFile(duik_1d_list),'Pseudo/DUIK 1d list',"List");
var duik_2d_list = {"binAsString":"RIFX\x00\x00)\u00D8FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00)\u00B4bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x05List\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00(:sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x10\u00CCparTparn\x00\x00\x00\x04\x00\x00\x00\x15tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Point\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x17\"tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x021\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x022\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x023\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x024\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x025\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Point\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"List\">[{\"name\":\"1\",\"type\":\"group\",\"id\":\"Group0\"},{\"name\":\"Value\",\"type\":\"point\",\"id\":\"Point13\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":\"1\",\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"2\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Value\",\"type\":\"point\",\"id\":\"Point14\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"3\",\"type\":\"group\",\"id\":\"Group7\"},{\"name\":\"Value\",\"type\":\"point\",\"id\":\"Point15\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider9\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"4\",\"type\":\"group\",\"id\":\"Group10\"},{\"name\":\"Value\",\"type\":\"point\",\"id\":\"Point16\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider12\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"5\",\"type\":\"group\",\"id\":\"Group17\"},{\"name\":\"Point\",\"type\":\"point\",\"id\":\"Point18\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider19\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_2d_list.ffx","category":"pseudoEffects"};
duik_2d_list;
		duik_2d_list = new PseudoEffect(DuAEF.DuBinary.toFile(duik_2d_list),'Pseudo/DUIK 2d list',"List");
var duik_3d_list = {"binAsString":"RIFX\x00\x00*PFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00*,bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x05List\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00(\u00B2sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x10\u00CCparTparn\x00\x00\x00\x04\x00\x00\x00\x15tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00D\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\r5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWeight\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00CH\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x17\u009Atdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d list-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x021\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d list-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x022\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d list-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x023\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d list-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x024\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d list-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x025\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Value\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0019\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Weight\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@i\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d list-0020\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05List\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"List\">[{\"name\":\"1\",\"type\":\"group\",\"id\":\"Group0\"},{\"name\":\"Value\",\"type\":\"point3d\",\"id\":\"Point18\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"2\",\"type\":\"group\",\"id\":\"Group1\"},{\"name\":\"Value\",\"type\":\"point3d\",\"id\":\"Point19\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider9\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":2000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"3\",\"type\":\"group\",\"id\":\"Group2\"},{\"name\":\"Value\",\"type\":\"point3d\",\"id\":\"Point20\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider12\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"4\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Value\",\"type\":\"point3d\",\"id\":\"Point21\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider15\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"5\",\"type\":\"group\",\"id\":\"Group4\"},{\"name\":\"Value\",\"type\":\"point3d\",\"id\":\"Point23\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Weight\",\"type\":\"slider\",\"id\":\"Slider17\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":-100,\"sMax\":200,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":true,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_3d_list.ffx","category":"pseudoEffects"};
duik_3d_list;
		duik_3d_list = new PseudoEffect(DuAEF.DuBinary.toFile(duik_3d_list),'Pseudo/DUIK 3d list',"List");
		//wiggle
var duik_1d_wiggle = {"binAsString":"RIFX\x00\x00\x13\u00DAFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x13\u00B6bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Wiggle\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x12:sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07<parTparn\x00\x00\x00\x04\x00\x00\x00\ttdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nLoop duration (s)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDetails\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nComplexity (octaves)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nMultiplier\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRandom Seed\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x1C@\x00\x00\x00\x00\x00F\x1C@\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\n\u00B2tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x12Loop duration (s)\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDetails\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x02tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x15Complexity (octaves)\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BMultiplier\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fRandom Seed\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00C3\u0088\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Wiggle\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Loop duration (s)\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":1000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Details\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Complexity (octaves)\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Multiplier\",\"type\":\"slider\",\"id\":\"Slider8\",\"keys\":true,\"hold\":false,\"value\":0.5,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Random Seed\",\"type\":\"slider\",\"id\":\"Slider4\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10000,\"vMin\":0,\"vMax\":10000,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_1d_wiggle.ffx","category":"pseudoEffects"};
duik_1d_wiggle;
		duik_1d_wiggle = new PseudoEffect(DuAEF.DuBinary.toFile(duik_1d_wiggle),'Pseudo/DUIK 1d wiggle',"Wiggle");
var duik_1d_multiwiggle = {"binAsString":"RIFX\x00\x00\x15\u00C4FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x15\u00A0bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Wiggle\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x14$sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\b\x12parTparn\x00\x00\x00\x04\x00\x00\x00\ntdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nLoop duration (s)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Link dimensions\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x01\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDetails\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nComplexity (octaves)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nMultiplier\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRandom Seed\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x1C@\x00\x00\x00\x00\x00F\x1C@\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x0B\u00C6tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x12Loop duration (s)\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DCtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x10Link dimensions\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDetails\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x02tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x15Complexity (octaves)\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BMultiplier\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fRandom Seed\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00C3\u0088\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d multiwiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Wiggle\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Loop duration (s)\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":1000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Link dimensions\",\"type\":\"check\",\"id\":\"Check3\",\"keys\":false,\"hold\":true,\"checked\":false,\"label\":\"\"},{\"name\":\"Details\",\"type\":\"group\",\"id\":\"Group4\"},{\"name\":\"Complexity (octaves)\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":0,\"per\":false,\"pix\":false},{\"name\":\"Multiplier\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":0.5,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Random Seed\",\"type\":\"slider\",\"id\":\"Slider7\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10000,\"vMin\":0,\"vMax\":10000,\"pre\":0,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_1d_multiwiggle.ffx","category":"pseudoEffects"};
duik_1d_multiwiggle;
		duik_1d_multiwiggle = new PseudoEffect(DuAEF.DuBinary.toFile(duik_1d_multiwiggle),'Pseudo/DUIK 1d multiwiggle',"Wiggle");
var duik_2d_wiggle = {"binAsString":"RIFX\x00\x00\x1F:FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x1F\x16bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Wiggle\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x1D\u009Asspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f\x04parTparn\x00\x00\x00\x04\x00\x00\x00\x0Ftdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rX\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rY\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nLoop duration (s)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDetails\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nComplexity (octaves)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nMultiplier\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRandom Seed\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x1C@\x00\x00\x00\x00\x00F\x1C@\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x11Jtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02X\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02Y\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x12Loop duration (s)\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDetails\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x02tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x15Complexity (octaves)\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BMultiplier\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fRandom Seed\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00C3\u0088\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d wiggle-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Wiggle\">[{\"name\":\"X\",\"type\":\"group\",\"id\":\"Group0\"},{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Y\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider4\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Loop duration (s)\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":1000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Details\",\"type\":\"group\",\"id\":\"Group7\"},{\"name\":\"Complexity (octaves)\",\"type\":\"slider\",\"id\":\"Slider8\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":0,\"per\":false,\"pix\":false},{\"name\":\"Multiplier\",\"type\":\"slider\",\"id\":\"Slider9\",\"keys\":true,\"hold\":false,\"value\":0.5,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Random Seed\",\"type\":\"slider\",\"id\":\"Slider10\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10000,\"vMin\":0,\"vMax\":10000,\"pre\":0,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_2d_wiggle.ffx","category":"pseudoEffects"};
duik_2d_wiggle;
		duik_2d_wiggle = new PseudoEffect(DuAEF.DuBinary.toFile(duik_2d_wiggle),'Pseudo/DUIK 2d wiggle',"Wiggle");
var duik_3d_wiggle = {"binAsString":"RIFX\x00\x00&\u00E4FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00&\u00C0bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Wiggle\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00%Dsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x0F4parTparn\x00\x00\x00\x04\x00\x00\x00\x13tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rX\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rY\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rZ\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nLoop duration (s)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDetails\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nComplexity (octaves)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nMultiplier\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A \x00\x00?\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRandom Seed\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x1C@\x00\x00\x00\x00\x00F\x1C@\x00?\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x15\u00C4tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02X\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02Y\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00CEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x02Z\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FEtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x12Loop duration (s)\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDetails\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x02tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x15Complexity (octaves)\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BMultiplier\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0017\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fRandom Seed\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00C3\u0088\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d wiggle-0018\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Wiggle\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Wiggle\">[{\"name\":\"X\",\"type\":\"group\",\"id\":\"Group0\"},{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Y\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider4\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Z\",\"type\":\"group\",\"id\":\"Group6\"},{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider7\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider8\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":2,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Loop duration (s)\",\"type\":\"slider\",\"id\":\"Slider9\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":1000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Details\",\"type\":\"group\",\"id\":\"Group10\"},{\"name\":\"Complexity (octaves)\",\"type\":\"slider\",\"id\":\"Slider11\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":0,\"per\":false,\"pix\":false},{\"name\":\"Multiplier\",\"type\":\"slider\",\"id\":\"Slider12\",\"keys\":true,\"hold\":false,\"value\":0.5,\"sMin\":0,\"sMax\":10,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Random Seed\",\"type\":\"slider\",\"id\":\"Slider13\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":10000,\"vMin\":0,\"vMax\":10000,\"pre\":0,\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_3d_wiggle.ffx","category":"pseudoEffects"};
duik_3d_wiggle;
		duik_3d_wiggle = new PseudoEffect(DuAEF.DuBinary.toFile(duik_3d_wiggle),'Pseudo/DUIK 3d wiggle',"Wiggle");
		//swing
var duik_1d_swing = {"binAsString":"RIFX\x00\x00\f\bFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x0B\u00E4bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Swing\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\njsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\fparTparn\x00\x00\x00\x04\x00\x00\x00\x05tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\u00C1 \x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nEase\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2|\x00\x00B\u0088\x00\x00\x00\x00\x00\x00@\u00A0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x06\x12tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Swing\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0$\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Ease\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x14\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Swing\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-10,\"sMax\":10,\"vMin\":-100,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Ease\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":5,\"vMin\":-63,\"vMax\":68,\"pre\":\"0\",\"per\":false,\"pix\":false}]</control>","fileName":"duik_1d_swing.ffx","category":"pseudoEffects"};
duik_1d_swing;
		duik_1d_swing = DuAEF.DuBinary.toFile(duik_1d_swing);
var duik_2d_swing = {"binAsString":"RIFX\x00\x00\r\u00EEFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00CAbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Swing\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\fPsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00E8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\u00C1 \x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nEase\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2|\x00\x00B\u0088\x00\x00\x00\x00\x00\x00@\u00A0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Axis\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\bAll|X|Y\x00LIST\x00\x00\x07\x1Ctdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Swing\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0$\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Ease\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x14\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Axis\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Swing\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-10,\"sMax\":10,\"vMin\":-100,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Ease\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":5,\"vMin\":-63,\"vMax\":68,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Axis\",\"type\":\"popup\",\"id\":\"Popup6\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"All|X|Y\"}]</control>","fileName":"duik_2d_swing.ffx","category":"pseudoEffects"};
duik_2d_swing;
		duik_2d_swing = DuAEF.DuBinary.toFile(duik_2d_swing);
var duik_3d_swing = {"binAsString":"RIFX\x00\x00\r\u00F0FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00CCbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Swing\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\fRsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00EAparTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\u00C1 \x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nEase\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2|\x00\x00B\u0088\x00\x00\x00\x00\x00\x00@\u00A0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Axis\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\nAll|X|Y|Z\x00LIST\x00\x00\x07\x1Ctdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Swing\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0$\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Ease\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x14\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Axis\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Swing\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-10,\"sMax\":10,\"vMin\":-100,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Ease\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":5,\"vMin\":-63,\"vMax\":68,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Axis\",\"type\":\"popup\",\"id\":\"Popup6\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"All|X|Y|Z\"}]</control>","fileName":"duik_3d_swing.ffx","category":"pseudoEffects"};
duik_3d_swing;
		duik_3d_swing = DuAEF.DuBinary.toFile(duik_3d_swing);
var duik_spatial_swing = {"binAsString":"RIFX\x00\x00\r\u00DEFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00BAbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Swing\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f@sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nAmplitude\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\u00C1 \x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nEase\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C2|\x00\x00B\u0088\x00\x00\x00\x00\x00\x00@\u00A0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03Angle\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07\x1Ctdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Swing\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nAmplitude\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0$\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Ease\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\x14\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial swing-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Angle\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Swing\">[{\"name\":\"Amplitude\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-10,\"sMax\":10,\"vMin\":-100,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Ease\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":5,\"vMin\":-63,\"vMax\":68,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Angle\",\"type\":\"angle\",\"id\":\"Angle5\",\"keys\":true,\"hold\":false,\"value\":0}]</control>","fileName":"duik_spatial_swing.ffx","category":"pseudoEffects"};
duik_spatial_swing;
		duik_spatial_swing = DuAEF.DuBinary.toFile(duik_spatial_swing);
		//Wheel
var duik_wheel = {"binAsString":"RIFX\x00\x00\t\u00F6FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\t\u00D2bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Wheel\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\bXsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03dparTparn\x00\x00\x00\x04\x00\x00\x00\x04tdmn\x00\x00\x00(Pseudo/DUIK wheel-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRadius\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00F\x1C@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Reverse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x01\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Trajectory\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x12Horizontal|Curved\x00LIST\x00\x00\x04\u00A8tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Wheel\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK wheel-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Radius\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u00C3\u0088\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bReverse\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK wheel-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BTrajectory\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Wheel\">[{\"name\":\"Radius\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":10000,\"vMin\":0,\"vMax\":32000,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Reverse\",\"type\":\"check\",\"id\":\"Check1\",\"keys\":true,\"hold\":true,\"checked\":false,\"label\":\"\"},{\"name\":\"Trajectory\",\"type\":\"popup\",\"id\":\"Popup2\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Horizontal|Curved\"}]</control>","fileName":"duik_wheel.ffx","category":"pseudoEffects"};
duik_wheel;
		duik_wheel = DuAEF.DuBinary.toFile(duik_wheel);
		//Effector
var duik_effector = {"binAsString":"RIFX\x00\x00\x11\u00B6FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x11\u0092bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\tEffector\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x10\x14sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x06\u00B6parTparn\x00\x00\x00\x04\x00\x00\x00\btdmn\x00\x00\x00(Pseudo/DUIK effector-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nInner limit\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00B\u00C8\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOutter limit\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\u00FA\x00\x00\x00\x00\x00\x00Dz\x00\x00CH\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x15Circle|Infinite Line\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rInterpolation\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Type\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x15Transition|Ping Pong\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Reverse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x01\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\t\x12tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\tEffector\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK effector-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fInner limit\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rOutter limit\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Mode\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0EInterpolation\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Type\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bReverse\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK effector-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\tEffector\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Effector\">[{\"name\":\"Inner limit\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Outter limit\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":200,\"sMin\":0,\"sMax\":1000,\"vMin\":0,\"vMax\":32000,\"pre\":1,\"per\":false,\"pix\":false},{\"name\":\"Mode\",\"type\":\"popup\",\"id\":\"Popup2\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Circle|Infinite Line\"},{\"name\":\"Interpolation\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Type\",\"type\":\"popup\",\"id\":\"Popup4\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Transition|Ping Pong\"},{\"name\":\"Reverse\",\"type\":\"check\",\"id\":\"Check5\",\"keys\":true,\"hold\":true,\"checked\":false,\"label\":\"\"},{\"type\":\"endgroup\"}]</control>","fileName":"duik_effector.ffx","category":"pseudoEffects"};
duik_effector;
		duik_effector = new PseudoEffect(DuAEF.DuBinary.toFile(duik_effector),'Pseudo/DUIK effector',"Effector");
		//Spring
var duik_1d_spring = {"binAsString":"RIFX\x00\x00\n\x00FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\t\u00DCbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Spring\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\b`sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03JparTparn\x00\x00\x00\x04\x00\x00\x00\x04tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nElasticity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00C8\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nDamping\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00A0\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Bounce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x01\x00\x00LIST\x00\x00\x04\u00CAtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Spring\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BElasticity\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@9\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDamping\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@4\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d spring-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Bounce\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Spring\">[{\"name\":\"Elasticity\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":25,\"vMin\":0,\"vMax\":100,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Damping\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":20,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Bounce\",\"type\":\"check\",\"id\":\"Check2\",\"keys\":true,\"hold\":true,\"checked\":false,\"label\":\"\"}]</control>","fileName":"duik_1d_spring.ffx","category":"pseudoEffects"};
duik_1d_spring;
		duik_1d_spring = DuAEF.DuBinary.toFile(duik_1d_spring);
var duik_multid_spring = {"binAsString":"RIFX\x00\x00\b\x1EFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x07\u00FAbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK multid spring\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Spring\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x06~sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x02tparTparn\x00\x00\x00\x04\x00\x00\x00\x03tdmn\x00\x00\x00(Pseudo/DUIK multid spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK multid spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nElasticity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00C8\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK multid spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nDamping\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00A0\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03\u00BEtdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Spring\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK multid spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK multid spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BElasticity\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@9\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK multid spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDamping\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@4\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Spring\">[{\"name\":\"Elasticity\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":25,\"vMin\":0,\"vMax\":100,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Damping\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":20,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false}]</control>","fileName":"duik_multid_spring.ffx","category":"pseudoEffects"};
duik_multid_spring;
		duik_multid_spring = DuAEF.DuBinary.toFile(duik_multid_spring);
var duik_spatial_spring = {"binAsString":"RIFX\x00\x00\n0FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\n\fbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Spring\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\b\u0090sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x03|parTparn\x00\x00\x00\x04\x00\x00\x00\x04tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nElasticity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00C8\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nDamping\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00A\u00A0\x00\x00@\u00A0\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x003Basic (light - needs keyframes)|Simulation (heavy)\x00\x00LIST\x00\x00\x04\u00C8tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Spring\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BElasticity\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@9\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDamping\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@4\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK spatial spring-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Mode\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Spring\">[{\"name\":\"Elasticity\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":25,\"vMin\":0,\"vMax\":100,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Damping\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":5,\"sMin\":0,\"sMax\":20,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Mode\",\"type\":\"popup\",\"id\":\"Popup4\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Basic (light - needs keyframes)|Simulation (heavy)\"}]</control>","fileName":"duik_spatial_spring.ffx","category":"pseudoEffects"};
duik_spatial_spring;
		duik_spatial_spring = DuAEF.DuBinary.toFile(duik_spatial_spring);
		//Blink
var duik_1d_blink = {"binAsString":"RIFX\x00\x00\x0E\x02FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00DEbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Blink\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\fdsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nValue B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\u00FA\x00\x00F\u00FA\x00\x00\u00C2\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00?\u0080\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRatio A/B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00BH\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07@tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Blink\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue A\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0Y\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nRatio A/B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 1d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Blink\">[{\"name\":\"Value A\",\"type\":\"slider\",\"id\":\"Slider4\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Value B\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":-100,\"sMax\":100,\"vMin\":-32000,\"vMax\":32000,\"pre\":2,\"per\":false,\"pix\":false},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Ratio A/B\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":50,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false}]</control>","fileName":"duik_1d_blink.ffx","category":"pseudoEffects"};
duik_1d_blink;
		duik_1d_blink = DuAEF.DuBinary.toFile(duik_1d_blink);
var duik_2d_blink = {"binAsString":"RIFX\x00\x00\r\u00D2FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00AEbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Blink\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f4sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06Value B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00?\u0080\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRatio A/B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00BH\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07\x10tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Blink\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DCtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue A\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DCtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue B\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x02\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nRatio A/B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 2d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Blink\">[{\"name\":\"Value A\",\"type\":\"point\",\"id\":\"Point6\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Value B\",\"type\":\"point\",\"id\":\"Point7\",\"keys\":true,\"hold\":false,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Ratio A/B\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":50,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false}]</control>","fileName":"duik_2d_blink.ffx","category":"pseudoEffects"};
duik_2d_blink;
		duik_2d_blink = DuAEF.DuBinary.toFile(duik_2d_blink);
var duik_3d_blink = {"binAsString":"RIFX\x00\x00\x0E\x02FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\r\u00DEbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Blink\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\fdsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12Value B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00?\u0080\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRatio A/B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00BH\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07@tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Blink\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue A\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue B\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x03\x00\x0F\x00\x03\u00FF\u00FF\u00FF\u00FF\x00\x00]\u00A8=\u009B|\u00DF\u00D9\u00D7\u00BD\u00BC?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\b\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nRatio A/B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK 3d blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Blink\">[{\"name\":\"Value A\",\"type\":\"point3d\",\"id\":\"Point8\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Value B\",\"type\":\"point3d\",\"id\":\"Point9\",\"keys\":true,\"hold\":false,\"is3D\":true,\"pointX\":0,\"pointY\":0,\"pointZ\":0,\"percentX\":0,\"percentY\":0,\"percentZ\":0},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Ratio A/B\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":50,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false}]</control>","fileName":"duik_3d_blink.ffx","category":"pseudoEffects"};
duik_3d_blink;
		duik_3d_blink = DuAEF.DuBinary.toFile(duik_3d_blink);
var duik_color_blink = {"binAsString":"RIFX\x00\x00\x0E2FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x0E\x0Ebescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x06Blink\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f\u0094sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x04\u00D8parTparn\x00\x00\x00\x04\x00\x00\x00\x06tdmn\x00\x00\x00(Pseudo/DUIK color blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Value A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Value B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nFrequency\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dy\u00C0\x00\x00\x00\x00\x00B\u00F0\x00\x00?\u0080\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nRatio A/B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00BH\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOffset\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x07ptdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Blink\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK color blink-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ftdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue A\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ftdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bValue B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nFrequency\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@^\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nRatio A/B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK color blink-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Offset\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Blink\">[{\"name\":\"Value A\",\"type\":\"color\",\"id\":\"Color11\",\"keys\":true,\"hold\":false,\"red\":255,\"green\":0,\"blue\":0},{\"name\":\"Value B\",\"type\":\"color\",\"id\":\"Color12\",\"keys\":true,\"hold\":false,\"red\":255,\"green\":0,\"blue\":0},{\"name\":\"Frequency\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":0,\"sMax\":120,\"vMin\":0,\"vMax\":999,\"pre\":\"2\",\"per\":false,\"pix\":false},{\"name\":\"Ratio A/B\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":50,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Offset\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false}]</control>","fileName":"duik_color_blink.ffx","category":"pseudoEffects"};
duik_color_blink;
		duik_color_blink = DuAEF.DuBinary.toFile(duik_color_blink);
		//Loop
var duik_looper = {"binAsString":"RIFX\x00\x00\x17jFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00\x17Fbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\x07Looper\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x15\u00CAsspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\tHparTparn\x00\x00\x00\x04\x00\x00\x00\x0Btdmn\x00\x00\x00(Pseudo/DUIK looper-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rIn\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04In\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\tActivate\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Type\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00 Cycle|Offset|Ping Pong|Continue\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nNumber of keyframes\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rOut\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Out\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\tActivate\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Type\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00 Cycle|Offset|Ping Pong|Continue\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nNumber of keyframes\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Dz\x00\x00\x00\x00\x00\x00A \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\f6tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Looper\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK looper-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x03In\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x03In\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Type\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x00tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x14Number of keyframes\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Looper\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK looper-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x04Out\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x04Out\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Type\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\x00tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x14Number of keyframes\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK looper-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Looper\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00{\"controlName\":\"Looper\",\"matchname\":\"Pseudo/DUIK looper\",\"controlArray\":[{\"index\":0,\"name\":\"In\",\"parent\":null,\"type\":\"group\",\"container\":null,\"invisible\":false},{\"index\":0,\"name\":\"In\",\"hold\":true,\"parent\":null,\"type\":\"checkbox\",\"keyframes\":true,\"invisible\":false,\"default\":true,\"label\":\"Activate\"},{\"index\":1,\"name\":\"Type\",\"hold\":true,\"parent\":null,\"type\":\"popup\",\"keyframes\":true,\"invisible\":false,\"default\":1,\"options\":\"Cycle|Offset|Ping Pong|Continue\"},{\"index\":2,\"name\":\"Number of keyframes\",\"hold\":false,\"parent\":null,\"type\":\"slider\",\"keyframes\":true,\"invisible\":false,\"default\":0,\"smin\":0,\"smax\":10,\"vmin\":0,\"vmax\":1000,\"precision\":0,\"percent\":false,\"pixel\":false},{\"type\":\"endgroup\"},{\"index\":1,\"name\":\"Out\",\"parent\":null,\"type\":\"group\",\"container\":null,\"invisible\":false,\"activeGroup\":true},{\"index\":0,\"name\":\"Out\",\"hold\":true,\"parent\":null,\"type\":\"checkbox\",\"keyframes\":true,\"invisible\":false,\"default\":true,\"label\":\"Activate\"},{\"index\":1,\"name\":\"Type\",\"hold\":true,\"parent\":null,\"type\":\"popup\",\"keyframes\":true,\"invisible\":false,\"default\":1,\"options\":\"Cycle|Offset|Ping Pong|Continue\"},{\"index\":2,\"name\":\"Number of keyframes\",\"hold\":false,\"parent\":null,\"type\":\"slider\",\"keyframes\":true,\"invisible\":false,\"default\":0,\"smin\":0,\"smax\":10,\"vmin\":0,\"vmax\":1000,\"precision\":0,\"percent\":false,\"pixel\":false,\"active\":true},{\"type\":\"endgroup\"}]}","fileName":"duik_looper.ffx","category":"pseudoEffects"};
duik_looper;
		duik_looper = new PseudoEffect(DuAEF.DuBinary.toFile(duik_looper),'Pseudo/DUIK looper',"Looper");
		//Paint Rig
var duik_paint_rig = {"binAsString":"RIFX\x00\x00!DFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00! bescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\nPaint Rig\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x1F\u00A2sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\r parTparn\x00\x00\x00\x04\x00\x00\x00\x10tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nStart\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00\x00\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nEnd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00B\u00C8\x00\x00\x00\x02\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rInterpolation\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x17Constant|Ramp|Triangle\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Ease\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x1DLinear|Ease|Ease In|Ease Out\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04Reverse\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x01\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rColor\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Color A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Color B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDiameter\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nDiameter A\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00?\u0080\x00\x00F\u00FA\x00\x00?\u0080\x00\x00B\u00C8\x00\x00?\u0080\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nDiameter B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00?\u0080\x00\x00F\u00FA\x00\x00?\u0080\x00\x00B\u00C8\x00\x00?\u0080\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x126tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nPaint Rig\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK paint rig-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Start\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F0tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x04End\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0EInterpolation\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Mode\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x05Ease\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bReverse\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nPaint Rig\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK paint rig-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Color\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ftdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bColor A\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ftdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bColor B\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@o\u00E0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nPaint Rig\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK paint rig-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\tDiameter\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BDiameter A\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0BDiameter B\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK paint rig-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\nPaint Rig\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Paint Rig\">[{\"name\":\"Start\",\"type\":\"slider\",\"id\":\"Slider0\",\"keys\":true,\"hold\":false,\"value\":0,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"1\",\"per\":true,\"pix\":false},{\"name\":\"End\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":2,\"per\":true,\"pix\":false},{\"name\":\"Interpolation\",\"type\":\"group\",\"id\":\"Group10\"},{\"name\":\"Mode\",\"type\":\"popup\",\"id\":\"Popup6\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Constant|Ramp|Triangle\"},{\"name\":\"Ease\",\"type\":\"popup\",\"id\":\"Popup8\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Linear|Ease|Ease In|Ease Out\"},{\"name\":\"Reverse\",\"type\":\"check\",\"id\":\"Check7\",\"keys\":true,\"hold\":true,\"checked\":false,\"label\":\"\"},{\"type\":\"endgroup\"},{\"name\":\"Color\",\"type\":\"group\",\"id\":\"Group22\"},{\"name\":\"Color A\",\"type\":\"color\",\"id\":\"Color2\",\"keys\":true,\"hold\":false,\"red\":255,\"green\":0,\"blue\":0},{\"name\":\"Color B\",\"type\":\"color\",\"id\":\"Color4\",\"keys\":true,\"hold\":false,\"red\":255,\"green\":0,\"blue\":0},{\"type\":\"endgroup\"},{\"name\":\"Diameter\",\"type\":\"group\",\"id\":\"Group23\"},{\"name\":\"Diameter A\",\"type\":\"slider\",\"id\":\"Slider3\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":1,\"sMax\":100,\"vMin\":1,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"name\":\"Diameter B\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":1,\"sMin\":1,\"sMax\":100,\"vMin\":1,\"vMax\":32000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_paint_rig.ffx","category":"pseudoEffects"};
duik_paint_rig;
		duik_paint_rig = DuAEF.DuBinary.toFile(duik_paint_rig);
		//Motion Trail
var duik_motion_trail = {"binAsString":"RIFX\x00\x00#>FaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00#\x1Abescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\rMotion trail\x00\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00!\u0098sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\r\u00C4parTparn\x00\x00\x00\x04\x00\x00\x00\x11tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00Motion source\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nIn (frames)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\x1C@\x00F\x1C@\x00\u00C4z\x00\x00Dz\x00\x00\u00C2H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOut (frames)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00C6\x1C@\x00F\x1C@\x00\u00C4z\x00\x00Dz\x00\x00BH\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rSampling\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Method\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pdnm\x00\x00\x00\x1FEach frame|Automatic|Sub-frame\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\rFame subdivision when using\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\rsub-frame or auto method:\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nSamples\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00?\u0080\x00\x00B\u00C8\x00\x00?\u0080\x00\x00A \x00\x00@\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\rDisplay\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05Color\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00EC\x18\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nOpacity\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00\x00\x00\x00\x00B\u00C8\x00\x00B\u00C8\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\nWidth\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00?\u0080\x00\x00Dz\x00\x00?\u0080\x00\x00B\u00C8\x00\x00@\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x13\u0088tdgptdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rMotion trail\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00DAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x03tdsn\x00\x00\x00\x01\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x02X?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\u00C0\u00C0\u00C0\u00FF\u00C0\u00C0\u00C0\x00\x00\x00\x00\u0080\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK motion trail-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x0EMotion source\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\fIn (frames)\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\u00C0I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00FAtdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rOut (frames)\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@I\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\u00C0\u008F@\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@\u008F@\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\tSampling\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x07Method\x00\x00tdb4\x00\x00\x00|\u00DB\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8?\x1A6\u00E2\u00EB\x1CC-?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E8tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x1CFame subdivision when using\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rMotion trail\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK motion trail-0008\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x1Asub-frame or auto method:\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0009\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rMotion trail\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK motion trail-0010\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bSamples\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@$\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0011\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rMotion trail\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(Pseudo/DUIK motion trail-0012\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00D4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bDisplay\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0013\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x01\ntdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Color\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x04\x00\x07\x00\x01\x00\x02\u00FF\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00`@o\u00E0\x00\x00\x00\x00\x00@m\u0080\x00\x00\x00\x00\x00@8\x00\x00\x00\x00\x00\x00@8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0014\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F4tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\bOpacity\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@Y\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b\x00\x00\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0015\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00F2tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\x06Width\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\u00FF\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdum\x00\x00\x00\b?\u00F0\x00\x00\x00\x00\x00\x00tduM\x00\x00\x00\b@Y\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK motion trail-0016\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00\u00E6tdbstdsb\x00\x00\x00\x04\x00\x00\x00\x01tdsn\x00\x00\x00\rMotion trail\x00\x00tdb4\x00\x00\x00|\u00BD\u0099\x00\x01\x00\x01\x00\x00\x00\x01\x00\x04\x00\x00]\u00A8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00cdat\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdpi\x00\x00\x00\x04\x00\x00\x00\x0Etdmn\x00\x00\x00(ADBE Group End\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<control name=\"Motion trail\">[{\"name\":\"Motion source\",\"type\":\"layer\",\"id\":\"Layer0\",\"keys\":true,\"hold\":true,\"value\":false},{\"name\":\"In (frames)\",\"type\":\"slider\",\"id\":\"Slider1\",\"keys\":true,\"hold\":false,\"value\":-50,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-10000,\"vMax\":10000,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Out (frames)\",\"type\":\"slider\",\"id\":\"Slider2\",\"keys\":true,\"hold\":false,\"value\":50,\"sMin\":-1000,\"sMax\":1000,\"vMin\":-10000,\"vMax\":10000,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"name\":\"Sampling\",\"type\":\"group\",\"id\":\"Group85\"},{\"name\":\"Method\",\"type\":\"popup\",\"id\":\"Popup86\",\"keys\":false,\"hold\":true,\"selected\":1,\"options\":\"Each frame|Automatic|Sub-frame\"},{\"name\":\"Fame subdivision when using\",\"type\":\"text\",\"id\":\"Text88\",\"dim\":true},{\"name\":\"sub-frame or auto method:\",\"type\":\"text\",\"id\":\"Text89\",\"dim\":true},{\"name\":\"Samples\",\"type\":\"slider\",\"id\":\"Slider87\",\"keys\":false,\"hold\":false,\"value\":4,\"sMin\":1,\"sMax\":10,\"vMin\":1,\"vMax\":100,\"pre\":\"0\",\"per\":false,\"pix\":false},{\"type\":\"endgroup\"},{\"name\":\"Display\",\"type\":\"group\",\"id\":\"Group3\"},{\"name\":\"Color\",\"type\":\"color\",\"id\":\"Color4\",\"keys\":true,\"hold\":false,\"red\":236,\"green\":24,\"blue\":24},{\"name\":\"Opacity\",\"type\":\"slider\",\"id\":\"Slider5\",\"keys\":true,\"hold\":false,\"value\":100,\"sMin\":0,\"sMax\":100,\"vMin\":0,\"vMax\":100,\"pre\":\"0\",\"per\":true,\"pix\":false},{\"name\":\"Width\",\"type\":\"slider\",\"id\":\"Slider6\",\"keys\":true,\"hold\":false,\"value\":2,\"sMin\":1,\"sMax\":100,\"vMin\":1,\"vMax\":1000,\"pre\":\"1\",\"per\":false,\"pix\":false},{\"type\":\"endgroup\"}]</control>","fileName":"duik_motion_trail.ffx","category":"pseudoEffects"};
duik_motion_trail;
		duik_motion_trail = DuAEF.DuBinary.toFile(duik_motion_trail);
		//X-Sheet
var duik_x_sheet = {"binAsString":"RIFX\x00\x00(rFaFXhead\x00\x00\x00\x10\x00\x00\x00\x03\x00\x00\x00D\x00\x00\x00\x01\x01\x00\x00\x00LIST\x00\x00(Nbescbeso\x00\x00\x008\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00]\u00A8\x00\x1D\u00F8R\x00\x00\x00\x00\x00d\x00d\x00d\x00d?\u00F0\x00\x00\x00\x00\x00\x00?\u00F0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FFLIST\x00\x00\x00\u00ACtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x02LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE Effect Parade\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdsn\x00\x00\x00\bX-sheet\x00LIST\x00\x00\x00dtdsptdot\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdpl\x00\x00\x00\x04\x00\x00\x00\x01LIST\x00\x00\x00@tdsitdix\x00\x00\x00\x04\u00FF\u00FF\u00FF\u00FFtdmn\x00\x00\x00(ADBE End of path sentinel\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00&\u00D2sspcfnam\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00LIST\x00\x00\x10DparTparn\x00\x00\x00\x04\x00\x00\x00\x14tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0000\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\u00FF\u00FF\u00FF\u00FF\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0001\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\rChange the animation exposure\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0002\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0003\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\r(the duration of each frame in\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0004\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0005\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\rthe animation)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0006\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00tdmn\x00\x00\x00(Pseudo/DUIK x sheet-0007\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00pard\x00\x00\x00\u0094\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07Mode\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x01\x00\x03\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0